/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.executionplan;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.CompilationPhaseTracer;
import org.neo4j.cypher.internal.compiler.v3_1.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_1.PreparedQuerySemantics;
import org.neo4j.cypher.internal.compiler.v3_1.PreparedQuerySemantics$;
import org.neo4j.cypher.internal.compiler.v3_1.RecordingNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.EntityAccessor;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.ExecutablePlanBuilder;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.ExecutionPlan;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.NewLogicalPlanSuccessRateMonitor;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.PlanFingerprint;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.PlanFingerprintReference;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.SilentFallbackPlanBuilder;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.WarningFallbackPlanBuilder;
import org.neo4j.cypher.internal.compiler.v3_1.planner.CantHandleQueryException;
import org.neo4j.cypher.internal.compiler.v3_1.spi.PlanContext;
import org.neo4j.cypher.internal.frontend.v3_1.notification.PlannerUnsupportedNotification$;
import org.neo4j.cypher.internal.frontend.v3_1.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Containing$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001E\u0011qCR1mY\n\f7m\u001b)mC:\u0014U/\u001b7eKJ$Vm\u001d;\u000b\u0005\r!\u0011!D3yK\u000e,H/[8oa2\fgN\u0003\u0002\u0006\r\u0005!aoM02\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003!1'o\u001c8uK:$\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0001E\u00051\u0001/\u0019:tKJ,\u0012a\t\t\u0003I\u0019j\u0011!\n\u0006\u0003CYI!aJ\u0013\u0003\u0019\rK\b\u000f[3s!\u0006\u00148/\u001a:\t\r%\u0002\u0001\u0015!\u0003$\u0003\u001d\u0001\u0018M]:fe\u00022Aa\u000b\u0001\u0001Y\t!Qo]3t'\tQS\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\u0005\ti)\u0012\t\u0011)A\u0005k\u0005I\u0011/^3ssR+\u0007\u0010\u001e\t\u0003mer!AL\u001c\n\u0005az\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0018\t\u000bqQC\u0011A\u001f\u0015\u0005y\u0002\u0005CA +\u001b\u0005\u0001\u0001\"\u0002\u001b=\u0001\u0004)\u0004b\u0002\"+\u0005\u0004%\taQ\u0001\fa2\fgnQ8oi\u0016DH/F\u0001E!\t)\u0005*D\u0001G\u0015\t9E!A\u0002ta&L!!\u0013$\u0003\u0017Ac\u0017M\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0017*\u0002\u000b\u0011\u0002#\u0002\u0019Ad\u0017M\\\"p]R,\u0007\u0010\u001e\u0011\t\u000f5S#\u0019!C\u0001\u001d\u0006Yan\u001c3f\u001b\u0006t\u0017mZ3s+\u0005y\u0005CA\u0010Q\u0013\t\t&A\u0001\bF]RLG/_!dG\u0016\u001c8o\u001c:\t\rMS\u0003\u0015!\u0003P\u00031qw\u000eZ3NC:\fw-\u001a:!\u0011\u001d)&F1A\u0005\u0002Y\u000b!d\u0019:fCR,g)\u001b8hKJ\u0004(/\u001b8u%\u00164WM]3oG\u0016,\u0012a\u0016\t\u0005]aS\u0006-\u0003\u0002Z_\tIa)\u001e8di&|g.\r\t\u0004]mk\u0016B\u0001/0\u0005\u0019y\u0005\u000f^5p]B\u0011qDX\u0005\u0003?\n\u0011q\u0002\u00157b]\u001aKgnZ3saJLg\u000e\u001e\t\u0003?\u0005L!A\u0019\u0002\u00031Ac\u0017M\u001c$j]\u001e,'\u000f\u001d:j]R\u0014VMZ3sK:\u001cW\r\u0003\u0004eU\u0001\u0006IaV\u0001\u001cGJ,\u0017\r^3GS:<WM\u001d9sS:$(+\u001a4fe\u0016t7-\u001a\u0011\t\u000f\u0019T#\u0019!C\u0001O\u0006Qq\u000e\u001c3Ck&dG-\u001a:\u0016\u0003!\u0004\"aH5\n\u0005)\u0014!!F#yK\u000e,H/\u00192mKBc\u0017M\u001c\"vS2$WM\u001d\u0005\u0007Y*\u0002\u000b\u0011\u00025\u0002\u0017=dGMQ;jY\u0012,'\u000f\t\u0005\b]*\u0012\r\u0011\"\u0001h\u0003)qWm\u001e\"vS2$WM\u001d\u0005\u0007a*\u0002\u000b\u0011\u00025\u0002\u00179,wOQ;jY\u0012,'\u000f\t\u0005\be*\u0012\r\u0011\"\u0001t\u0003-\u0001\u0018\u000e]3Ck&dG-\u001a:\u0016\u0003Q\u0004\"aH;\n\u0005Y\u0014!!G*jY\u0016tGOR1mY\n\f7m\u001b)mC:\u0014U/\u001b7eKJDa\u0001\u001f\u0016!\u0002\u0013!\u0018\u0001\u00049ja\u0016\u0014U/\u001b7eKJ\u0004\u0003b\u0002>+\u0005\u0004%\ta_\u0001\u000eaJ,\u0007/\u0019:fIF+XM]=\u0016\u0003q\u0004\"! @\u000e\u0003\u0011I!a \u0003\u0003-A\u0013X\r]1sK\u0012\fV/\u001a:z'\u0016l\u0017M\u001c;jGNDq!a\u0001+A\u0003%A0\u0001\bqe\u0016\u0004\u0018M]3e#V,'/\u001f\u0011\t\u0013\u0005\u001d!F1A\u0005\u0002\u0005%\u0011!D3yK\u000e,H/[8o!2\fg.\u0006\u0002\u0002\fA\u0019q$!\u0004\n\u0007\u0005=!AA\u0007Fq\u0016\u001cW\u000f^5p]Bc\u0017M\u001c\u0005\t\u0003'Q\u0003\u0015!\u0003\u0002\f\u0005qQ\r_3dkRLwN\u001c)mC:\u0004\u0003bBA\fU\u0011\u0005\u0011\u0011B\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000f\u0005m!\u0006\"\u0001\u0002\u001e\u0005Q\u0011m]:feR,6/\u001a3\u0015\t\u0005}\u0011Q\u0005\t\u0004]\u0005\u0005\u0012bAA\u0012_\t!QK\\5u\u0011\u001d\t9#!\u0007A\u0002!\fA!^:fI\u0002")
public class FallbackPlanBuilderTest
extends CypherFunSuite {
    private final CypherParser parser = new CypherParser();

    public CypherParser parser() {
        return this.parser;
    }

    public FallbackPlanBuilderTest() {
        this.test("should delegate var length to old pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH ()-[r*]->() RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.executionPlan()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should delegate plain shortest path to new pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH shortestPath(()-[r*]->()) RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.executionPlan()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should delegate shortest path with var length expressions to old pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH shortestPath(()-[r*]->({x: ()-[:T*]->()})) RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.executionPlan()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn if falling back from a specified plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object x$1 = null;
                Object x$2 = null;
                Object x$3 = null;
                Object x$4 = null;
                Object x$5 = null;
                Object x$6 = null;
                RecordingNotificationLogger x$7 = new RecordingNotificationLogger();
                String x$8 = PreparedQuerySemantics$.MODULE$.$lessinit$greater$default$8(null, null, null, null, null, null);
                Set x$9 = PreparedQuerySemantics$.MODULE$.$lessinit$greater$default$9(null, null, null, null, null, null);
                PreparedQuerySemantics preparedQuery = new PreparedQuerySemantics(null, null, null, null, null, null, (InternalNotificationLogger)x$7, x$8, x$9);
                ExecutablePlanBuilder builder = (ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
                Mockito.when((Object)builder.producePlan(preparedQuery, null, null, null)).thenThrow(new Class[]{CantHandleQueryException.class});
                new WarningFallbackPlanBuilder((ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class)), builder, (NewLogicalPlanSuccessRateMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class))).producePlan(preparedQuery, null, null, null);
                this.$outer.convertToAnyShouldWrapper(preparedQuery.notificationLogger().notifications()).should(this.$outer.contain().apply((Object)PlannerUnsupportedNotification$.MODULE$), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not warn if falling back from fallback plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object x$10 = null;
                Object x$11 = null;
                Object x$12 = null;
                Object x$13 = null;
                Object x$14 = null;
                Object x$15 = null;
                RecordingNotificationLogger x$16 = new RecordingNotificationLogger();
                String x$17 = PreparedQuerySemantics$.MODULE$.$lessinit$greater$default$8(null, null, null, null, null, null);
                Set x$18 = PreparedQuerySemantics$.MODULE$.$lessinit$greater$default$9(null, null, null, null, null, null);
                PreparedQuerySemantics preparedQuery = new PreparedQuerySemantics(null, null, null, null, null, null, (InternalNotificationLogger)x$16, x$17, x$18);
                ExecutablePlanBuilder builder = (ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
                Mockito.when((Object)builder.producePlan(preparedQuery, null, null, null)).thenThrow(new Class[]{CantHandleQueryException.class});
                new SilentFallbackPlanBuilder((ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class)), builder, (NewLogicalPlanSuccessRateMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class))).producePlan(preparedQuery, null, null, null);
                this.$outer.convertToAnyShouldWrapper(preparedQuery.notificationLogger().notifications()).should(this.$outer.not()).contain((Object)PlannerUnsupportedNotification$.MODULE$, Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class uses {
        private final PlanContext planContext;
        private final EntityAccessor nodeManager;
        private final Function1<Option<PlanFingerprint>, PlanFingerprintReference> createFingerprintReference;
        private final ExecutablePlanBuilder oldBuilder;
        private final ExecutablePlanBuilder newBuilder;
        private final SilentFallbackPlanBuilder pipeBuilder;
        private final PreparedQuerySemantics preparedQuery;
        private final ExecutionPlan executionPlan;

        public PlanContext planContext() {
            return this.planContext;
        }

        public EntityAccessor nodeManager() {
            return this.nodeManager;
        }

        public Function1<Option<PlanFingerprint>, PlanFingerprintReference> createFingerprintReference() {
            return this.createFingerprintReference;
        }

        public ExecutablePlanBuilder oldBuilder() {
            return this.oldBuilder;
        }

        public ExecutablePlanBuilder newBuilder() {
            return this.newBuilder;
        }

        public SilentFallbackPlanBuilder pipeBuilder() {
            return this.pipeBuilder;
        }

        public PreparedQuerySemantics preparedQuery() {
            return this.preparedQuery;
        }

        public ExecutionPlan executionPlan() {
            return this.executionPlan;
        }

        public ExecutionPlan result() {
            return this.pipeBuilder().producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING, this.createFingerprintReference());
        }

        public void assertUsed(ExecutablePlanBuilder used) {
            ExecutablePlanBuilder executablePlanBuilder = used;
            ExecutablePlanBuilder executablePlanBuilder2 = this.oldBuilder();
            ExecutablePlanBuilder notUsed = !(executablePlanBuilder != null ? !executablePlanBuilder.equals(executablePlanBuilder2) : executablePlanBuilder2 != null) ? this.newBuilder() : this.oldBuilder();
            ((ExecutablePlanBuilder)Mockito.verify((Object)used)).producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING, this.createFingerprintReference());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{used});
            Mockito.verifyZeroInteractions((Object[])new Object[]{notUsed});
        }

        public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$uses$$$outer() {
            return FallbackPlanBuilderTest.this;
        }

        public uses(String queryText) {
            if (FallbackPlanBuilderTest.this == null) {
                throw null;
            }
            this.planContext = (PlanContext)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
            this.nodeManager = (EntityAccessor)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(EntityAccessor.class));
            this.createFingerprintReference = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ uses $outer;

                public final PlanFingerprintReference apply(Option<PlanFingerprint> fp) {
                    return (PlanFingerprintReference)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$FallbackPlanBuilderTest$uses$$$outer().mock(ManifestFactory$.MODULE$.classType(PlanFingerprintReference.class));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.oldBuilder = (ExecutablePlanBuilder)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
            this.newBuilder = (ExecutablePlanBuilder)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
            this.pipeBuilder = new SilentFallbackPlanBuilder(this.oldBuilder(), this.newBuilder(), (NewLogicalPlanSuccessRateMonitor)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class)));
            this.preparedQuery = new PreparedQuerySemantics(FallbackPlanBuilderTest.this.parser().parse(queryText, FallbackPlanBuilderTest.this.parser().parse$default$2()), queryText, (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), null, null, null, null, Predef$.MODULE$.Set().empty());
            this.executionPlan = (ExecutionPlan)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(ExecutionPlan.class));
            Mockito.when((Object)this.oldBuilder().producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING, this.createFingerprintReference())).thenReturn((Object)this.executionPlan());
            Mockito.when((Object)this.newBuilder().producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING, this.createFingerprintReference())).thenReturn((Object)this.executionPlan());
        }
    }
}

