/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.executionplan;

import java.net.URL;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.LoadCsvPeriodicCommitObserver;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QueryTransactionalContext;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001#\t\tCj\\1e\u0007N4\b+\u001a:j_\u0012L7mQ8n[&$xJY:feZ,'\u000fV3ti*\u00111\u0001B\u0001\u000eKb,7-\u001e;j_:\u0004H.\u00198\u000b\u0005\u00151\u0011\u0001\u0002<4?FR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!I\u0011\u0005\u0001a\u0001\u0002\u0004%\tAI\u0001\u0012e\u0016\u001cx.\u001e:dKVsG-\u001a:UKN$X#A\u0012\u0011\u0005}!\u0013BA\u0013\u0003\u0005uau.\u00193DgZ\u0004VM]5pI&\u001c7i\\7nSR|%m]3sm\u0016\u0014\b\"C\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001)\u0003U\u0011Xm]8ve\u000e,WK\u001c3feR+7\u000f^0%KF$\"!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\ba\u0019\n\t\u00111\u0001$\u0003\rAH%\r\u0005\u0007e\u0001\u0001\u000b\u0015B\u0012\u0002%I,7o\\;sG\u0016,f\u000eZ3s)\u0016\u001cH\u000f\t\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002U\nA\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8uKb$X#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\"\u0011aA:qS&\u00111\b\u000f\u0002\u001a#V,'/\u001f+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}\u0005ABO]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqR|F%Z9\u0015\u0005%z\u0004b\u0002\u0019=\u0003\u0003\u0005\rA\u000e\u0005\u0007\u0003\u0002\u0001\u000b\u0015\u0002\u001c\u0002+Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=uA!I1\t\u0001a\u0001\u0002\u0004%\t\u0001R\u0001\te\u0016\u001cx.\u001e:dKV\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002I\t\u0005)\u0001/\u001b9fg&\u0011!j\u0012\u0002\u0014\u000bb$XM\u001d8bY\u000e\u001bfKU3t_V\u00148-\u001a\u0005\n\u0019\u0002\u0001\r\u00111A\u0005\u00025\u000bAB]3t_V\u00148-Z0%KF$\"!\u000b(\t\u000fAZ\u0015\u0011!a\u0001\u000b\"1\u0001\u000b\u0001Q!\n\u0015\u000b\u0011B]3t_V\u00148-\u001a\u0011\t\u000fI\u0003!\u0019!C\u0001'\u0006\u0019QO\u001d7\u0016\u0003Q\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u00079,GOC\u0001Z\u0003\u0011Q\u0017M^1\n\u0005m3&aA+S\u0019\"1Q\f\u0001Q\u0001\nQ\u000bA!\u001e:mA!)q\f\u0001C)A\u0006Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003%\u0002")
public class LoadCsvPeriodicCommitObserverTest
extends CypherFunSuite {
    private LoadCsvPeriodicCommitObserver resourceUnderTest;
    private QueryTransactionalContext transactionalContext;
    private ExternalCSVResource resource;
    private final URL url = new URL("file:///tmp/something.csv");

    public LoadCsvPeriodicCommitObserver resourceUnderTest() {
        return this.resourceUnderTest;
    }

    public void resourceUnderTest_$eq(LoadCsvPeriodicCommitObserver x$1) {
        this.resourceUnderTest = x$1;
    }

    public QueryTransactionalContext transactionalContext() {
        return this.transactionalContext;
    }

    public void transactionalContext_$eq(QueryTransactionalContext x$1) {
        this.transactionalContext = x$1;
    }

    public ExternalCSVResource resource() {
        return this.resource;
    }

    public void resource_$eq(ExternalCSVResource x$1) {
        this.resource = x$1;
    }

    public URL url() {
        return this.url;
    }

    public void beforeEach() {
        QueryContext queryContext = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
        this.transactionalContext_$eq((QueryTransactionalContext)this.mock(ManifestFactory$.MODULE$.classType(QueryTransactionalContext.class)));
        Mockito.when((Object)queryContext.transactionalContext()).thenReturn((Object)this.transactionalContext());
        this.resource_$eq((ExternalCSVResource)this.mock(ManifestFactory$.MODULE$.classType(ExternalCSVResource.class)));
        this.resourceUnderTest_$eq(new LoadCsvPeriodicCommitObserver(1L, this.resource(), queryContext));
    }

    public LoadCsvPeriodicCommitObserverTest() {
        this.test("writing should not trigger tx restart until next csv line is fetched", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$1 = this.$outer.resourceUnderTest();
                URL x$1 = this.$outer.url();
                Option x$2 = qual$1.getCsvIterator$default$2();
                Iterator iterator = qual$1.getCsvIterator(x$1, x$2);
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator.next();
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple iterators are still handled correctly only commit when the first iterator advances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})}))).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$2 = this.$outer.resourceUnderTest();
                URL x$3 = this.$outer.url();
                Option x$4 = qual$2.getCsvIterator$default$2();
                Iterator iterator1 = qual$2.getCsvIterator(x$3, x$4);
                LoadCsvPeriodicCommitObserver qual$3 = this.$outer.resourceUnderTest();
                URL x$5 = this.$outer.url();
                Option x$6 = qual$3.getCsvIterator$default$2();
                Iterator iterator2 = qual$3.getCsvIterator(x$5, x$6);
                iterator2.next();
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator1.next();
                ((QueryTransactionalContext)Mockito.verify((Object)this.$outer.transactionalContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if a custom iterator is specified should be passed to the wrapped resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
                ((ExternalCSVResource)Mockito.verify((Object)this.$outer.resource(), (VerificationMode)Mockito.times((int)1))).getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

