/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.executionplan;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.PlanFingerprint;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.PlanFingerprintReference;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.compiler.v3_1.spi.NodesWithLabelCardinality;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.time.FakeClock;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001#\ta\u0002\u000b\\1o\r&tw-\u001a:qe&tGOU3gKJ,gnY3UKN$(BA\u0002\u0005\u00035)\u00070Z2vi&|g\u000e\u001d7b]*\u0011QAB\u0001\u0005mNz\u0016G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005MIR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0003\u0018\u0015\tA\u0002\"\u0001\u0005ge>tG/\u001a8e\u0013\tQBC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005\u0011\u0001\"B\u0011\u0001\t\u0007\u0011\u0013\u0001\u00047jMR$vn\u00149uS>tWCA\u0012-)\t!S\u0007E\u0002&Q)j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-bC\u0002\u0001\u0003\u0006[\u0001\u0012\rA\f\u0002\u0002)F\u0011qF\r\t\u0003KAJ!!\r\u0014\u0003\u000f9{G\u000f[5oOB\u0011QeM\u0005\u0003i\u0019\u00121!\u00118z\u0011\u00151\u0004\u00051\u0001+\u0003\u0011IG/Z7\t\u000ba\u0002A\u0011A\u001d\u0002\u001d\u0011j\u0017N\\;tI\u001d\u0014X-\u0019;feV\u0011!h\u0010\u000b\u0003w\u0001\u00032!\n\u001f?\u0013\tidEA\u0005Gk:\u001cG/[8oaA\u00111f\u0010\u0003\u0006[]\u0012\rA\f\u0005\u0006m]\u0002\rA\u0010\u0005\u0006\u0005\u0002!\taQ\u0001\u0006Y\u0006\u0014W\r\u001c\u000b\u0003\t\"\u0003\"!\u0012$\u000e\u0003YI!a\u0012\f\u0003\u000f1\u000b'-\u001a7JI\")\u0011*\u0011a\u0001\u0015\u0006\t\u0011\u000e\u0005\u0002&\u0017&\u0011AJ\n\u0002\u0004\u0013:$\b")
public class PlanFingerprintReferenceTest
extends CypherFunSuite {
    public <T> Option<T> liftToOption(T item) {
        return Option$.MODULE$.apply(item);
    }

    public <T> Function0<T> $minus$greater(T item) {
        return new Serializable(this, item){
            public static final long serialVersionUID = 0L;
            private final Object item$1;

            public final T apply() {
                return (T)this.item$1;
            }
            {
                this.item$1 = item$1;
            }
        };
    }

    public LabelId label(int i) {
        return new LabelId(i);
    }

    public PlanFingerprintReferenceTest() {
        this.test("should be stale if all properties are out of date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)4.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if stats are not diverged over the threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.5;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if txId didn't change", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)17L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if life time has not expired", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                clock.forward(500L, TimeUnit.MILLISECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should update the timestamp if the life time is expired but transaction has not changed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                PlanFingerprintReference reference = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)17L)), stats))).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
                clock.forward(500L, TimeUnit.MILLISECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should update the timestamp and the txId if the life time is expired the txId is old but stats has not changed over the threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.1;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.millis(), 17L, snapshot);
                PlanFingerprintReference reference = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

