/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.executionplan;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.CompilationPhaseTracer;
import org.neo4j.cypher.internal.compiler.v3_1.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_1.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_1.Monitors;
import org.neo4j.cypher.internal.compiler.v3_1.PreparedQuerySemantics;
import org.neo4j.cypher.internal.compiler.v3_1.PreparedQuerySemantics$;
import org.neo4j.cypher.internal.compiler.v3_1.devNullLogger$;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.LegacyExecutablePlanBuilder;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.LegacyExecutablePlanBuilder$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.DistinctPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.NodeStartPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.TraversalMatchPipe;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.idp.DefaultIDPSolverConfig$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v3_1.tracing.rewriters.RewriterStepSequencer$;
import org.neo4j.cypher.internal.compiler.v3_1.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v3_1.Scope;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_1.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001#\ti\"+\u001e7f\u000bb,7-\u001e;bE2,\u0007\u000b\\1o\u0005VLG\u000eZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005iQ\r_3dkRLwN\u001c9mC:T!!\u0002\u0004\u0002\tY\u001ct,\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0017Ad\u0017M\\\"p]R,\u0007\u0010^\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0004gBL\u0017B\u0001\u0015&\u0005-\u0001F.\u00198D_:$X\r\u001f;\t\r)\u0002\u0001\u0015!\u0003$\u00031\u0001H.\u00198D_:$X\r\u001f;!\u0011\u001da\u0003A1A\u0005\u00025\na\u0001]1sg\u0016\u0014X#\u0001\u0018\u0011\u0005=\nT\"\u0001\u0019\u000b\u000512\u0012B\u0001\u001a1\u00051\u0019\u0015\u0010\u001d5feB\u000b'o]3s\u0011\u0019!\u0004\u0001)A\u0005]\u00059\u0001/\u0019:tKJ\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u0007G>tg-[4\u0016\u0003a\u0002\"!\u000f\u001e\u000e\u0003\u0011I!a\u000f\u0003\u00037\rK\b\u000f[3s\u0007>l\u0007/\u001b7fe\u000e{gNZ5hkJ\fG/[8o\u0011\u0019i\u0004\u0001)A\u0005q\u000591m\u001c8gS\u001e\u0004\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\fa2\fgNQ;jY\u0012,'/F\u0001B!\ty\")\u0003\u0002D\u0005\tYB*Z4bGf,\u00050Z2vi\u0006\u0014G.\u001a)mC:\u0014U/\u001b7eKJDa!\u0012\u0001!\u0002\u0013\t\u0015\u0001\u00049mC:\u0014U/\u001b7eKJ\u0004\u0003\"B$\u0001\t\u0003A\u0015\u0001E1tg\u0016\u0014H\u000fU5qK\u0016C\u0018n\u001d;t+\tI5\rF\u0002K!b\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013A!\u00168ji\")\u0011K\u0012a\u0001%\u0006!\u0001/\u001b9f!\t\u0019f+D\u0001U\u0015\t)F!A\u0003qSB,7/\u0003\u0002X)\n!\u0001+\u001b9f\u0011\u0015If\t1\u0001[\u0003\u0015YG.Y:t!\rYf,\u0019\b\u0003\u0017rK!!\u0018'\u0002\rA\u0013X\rZ3g\u0013\ty\u0006MA\u0003DY\u0006\u001c8O\u0003\u0002^\u0019B\u0011!m\u0019\u0007\u0001\t\u0015!gI1\u0001f\u0005\u0005!\u0016C\u00014j!\tYu-\u0003\u0002i\u0019\n9aj\u001c;iS:<\u0007CA&k\u0013\tYGJA\u0002B]fDQ!\u001c\u0001\u0005\u00029\fa#Y:tKJ$\b+\u001b9f\t>,7OT8u\u000bbL7\u000f^\u000b\u0003_R$2A\u00139r\u0011\u0015\tF\u000e1\u0001S\u0011\u0015IF\u000e1\u0001s!\rYfl\u001d\t\u0003ER$Q\u0001\u001a7C\u0002\u0015DQA\u001e\u0001\u0005\n]\f!CY;jY\u0012,\u00050Z2vi&|g\u000eU5qKR\u0011!\u000b\u001f\u0005\u0006sV\u0004\rA_\u0001\u0002cB\u00111l_\u0005\u0003y\u0002\u0014aa\u0015;sS:<\u0007")
public class RuleExecutablePlanBuilderTest
extends CypherFunSuite {
    private final PlanContext planContext = (PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
    private final CypherParser parser = new CypherParser();
    private final CypherCompilerConfiguration config;
    private final LegacyExecutablePlanBuilder planBuilder;

    public PlanContext planContext() {
        return this.planContext;
    }

    public CypherParser parser() {
        return this.parser;
    }

    public CypherCompilerConfiguration config() {
        return this.config;
    }

    public LegacyExecutablePlanBuilder planBuilder() {
        return this.planBuilder;
    }

    public <T> void assertPipeExists(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$1;

            public final boolean apply(Pipe x$3) {
                Class<?> clazz = x$3.getClass();
                Class clazz2 = this.klass$1;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$1 = klass$1;
            }
        }));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public <T> void assertPipeDoesNotExist(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$2;

            public final boolean apply(Pipe x$4) {
                Class<?> clazz = x$4.getClass();
                Class clazz2 = this.klass$2;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$2 = klass$2;
            }
        })));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected not to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public Pipe org$neo4j$cypher$internal$compiler$v3_1$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe(String q) {
        Statement statement;
        Statement x$18 = statement = this.parser().parse(q, this.parser().parse$default$2());
        String x$19 = q;
        None$ x$20 = None$.MODULE$;
        Map x$21 = Predef$.MODULE$.Map().empty();
        SemanticTable x$22 = (SemanticTable)this.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class));
        Scope x$23 = (Scope)this.mock(ManifestFactory$.MODULE$.classType(Scope.class));
        devNullLogger$ x$24 = devNullLogger$.MODULE$;
        String x$25 = PreparedQuerySemantics$.MODULE$.apply$default$8(x$18, x$19, (Option)x$20, x$21, x$22, x$23);
        Set x$26 = PreparedQuerySemantics$.MODULE$.apply$default$9(x$18, x$19, (Option)x$20, x$21, x$22, x$23);
        PreparedQuerySemantics parsedQ = new PreparedQuerySemantics(x$18, x$19, (Option)x$20, x$21, x$22, x$23, (InternalNotificationLogger)x$24, x$25, x$26);
        return this.planBuilder().producePipe(parsedQ, this.planContext(), (CompilationPhaseTracer)this.mock(ManifestFactory$.MODULE$.classType(CompilationPhaseTracer.class))).pipe();
    }

    public RuleExecutablePlanBuilderTest() {
        int x$5 = 100;
        double x$6 = 0.5;
        long x$7 = 1000L;
        boolean x$8 = false;
        long x$9 = 10000L;
        int x$10 = DefaultIDPSolverConfig$.MODULE$.maxTableSize();
        long x$11 = DefaultIDPSolverConfig$.MODULE$.iterationDurationLimit();
        boolean x$12 = false;
        this.config = new CypherCompilerConfiguration(x$5, x$6, x$7, x$8, x$10, x$11, x$12, x$9);
        Monitors x$13 = (Monitors)this.mock(ManifestFactory$.MODULE$.classType(Monitors.class));
        CypherCompilerConfiguration x$14 = this.config();
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidatingRewriterStepSequencer apply(String sequenceName) {
                return RewriterStepSequencer$.MODULE$.newValidating(sequenceName);
            }
        };
        Serializable x$16 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x) {
                return Predef$.MODULE$.identity(x);
            }
        };
        Function1 x$17 = LegacyExecutablePlanBuilder$.MODULE$.$lessinit$greater$default$4();
        this.planBuilder = new LegacyExecutablePlanBuilder(x$13, x$14, (Function1)x$15, x$17, (Function1)x$16);
        this.test("should_use_distinct_pipe_for_distinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH n RETURN DISTINCT n");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$1) {
                        return x$1 instanceof DistinctPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_traversal_matcher_when_possible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Foo")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("match (n:Foo)-->(x) return x");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$2) {
                        return x$2 instanceof TraversalMatchPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: line[0] }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv_2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: \"Foo Bar Baz\" }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

