/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.executionplan.builders;

import org.neo4j.cypher.internal.compiler.v3_1.commands.Pattern;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelatedTo;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SingleNode;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SingleNode$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.VarLengthRelatedTo;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Variable;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.True;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.builders.LongestTrail;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.builders.TrailBuilder$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.EndPoint;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.NodeVariable;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.RelationshipVariable;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.SingleStepTrail;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.Trail;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.VariableLengthStepTrail;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.RelationshipType;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\t\u0001BK]1jY\n+\u0018\u000e\u001c3feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001BY;jY\u0012,'o\u001d\u0006\u0003\u000b\u0019\tQ\"\u001a=fGV$\u0018n\u001c8qY\u0006t'BA\u0004\t\u0003\u001118gX\u0019\u000b\u0005%Q\u0011\u0001C2p[BLG.\u001a:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\bG\u0001\u0011\r\u0011\"\u0001%\u0003\u0005\tU#A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!r\u0011aB4sCBDGMY\u0005\u0003U\u001d\u0012\u0001CU3mCRLwN\\:iSB$\u0016\u0010]3\t\r1\u0002\u0001\u0015!\u0003&\u0003\t\t\u0005\u0005C\u0004/\u0001\t\u0007I\u0011\u0001\u0013\u0002\u0003\tCa\u0001\r\u0001!\u0002\u0013)\u0013A\u0001\"!\u0011\u001d\u0011\u0004A1A\u0005\u0002\u0011\n\u0011a\u0011\u0005\u0007i\u0001\u0001\u000b\u0011B\u0013\u0002\u0005\r\u0003\u0003b\u0002\u001c\u0001\u0005\u0004%\t\u0001J\u0001\u0002\t\"1\u0001\b\u0001Q\u0001\n\u0015\n!\u0001\u0012\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005!\u0011\t^8C+\u0005a\u0004CA\u001fA\u001b\u0005q$BA \u0007\u0003!\u0019w.\\7b]\u0012\u001c\u0018BA!?\u0005%\u0011V\r\\1uK\u0012$v\u000e\u0003\u0004D\u0001\u0001\u0006I\u0001P\u0001\u0006\u0003R|'\t\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001<\u0003\u0011\u0011Eo\\\"\t\r\u001d\u0003\u0001\u0015!\u0003=\u0003\u0015\u0011Eo\\\"!\u0011\u001dI\u0005A1A\u0005\u0002m\nAa\u0011;p\t\"11\n\u0001Q\u0001\nq\nQa\u0011;p\t\u0002Bq!\u0014\u0001C\u0002\u0013\u00051(A\u0003Ci>\u0014%\u0007\u0003\u0004P\u0001\u0001\u0006I\u0001P\u0001\u0007\u0005R|'I\r\u0011\t\u000fE\u0003!\u0019!C\u0001%\u0006!!\t^8F+\u0005\u0019\u0006CA\u001fU\u0013\t)fH\u0001\nWCJdUM\\4uQJ+G.\u0019;fIR{\u0007BB,\u0001A\u0003%1+A\u0003Ci>,\u0005\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001*\u0002\t\u0015#xN\u0012\u0005\u00077\u0002\u0001\u000b\u0011B*\u0002\u000b\u0015#xN\u0012\u0011\t\u000fu\u0003!\u0019!C\u0001w\u0005!Q\t^8H\u0011\u0019y\u0006\u0001)A\u0005y\u0005)Q\t^8HA\u0001")
public class TrailBuilderTest
extends CypherFunSuite {
    private final RelationshipType A = RelationshipType.withName((String)"A");
    private final RelationshipType B = RelationshipType.withName((String)"B");
    private final RelationshipType C = RelationshipType.withName((String)"C");
    private final RelationshipType D = RelationshipType.withName((String)"D");
    private final RelatedTo AtoB = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo BtoC = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo CtoD = new RelatedTo(new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("d", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr3", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo BtoB2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b2", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr4", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final VarLengthRelatedTo BtoE = new VarLengthRelatedTo("p", new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final VarLengthRelatedTo EtoF = new VarLengthRelatedTo("p2", new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("f", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo EtoG = new RelatedTo(new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("g", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"E"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());

    public RelationshipType A() {
        return this.A;
    }

    public RelationshipType B() {
        return this.B;
    }

    public RelationshipType C() {
        return this.C;
    }

    public RelationshipType D() {
        return this.D;
    }

    public RelatedTo AtoB() {
        return this.AtoB;
    }

    public RelatedTo BtoC() {
        return this.BtoC;
    }

    public RelatedTo CtoD() {
        return this.CtoD;
    }

    public RelatedTo BtoB2() {
        return this.BtoB2;
    }

    public VarLengthRelatedTo BtoE() {
        return this.BtoE;
    }

    public VarLengthRelatedTo EtoF() {
        return this.EtoF;
    }

    public RelatedTo EtoG() {
        return this.EtoG;
    }

    public TrailBuilderTest() {
        this.test("find_longest_path_for_single_pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"b"), (Trail)new SingleStepTrail((Trail)new EndPoint("b"), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))));
                this.$outer.convertToAnyShouldWrapper(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single_path_is_reversed_to_be_able_to_start_from_startpoint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleStepTrail trail = new SingleStepTrail((Trail)new EndPoint("a"), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)trail));
                this.$outer.convertToAnyShouldWrapper(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points_with_a_predicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals r1Pred = new Equals((Expression)new Property((Expression)new Variable("pr1"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Equals r2Pred = new Equals((Expression)new Property((Expression)new Variable("pr2"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)"FOO"));
                Seq predicates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r1Pred, r2Pred}));
                Equals rewrittenR1 = new Equals((Expression)new Property((Expression)new RelationshipVariable(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Equals rewrittenR2 = new Equals((Expression)new Property((Expression)new RelationshipVariable(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)"FOO"));
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)rewrittenR2, (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r2Pred})));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)rewrittenR1, (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r1Pred})));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), predicates);
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(foundTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points_with_a_node_predicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals nodePred = new Equals((Expression)new Property((Expression)new Variable("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Seq predicates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{nodePred}));
                Equals rewrittenPredicate = new Equals((Expression)new Property((Expression)new NodeVariable(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)rewrittenPredicate, (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{nodePred})));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), predicates);
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(foundTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_not_accept_trails_with_bound_points_in_the_middle", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LongestTrail longestTrail = (LongestTrail)TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).get();
                if (longestTrail != null) {
                    Trail trail;
                    Trail trail2;
                    Trail trail3 = trail2 = (trail = longestTrail.longestTrail());
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)trail3.size())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                    return;
                }
                throw new MatchError((Object)longestTrail);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_with_single_start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("d");
                SingleStepTrail third = new SingleStepTrail((Trail)boundPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr3", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), "c", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.CtoD(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2(), this.$outer.CtoD()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single_varlength_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("e");
                VariableLengthStepTrail first = new VariableLengthStepTrail((Trail)boundPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                Some expectedTrail = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VarLengthRelatedTo[]{this.$outer.BtoE()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single_rel_followed_by_varlength_with_single_bound_point", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail last = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail first = new SingleStepTrail((Trail)last, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("two_varlength_paths_with_both_ends_bound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail trail = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                Some expected = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VarLengthRelatedTo[]{this.$outer.BtoE(), this.$outer.EtoF()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "f"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_end_in_varlength_paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_only_have_single_varlength_paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.EtoF()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_only_have_varlength_paths_at_the_end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.EtoG()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("two_varlength_paths_with_one_end_bound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_loops", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo AtoX = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo XtoC = new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr6", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                EndPoint endPoint = new EndPoint("c");
                SingleStepTrail last = new SingleStepTrail((Trail)endPoint, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr6", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "x", (Predicate)new True(), (Predicate)new True(), (Pattern)XtoC, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail trail = new SingleStepTrail((Trail)last, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)AtoX, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), AtoX, XtoC})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), (Seq)Seq$.MODULE$.empty());
                Some expected = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)trail));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_long_paths_with_unnamed_nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo s1 = new RelatedTo(new SingleNode("  UNNAMED13", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED15", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED13", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s3 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED14", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED17", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s4 = new RelatedTo(new SingleNode("  UNNAMED14", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED18", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                EndPoint fifth = new EndPoint("c");
                SingleStepTrail fourth = new SingleStepTrail((Trail)fifth, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "  UNNAMED18", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "  UNNAMED14", (Predicate)new True(), (Predicate)new True(), (Pattern)s4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail third = new SingleStepTrail((Trail)fourth, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "  UNNAMED17", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)s3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "  UNNAMED13", (Predicate)new True(), (Predicate)new True(), (Pattern)s2, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, "  UNNAMED15", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)s1, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{s1, s2, s3, s4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.empty());
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_predicates_in_the_middle", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals predForB = new Equals((Expression)new Property((Expression)new Variable("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"b"));
                Equals predForC = new Equals((Expression)new Property((Expression)new Variable("c"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"c"));
                Equals expectedForB = new Equals((Expression)new Property((Expression)new NodeVariable(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"b"));
                Equals expectedForC = new Equals((Expression)new Property((Expression)new NodeVariable(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"c"));
                RelatedTo s1 = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s3 = new RelatedTo(new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("d", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                EndPoint fourth = new EndPoint("d");
                SingleStepTrail third = new SingleStepTrail((Trail)fourth, (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "c", (Predicate)new True(), (Predicate)new True(), (Pattern)s3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "b", (Predicate)new True(), (Predicate)expectedForC, (Pattern)s2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForC})));
                SingleStepTrail first = new SingleStepTrail((Trail)second, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "a", (Predicate)new True(), (Predicate)expectedForB, (Pattern)s1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForB})));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{s1, s2, s3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForB, predForC})));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

