/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.internal.compiler.v3_1.helpers.RuntimeScalaValueConverter;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001#\tq\"+\u001e8uS6,7kY1mCZ\u000bG.^3D_:4XM\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001[3ma\u0016\u00148O\u0003\u0002\u0006\r\u0005!aoM02\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003!1'o\u001c8uK:$\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0001E\u0005I1m\u001c8wKJ$XM]\u000b\u0002GA\u0011q\u0004J\u0005\u0003K\t\u0011!DU;oi&lWmU2bY\u00064\u0016\r\\;f\u0007>tg/\u001a:uKJDaa\n\u0001!\u0002\u0013\u0019\u0013AC2p]Z,'\u000f^3sA\u0001")
public class RuntimeScalaValueConverterTest
extends CypherFunSuite {
    private final RuntimeScalaValueConverter converter = new RuntimeScalaValueConverter((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final boolean apply(Object x$1) {
            return false;
        }
    });

    public RuntimeScalaValueConverter converter() {
        return this.converter;
    }

    public RuntimeScalaValueConverterTest() {
        this.test("should convert hash map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Integer> it = new HashMap<String, Integer>();
                it.put("k1", BoxesRunTime.boxToInteger((int)5));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<String, Integer> it = Collections.singletonMap("key", BoxesRunTime.boxToInteger((int)12));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)BoxesRunTime.boxToInteger((int)12))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<K, V> it = Collections.emptyMap();
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Object> it = new HashMap<String, Object>();
                it.put("k1", Collections.singletonMap("a", BoxesRunTime.boxToInteger((int)2)));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert linked list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinkedList<Integer> it = new LinkedList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert array list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Integer> it = new ArrayList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<Integer> it = Collections.singleton(BoxesRunTime.boxToInteger((int)3));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                java.util.List<T> it = Collections.emptyList();
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested data structures", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<java.util.List<Object>> it = Collections.singleton(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{3, 4})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert from set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashSet<String> it = new HashSet<String>();
                it.add("Hello");
                this.$outer.convertToAnyShouldWrapper(this.$outer.converter().asDeepScalaValue(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello"}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert traversable to Iterable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuntimeScalaValueConverterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Stream it = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}));
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(it).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(Iterable.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

