/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.internal.compiler.v3_1.helpers.ScalaCompatibility$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\t12kY1mC\u000e{W\u000e]1uS\nLG.\u001b;z)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0001.\u001a7qKJ\u001c(BA\u0003\u0007\u0003\u001118gX\u0019\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001")
public class ScalaCompatibilityTest
extends CypherFunSuite {
    public ScalaCompatibilityTest() {
        this.test("should convert hash map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Integer> it = new HashMap<String, Integer>();
                it.put("k1", BoxesRunTime.boxToInteger((int)5));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<String, Integer> it = Collections.singletonMap("key", BoxesRunTime.boxToInteger((int)12));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)BoxesRunTime.boxToInteger((int)12))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<K, V> it = Collections.emptyMap();
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(Predef$.MODULE$.Map().empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Object> it = new HashMap<String, Object>();
                it.put("k1", Collections.singletonMap("a", BoxesRunTime.boxToInteger((int)2)));
                it.put("k2", BoxesRunTime.boxToInteger((int)15));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert linked list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinkedList<Integer> it = new LinkedList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert array list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Integer> it = new ArrayList<Integer>();
                it.add(BoxesRunTime.boxToInteger((int)12));
                it.add(BoxesRunTime.boxToInteger((int)14));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert singleton set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<Integer> it = Collections.singleton(BoxesRunTime.boxToInteger((int)3));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert empty list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                java.util.List<T> it = Collections.emptyList();
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert nested data structures", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<java.util.List<Object>> it = Collections.singleton(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{3, 4})));
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert from set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashSet<String> it = new HashSet<String>();
                it.add("Hello");
                this.$outer.convertToAnyShouldWrapper(ScalaCompatibility$.MODULE$.asScalaCompatible(it)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello"}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert traversable to Iterable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Stream it = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}));
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(it).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(Iterable.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

