/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.parser;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.cypher.internal.compiler.v3_1.AbstractPattern;
import org.neo4j.cypher.internal.compiler.v3_1.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_1.ParsedEntity;
import org.neo4j.cypher.internal.compiler.v3_1.ParsedEntity$;
import org.neo4j.cypher.internal.compiler.v3_1.ParsedRelation;
import org.neo4j.cypher.internal.compiler.v3_1.ParsedRelation$;
import org.neo4j.cypher.internal.compiler.v3_1.ParsedVarLengthRelation;
import org.neo4j.cypher.internal.compiler.v3_1.ast.convert.commands.StatementConverters;
import org.neo4j.cypher.internal.compiler.v3_1.ast.convert.commands.StatementConverters$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AbstractQuery;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AllInCollection;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AllNodes;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AllRelationships;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AllVariables;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AnyInCollection;
import org.neo4j.cypher.internal.compiler.v3_1.commands.AnyIndex$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateIndex$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateNodePropertyExistenceConstraint$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateNodeStartItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateRelationshipPropertyExistenceConstraint$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateRelationshipStartItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateUniqueConstraint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateUniqueConstraint$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.CreateUniqueStartItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropIndex$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropNodePropertyExistenceConstraint$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.DropRelationshipPropertyExistenceConstraint$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.LabelAction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.LabelOp;
import org.neo4j.cypher.internal.compiler.v3_1.commands.LabelRemoveOp$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.LabelSetOp$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.LoadCSV;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NamedPath;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NodeById;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NodeById$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NodeByIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NodeByLabel;
import org.neo4j.cypher.internal.compiler.v3_1.commands.NoneInCollection;
import org.neo4j.cypher.internal.compiler.v3_1.commands.PathExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.PathExpression$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.PathExtractorExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.Pattern;
import org.neo4j.cypher.internal.compiler.v3_1.commands.PeriodicCommitQuery;
import org.neo4j.cypher.internal.compiler.v3_1.commands.Query;
import org.neo4j.cypher.internal.compiler.v3_1.commands.Query$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.QueryString$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelatedTo;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelatedTo$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelationshipById;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelationshipById$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.RelationshipByIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.ReturnColumn;
import org.neo4j.cypher.internal.compiler.v3_1.commands.ReturnItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SchemaIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SchemaIndexKind;
import org.neo4j.cypher.internal.compiler.v3_1.commands.ShortestPath;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SingleInCollection;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SingleNode;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SingleNode$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.SortItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.StartItem;
import org.neo4j.cypher.internal.compiler.v3_1.commands.Union;
import org.neo4j.cypher.internal.compiler.v3_1.commands.VarLengthRelatedTo;
import org.neo4j.cypher.internal.compiler.v3_1.commands.VarLengthRelatedTo$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.AbsFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Add;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.AggregationExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Avg;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.CoalesceFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.CollectionSliceExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ContainerIndex;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.CosFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Count;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.CountStar;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Distinct;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Divide;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ExtractFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.FilterFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.GenericCase;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.IdFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.LengthFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.LiteralMap;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Max;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Min;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Modulo;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Multiply;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ParameterExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PercentileCont;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PercentileDisc;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Pow;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ReduceFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.RelationshipEndPoints;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.RelationshipTypeFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.RoundFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ShortestPathExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ShortestPathExpression$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.SignFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.SimpleCase;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.SizeFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.SqrtFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Stdev;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.StdevP;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Subtract;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Sum;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Variable;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.And$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.ConstantCachedIn;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.DynamicCachedIn;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.GreaterThan;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.GreaterThanOrEqual;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.HasLabel;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.IsNull;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.LessThan;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.LessThanOrEqual;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.LiteralRegularExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.NonEmpty;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Not;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Or;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.RegularExpression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.True;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Xor;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.UnresolvedLabel$;
import org.neo4j.cypher.internal.compiler.v3_1.devNullLogger$;
import org.neo4j.cypher.internal.compiler.v3_1.helpers.LabelSupport$;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.CreateNode;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.CreateRelationship;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.CreateUniqueAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.DeleteEntityAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.DeletePropertyAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.ForeachAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.MapPropertySetAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.NamedExpectation;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.NamedExpectation$;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.PropertySetAction;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.RelationshipEndpoint;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.RelationshipEndpoint$;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.UniqueLink;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.UniqueLink$;
import org.neo4j.cypher.internal.compiler.v3_1.mutation.UpdateAction;
import org.neo4j.cypher.internal.compiler.v3_1.parser.CypherParserTest$;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_1.SyntaxException;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_1.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001#\t\u00012)\u001f9iKJ\u0004\u0016M]:feR+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001]1sg\u0016\u0014(BA\u0003\u0007\u0003\u001118gX\u0019\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001\u0005\b\u0007\u0001\u0011\r\u0011\"\u0001\"+\u0005\u0011\u0003CA\u0012&\u001b\u0005!#BA\u0002\u0017\u0013\t1CE\u0001\u0007DsBDWM\u001d)beN,'\u000f\u0003\u0004)\u0001\u0001\u0006IAI\u0001\ba\u0006\u00148/\u001a:!\u0011\u001dQ\u0003A1A\u0005\u0002-\n\u0011AZ\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006B\u0001\tG>lW.\u00198eg&\u0011\u0011G\f\u0002\u0018!\u0006$\b.\u0012=ue\u0006\u001cGo\u001c:FqB\u0014Xm]:j_:Daa\r\u0001!\u0002\u0013a\u0013A\u00014!\u0011\u0015)\u0004\u0001\"\u00037\u0003-)\u0007\u0010]3diF+XM]=\u0015\u0007]jd\t\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0003V]&$\b\"\u0002 5\u0001\u0004y\u0014!B9vKJL\bC\u0001!D\u001d\tA\u0014)\u0003\u0002Cs\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011\u0015\bC\u0003Hi\u0001\u0007\u0001*A\u0007fqB,7\r^3e#V,'/\u001f\t\u0003[%K!A\u0013\u0018\u0003\u001b\u0005\u00137\u000f\u001e:bGR\fV/\u001a:z\u0001")
public class CypherParserTest
extends CypherFunSuite {
    private final CypherParser parser = new CypherParser();
    private final PathExtractorExpression f = new PathExtractorExpression((Seq)Seq$.MODULE$.empty());

    public CypherParser parser() {
        return this.parser;
    }

    public PathExtractorExpression f() {
        return this.f;
    }

    public void org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery(String query, AbstractQuery expectedQuery) {
        Statement parsedQuery = this.parser().parse(query, this.parser().parse$default$2());
        Statement qual$3 = StatementConverters$.MODULE$.StatementConverter(parsedQuery);
        devNullLogger$ x$5 = devNullLogger$.MODULE$;
        String x$6 = StatementConverters.StatementConverter$.MODULE$.asQuery$default$2$extension(qual$3);
        AbstractQuery abstractQuery = StatementConverters.StatementConverter$.MODULE$.asQuery$extension(qual$3, (InternalNotificationLogger)x$5, x$6);
        try {
            Assert.assertThat((String)query, (Object)abstractQuery, (Matcher)CoreMatchers.equalTo((Object)expectedQuery));
            return;
        }
        catch (AssertionError assertionError) {
            throw new AssertionError((Object)((Throwable)((Object)assertionError)).getMessage().replace("WrappedArray", "List"));
        }
    }

    public CypherParserTest() {
        this.test("shouldParseEasiestPossibleQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(1) return \"apa\"", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"apa"), "\"apa\"")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal with escaped sequence in", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\tp\\\"a\\'b\"", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\tp\"a'b"), "\"a\\tp\\\"a\\'b\"")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(1) return 'a\\tp\\'a\\\"b'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\tp'a\"b"), "'a\\tp\\'a\\\"b'")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal containing UTF-16 escape sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\uE12345\" AS x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\ue12345"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal containing UTF-32 escape sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\U000292b145\" AS x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\ud864\udeb145"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("allTheNodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(*) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("allTheRels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start r = relationship(*) return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllRelationships("r")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleAliasingOfColumnNames", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s as somethingElse", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "somethingElse")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsAnIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node:index(key = \"value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsAnNonParsedIndexQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node:index(\"key:value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndexQuery("a", "index", (Expression)new Literal((Object)"key:value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEasiestPossibleRelationshipQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = relationship(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEasiestPossibleRelationshipQueryShort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = rel(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsARelationshipIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = rel:index(key = \"value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new RelationshipByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keywordsShouldBeCaseInsensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START s = NODE(1) RETURN s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMultipleNodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1,2,3) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMultipleInputs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1), b = NODE(2) return a,b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnProp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnLiterals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return 12", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)), "12")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnAdditions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return 12+a.x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Add((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "12+a.x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("arithmeticsPrecedence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a.a/a.b*a.c-a.d*a.e", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Subtract((Expression)new Multiply((Expression)new Divide((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("a")), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("b"))), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("c"))), (Expression)new Multiply((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("d")), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("e")))), "a.a/a.b*a.c-a.d*a.e")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return (10 - 5)^2 * COS(3.1415927/4)^2", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Multiply((Expression)new Pow((Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)10)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)5))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2))), (Expression)new Pow((Expression)new CosFunction((Expression)new Divide((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415927)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)4)))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))), "(10 - 5)^2 * COS(3.1415927/4)^2")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnPropWithDecimals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.extractReturnItems = 3.1415 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("extractReturnItems")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where not(a.name = \"andres\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNotEqualTo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name <> \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLessThan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name < \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LessThan((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleGreaterThan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name > \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new GreaterThan((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLessThanOrEqual", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name <= \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LessThanOrEqual((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleRegularComparison", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where \"Andres\" =~ 'And.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LiteralRegularExpression((Expression)new Literal((Object)"Andres"), new Literal((Object)"And.*"), (Function1)Predef$.MODULE$.$conforms())).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleMultipleRegularComparison", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name =~ 'And.*' AnD a.name =~ 'And.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And.*"), (Function1)Predef$.MODULE$.$conforms()), (Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And.*"), (Function1)Predef$.MODULE$.$conforms()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleEscapedRegexs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name =~ 'And\\\\/.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And\\/.*"), (Function1)Predef$.MODULE$.$conforms())).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleGreaterThanOrEqual", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name >= \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new GreaterThanOrEqual((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("booleanLiterals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where true = false return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new True(), (Expression)new Not((Predicate)new True()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnNumericProp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where 35 = a.age return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)35)), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNegativeLiteralsAsExpected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where -35 = a.age AND (a.age > -1.2 AND a.weight=-50) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-35)), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), And$.MODULE$.apply((Predicate)new GreaterThan((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-1.2))), (Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("weight")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-50)))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldCreateNotEqualsQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where 35 <> a.age return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)35)), (Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multipleFilters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" or a.name = \"mattias\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"mattias")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldCreateXorQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = 'andres' xor a.name = 'mattias' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Xor((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"mattias")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedTo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[:KNOWS]-> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToUsingUnicodeDashes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) \u2014[:KNOWS]\ufe58> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToUsingUnicodeArrowHeads", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a\u3008\u2014[:KNOWS]\ufe58\u27e9b return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.BOTH$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutRelType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutRelTypeButWithRelVariable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a)-[r]->(b) return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToTheOtherWay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) <-[:KNOWS]- (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("twoDoubleOptionalWithFourHalfs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START a=node(1), b=node(2) OPTIONAL MATCH (a)-[r1]->(X)<-[r2]-(b), (a)<-[r3]-(Z)-[r4]->(b) return r1,r2,r3,r4 order by id(r1),id(r2),id(r3),id(r4)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("X", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("X", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("Z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("Z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r4", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new IdFunction((Expression)new Variable("r1")), true), new SortItem((Expression)new IdFunction((Expression)new Variable("r2")), true), new SortItem((Expression)new IdFunction((Expression)new Variable("r3")), true), new SortItem((Expression)new IdFunction((Expression)new Variable("r4")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("r1"), "r1"), new ReturnItem((Expression)new Variable("r2"), "r2"), new ReturnItem((Expression)new Variable("r3"), "r3"), new ReturnItem((Expression)new Variable("r4"), "r4")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldOutputVariables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "a.name")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReadPropertiesOnExpressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return (a).name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "(a).name")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleAndPredicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" and a.lastname = \"taylor\" return a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("lastname")), (Expression)new Literal((Object)"taylor")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "a.name")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithRelationOutput", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[rel:KNOWS]-> (b) return rel", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "rel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("rel"), "rel")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutEndName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "  UNNAMED43", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedInTwoSteps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[:KNOWS]-> (b) -[:FRIEND]-> (c) return c", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), RelatedTo$.MODULE$.apply("b", "c", "  UNNAMED44", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FRIEND"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("c"), "c")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("djangoCTRelationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[r:`<<KNOWS>>`]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<<KNOWS>>"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("countTheNumberOfHits", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> (b) return a, b, count(*)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new CountStar()})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "count(*)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new CountStar(), "count(*)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("countStar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return count(*) order by count(*)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new CountStar()})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count(*)"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new CountStar(), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new CountStar(), "count(*)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[r]-> (b) return distinct a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sumTheAgesOfPeople", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) -[r]-> (b) return a, b, sum(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Sum((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "sum(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new Sum((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "sum(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("avgTheAgesOfPeople", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> (b) return a, b, avg(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Avg((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "avg(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new Avg((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "avg(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("minTheAgesOfPeople", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> (b) return a, b, min(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Min((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "min(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new Min((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "min(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("maxTheAgesOfPeople", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> (b) return a, b, max(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Max((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "max(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new Max((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "max(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("singleColumnSorting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sortOnAggregatedColumn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by avg(a.name)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Avg((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name"))), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("sortOnAliasedAggregatedColumn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n = node(0) match (n)-[r:KNOWS]-(c) return n, count(c) as cnt order by cnt", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "c", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.BOTH$.MODULE$)})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Variable("cnt"), true)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Count((Expression)new Variable("c"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n"), new ReturnItem((Expression)new Count((Expression)new Variable("c")), "cnt")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleTwoSortColumns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name, a.age", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true), new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleTwoSortColumnsAscending", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name ASCENDING, a.age ASC", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true), new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("orderByDescending", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name DESCENDING", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), false)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("orderByDesc", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name desc", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), false)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("nestedBooleanOperatorsAndParentesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n = NODE(1,2,3) where (n.animal = \"monkey\" and n.food = \"banana\") or (n.animal = \"cow\" and n\n      .food=\"grass\") return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).where((Predicate)new Or(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"monkey")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"banana"))), And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"cow")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"grass"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("nestedBooleanOperatorsAndParentesisXor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n = NODE(1,2,3) where (n.animal = \"monkey\" and n.food = \"banana\") xor (n.animal = \"cow\" and n\n      .food=\"grass\") return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).where((Predicate)new Xor(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"monkey")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"banana"))), And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"cow")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"grass"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("limit5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n limit 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).limit(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("skip5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n skip 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).skip(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("skip5limit5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n skip 5 limit 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).limit(5).skip(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match (n)-[r]->(x) where type(r) = \"something\" return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).where((Predicate)new Equals((Expression)new RelationshipTypeFunction((Expression)new Variable("r")), (Expression)new Literal((Object)"something"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pathLength", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=((n)-[r]->(x)) where LENGTH(p) = 10 return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new Equals((Expression)new LengthFunction((Expression)new Variable("p")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("stringLength", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("return LENGTH('foo') = 10 as n", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new LengthFunction((Expression)new Literal((Object)"foo")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0))), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("string size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("return SIZE('foo') = 10 as n", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new SizeFunction((Expression)new Literal((Object)"foo")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0))), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("collectionSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("return SIZE([1, 2]) = 10 as n", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new SizeFunction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2))}))), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0))), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipTypeOut", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match (n)-[r]->(x) return TYPE(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipTypeFunction((Expression)new Variable("r")), "TYPE(r)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldBeAbleToParseCoalesce", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match (n)-[r]->(x) return COALESCE(r.name,x.name)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new CoalesceFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Property((Expression)new Variable("r"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name"))})), "COALESCE(r.name,x.name)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipsFromPathOutput", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=(n)-[r]->(x) return RELATIONSHIPS(p)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipFunction((Expression)new Variable("p")), "RELATIONSHIPS(p)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keepDirectionForNamedPaths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START a=node(1) match p=(b)<-[r]-(a) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("b", "a", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "b", "a", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipsFromPathInWhere", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=(n)-[r]->(x) where length(rels(p))=1 return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new Equals((Expression)new LengthFunction((Expression)new RelationshipFunction((Expression)new Variable("p"))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("countNonNullValues", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a, count(a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Count((Expression)new Variable("a"))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "count(a)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Count((Expression)new Variable("a")), "count(a)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleIdBothInReturnAndWhere", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) where id(a) = 0 return ID(a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Variable("a")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new IdFunction((Expression)new Variable("a")), "ID(a)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldBeAbleToHandleStringLiteralsWithApostrophe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node:index(key = 'value') return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleQuotationsInsideApostrophes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node:index(key = 'val\"ue') return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"val\"ue"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simplePathExample", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(0) match p = (a)-->(b) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED31", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("  UNNAMED31", "a", "b", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("threeStepsPath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(0) match p = ( (a)-[r1]->(b)-[r2]->c ) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), RelatedTo$.MODULE$.apply("b", "c", "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r1", "a", "b", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), ParsedRelation$.MODULE$.apply("r2", "b", "c", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pathsShouldBePossibleWithoutParenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(0) match p = (a)-[r]->(b) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[:knows*1..3]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithRelsIterable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[r:knows*1..3]-> (x) return length(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LengthFunction((Expression)new Variable("r")), "length(r)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("fixedVarLengthPath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[*3]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED26", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithoutMinDepth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[:knows*..3]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithRelationshipVariable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[r:knows*2..]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$, "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithoutMaxDepth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[:knows*2..]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$, "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unboundVariableLengthPath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a) -[:knows*]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED26", "a", "x", (Option)None$.MODULE$, (Option)None$.MODULE$, "knows", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalRelationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) optional match (a) --> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED37", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalTypedRelationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) optional match (a) -[:KNOWS]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED37", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalTypedAndNamedRelationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) optional match (a) -[r:KNOWS]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalNamedRelationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) optional match (a) -[r]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testAllIterablePredicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) match p=((a)-[r]->(b)) where all(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new AllInCollection((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testAnyIterablePredicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) match p=((a)-[r]->(b)) where any(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new SingleInCollection((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new AnyInCollection((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testNoneIterablePredicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) match p=((a)-[r]->(b)) where none(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new NoneInCollection((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testSingleIterablePredicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) match p=((a)-[r]->(b)) where single(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).where((Predicate)new SingleInCollection((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamAsStartNode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node({a}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("a"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamAsStartRel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = relationship({a}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new RelationshipById("pA", (Expression)new ParameterExpression("a"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testNumericParamNameAsStartNode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node({0}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("0"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForWhereLiteral", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node(1) where pA.name = {name} return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("name"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForIndexValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node:idx(key = {Value}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("pA", "idx", (Expression)new Literal((Object)"key"), (Expression)new ParameterExpression("Value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForIndexQuery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node:idx({query}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndexQuery("pA", "idx", (Expression)new ParameterExpression("query"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForSkip", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA skip {skipper}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).skip("skipper").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForLimit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA limit {stop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForLimitAndSkip", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA skip {skipper} limit {stop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).skip("skipper").limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testQuotedParams", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node({`id`}) where pA.name =~ {`regex`} return pA skip {`ski``pper`} limit {`stop`}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("id"))})).where((Predicate)new RegularExpression((Expression)new Property((Expression)new Variable("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("regex"), (Function1)Predef$.MODULE$.$conforms())).skip("ski`pper").limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForRegex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start pA = node(0) where pA.name =~ {regex} return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new RegularExpression((Expression)new Property((Expression)new Variable("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("regex"), (Function1)Predef$.MODULE$.$conforms())).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithMaxDepth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( (a)-[*..6]->(b) ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithMaxDepth and rel iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( (a)-[r*..6]->(b) ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( a-[:KNOWS*..6]->(b) ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testAllShortestPathsWithType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = allShortestPaths( a-[:KNOWS*..6]->(b) ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), false, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithoutStart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match p = shortestPath( a-[*1..3]->(b) ) WHERE a.name = 'John' AND b.name = 'Sarah' return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), true, (Option)None$.MODULE$)})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"John")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Sarah")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathExpression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return shortestPath(a-[:KNOWS*0..3]->(b)) AS path", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ShortestPathExpression(new ShortestPath("  UNNAMED34", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), true, (Option)None$.MODULE$), ShortestPathExpression$.MODULE$.apply$default$2()), "path")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shortest path with 0 as min length and no max length", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return shortestPath(a-[:KNOWS*0..]->(b)) AS path", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ShortestPathExpression(new ShortestPath("  UNNAMED34", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, true, (Option)None$.MODULE$, true, (Option)None$.MODULE$), ShortestPathExpression$.MODULE$.apply$default$2()), "path")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testForNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) where a is null return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new IsNull((Expression)new Variable("a"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testForNotNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) where a is not null return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Not((Predicate)new IsNull((Expression)new Variable("a")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("testCountDistinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) return count(distinct a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Distinct((AggregationExpression)new Count((Expression)new Variable("a")), (Expression)new Variable("a"))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count(distinct a)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Distinct((AggregationExpression)new Count((Expression)new Variable("a")), (Expression)new Variable("a")), "count(distinct a)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsPatternExistsInTheWhereClause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo1 = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED34", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where a-->(b) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo1})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo1}))), PathExpression$.MODULE$.apply$default$4()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
                RelatedTo relatedTo2 = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED43", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where exists((a)-->(b)) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo2})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo2}))), PathExpression$.MODULE$.apply$default$4()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsPatternExistsInTheReturnClause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED44", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return exists((a)-->(b)) AS result", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4())), "result")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsNotHasRelationshipInTheWhereClause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED41", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED38", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where not(a-->()) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4())))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLFAsWhiteSpace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start\na=node(0)\nwhere\na.prop=12\nreturn\na", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleUpperCaseDistinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return DISTINCT s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMathFunctions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(0) return 5 % s.x, abs(-1), round(3.1415), 2 ^ s.x, sqrt(16), sign(1)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Modulo((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)5)), (Expression)new Property((Expression)new Variable("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "5 % s.x"), new ReturnItem((Expression)new AbsFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-1))), "abs(-1)"), new ReturnItem((Expression)new RoundFunction((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415))), "round(3.1415)"), new ReturnItem((Expression)new Pow((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)new Property((Expression)new Variable("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "2 ^ s.x"), new ReturnItem((Expression)new SqrtFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)16))), "sqrt(16)"), new ReturnItem((Expression)new SignFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), "sign(1)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentAtEnd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s // COMMENT", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentAlone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s\n      // COMMENT", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentsInsideStrings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) where s.apa = '//NOT A COMMENT' return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("apa")), (Expression)new Literal((Object)"//NOT A COMMENT"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleCommentsFollowedByWhiteSpace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1)\n      //I can haz more comment?\n      return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("first last and rest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return head(nodes(p)), last(nodes(p)), tail(nodes(p))", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ContainerIndex((Expression)new NodesFunction((Expression)new Variable("p")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "head(nodes(p))"), new ReturnItem((Expression)new ContainerIndex((Expression)new NodesFunction((Expression)new Variable("p")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-1))), "last(nodes(p))"), new ReturnItem((Expression)new CollectionSliceExpression((Expression)new NodesFunction((Expression)new Variable("p")), (Option)new Some((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), (Option)None$.MODULE$), "tail(nodes(p))")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return filter(x in nodes(p) WHERE x.prop = 123)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new FilterFunction((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "filter(x in nodes(p) WHERE x.prop = 123)")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in nodes(p) WHERE x.prop = 123]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new FilterFunction((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "[x in nodes(p) WHERE x.prop = 123]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("extract", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in nodes(p) | x.prop]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ExtractFunction((Expression)new NodesFunction((Expression)new Variable("p")), "x", (Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "[x in nodes(p) | x.prop]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("listComprehension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in rels(p) WHERE x.prop > 123 | x.prop]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ExtractFunction((Expression)new FilterFunction((Expression)new RelationshipFunction((Expression)new Variable("p")), "x", (Predicate)new GreaterThan((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "x", (Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "[x in rels(p) WHERE x.prop > 123 | x.prop]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) return ['a','b','c']", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)"b"), new Literal((Object)"c")})), "['a','b','c']")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) return []", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Nil$.MODULE$), "[]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) return [1,2,3]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))})), "[1,2,3]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal4", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) return ['a',2]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)BoxesRunTime.boxToInteger((int)2))})), "['a',2]")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("in with collection literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) where x.prop in ['a','b'] return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new ConstantCachedIn((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)"b")})))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("in with collection prop", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) where x.prop in x.props return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new DynamicCachedIn((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("props")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in varlength rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in shortest path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in relationship predicate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED34", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS", "BLOCKS"})), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where a-[:KNOWS|:BLOCKS]-b return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("first parsed pipe query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START x = node(1) WITH x WHERE x.foo = 42 RETURN x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("read first and update next", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)new Multiply((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) with a create (b {age : a.age * 2}) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variable length path with collection for relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) optional match (a) -[r*1..3]-> (x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED35", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)new Some((Object)"r"), (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("binary precedence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0) where n.a = 'x' and n.b = 'x' xor n.c = 'x' or n.d = 'x' return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Or((Predicate)new Xor(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("a")), (Expression)new Literal((Object)"x")), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("b")), (Expression)new Literal((Object)"x"))), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("c")), (Expression)new Literal((Object)"x"))), (Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("d")), (Expression)new Literal((Object)"x")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node from param", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create ({param})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("  UNNAMED7", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {name : 'Andres'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a property and return it", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {name : 'Andres'}) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node from map expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {param})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a:FOO)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with multiple labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a:FOO:BAR)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with multiple labels with spaces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a :FOO :BAR)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create nodes with labels and a rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE (n:Person:Husband)-[:FOO]->(x:Person)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED25", new RelationshipEndpoint((Expression)new Variable("n"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person", "Husband"}))), new RelationshipEndpoint((Expression)new Variable("x"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}))), "FOO", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) with a,b create a-[r:REL]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship make outgoing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a<-[r:REL]-b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship make outgoing named", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create p=a<-[r:REL]-b return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship with properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"why"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new Literal((Object)"bar"))}))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) with a,b create a-[r:REL {why : 42, foo : 'bar'}]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship without variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship with properties from map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL {param}]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship without variable2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("delete node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Variable("a"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) with a delete a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple delete node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Variable("a"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) delete a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("delete rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Variable("r"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match (a)-[r:REL]->(b) delete r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("delete path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Variable("p"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match p=(a)-[r:REL]->(b) delete p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set property on node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set property on node from expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) with a set (a).hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set multiple properties on node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world")), new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), (Expression)new Literal((Object)"bar"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.hello = 'world', a.foo = 'bar'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("update property with expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Multiply((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.salary = a.salary * 2 ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("remove property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeletePropertyAction((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) remove a.salary", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach on path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new NodesFunction((Expression)new Variable("p")), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertySetAction[]{new PropertySetAction(new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("touched")), (Expression)new True())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match p = a-[r:REL]->(b) with p foreach(n in nodes(p) | set n.touched = true ) ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach on path with multiple updates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))})), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateRelationship[]{new CreateRelationship("r1", RelationshipEndpoint$.MODULE$.apply("x"), RelationshipEndpoint$.MODULE$.apply("z"), "HAS", (Map)Predef$.MODULE$.Map().empty()), new CreateRelationship("r2", RelationshipEndpoint$.MODULE$.apply("x"), RelationshipEndpoint$.MODULE$.apply("z2"), "HAS", (Map)Predef$.MODULE$.Map().empty())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (n) foreach(n in [1,2,3] | create (x)-[r1:HAS]->(z) create (x)-[r2:HAS]->(z2) )", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple read first and update next", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)new Multiply((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("b"), "b")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) create (b {age : a.age * 2}) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple start with two nodes and create relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a-[r:REL]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple create relationship with properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"why"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new Literal((Object)"bar"))}))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a<-[r:REL {why : 42, foo : 'bar'}]-b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple set property on node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) set a.hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple update property with expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Multiply((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) set a.salary = a.salary * 2 ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple foreach on path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new NodesFunction((Expression)new Variable("p")), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertySetAction[]{new PropertySetAction(new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("touched")), (Expression)new True())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) match p = a-[r:REL]->(b) foreach(n in nodes(p) | set n.touched = true ) ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("returnAll", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single create unique", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "  UNNAMED44", "reltype", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[:reltype]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single create unique with rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "r", "reltype", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[r:reltype]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single relate with empty parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "  UNNAMED57", "  UNNAMED44", "reltype", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[:reltype]->()", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique with two patterns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "  UNNAMED35", "X", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), UniqueLink$.MODULE$.apply("c", "b", "  UNNAMED45", "X", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) create unique (a)-[:X]->(b)<-[:X]-c", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relate with initial values for node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(NamedExpectation$.MODULE$.apply("a"), NamedExpectation$.MODULE$.apply("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))}))), NamedExpectation$.MODULE$.apply("  UNNAMED33"), "X", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) create unique a-[:X]->(b {name:'Andres'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique with initial values for rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(NamedExpectation$.MODULE$.apply("a"), NamedExpectation$.MODULE$.apply("b"), NamedExpectation$.MODULE$.apply("  UNNAMED33", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))}))), "X", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) create unique a-[:X {name:'Andres'}]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach with literal collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query tail = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToDouble((double)1.0)), new Literal((Object)BoxesRunTime.boxToDouble((double)2.0)), new Literal((Object)BoxesRunTime.boxToDouble((double)3.0))})), "x", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)new Variable("x"))})), (Seq)Seq$.MODULE$.empty())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create root foreach(x in [1,2,3] | create (a {number:x}))", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("root", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).tail(tail).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("string literals should not be mistaken for variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (tag1 {name:'tag2'}), (tag2 {name:'tag1'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("tag1", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"tag2"))})), (Seq)Seq$.MODULE$.empty())), new CreateNodeStartItem(new CreateNode("tag2", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"tag1"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relate with two rels to same node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query returns = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("root", "x", "r1", "X", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$), UniqueLink$.MODULE$.apply("root", "x", "r2", "Y", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("x"), "x")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start root=node(0) create unique (x)<-[r1:X]-(root)-[r2:Y]->(x) return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("root", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(returns).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("optional shortest path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a  = node(1), x = node(2,3)\n         optional match p = shortestPath((a) -[*]-> (x))\n         return *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 3L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)None$.MODULE$, true, (Option)None$.MODULE$)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("return paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED30", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED27", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a  = node(1) return a-->()", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4()), "a-->()")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("not with parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a  = node(1) where not(1=2) or 2=3 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Not((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))), (Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)3))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("precedence of not without parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where not true or false return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Not((Predicate)new True()), (Predicate)new Not((Predicate)new True()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = node(1) where not 1 < 2 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new LessThan((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("not with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (admin) WHERE NOT (admin)-[:MEMBER_OF]->() RETURN admin", (AbstractQuery)this.parsedQueryWithOffsets$1(31, 46));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (admin) WHERE NOT ((admin)-[:MEMBER_OF]->()) RETURN admin", (AbstractQuery)this.parsedQueryWithOffsets$1(32, 47));
            }

            private final Query parsedQueryWithOffsets$1(int offset1, int offset2) {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("admin", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode(new StringBuilder().append((Object)"  UNNAMED").append((Object)BoxesRunTime.boxToInteger((int)offset2)).toString(), SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new StringBuilder().append((Object)"  UNNAMED").append((Object)BoxesRunTime.boxToInteger((int)offset1)).toString(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEMBER_OF"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                return Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("admin", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Not((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4())))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("admin"), "admin")}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("full path in create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r1", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("  UNNAMED48"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "KNOWS", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), new CreateRelationshipStartItem(new CreateRelationship("r2", new RelationshipEndpoint((Expression)new Variable("  UNNAMED48"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "LOVES", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(1), b=node(2) create a-[r1:KNOWS]->()-[r2:LOVES]->(b)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create and assign to path variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create p = a-[r:KNOWS]->() return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("  UNNAMED24"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "KNOWS", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "  UNNAMED24", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relate and assign to path variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "  UNNAMED47", "r", "KNOWS", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "  UNNAMED47", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a=node(0) create unique p = a-[r:KNOWS]->() return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("use predicate as expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0) return id(n) = 0, n is null", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new IdFunction((Expression)new Variable("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "id(n) = 0"), new ReturnItem((Expression)new IsNull((Expression)new Variable("n")), "n is null")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique should support parameter maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NamedExpectation start = NamedExpectation$.MODULE$.apply("n");
                NamedExpectation rel = NamedExpectation$.MODULE$.apply("  UNNAMED33");
                NamedExpectation end = NamedExpectation$.MODULE$.apply("  UNNAMED42", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty());
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(start, end, rel, "foo", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) CREATE UNIQUE (n)-[:foo]->({param}) RETURN *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("with limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0,1,2) with n limit 2 where ID(n) = 1 return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}))})).limit(2).tail(Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Variable("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")}))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("with sort limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0,1,2) with n order by ID(n) desc limit 2 where ID(n) = 1 return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new IdFunction((Expression)new Variable("n")), false)})).limit(2).tail(Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Variable("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")}))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set to param", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Variable("n"), (Expression)new ParameterExpression("prop"), true)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0) set n = {prop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("inclusive set to param", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Variable("n"), (Expression)new ParameterExpression("prop"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0) set n += {prop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("set to map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Variable("n"), (Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new Literal((Object)"value")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))}))), true)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(0) set n = {key: 'value', foo: 1}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("add label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelSetOp$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken.Unresolved[]{new KeyToken.Unresolved("LabelName", (TokenType)TokenType.Label$.MODULE$)})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) set n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("add short label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelSetOp$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken.Unresolved[]{new KeyToken.Unresolved("LabelName", (TokenType)TokenType.Label$.MODULE$)})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) SET n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) set n :LabelName2 :LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple short labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) set n:LabelName2:LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple short labels2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) SET n :LabelName2 :LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("remove label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelRemoveOp$.MODULE$, LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName"})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) REMOVE n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("remove multiple labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Variable("n"), (LabelOp)LabelRemoveOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) REMOVE n:LabelName2:LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by label in where", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE (n):Foo RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new HasLabel((Expression)new Variable("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by label in where with expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE (n):Foo RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new HasLabel((Expression)new Variable("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by labels in where", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE n:Foo:Bar RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where(And$.MODULE$.apply((Predicate)new HasLabel((Expression)new Variable("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$)), (Predicate)new HasLabel((Expression)new Variable("n"), (KeyToken)new KeyToken.Unresolved("Bar", (TokenType)TokenType.Label$.MODULE$)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create no index without properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$219 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create index on :MyLabel", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), CreateIndex$.MODULE$.apply$default$3()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(SyntaxException.class)));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create index on single property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create index on :MyLabel(prop1)", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1"})), CreateIndex$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create index on multiple properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$221 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create index on :MyLabel(prop1, prop2)", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1", "prop2"})), CreateIndex$.MODULE$.apply$default$3()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(SyntaxException.class)));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match left with single label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a:foo) -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED47", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match left with multiple labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a:foo:bar) -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo"), UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED51", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match right with multiple labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match () -[r:MARRIED]-> (a:foo:bar) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("  UNNAMED24", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo"), UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match both with labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (b:foo) -[r:MARRIED]-> (a:bar) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("union ftw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q1 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")}));
                Query q2 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("t", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("t"), "t")}));
                Query q3 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("u", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("u"), "u")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s UNION all start t = NODE(1) return t UNION all start u = NODE(1) return u", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q1, q2, q3})), QueryString$.MODULE$.empty(), false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("union distinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s UNION start s = NODE(1) return s UNION start s = NODE(1) return s", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q, q, q})), QueryString$.MODULE$.empty(), true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple unions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).limit(1).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "(n)")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (n) RETURN (n) LIMIT 1 UNION MATCH (n) RETURN (n) LIMIT 1 UNION MATCH (n) RETURN (n) LIMIT 1", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q, q, q})), QueryString$.MODULE$.empty(), true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keywords in reltype and label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START n=node(0) MATCH (n:On)-[:WHERE]->() RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("On")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED39", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("remove index on single property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("drop index on :MyLabel(prop1)", (AbstractQuery)new DropIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1"})), DropIndex$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple query with index hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (n:Person)-->() using index n:Person(name) where n.name = 'Andres' return n", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED19", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres"))).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new SchemaIndex("n", "Person", "name", (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple in expression with index hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (n:Person)-->() using index n:Person(name) where n.name IN ['Andres'] return n", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED19", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new ConstantCachedIn((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"Andres")})))).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new SchemaIndex("n", "Person", "name", (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single node match pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(*) match (s) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("awesome single labeled node match pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (s:nostart) return s", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("nostart")})), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single node match pattern path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start s = node(*) match p = s return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedEntity$.MODULE$.apply("s")}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("label scan hint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (p:Person) using scan p:Person return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("p", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3())})).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByLabel("p", "Person")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("varlength named path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(1) match p=(n)-[:KNOWS*..2]->(x) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED27", new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED27", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("n"), ParsedEntity$.MODULE$.apply("x"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("reduce function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Collection collection = new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))}));
                Add expression = new Add((Expression)new Variable("acc"), (Expression)new Variable("x"));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start n=node(1) return reduce(acc = 0, x in [1,2,3] | acc + x)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ReduceFunction((Expression)collection, "x", (Expression)expression, "acc", (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "reduce(acc = 0, x in [1,2,3] | acc + x)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start and endNode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("start r=rel(1) return startNode(r), endNode(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("r", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipEndPoints((Expression)new Variable("r"), true), "startNode(r)"), new ReturnItem((Expression)new RelationshipEndPoints((Expression)new Variable("r"), false), "endNode(r)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mathy aggregation expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property property = new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("property"));
                PercentileCont percentileCont = new PercentileCont((Expression)property, (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.4)));
                PercentileDisc percentileDisc = new PercentileDisc((Expression)property, (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)));
                Stdev stdev = new Stdev((Expression)property);
                StdevP stdevP = new StdevP((Expression)property);
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (n) return percentileCont(n.property, 0.4), percentileDisc(n.property, 0.5), stdev(n.property), stdevp(n.property)", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{percentileCont, percentileDisc, stdev, stdevP})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)percentileCont, "percentileCont(n.property, 0.4)"), new ReturnItem((Expression)percentileDisc, "percentileDisc(n.property, 0.5)"), new ReturnItem((Expression)stdev, "stdev(n.property)"), new ReturnItem((Expression)stdevP, "stdevp(n.property)")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("escaped variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match `Unusual variable` return `Unusual variable`.propertyName", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("Unusual variable", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("Unusual variable"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("propertyName")), "`Unusual variable`.propertyName")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("aliased column does not keep escape symbols", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (a) return a as `Escaped alias`", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "Escaped alias")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create with labels and props with parens", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE (node :FOO:BAR {name: 'Stefan'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("node", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Stefan"))})), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("constraint creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON (id:Label) ASSERT id.property IS UNIQUE", (AbstractQuery)new CreateUniqueConstraint("id", "Label", "id", "property", CreateUniqueConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node property existence constraint creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON (id:Label) ASSERT exists(id.property)", (AbstractQuery)new CreateNodePropertyExistenceConstraint("id", "Label", "id", "property", CreateNodePropertyExistenceConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node property existence constraint deletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("DROP CONSTRAINT ON (id:Label) ASSERT exists(id.property)", (AbstractQuery)new DropNodePropertyExistenceConstraint("id", "Label", "id", "property", DropNodePropertyExistenceConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationship property existence constraint creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON ()-[id:RelType]-() ASSERT exists(id.property)", (AbstractQuery)new CreateRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", CreateRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON ()-[id:RelType]->() ASSERT exists(id.property)", (AbstractQuery)new CreateRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", CreateRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON ()<-[id:RelType]-() ASSERT exists(id.property)", (AbstractQuery)new CreateRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", CreateRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("relationship property existence constraint deletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("DROP CONSTRAINT ON ()-[id:RelType]-() ASSERT exists(id.property)", (AbstractQuery)new DropRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", DropRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("DROP CONSTRAINT ON ()-[id:RelType]->() ASSERT exists(id.property)", (AbstractQuery)new DropRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", DropRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("DROP CONSTRAINT ON ()<-[id:RelType]-() ASSERT exists(id.property)", (AbstractQuery)new DropRelationshipPropertyExistenceConstraint("id", "RelType", "id", "property", DropRelationshipPropertyExistenceConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("named path with variable length path and named relationships collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match p = (a)-[r*]->(b) return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED13", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)new Some((Object)"r"), (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED13", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("a"), ParsedEntity$.MODULE$.apply("b"), (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"r"))}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("variable length relationship with rel collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (a)-[rels*]->(b) WHERE ALL(r in rels WHERE r.prop = 42) RETURN rels", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED9", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Option)new Some((Object)"rels"), (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new AllInCollection((Expression)new Variable("rels"), "r", (Predicate)new Equals((Expression)new Property((Expression)new Variable("r"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("rels"), "rels")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("simple case statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (a) RETURN CASE a.prop WHEN 1 THEN 'hello' ELSE 'goodbye' END AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new SimpleCase((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Literal((Object)"hello"))})), (Option)new Some((Object)new Literal((Object)"goodbye"))), "result")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("generic case statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (a) RETURN CASE WHEN a.prop = 1 THEN 'hello' ELSE 'goodbye' END AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new GenericCase((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Equals((Expression)new Property((Expression)new Variable("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), (Object)new Literal((Object)"hello"))})), (Option)new Some((Object)new Literal((Object)"goodbye"))), "result")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("genericCaseCoercesInWhen", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo relatedTo = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED41", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED30", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOVES"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery(new StringOps(Predef$.MODULE$.augmentString("MATCH (a) RETURN CASE WHEN (a)-[:LOVES]->() THEN 1 ELSE 0 END AS result")).stripMargin(), (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new GenericCase((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo})), (Predicate)new True(), (Expression)new PathExtractorExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{relatedTo}))), PathExpression$.MODULE$.apply$default$4())), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))})), (Option)new Some((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)0)))), "result")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldGroupCreateAndCreateUpdate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query thirdQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("wife", "friendOfFriend", "  UNNAMED128", "KNOWS", (SemanticDirection)SemanticDirection.BOTH$.MODULE$)})))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("  UNNAMED128", "wife", "friendOfFriend", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), (SemanticDirection)SemanticDirection.BOTH$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("p1"), "p1"), new ReturnItem((Expression)new Variable("p2"), "p2"), new ReturnItem((Expression)new Variable("p3"), "p3")}));
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED65", new RelationshipEndpoint((Expression)new Variable("me"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("wife"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Gunhild"))})), (Seq)Seq$.MODULE$.empty()), "MARRIED_TO", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedRelation("  UNNAMED65", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), ParsedEntity$.MODULE$.apply("me"), new ParsedEntity("wife", (Expression)new Variable("wife"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Gunhild"))})), (Seq)Seq$.MODULE$.empty()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED_TO"})), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, false)}))})).tail(thirdQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("START me=node(0) MATCH p1 = me-[*2]-friendOfFriend CREATE p2 = me-[:MARRIED_TO]->(wife {name:\"Gunhild\"}) CREATE UNIQUE p3 = wife-[:KNOWS]-friendOfFriend RETURN p1,p2,p3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("me", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED30", new SingleNode("me", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("friendOfFriend", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED30", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("me"), ParsedEntity$.MODULE$.apply("friendOfFriend"), (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("return only query with literal map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("RETURN { key: 'value' }", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new Literal((Object)"value"))}))), "{ key: 'value' }")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("access nested properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query tail = Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Property((Expression)new Variable("person"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("address")), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("city")), "person.address.city")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("WITH { name:'Alice', address: { city:'London', residential:true }} AS person RETURN person.address.city", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).tail(tail).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Alice")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"address"), (Object)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)new Literal((Object)"London")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"residential"), (Object)new True())}))))}))), "person")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("long match chain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("match (a)<-[r1:REL1]-(b)<-[r2:REL2]-(c) return a, b, c", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1"})), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$), RelatedTo$.MODULE$.apply("b", "c", "r2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL2"})), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("a"), "a"), new ReturnItem((Expression)new Variable("b"), "b"), new ReturnItem((Expression)new Variable("c"), "c")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("long create chain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("create (a)<-[r1:REL1]-(b)<-[r2:REL2]-(c)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r1", new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("a"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), "REL1", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), new CreateRelationshipStartItem(new CreateRelationship("r2", new RelationshipEndpoint((Expression)new Variable("c"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Variable("b"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), "REL2", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test literal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("RETURN 0.5, .5, 50, -0.3, -33, 1E-10, -4.5E23, 0x45fd, -0xdc5e", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)), "0.5"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)), ".5"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)50)), "50"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-0.3)), "-0.3"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-33)), "-33"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)1.0E-10)), "1E-10"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-4.5E23)), "-4.5E23"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)17917)), "0x45fd"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-56414)), "-0xdc5e")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test unary plus minus", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH n WHERE n.prop=+2 RETURN -n.prop, +n.foo, 1 + -n.bar", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Equals((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "-n.prop"), new ReturnItem((Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), "+n.foo"), new ReturnItem((Expression)new Add((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("bar")))), "1 + -n.bar")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compile query integration test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement parsedQuery = this.$outer.parser().parse("create (a1) create (a2) create (a3) create (a4) create (a5) create (a6) create (a7)", this.$outer.parser().parse$default$2());
                Statement qual$1 = StatementConverters$.MODULE$.StatementConverter(parsedQuery);
                devNullLogger$ x$1 = devNullLogger$.MODULE$;
                String x$2 = StatementConverters.StatementConverter$.MODULE$.asQuery$default$2$extension(qual$1);
                Query q = (Query)StatementConverters.StatementConverter$.MODULE$.asQuery$extension(qual$1, (InternalNotificationLogger)x$1, x$2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.tail().nonEmpty(), "q.tail.nonEmpty");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"wasn't compacted enough");
                Query compacted = q.compact();
                Option $org_scalatest_assert_macro_left = compacted.tail();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"wasn't compacted enough");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)compacted.start().size()));
                int $org_scalatest_assert_macro_right = 7;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"lost create commands");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle optional match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("OPTIONAL MATCH n RETURN n", (AbstractQuery)Query$.MODULE$.optionalMatches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compile query integration test 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query compacted;
                Statement parsedQuery = this.$outer.parser().parse("create (a1) create (a2) create (a3) with a1 create (a4) return a1, a4", this.$outer.parser().parse$default$2());
                Statement qual$2 = StatementConverters$.MODULE$.StatementConverter(parsedQuery);
                devNullLogger$ x$3 = devNullLogger$.MODULE$;
                String x$4 = StatementConverters.StatementConverter$.MODULE$.asQuery$default$2$extension(qual$2);
                Query q = (Query)StatementConverters.StatementConverter$.MODULE$.asQuery$extension(qual$2, (InternalNotificationLogger)x$3, x$4);
                Query lastQ = compacted = q.compact();
                while (lastQ.tail().nonEmpty()) {
                    lastQ = (Query)lastQ.tail().get();
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lastQ.returns().columns());
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a4"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lost the tail while compacting");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle optional match following optional match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query last = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "c", "r2", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.INCOMING$.MODULE$)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()}));
                Query second = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "b", "r1", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).makeOptional().tail(last).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()}));
                Query first = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).tail(second).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (n) OPTIONAL MATCH (n)-[r1]->(b) OPTIONAL MATCH (n)<-[r2]-(c) RETURN *", (AbstractQuery)first);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle match properties pointing to other parts of pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleNode nodeA = new SingleNode("a", (Seq)Seq$.MODULE$.empty(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new Property((Expression)new Variable("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("bar")))})));
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (a { foo:x.bar })-->(x) RETURN *", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(nodeA, new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED23", (Seq)Seq$.MODULE$.empty(), (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow both relationships and nodes to be set with maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH (a)-[r:KNOWS]->(b) SET r = { id: 42 }", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "KNOWS", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$)})).tail(Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Variable("r"), (Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42)))}))), true)})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow whitespace in multiple word operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("OPTIONAL\t MATCH (n) WHERE n  IS   NOT\n /* possibly */ NULL    RETURN n", (AbstractQuery)Query$.MODULE$.optionalMatches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Not((Predicate)new IsNull((Expression)new Variable("n")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow append to empty collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("return [] + 1 AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Add((Expression)new Collection((Seq)Nil$.MODULE$), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), "result")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle load and return as map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("LOAD CSV WITH HEADERS FROM 'file:///tmp/file.cvs' AS line RETURN line.key", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(true, (Expression)new Literal((Object)"file:///tmp/file.cvs"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("line"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("key")), "line.key")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV with the file URL specified as a parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("LOAD CSV WITH HEADERS FROM {path} AS line RETURN line.key", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(true, (Expression)new ParameterExpression("path"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("line"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("key")), "line.key")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV with the file URL specified being an arbitrary expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("MATCH n WITH n LOAD CSV WITH HEADERS FROM n.path AS line RETURN line.key", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).tail(Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(true, (Expression)new Property((Expression)new Variable("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("path")), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Variable("line"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("key")), "line.key")}))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle load and return", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("LOAD CSV FROM 'file:///tmp/file.cvs' AS line RETURN line", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/file.cvs"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Variable("line"), "line")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse a periodic commit query with size followed by LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("USING PERIODIC COMMIT 10 LOAD CSV FROM 'file:///tmp/foo.csv' AS line CREATE x", (AbstractQuery)new PeriodicCommitQuery((AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/foo.csv"), "line", (Option)None$.MODULE$)})).tail(Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("x", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})), (Option)new Some((Object)BoxesRunTime.boxToLong((long)10L))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse a periodic commit query without size followed by LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$expectQuery("USING PERIODIC COMMIT LOAD CSV FROM 'file:///tmp/foo.csv' AS line CREATE x", (AbstractQuery)new PeriodicCommitQuery((AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/foo.csv"), "line", (Option)None$.MODULE$)})).tail(Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("x", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllVariables()})), (Option)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject a periodic commit query not followed by LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$275 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().parser().parse("USING PERIODIC COMMIT CREATE ()", this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().parser().parse$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject a periodic commit query followed by LOAD CSV and a union", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$276 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().parser().parse("USING PERIODIC COMMIT LOAD CSV  FROM 'file:///tmp/foo.csv' AS line CREATE x UNION MATCH n RETURN n", this.$outer.org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer().parser().parse$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v3_1$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

