/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.pipes;

import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyPropertyKey;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyPropertyKey$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.TokenContext;
import org.neo4j.cypher.internal.frontend.v3_1.DummyPosition$;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001#\t\u0019B*\u0019>z!J|\u0007/\u001a:us.+\u0017\u0010V3ti*\u00111\u0001B\u0001\u0006a&\u0004Xm\u001d\u0006\u0003\u000b\u0019\tAA^\u001a`c)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u001d\t\u0003A1A\u0005\n\t\n1\u0001]8t+\u0005\u0019\u0003C\u0001\u0013&\u001b\u00051\u0012B\u0001\u0014\u0017\u00055Ie\u000e];u!>\u001c\u0018\u000e^5p]\"1\u0001\u0006\u0001Q\u0001\n\r\nA\u0001]8tA!9!\u0006\u0001b\u0001\n\u0013Y\u0013!\u0005)S\u001fB+%\u000bV-`\u0017\u0016KvLT!N\u000bV\tA\u0006\u0005\u0002.a5\taF\u0003\u00020-\u0005\u0019\u0011m\u001d;\n\u0005Er#a\u0004)s_B,'\u000f^=LKft\u0015-\\3\t\rM\u0002\u0001\u0015!\u0003-\u0003I\u0001&k\u0014)F%RKvlS#Z?:\u000bU*\u0012\u0011\t\u000fU\u0002!\u0019!C\u0005m\u0005y\u0001KU(Q\u000bJ#\u0016lX&F3~KE)F\u00018!\t!\u0003(\u0003\u0002:-\ti\u0001K]8qKJ$\u0018pS3z\u0013\u0012Daa\u000f\u0001!\u0002\u00139\u0014\u0001\u0005)S\u001fB+%\u000bV-`\u0017\u0016Kv,\u0013#!\u0001")
public class LazyPropertyKeyTest
extends CypherFunSuite {
    private final InputPosition pos = DummyPosition$.MODULE$.apply(0);
    private final PropertyKeyName org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME = new PropertyKeyName("foo", this.pos());
    private final PropertyKeyId org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID = new PropertyKeyId(42);

    private InputPosition pos() {
        return this.pos;
    }

    public PropertyKeyName org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME() {
        return this.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME;
    }

    public PropertyKeyId org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID() {
        return this.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID;
    }

    public LazyPropertyKeyTest() {
        this.test("if key is resolved, don't do any lookups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyPropertyKeyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = (SemanticTable)this.$outer.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class));
                TokenContext context = (TokenContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(TokenContext.class));
                Mockito.when((Object)table.resolvedPropertyKeyNames()).thenReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME().name()), (Object)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID())})));
                Option id = LazyPropertyKey$.MODULE$.apply(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME(), table).id(context);
                this.$outer.convertToAnyShouldWrapper(id).should(this.$outer.equal(new Some((Object)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID())), (Object)Equality$.MODULE$.default());
                Mockito.verifyZeroInteractions((Object[])new Object[]{context});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if key is not resolved, do a lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyPropertyKeyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = (SemanticTable)this.$outer.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class));
                TokenContext context = (TokenContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(TokenContext.class));
                Mockito.when((Object)context.getOptPropertyKeyId(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME().name())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID().id())));
                Mockito.when((Object)table.resolvedPropertyKeyNames()).thenReturn((Object)Map$.MODULE$.empty());
                Option id = LazyPropertyKey$.MODULE$.apply(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME(), table).id(context);
                this.$outer.convertToAnyShouldWrapper(id).should(this.$outer.equal(new Some((Object)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID())), (Object)Equality$.MODULE$.default());
                ((TokenContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).getOptPropertyKeyId("foo");
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{context});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple calls to id should result in only one lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyPropertyKeyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = (SemanticTable)this.$outer.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class));
                TokenContext context = (TokenContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(TokenContext.class));
                Mockito.when((Object)context.getOptPropertyKeyId(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME().name())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_ID().id())));
                Mockito.when((Object)table.resolvedPropertyKeyNames()).thenReturn((Object)Map$.MODULE$.empty());
                LazyPropertyKey lazyPropertyKey = LazyPropertyKey$.MODULE$.apply(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$pipes$LazyPropertyKeyTest$$PROPERTY_KEY_NAME(), table);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).foreach((Function1)new Serializable(this, context, lazyPropertyKey){
                    public static final long serialVersionUID = 0L;
                    private final TokenContext context$1;
                    private final LazyPropertyKey lazyPropertyKey$1;

                    public final Option<PropertyKeyId> apply(int i) {
                        return this.lazyPropertyKey$1.id(this.context$1);
                    }
                    {
                        this.context$1 = context$1;
                        this.lazyPropertyKey$1 = lazyPropertyKey$1;
                    }
                });
                ((TokenContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).getOptPropertyKeyId("foo");
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{context});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

