/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.pipes;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyLabel$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.NodeCountFromCountStorePipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.NodeCountFromCountStorePipe$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QueryContext;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId$;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001#\tybj\u001c3f\u0007>,h\u000e\u001e$s_6\u001cu.\u001e8u'R|'/\u001a)ja\u0016$Vm\u001d;\u000b\u0005\r!\u0011!\u00029ja\u0016\u001c(BA\u0003\u0007\u0003\u001118gX\u0019\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%m\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003!1'o\u001c8uK:$\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\f\u0002\u0007\u0005\u001cH/\u0003\u0002!;\tQ\u0012i\u001d;D_:\u001cHO];di&|g\u000eV3tiN+\b\u000f]8si\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011A\u0001\u0005\bO\u0001\u0011\r\u0011b\u0001)\u0003\u001diwN\\5u_J,\u0012!\u000b\t\u0003K)J!a\u000b\u0002\u0003\u0017AK\u0007/Z'p]&$xN\u001d\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002\u00115|g.\u001b;pe\u0002\u0002")
public class NodeCountFromCountStorePipeTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final PipeMonitor monitor;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public NodeCountFromCountStorePipeTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));
        this.test("should return a count for nodes with a label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                table.resolvedLabelIds().put((Object)"A", (Object)new LabelId(12));
                String x$4 = "count(n)";
                Some x$5 = new Some((Object)LazyLabel$.MODULE$.apply((LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("A", position);
                    }
                }), table));
                Option x$6 = NodeCountFromCountStorePipe$.MODULE$.apply$default$3(x$4, (Option)x$5);
                NodeCountFromCountStorePipe pipe = new NodeCountFromCountStorePipe(x$4, (Option)x$5, x$6, this.$outer.monitor());
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith((QueryContext)Mockito.when((Object)BoxesRunTime.boxToLong((long)((QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class))).nodeCountByCountStore(12))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L)).getMock(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$1) {
                        return x$1.apply((Object)"count(n)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return zero if label is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                String x$7 = "count(n)";
                Some x$8 = new Some((Object)LazyLabel$.MODULE$.apply((LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("A", position);
                    }
                }), table));
                Option x$9 = NodeCountFromCountStorePipe$.MODULE$.apply$default$3(x$7, (Option)x$8);
                NodeCountFromCountStorePipe pipe = new NodeCountFromCountStorePipe(x$7, (Option)x$8, x$9, this.$outer.monitor());
                QueryContext mockedContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)mockedContext.nodeCountByCountStore(12))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L));
                Mockito.when((Object)mockedContext.getOptLabelId("A")).thenReturn((Object)None$.MODULE$);
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(mockedContext, QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$2) {
                        return x$2.apply((Object)"count(n)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return a count for nodes without a label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String x$10 = "count(n)";
                None$ x$11 = None$.MODULE$;
                Option x$12 = NodeCountFromCountStorePipe$.MODULE$.apply$default$3(x$10, (Option)x$11);
                NodeCountFromCountStorePipe pipe = new NodeCountFromCountStorePipe(x$10, (Option)x$11, x$12, this.$outer.monitor());
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith((QueryContext)Mockito.when((Object)BoxesRunTime.boxToLong((long)((QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class))).nodeCountByCountStore(NameId$.MODULE$.WILDCARD()))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L)).getMock(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$3) {
                        return x$3.apply((Object)"count(n)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

