/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.pipes;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyLabel$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyTypes;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.RelationshipCountFromCountStorePipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.RelationshipCountFromCountStorePipe$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QueryContext;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId$;
import org.neo4j.cypher.internal.frontend.v3_1.RelTypeId;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.RelTypeName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001#\t9#+\u001a7bi&|gn\u001d5ja\u000e{WO\u001c;Ge>l7i\\;oiN#xN]3QSB,G+Z:u\u0015\t\u0019A!A\u0003qSB,7O\u0003\u0002\u0006\r\u0005!aoM02\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IY\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0017\u0003\r\t7\u000f^\u0005\u0003Au\u0011!$Q:u\u0007>t7\u000f\u001e:vGRLwN\u001c+fgR\u001cV\u000f\u001d9peRDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000f\u001d\u0002!\u0019!C\u0002Q\u00059Qn\u001c8ji>\u0014X#A\u0015\u0011\u0005\u0015R\u0013BA\u0016\u0003\u0005-\u0001\u0016\u000e]3N_:LGo\u001c:\t\r5\u0002\u0001\u0015!\u0003*\u0003!iwN\\5u_J\u0004\u0003")
public class RelationshipCountFromCountStorePipeTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final PipeMonitor monitor;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public RelationshipCountFromCountStorePipeTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));
        this.test("should return a count for relationships without a type or any labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationshipCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String x$5 = "count(r)";
                None$ x$6 = None$.MODULE$;
                LazyTypes x$7 = LazyTypes$.MODULE$.empty();
                None$ x$8 = None$.MODULE$;
                Option x$9 = RelationshipCountFromCountStorePipe$.MODULE$.apply$default$5(x$5, (Option)x$6, x$7, (Option)x$8);
                RelationshipCountFromCountStorePipe pipe = new RelationshipCountFromCountStorePipe(x$5, (Option)x$6, x$7, (Option)x$8, x$9, this.$outer.monitor());
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith((QueryContext)Mockito.when((Object)BoxesRunTime.boxToLong((long)((QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class))).relationshipCountByCountStore(NameId$.MODULE$.WILDCARD(), NameId$.MODULE$.WILDCARD(), NameId$.MODULE$.WILDCARD()))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L)).getMock(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$1) {
                        return x$1.apply((Object)"count(r)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return a count for relationships with a type but no labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationshipCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                table.resolvedRelTypeNames().put((Object)"X", (Object)new RelTypeId(22));
                String x$10 = "count(r)";
                None$ x$11 = None$.MODULE$;
                LazyTypes x$12 = LazyTypes$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelTypeName[]{new RelTypeName("X", this.$outer.pos())})), table);
                None$ x$13 = None$.MODULE$;
                Option x$14 = RelationshipCountFromCountStorePipe$.MODULE$.apply$default$5(x$10, (Option)x$11, x$12, (Option)x$13);
                RelationshipCountFromCountStorePipe pipe = new RelationshipCountFromCountStorePipe(x$10, (Option)x$11, x$12, (Option)x$13, x$14, this.$outer.monitor());
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith((QueryContext)Mockito.when((Object)BoxesRunTime.boxToLong((long)((QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class))).relationshipCountByCountStore(NameId$.MODULE$.WILDCARD(), 22, NameId$.MODULE$.WILDCARD()))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L)).getMock(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$2) {
                        return x$2.apply((Object)"count(r)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return a count for relationships with a type and start label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationshipCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                table.resolvedRelTypeNames().put((Object)"X", (Object)new RelTypeId(22));
                table.resolvedLabelIds().put((Object)"A", (Object)new LabelId(12));
                String x$15 = "count(r)";
                Some x$16 = new Some((Object)LazyLabel$.MODULE$.apply((LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("A", position);
                    }
                }), table));
                LazyTypes x$17 = LazyTypes$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelTypeName[]{new RelTypeName("X", this.$outer.pos())})), table);
                None$ x$18 = None$.MODULE$;
                Option x$19 = RelationshipCountFromCountStorePipe$.MODULE$.apply$default$5(x$15, (Option)x$16, x$17, (Option)x$18);
                RelationshipCountFromCountStorePipe pipe = new RelationshipCountFromCountStorePipe(x$15, (Option)x$16, x$17, (Option)x$18, x$19, this.$outer.monitor());
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith((QueryContext)Mockito.when((Object)BoxesRunTime.boxToLong((long)((QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class))).relationshipCountByCountStore(12, 22, NameId$.MODULE$.WILDCARD()))).thenReturn((Object)BoxesRunTime.boxToLong((long)42L)).getMock(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$3) {
                        return x$3.apply((Object)"count(r)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return zero if rel-type is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationshipCountFromCountStorePipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                String x$20 = "count(r)";
                None$ x$21 = None$.MODULE$;
                LazyTypes x$22 = new LazyTypes((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X"})));
                Some x$23 = new Some((Object)LazyLabel$.MODULE$.apply((LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("A", position);
                    }
                }), table));
                Option x$24 = RelationshipCountFromCountStorePipe$.MODULE$.apply$default$5(x$20, (Option)x$21, x$22, (Option)x$23);
                RelationshipCountFromCountStorePipe pipe = new RelationshipCountFromCountStorePipe(x$20, (Option)x$21, x$22, (Option)x$23, x$24, this.$outer.monitor());
                QueryContext mockedContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)mockedContext.relationshipCountByCountStore(NameId$.MODULE$.WILDCARD(), 22, 12))).thenReturn((Object)BoxesRunTime.boxToLong((long)38L));
                Mockito.when((Object)mockedContext.getOptLabelId("A")).thenReturn((Object)None$.MODULE$);
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(mockedContext, QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                this.$outer.convertToAnyShouldWrapper(pipe.createResults(queryState).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$4) {
                        return x$4.apply((Object)"count(r)");
                    }
                }).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

