/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.pipes.matching;

import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.AddedHistory;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.InitialHistory;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.MatchingPair;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.PatternElement;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.PatternNode;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.PatternNode$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.matching.PatternRelationship;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001'\tY\u0001*[:u_JLH+Z:u\u0015\t\u0019A!\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t)a!A\u0003qSB,7O\u0003\u0002\b\u0011\u0005!aoM02\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u001dI\"B\u0001\u000e\u000b\u0003!1'o\u001c8uK:$\u0017B\u0001\u000f\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000f\r\u0002!\u0019!C\u0001I\u0005\u0019A/\u001f9\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\b\u0002\u000f\u001d\u0014\u0018\r\u001d5eE&\u0011!f\n\u0002\u0011%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d+za\u0016Da\u0001\f\u0001!\u0002\u0013)\u0013\u0001\u0002;za\u0002\u0002")
public class HistoryTest
extends CypherFunSuite {
    private final RelationshipType typ = RelationshipType.withName((String)"REL");

    public RelationshipType typ() {
        return this.typ;
    }

    public HistoryTest() {
        this.test("excludingPatternRelsWorksAsExpected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternNode a = new PatternNode("a", PatternNode$.MODULE$.$lessinit$greater$default$2(), PatternNode$.MODULE$.$lessinit$greater$default$3());
                PatternNode b = new PatternNode("b", PatternNode$.MODULE$.$lessinit$greater$default$2(), PatternNode$.MODULE$.$lessinit$greater$default$3());
                PatternRelationship pr = a.relateTo("r", b, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, a.relateTo$default$5());
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                MatchingPair mp = new MatchingPair((PatternElement)pr, (Object)r);
                AddedHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty()).add(mp);
                this.$outer.convertToAnyShouldWrapper(history.removeSeen((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pr})))).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_known_that_it_has_seen_a_relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                InitialHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{r})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)history.hasSeen((Object)r))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_know_that_it_has_not_seen_a_relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                InitialHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)history.hasSeen((Object)r))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

