/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.planDescription;

import java.util.Locale;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.LengthFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Variable;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.HasLabel;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Not;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.PropertyExists;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v3_1.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.ExpandAllPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyLabel;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.NodeByLabelScanPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.NodeHashJoinPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.SingleRowPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.VarLengthExpandPipe;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.VarLengthExpandPipe$;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Argument;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.CompactedLine;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Id;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Line;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.Line$;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.RenderTreeTableTest$;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.RenderTreeTableTest$$anonfun$41$;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.TwoChildren;
import org.neo4j.cypher.internal.compiler.v3_1.planDescription.renderAsTreeTable$;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001#\t\u0019\"+\u001a8eKJ$&/Z3UC\ndW\rV3ti*\u00111\u0001B\u0001\u0010a2\fg\u000eR3tGJL\u0007\u000f^5p]*\u0011QAB\u0001\u0005mNz\u0016G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u001c!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tar$D\u0001\u001e\u0015\tqb\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001%\b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0003\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0002Z3gCVdG\u000fT8dC2,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001B;uS2T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1Aj\\2bY\u0016DaA\r\u0001!\u0002\u0013I\u0013A\u00043fM\u0006,H\u000e\u001e'pG\u0006dW\r\t\u0005\u0006i\u0001!\t%N\u0001\nE\u00164wN]3BY2$\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0003>\u0001\u0011\u0005S'\u0001\u0005bMR,'/\u00117m\u0011\u001dy\u0004A1A\u0005\u0002\u0001\u000bA\u0001]5qKV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005)\u0001/\u001b9fg&\u0011ai\u0011\u0002\u000e'&tw\r\\3S_^\u0004\u0016\u000e]3\t\r!\u0003\u0001\u0015!\u0003B\u0003\u0015\u0001\u0018\u000e]3!\u0001")
public class RenderTreeTableTest
extends CypherFunSuite
implements BeforeAndAfterAll {
    private final Locale defaultLocale;
    private final SingleRowPipe pipe;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private Locale defaultLocale() {
        return this.defaultLocale;
    }

    public void beforeAll() {
        Locale.setDefault(Locale.US);
    }

    public void afterAll() {
        Locale.setDefault(this.defaultLocale());
    }

    public SingleRowPipe pipe() {
        return this.pipe;
    }

    public RenderTreeTableTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.defaultLocale = Locale.getDefault();
        this.test("node feeding from other node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "ROOT", (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |        +\n        || +LEAF    |\n        |+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding from two nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |\\       +\n        || | +LEAF2 |\n        || |        +\n        || +LEAF1   |\n        |+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding of node that is feeding of node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new SingleChild((InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+\n        || Operator      |\n        |+---------------+\n        || +ROOT         |\n        || |             +\n        || +INTERMEDIATE |\n        || |             +\n        || +LEAF         |\n        |+---------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two leafs, one of which is deep", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+\n        || Operator        |\n        |+-----------------+\n        || +ROOT           |\n        || |\\              +\n        || | +INTERMEDIATE |\n        || | |\\            +\n        || | | +LEAF2      |\n        || | |             +\n        || | +LEAF1        |\n        || |               +\n        || +LEAF3          |\n        |+-----------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two intermediate nodes coming from four leaf nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+-----------+\n        || Operator        | Variables |\n        |+-----------------+-----------+\n        || +ROOT           |           |\n        || |\\              +-----------+\n        || | +INTERMEDIATE |           |\n        || | |\\            +-----------+\n        || | | +LEAF       | d         |\n        || | |             +-----------+\n        || | +LEAF         | c         |\n        || |               +-----------+\n        || +INTERMEDIATE   |           |\n        || |\\              +-----------+\n        || | +LEAF         | b         |\n        || |               +-----------+\n        || +LEAF           | a         |\n        |+-----------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("complex tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl pass = new PlanDescriptionImpl(new Id(), "PASS", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(4L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.EstimatedRows(4.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl inner = new PlanDescriptionImpl(new Id(), "INNER", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)pass), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(7L), new InternalPlanDescription.Arguments$.DbHits(42L), new InternalPlanDescription.Arguments$.EstimatedRows(6.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)inner), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(3L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl parent = new PlanDescriptionImpl(new Id(), "PARENT", (Children)new SingleChild((InternalPlanDescription)plan), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)parent)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------+----------------+------+---------+\n        || Operator   | Estimated Rows | Rows | DB Hits |\n        |+------------+----------------+------+---------+\n        || +PARENT    |                |      |         |\n        || |          +----------------+------+---------+\n        || +ROOT      |              1 |    3 |       0 |\n        || |\\         +----------------+------+---------+\n        || | +INNER   |              6 |    7 |      42 |\n        || | |\\       +----------------+------+---------+\n        || | | +PASS  |              4 |    4 |       0 |\n        || | | |      +----------------+------+---------+\n        || | | +LEAF2 |              1 |    9 |       2 |\n        || | |        +----------------+------+---------+\n        || | +LEAF1   |              1 |   42 |      33 |\n        || |          +----------------+------+---------+\n        || +LEAF3     |              1 |    9 |       2 |\n        |+------------+----------------+------+---------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.pipe = new SingleRowPipe((PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
        this.test("single node is represented nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables |\n        |+----------+----------------+------+---------+-----------+\n        || +NAME    |              1 |   42 |      33 | n         |\n        |+----------+----------------+------+---------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("extra variables are not a problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables |\n        |+----------+----------------+------+---------+-----------+\n        || +NAME    |              1 |   42 |      33 | a, b, c   |\n        |+----------+----------------+------+---------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("super many variables stretches the column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e", "f"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables        |\n        |+----------+----------------+------+---------+------------------+\n        || +NAME    |              1 |   42 |      33 | a, b, c, d, e, f |\n        |+----------+----------------+------+---------+------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("execution plan without profiler stats are not shown", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+-----------+\n        || Operator | Estimated Rows | Variables |\n        |+----------+----------------+-----------+\n        || +NAME    |              1 | n         |\n        |+----------+----------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plan information is rendered on the corresponding row to the tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                Seq args2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(2L), new InternalPlanDescription.Arguments$.DbHits(633L), new InternalPlanDescription.Arguments$.Index("Label", "Prop"), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan1 = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, args1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan2 = new PlanDescriptionImpl(new Id(), "NAME", (Children)new SingleChild((InternalPlanDescription)plan1), args2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+--------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other        |\n        |+----------+----------------+------+---------+-----------+--------------+\n        || +NAME    |              1 |    2 |     633 | b         | :Label(Prop) |\n        || |        +----------------+------+---------+-----------+--------------+\n        || +NAME    |              1 |   42 |      33 | a         |              |\n        |+----------+----------------+------+---------+-----------+--------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExpandAllPipe expandPipe = new ExpandAllPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, LazyTypes$.MODULE$.empty(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+----------------+-----------+---------------------+\n        || Operator     | Estimated Rows | Variables | Other               |\n        |+--------------+----------------+-----------+---------------------+\n        || +Expand(All) |              1 | rel, to   | (from)<-[rel:]-(to) |\n        |+--------------+----------------+-----------+---------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Label scan should be just as pretty as you would expect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              1 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Var length expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VarLengthExpandPipe expandPipe = new VarLengthExpandPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, LazyTypes$.MODULE$.empty(), 0, (Option)None$.MODULE$, false, VarLengthExpandPipe$.MODULE$.apply$default$11(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+----------------+-----------+----------------------+\n        || Operator              | Estimated Rows | Variables | Other                |\n        |+-----------------------+----------------+-----------+----------------------+\n        || +VarLengthExpand(All) |              1 | rel, to   | (from)-[rel:*]->(to) |\n        |+-----------------------+----------------+-----------+----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do not show unnamed variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("  UNNAMED123", "R", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHOOP"})), "  UNNAMED24", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6()), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "  UNNAMED123", "  FRESHID12", "  AGGREGATION255"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------------------------------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables                         | Other            |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        || +NAME    |              1 |   42 |      33 | anon[255], anon[12], anon[123], n | ()-[R:WHOOP]->() |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show multiple relationship types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("source", "through", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOME", "OTHER", "THING"})), "target", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6()), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other                                           |\n        |+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        || +NAME    |              1 |   42 |      33 | n         | (source)-[through:SOME|:OTHER|:THING]->(target) |\n        |+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show nicer output instead of unnamed variables in equals expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Not((Predicate)new Equals((Expression)new Variable("  UNNAMED123"), (Expression)new Variable("  UNNAMED321")))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-----------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other                       |\n        |+----------+----------------+------+---------+-----------+-----------------------------+\n        || +NAME    |              1 |   42 |      33 | n         | NOT(anon[123] == anon[321]) |\n        |+----------+----------------+------+---------+-----------+-----------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasLabels nicely without token id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new HasLabel((Expression)new Variable("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.Label$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other    |\n        |+----------+----------------+------+---------+-----------+----------+\n        || +NAME    |              1 |   42 |      33 | n         | x:Artist |\n        |+----------+----------------+------+---------+-----------+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("format length properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new LengthFunction((Expression)new Variable("n"))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other     |\n        |+----------+----------------+------+---------+-----------+-----------+\n        || +NAME    |              1 |   42 |      33 | n         | length(n) |\n        |+----------+----------------+------+---------+-----------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't leak deduped names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Variable("  id@23")), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  n@76"})));
                String details = renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(details).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other |\n        |+----------+----------------+------+---------+-----------+-------+\n        || +NAME    |              1 |   42 |      33 | n         | id    |\n        |+----------+----------------+------+---------+-----------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't render planner in Other", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Planner("COST"), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Variable("  id@23")), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other |\n        |+----------+----------------+------+---------+-----------+-------+\n        || +NAME    |              1 |   42 |      33 | n         | id    |\n        |+----------+----------------+------+---------+-----------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("round estimated rows to int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe1 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)0.00123456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                NodeByLabelScanPipe pipe2 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.23456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe1.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              0 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe2.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              1 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("properly show Property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Property((Expression)new Variable("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.PropertyKey$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other    |\n        |+----------+----------------+------+---------+-----------+----------+\n        || +NAME    |              1 |   42 |      33 | n         | x.Artist |\n        |+----------+----------------+------+---------+-----------+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasProp with variable and property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new PropertyExists((Expression)new Variable("x"), (KeyToken)new KeyToken.Resolved("prop", 42, (TokenType)TokenType.PropertyKey$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-----------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other           |\n        |+----------+----------------+------+---------+-----------+-----------------+\n        || +NAME    |              1 |   42 |      33 | n         | hasProp(x.prop) |\n        |+----------+----------------+------+---------+-----------+-----------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't show unnamed variables in key names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeHashJoinPipe joinPipe = new NodeHashJoinPipe((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "  UNNAMED45", "  FRESHID77"})), (Pipe)this.$outer.pipe(), (Pipe)this.$outer.pipe(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)42.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(joinPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+----------------+-----------------------+\n        || Operator      | Estimated Rows | Other                 |\n        |+---------------+----------------+-----------------------+\n        || +NodeHashJoin |             42 | a, anon[45], anon[77] |\n        || |\\            +----------------+-----------------------+\n        || | +EmptyRow   |              1 |                       |\n        || |             +----------------+-----------------------+\n        || +EmptyRow     |              1 |                       |\n        |+---------------+----------------+-----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two identical nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +NODE(2) |\n        |+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two similar nodes with variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+-----------+\n        || Operator | Variables |\n        |+----------+-----------+\n        || +NODE(2) | a, b      |\n        |+----------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | c, d      |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with same variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | a, b      |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with one new variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | c -- a, b |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with many repeating variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", repeating, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+--------------------------------------------------------------------------------------------------+\n        || Operator     | Variables                                                                                        |\n        |+--------------+--------------------------------------------------------------------------------------------------+\n        || +OPERATOR(2) | var_A, var_B -- var_a, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |\n        || |            +--------------------------------------------------------------------------------------------------+\n        || +NODE(2)     | var_a, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, ...   |\n        |+--------------+--------------------------------------------------------------------------------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact only the sufficiently similar pair of two simular pairs of nodes with many repeating variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.LabelName[]{new InternalPlanDescription.Arguments$.LabelName("123")})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", repeating, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0])).andThen(new Id(), "OPERATOR", (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+--------------------------------------------------------------------------------------------------+-------+\n        || Operator     | Variables                                                                                        | Other |\n        |+--------------+--------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR(2) | var_A, var_B, var_a -- var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |       |\n        || |            +--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ...   |       |\n        || |            +--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        | var_a                                                                                            | :123  |\n        |+--------------+--------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact only the sufficiently similar pair of two simular pairs of nodes with many repeating variables and many columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                InternalPlanDescription.Arguments$.LabelName l = new InternalPlanDescription.Arguments$.LabelName("123");
                InternalPlanDescription.Arguments$.Time t = new InternalPlanDescription.Arguments$.Time(12345678L);
                InternalPlanDescription.Arguments$.Rows r = new InternalPlanDescription.Arguments$.Rows(2L);
                InternalPlanDescription.Arguments$.DbHits d = new InternalPlanDescription.Arguments$.DbHits(2L);
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", repeating, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d})).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d})).andThen(new Id(), "OPERATOR", (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d}));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || Operator     | Rows | DB Hits | Time (ms) | Variables                                                                                        | Other |\n        |+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR(2) |    2 |       4 |    24.691 | var_A, var_B, var_a -- var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |       |\n        || |            +------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        |    2 |       2 |    12.346 | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ...   |       |\n        || |            +------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        |    2 |       2 |    12.346 | var_a                                                                                            | :123  |\n        |+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do not compact two similar pairs of nodes with non-empty other column and many repeating variables and many columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                InternalPlanDescription.Arguments$.LabelName l = new InternalPlanDescription.Arguments$.LabelName("123");
                InternalPlanDescription.Arguments$.Time t = new InternalPlanDescription.Arguments$.Time(12345678L);
                InternalPlanDescription.Arguments$.Rows r = new InternalPlanDescription.Arguments$.Rows(2L);
                InternalPlanDescription.Arguments$.DbHits d = new InternalPlanDescription.Arguments$.DbHits(2L);
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "NODE", repeating, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})).andThen(new Id(), "OPERATOR", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})).andThen(new Id(), "OPERATOR", (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d}));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || Operator  | Rows | DB Hits | Time (ms) | Variables                                                                                      | Other |\n        |+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR |    2 |       2 |    12.346 | var_A, var_B, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, ... | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR |    2 |       2 |    12.346 | var_a                                                                                          | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +NODE     |    2 |       2 |    12.346 | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ... | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +NODE     |    2 |       2 |    12.346 | var_a                                                                                          | :123  |\n        |+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("no compaction on complex plan with no repeated names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl branch1 = new PlanDescriptionImpl(new Id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl branch2 = new PlanDescriptionImpl(new Id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl branch3 = new PlanDescriptionImpl(new Id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf3), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl branch4 = new PlanDescriptionImpl(new Id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)branch1, (InternalPlanDescription)branch2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)branch3, (InternalPlanDescription)branch4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+-----------+\n        || Operator        | Variables |\n        |+-----------------+-----------+\n        || +ROOT           |           |\n        || |\\              +-----------+\n        || | +INTERMEDIATE |           |\n        || | |\\            +-----------+\n        || | | +BRANCH     | d         |\n        || | | |           +-----------+\n        || | | +LEAF       | d         |\n        || | |             +-----------+\n        || | +BRANCH       | c         |\n        || | |             +-----------+\n        || | +LEAF         | c         |\n        || |               +-----------+\n        || +INTERMEDIATE   |           |\n        || |\\              +-----------+\n        || | +BRANCH       | b         |\n        || | |             +-----------+\n        || | +LEAF         | b         |\n        || |               +-----------+\n        || +BRANCH         | a         |\n        || |               +-----------+\n        || +LEAF           | a         |\n        |+-----------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compaction on complex plan with repeated names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(new Id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch1 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch2 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch3 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf3), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch4 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)branch1, (InternalPlanDescription)branch2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(new Id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)branch3, (InternalPlanDescription)branch4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+\n        || Operator     |\n        |+--------------+\n        || +NODE        |\n        || |\\           +\n        || | +NODE      |\n        || | |\\         +\n        || | | +NODE(2) |\n        || | |          +\n        || | +NODE(2)   |\n        || |            +\n        || +NODE        |\n        || |\\           +\n        || | +NODE(2)   |\n        || |            +\n        || +NODE(2)     |\n        |+--------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with no variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Set().empty(), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, Predef$.MODULE$.Set().empty());
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)""));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with only new variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, Predef$.MODULE$.Set().empty());
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with only old variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with old and new variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"c, d -- a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with many old and new variables and all compaction lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set newvars = (Set)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'e')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('f')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)repeating.$plus$plus((GenTraversableOnce)newvars), (Option)None$.MODULE$);
                CompactedLine compacted = new CompactedLine(line, repeating);
                int maxlen = compacted.formatVariables(1000).length();
                String mintext = "var_a, ...";
                package$.MODULE$.Range().apply(maxlen, 1, -1).foreach$mVc$sp((Function1)new Serializable(this, compacted, maxlen, mintext){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$41 $outer;
                    private final CompactedLine compacted$1;
                    private final int maxlen$1;
                    private final String mintext$1;

                    public final void apply(int length) {
                        this.apply$mcVI$sp(length);
                    }

                    public void apply$mcVI$sp(int length) {
                        String formatted = this.compacted$1.formatVariables(length);
                        if (formatted.length() < this.maxlen$1) {
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().endWith().apply("..."));
                        } else {
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().endWith().apply("var_z"));
                        }
                        if (length < this.mintext$1.length()) {
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().be().apply((Object)this.mintext$1));
                        } else {
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().withClue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected formatted length to be no greater than ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})), (Function0)new Serializable(this, formatted, length){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$41$$anonfun$apply$mcV$sp$1 $outer;
                                private final String formatted$1;
                                private final int length$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.formatted$1.length())).should(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer().be().$less$eq((Object)BoxesRunTime.boxToInteger((int)this.length$1), (Ordering)Ordering.Int$.MODULE$));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.formatted$1 = formatted$1;
                                    this.length$1 = length$1;
                                }
                            });
                        }
                    }

                    public /* synthetic */ $anonfun$41 org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.compacted$1 = compacted$1;
                        this.maxlen$1 = maxlen$1;
                        this.mintext$1 = mintext$1;
                    }
                });
            }

            public /* synthetic */ RenderTreeTableTest org$neo4j$cypher$internal$compiler$v3_1$planDescription$RenderTreeTableTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

