/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.planner;

import org.neo4j.cypher.internal.compiler.v3_1.planner.AstRewritingTestSupport;
import org.neo4j.cypher.internal.compiler.v3_1.planner.AstRewritingTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_1.planner.checkForUnresolvedTokens$;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.RelTypeId;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Query;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.notification.MissingLabelNotification;
import org.neo4j.cypher.internal.frontend.v3_1.notification.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.frontend.v3_1.notification.MissingRelTypeNotification;
import org.neo4j.cypher.internal.frontend.v3_1.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001#\ta2\t[3dW\u001a{'/\u00168sKN|GN^3e)>\\WM\\:UKN$(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\tY\u001ct,\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00137A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uKB\u0011A$H\u0007\u0002\u0005%\u0011aD\u0001\u0002\u0018\u0003N$(+Z<sSRLgn\u001a+fgR\u001cV\u000f\u001d9peRDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005q\u0001\u0001\"\u0002\u0013\u0001\t\u0013)\u0013!\u00029beN,GC\u0001\u0014-!\t9#&D\u0001)\u0015\tIc#A\u0002bgRL!a\u000b\u0015\u0003\u000bE+XM]=\t\u000b5\u001a\u0003\u0019\u0001\u0018\u0002\u000bE,XM]=\u0011\u0005=*dB\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n\u0014A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0019")
public class CheckForUnresolvedTokensTest
extends CypherFunSuite
implements AstRewritingTestSupport {
    private final CypherParser parser;
    private final InputPosition pos;

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$AstRewritingTestSupport$_setter_$parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public Query org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse(String query) {
        Statement statement = this.parser().parse(query, this.parser().parse$default$2());
        if (statement instanceof Query) {
            Query query2;
            Query query3 = query2 = (Query)statement;
            return query3;
        }
        throw this.fail("Must be a Query");
    }

    public CheckForUnresolvedTokensTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        AstRewritingTestSupport$class.$init$(this);
        this.test("warn when missing label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingLabelNotification[]{new MissingLabelNotification(new InputPosition(9, 1, 10), "A"), new MissingLabelNotification(new InputPosition(17, 1, 18), "B")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when labels are there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("warn when missing relationship type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-[r:R1|R2]->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingRelTypeNotification[]{new MissingRelTypeNotification(new InputPosition(15, 1, 16), "R1"), new MissingRelTypeNotification(new InputPosition(18, 1, 19), "R2")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when relationship types are there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                semanticTable.resolvedRelTypeNames().put((Object)"R1", (Object)new RelTypeId(1));
                semanticTable.resolvedRelTypeNames().put((Object)"R2", (Object)new RelTypeId(2));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-[r:R1|R2]->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("warn when missing property key name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a) WHERE a.prop = 42 RETURN a");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingPropertyNameNotification[]{new MissingPropertyNameNotification(new InputPosition(18, 1, 19), "prop")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when property key name is there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedPropertyKeyNames().put((Object)"prop", (Object)new PropertyKeyId(42));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a {prop: 42}) RETURN a");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn for literal maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$CheckForUnresolvedTokensTest$$parse("RETURN {prop: 'foo'}");
                this.$outer.convertToAnyShouldWrapper(checkForUnresolvedTokens$.MODULE$.apply(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

