/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.planner;

import org.neo4j.cypher.internal.compiler.v3_1.ASTRewriter;
import org.neo4j.cypher.internal.compiler.v3_1.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_1.HardcodedGraphStatistics$;
import org.neo4j.cypher.internal.compiler.v3_1.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v3_1.Monitors;
import org.neo4j.cypher.internal.compiler.v3_1.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v3_1.planner.CostBasedExecutablePlanBuilder;
import org.neo4j.cypher.internal.compiler.v3_1.planner.LogicalPlanConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_1.planner.LogicalPlanningTestSupport;
import org.neo4j.cypher.internal.compiler.v3_1.planner.LogicalPlanningTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_1.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v3_1.planner.Predicate;
import org.neo4j.cypher.internal.compiler.v3_1.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v3_1.planner.RegularPlannerQuery;
import org.neo4j.cypher.internal.compiler.v3_1.planner.Selections;
import org.neo4j.cypher.internal.compiler.v3_1.planner.Selections$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.SimpleTokenResolver;
import org.neo4j.cypher.internal.compiler.v3_1.planner.UnionQuery;
import org.neo4j.cypher.internal.compiler.v3_1.planner.execution.PipeExecutionBuilderContext;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.MetricsFactory;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.SimpleMetricsFactory$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.IdName;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.PatternLength;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.PatternRelationship;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.StrictnessMode;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v3_1.spi.ProcedureSignature;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QualifiedProcedureName;
import org.neo4j.cypher.internal.compiler.v3_1.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.ast.And;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.PartialPredicate$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.RelTypeName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001#\tq1+\u001a7fGRLwN\\:UKN$(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\tY\u001ct,\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00137}\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003!1'o\u001c8uK:$\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"\u0001H\u000f\u000e\u0003\tI!A\b\u0002\u000351{w-[2bYBc\u0017M\u001c8j]\u001e$Vm\u001d;TkB\u0004xN\u001d;\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t2\u0012aA1ti&\u0011A%\t\u0002\u001b\u0003N$8i\u001c8tiJ,8\r^5p]R+7\u000f^*vaB|'\u000f\u001e\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"\u0001\b\u0001\t\u000f)\u0002!\u0019!C\u0001W\u0005I\u0011-S:QKJ\u001cxN\\\u000b\u0002YA\u0011\u0001%L\u0005\u0003]\u0005\u0012\u0011\u0002S1t\u0019\u0006\u0014W\r\\:\t\rA\u0002\u0001\u0015!\u0003-\u0003)\t\u0017j\u001d)feN|g\u000e\t\u0005\be\u0001\u0011\r\u0011\"\u0001,\u00035\t\u0017j\u001d)s_\u001e\u0014\u0018-\\7fe\"1A\u0007\u0001Q\u0001\n1\na\"Y%t!J|wM]1n[\u0016\u0014\b\u0005C\u00047\u0001\t\u0007I\u0011A\u0016\u0002\u0013\tL5/\u00118j[\u0006d\u0007B\u0002\u001d\u0001A\u0003%A&\u0001\u0006c\u0013N\fe.[7bY\u0002BqA\u000f\u0001C\u0002\u0013\u00051(A\bd_6\u0004\u0018M]3Uo>tu\u000eZ3t+\u0005a\u0004C\u0001\u0011>\u0013\tq\u0014E\u0001\u0004FcV\fGn\u001d\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001f\u0002!\r|W\u000e]1sKR;xNT8eKN\u0004\u0003\"\u0002\"\u0001\t\u0013\u0019\u0015aB5e\u001d\u0006lWm\u001d\u000b\u0003\tZ\u00032!\u0012'O\u001b\u00051%BA$I\u0003%IW.\\;uC\ndWM\u0003\u0002J\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014$\u0003\u0007M+G\u000f\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006)\u0001\u000f\\1og*\u00111KA\u0001\bY><\u0017nY1m\u0013\t)\u0006K\u0001\u0004JI:\u000bW.\u001a\u0005\u0006/\u0006\u0003\r\u0001W\u0001\u0006]\u0006lWm\u001d\t\u00043jcV\"\u0001&\n\u0005mS%A\u0003\u001fsKB,\u0017\r^3e}A\u0011Q\f\u0019\b\u00033zK!a\u0018&\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?*CQ\u0001\u001a\u0001\u0005\n\u0015\f\u0001cY8na\u0006\u0014XMQ8uQNKG-Z:\u0015\u0007q2\u0007\u000eC\u0003hG\u0002\u0007A,\u0001\u0003mK\u001a$\b\"B5d\u0001\u0004a\u0016!\u0002:jO\"$\b")
public class SelectionsTest
extends CypherFunSuite
implements LogicalPlanningTestSupport {
    private final HasLabels aIsPerson;
    private final HasLabels aIsProgrammer;
    private final HasLabels bIsAnimal;
    private final Equals compareTwoNodes;
    private final Monitors monitors;
    private final CypherParser parser;
    private final SemanticChecker semanticChecker;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private final ASTRewriter astRewriter;
    private final PatternRelationship mockRel;
    private final SimpleTokenResolver tokenResolver;
    private final RegularPlannerQuery solved;
    private final CypherCompilerConfiguration config;
    private final InputPosition pos;

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    public PatternRelationship mockRel() {
        return this.mockRel;
    }

    @Override
    public SimpleTokenResolver tokenResolver() {
        return this.tokenResolver;
    }

    @Override
    public RegularPlannerQuery solved() {
        return this.solved;
    }

    @Override
    public CypherCompilerConfiguration config() {
        return this.config;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$monitors_$eq(Monitors x$1) {
        this.monitors = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$mockRel_$eq(PatternRelationship x$1) {
        this.mockRel = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$tokenResolver_$eq(SimpleTokenResolver x$1) {
        this.tokenResolver = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$solved_$eq(RegularPlannerQuery x$1) {
        this.solved = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_1$planner$LogicalPlanningTestSupport$_setter_$config_$eq(CypherCompilerConfiguration x$1) {
        this.config = x$1;
    }

    @Override
    public RegularPlannerQuery solvedWithEstimation(Cardinality cardinality) {
        return LogicalPlanningTestSupport$class.solvedWithEstimation(this, cardinality);
    }

    @Override
    public PatternRelationship newPatternRelationship(IdName start, IdName end, IdName rel, SemanticDirection dir, Seq<RelTypeName> types, PatternLength length) {
        return LogicalPlanningTestSupport$class.newPatternRelationship(this, start, end, rel, dir, types, length);
    }

    @Override
    public QueryGraph newMockedQueryGraph() {
        return LogicalPlanningTestSupport$class.newMockedQueryGraph(this);
    }

    @Override
    public PipeExecutionBuilderContext newMockedPipeExecutionPlanBuilderContext() {
        return LogicalPlanningTestSupport$class.newMockedPipeExecutionPlanBuilderContext(this);
    }

    @Override
    public SimpleMetricsFactory$ newMetricsFactory() {
        return LogicalPlanningTestSupport$class.newMetricsFactory(this);
    }

    @Override
    public Metrics newSimpleMetrics(GraphStatistics stats) {
        return LogicalPlanningTestSupport$class.newSimpleMetrics(this, stats);
    }

    @Override
    public GraphStatistics newMockedGraphStatistics() {
        return LogicalPlanningTestSupport$class.newMockedGraphStatistics(this);
    }

    @Override
    public SemanticTable newMockedSemanticTable() {
        return LogicalPlanningTestSupport$class.newMockedSemanticTable(this);
    }

    @Override
    public LogicalPlanningTestSupport.SpyableMetricsFactory newMockedMetricsFactory() {
        return LogicalPlanningTestSupport$class.newMockedMetricsFactory(this);
    }

    @Override
    public QueryGraphSolver newMockedStrategy(LogicalPlan plan) {
        return LogicalPlanningTestSupport$class.newMockedStrategy(this, plan);
    }

    @Override
    public Metrics mockedMetrics() {
        return LogicalPlanningTestSupport$class.mockedMetrics(this);
    }

    @Override
    public LogicalPlanningContext newMockedLogicalPlanningContext(PlanContext planContext, Metrics metrics, SemanticTable semanticTable, QueryGraphSolver strategy, Cardinality cardinality, Option<StrictnessMode> strictness, InternalNotificationLogger notificationLogger, boolean useErrorsOverWarnings) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext(this, planContext, metrics, semanticTable, strategy, cardinality, strictness, notificationLogger, useErrorsOverWarnings);
    }

    @Override
    public GraphStatistics newMockedStatistics() {
        return LogicalPlanningTestSupport$class.newMockedStatistics(this);
    }

    @Override
    public HardcodedGraphStatistics$ hardcodedStatistics() {
        return LogicalPlanningTestSupport$class.hardcodedStatistics(this);
    }

    @Override
    public PlanContext newMockedPlanContext(GraphStatistics statistics) {
        return LogicalPlanningTestSupport$class.newMockedPlanContext(this, statistics);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithProjections(Seq<String> ids) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithProjections(this, ids);
    }

    @Override
    public LogicalPlan newMockedLogicalPlan(Set<IdName> idNames2, Cardinality cardinality, Set<Hint> hints) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan(this, idNames2, cardinality, hints);
    }

    @Override
    public LogicalPlan newMockedLogicalPlan(Seq<String> ids) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan(this, ids);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithSolved(Set<IdName> ids, PlannerQuery solved) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithSolved(this, ids, solved);
    }

    @Override
    public LogicalPlan newMockedLogicalPlanWithPatterns(Set<IdName> ids, Seq<PatternRelationship> patterns) {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns(this, ids, patterns);
    }

    @Override
    public CostBasedExecutablePlanBuilder newPlanner(MetricsFactory metricsFactory) {
        return LogicalPlanningTestSupport$class.newPlanner(this, metricsFactory);
    }

    @Override
    public PlannerQuery buildPlannerQuery(String query, Option<Function1<QualifiedProcedureName, ProcedureSignature>> lookup) {
        return LogicalPlanningTestSupport$class.buildPlannerQuery(this, query, lookup);
    }

    @Override
    public UnionQuery buildPlannerUnionQuery(String query, Option<Function1<QualifiedProcedureName, ProcedureSignature>> lookup) {
        return LogicalPlanningTestSupport$class.buildPlannerUnionQuery(this, query, lookup);
    }

    @Override
    public HasLabels identHasLabel(String name, String labelName) {
        return LogicalPlanningTestSupport$class.identHasLabel(this, name, labelName);
    }

    @Override
    public Option<Function1<QualifiedProcedureName, ProcedureSignature>> buildPlannerQuery$default$2() {
        return LogicalPlanningTestSupport$class.buildPlannerQuery$default$2(this);
    }

    @Override
    public Option<Function1<QualifiedProcedureName, ProcedureSignature>> buildPlannerUnionQuery$default$2() {
        return LogicalPlanningTestSupport$class.buildPlannerUnionQuery$default$2(this);
    }

    @Override
    public SemanticDirection newPatternRelationship$default$4() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$4(this);
    }

    @Override
    public Seq<RelTypeName> newPatternRelationship$default$5() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$5(this);
    }

    @Override
    public PatternLength newPatternRelationship$default$6() {
        return LogicalPlanningTestSupport$class.newPatternRelationship$default$6(this);
    }

    @Override
    public GraphStatistics newSimpleMetrics$default$1() {
        return LogicalPlanningTestSupport$class.newSimpleMetrics$default$1(this);
    }

    @Override
    public Metrics newMockedLogicalPlanningContext$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$2(this);
    }

    @Override
    public SemanticTable newMockedLogicalPlanningContext$default$3() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$3(this);
    }

    @Override
    public QueryGraphSolver newMockedLogicalPlanningContext$default$4() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$4(this);
    }

    @Override
    public Cardinality newMockedLogicalPlanningContext$default$5() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$5(this);
    }

    @Override
    public Option<StrictnessMode> newMockedLogicalPlanningContext$default$6() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$6(this);
    }

    @Override
    public InternalNotificationLogger newMockedLogicalPlanningContext$default$7() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$7(this);
    }

    @Override
    public boolean newMockedLogicalPlanningContext$default$8() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanningContext$default$8(this);
    }

    @Override
    public GraphStatistics newMockedPlanContext$default$1() {
        return LogicalPlanningTestSupport$class.newMockedPlanContext$default$1(this);
    }

    @Override
    public Cardinality newMockedLogicalPlan$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan$default$2(this);
    }

    @Override
    public Set<Hint> newMockedLogicalPlan$default$3() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlan$default$3(this);
    }

    @Override
    public Seq<PatternRelationship> newMockedLogicalPlanWithPatterns$default$2() {
        return LogicalPlanningTestSupport$class.newMockedLogicalPlanWithPatterns$default$2(this);
    }

    @Override
    public IdName idName(String name) {
        return LogicalPlanConstructionTestSupport$class.idName(this, name);
    }

    @Override
    public IdName idSymbol(Symbol name) {
        return LogicalPlanConstructionTestSupport$class.idSymbol(this, name);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public HasLabels aIsPerson() {
        return this.aIsPerson;
    }

    public HasLabels aIsProgrammer() {
        return this.aIsProgrammer;
    }

    public HasLabels bIsAnimal() {
        return this.bIsAnimal;
    }

    public Equals compareTwoNodes() {
        return this.compareTwoNodes;
    }

    public Set<IdName> org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames(Seq<String> names) {
        return ((TraversableOnce)names.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IdName apply(String x$1) {
                return new IdName(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private Equals compareBothSides(String left, String right) {
        return new Equals((Expression)this.prop(left, "prop1"), (Expression)this.prop(right, "prop1"), this.pos());
    }

    public SelectionsTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanConstructionTestSupport$class.$init$(this);
        LogicalPlanningTestSupport$class.$init$(this);
        this.aIsPerson = this.identHasLabel("a", "Person");
        this.aIsProgrammer = this.identHasLabel("a", "Programmer");
        this.bIsAnimal = this.identHasLabel("b", "Animal");
        this.compareTwoNodes = this.compareBothSides("a", "b");
        this.test("can flat predicates to a sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson())})));
                this.$outer.convertToAnyShouldWrapper(selections.flatPredicates()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can flat empty predicates to an empty sequence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new Selections(Selections$.MODULE$.apply$default$1()).flatPredicates()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to sense that predicates are not covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson()), new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)selections.coveredBy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to tell when all predicates are covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson())})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)selections.coveredBy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can extract HasLabels Predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predicate[] predicateArray = new Predicate[4];
                predicateArray[0] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson());
                predicateArray[1] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)this.$outer.aIsPerson());
                predicateArray[2] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Expression)this.$outer.bIsAnimal());
                Variable variable = (Variable)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Variable apply(InputPosition position) {
                        return new Variable("c", position);
                    }
                });
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("42", position);
                    }
                });
                predicateArray[3] = new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), (Expression)this.$outer.withPos(new Serializable(this, variable, signedDecimalIntegerLiteral){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$1$1;
                    private final SignedDecimalIntegerLiteral eta$1$1$1;

                    public final Equals apply(InputPosition position) {
                        return new Equals((Expression)this.eta$0$1$1, (Expression)this.eta$1$1$1, position);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                        this.eta$1$1$1 = eta$1$1$1;
                    }
                }));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])predicateArray)));
                this.$outer.convertToAnyShouldWrapper(selections.labelPredicates()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new IdName("a")), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new IdName("b")), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.bIsAnimal()})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can find predicates given covered ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<IdName> a = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set<IdName> b = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(a, (Expression)this.$outer.aIsPerson()), new Predicate(b, (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(a)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasLabels[]{this.$outer.aIsPerson()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("returns no predicates if no ids are covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<IdName> a = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set<IdName> b = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(a, (Expression)this.$outer.aIsPerson()), new Predicate(b, (Expression)this.$outer.bIsAnimal())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(Predef$.MODULE$.Set().empty())).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("does not take on a predicate if it is only half covered", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set<IdName> aAndB = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
                Set a = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{(IdName)aAndB.head()}));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(aAndB, (Expression)this.$outer.compareTwoNodes())})));
                this.$outer.convertToAnyShouldWrapper(selections.predicatesGiven(a)).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("prunes away sub predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                And covering = new And((Expression)this.$outer.aIsPerson(), (Expression)this.$outer.aIsProgrammer(), this.$outer.pos());
                HasLabels covered = this.$outer.aIsProgrammer();
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), PartialPredicate$.MODULE$.apply((Expression)covered, (Expression)covering))})));
                Selections result = selections.$plus$plus(new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)covering)}))));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{new Predicate(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$SelectionsTest$$idNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Expression)covering)})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should recognize value joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property lhs = this.$outer.prop("x", "id");
                Property rhs = this.$outer.prop("z", "id");
                Equals equalityComparison = new Equals((Expression)lhs, (Expression)rhs, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{equalityComparison}));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{equalityComparison}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if one side is a literal, it's not a value join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Selections selections = Selections$.MODULE$.from((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.$outer.propEquality("x", "id", 42)}));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if both lhs and rhs come from the same variable, it's not a value join", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property lhs = this.$outer.prop("x", "id1");
                Property rhs = this.$outer.prop("x", "id2");
                Equals equalityComparison = new Equals((Expression)lhs, (Expression)rhs, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{equalityComparison}));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("combination of predicates is not a problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property x_id1 = this.$outer.prop("x", "id1");
                Property x_id2 = this.$outer.prop("x", "id2");
                Property z_id = this.$outer.prop("z", "id");
                SignedDecimalIntegerLiteral lit = this.$outer.literalInt(42);
                Equals pred1 = new Equals((Expression)x_id1, (Expression)x_id2, this.$outer.pos());
                Equals pred2 = new Equals((Expression)x_id1, (Expression)z_id, this.$outer.pos());
                Equals pred3 = new Equals((Expression)x_id2, (Expression)lit, this.$outer.pos());
                Selections selections = Selections$.MODULE$.from((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{pred1, pred2, pred3}));
                Set result = selections.valueJoins();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{pred2}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

