/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.planner.Predicate;
import org.neo4j.cypher.internal.compiler.v3_1.planner.Selections;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.ExpressionSelectivityCalculator;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.ExpressionSelectivityCalculatorTest$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.ExpressionSelectivityCalculatorTest$$anonfun$4$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.ExpressionSelectivityCalculatorTest$$anonfun$5$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.IndependenceCombiner$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.cardinality.SelectivityCombiner;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.plans.IdName;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition$;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AndedPropertyInequalities;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_1.ast.GreaterThan;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.In;
import org.neo4j.cypher.internal.frontend.v3_1.ast.InequalityExpression;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Parameter;
import org.neo4j.cypher.internal.frontend.v3_1.ast.PartialPredicate$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.StartsWith;
import org.neo4j.cypher.internal.frontend.v3_1.ast.StringLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.helpers.NonEmptyList$;
import org.neo4j.cypher.internal.frontend.v3_1.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v3_1.symbols.package$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001+\t\u0019S\t\u001f9sKN\u001c\u0018n\u001c8TK2,7\r^5wSRL8)\u00197dk2\fGo\u001c:UKN$(BA\u0002\u0005\u0003-\u0019\u0017M\u001d3j]\u0006d\u0017\u000e^=\u000b\u0005\u00151\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000f!\tq\u0001\u001d7b]:,'O\u0003\u0002\n\u0015\u0005!aoM02\u0015\tYA\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\ty\u0001#\u0001\u0004dsBDWM\u001d\u0006\u0003#I\tQA\\3pi)T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001Yy\u0002CA\f\u001e\u001b\u0005A\"BA\r\u001b\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tI1D\u0003\u0002\u001d\u0019\u0005AaM]8oi\u0016tG-\u0003\u0002\u001f1\tq1)\u001f9iKJ4UO\\*vSR,\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u001b\u0003\r\t7\u000f^\u0005\u0003I\u0005\u0012!$Q:u\u0007>t7\u000f\u001e:vGRLwN\u001c+fgR\u001cV\u000f\u001d9peRDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u0002")
public class ExpressionSelectivityCalculatorTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public ExpressionSelectivityCalculatorTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("Should consider parameter expressions when calculating index selectivity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                semanticTable.resolvedLabelIds().put((Object)"Page", (Object)new LabelId(0));
                semanticTable.resolvedPropertyKeyNames().put((Object)"title", (Object)new PropertyKeyId(0));
                Predicate[] predicateArray = new Predicate[1];
                Variable variable = this.$outer.varFor("n");
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{(LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("Page", position);
                    }
                })}));
                predicateArray[0] = new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{new IdName("n")})), (Expression)this.$outer.withPos(new Serializable(this, variable, seq){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$1$1;
                    private final Seq eta$1$1$1;

                    public final HasLabels apply(InputPosition position) {
                        return new HasLabels((Expression)this.eta$0$1$1, this.eta$1$1$1, position);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                        this.eta$1$1$1 = eta$1$1$1;
                    }
                }));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])predicateArray)));
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)None$.MODULE$)).thenReturn((Object)Cardinality$.MODULE$.lift(1000.0));
                Mockito.when((Object)stats.indexSelectivity(new LabelId(0), new PropertyKeyId(0))).thenReturn((Object)new Some(Selectivity$.MODULE$.of(0.1).get()));
                ExpressionSelectivityCalculator calculator = new ExpressionSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                Variable variable2 = this.$outer.varFor("n");
                PropertyKeyName propertyKeyName = (PropertyKeyName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PropertyKeyName apply(InputPosition position) {
                        return new PropertyKeyName("title", position);
                    }
                });
                Property property = (Property)this.$outer.withPos(new Serializable(this, variable2, propertyKeyName){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$2$1;
                    private final PropertyKeyName eta$1$2$1;

                    public final Property apply(InputPosition position) {
                        return new Property((Expression)this.eta$0$2$1, this.eta$1$2$1, position);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                        this.eta$1$2$1 = eta$1$2$1;
                    }
                });
                Parameter parameter = (Parameter)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Parameter apply(InputPosition position) {
                        return new Parameter("titles", (CypherType)package$.MODULE$.CTAny(), position);
                    }
                });
                Selectivity result = calculator.apply((Expression)this.$outer.withPos(new Serializable(this, property, parameter){
                    public static final long serialVersionUID = 0L;
                    private final Property eta$0$3$1;
                    private final Parameter eta$1$3$1;

                    public final In apply(InputPosition position) {
                        return new In((Expression)this.eta$0$3$1, (Expression)this.eta$1$3$1, position);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                        this.eta$1$3$1 = eta$1$3$1;
                    }
                }), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)result.factor())).should(this.$outer.equal(this.$outer.convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)0.92), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)0.01))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should peek inside sub predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                semanticTable.resolvedLabelIds().put((Object)"Page", (Object)new LabelId(0));
                Predicate[] predicateArray = new Predicate[1];
                Variable variable = this.$outer.varFor("n");
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{(LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("Page", position);
                    }
                })}));
                predicateArray[0] = new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{new IdName("n")})), (Expression)this.$outer.withPos(new Serializable(this, variable, seq){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$4$1;
                    private final Seq eta$1$4$1;

                    public final HasLabels apply(InputPosition position) {
                        return new HasLabels((Expression)this.eta$0$4$1, this.eta$1$4$1, position);
                    }
                    {
                        this.eta$0$4$1 = eta$0$4$1;
                        this.eta$1$4$1 = eta$1$4$1;
                    }
                }));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])predicateArray)));
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)None$.MODULE$)).thenReturn((Object)Cardinality$.MODULE$.lift(2000.0));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(0)))).thenReturn((Object)Cardinality$.MODULE$.lift(1000.0));
                ExpressionSelectivityCalculator calculator = new ExpressionSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                Variable variable2 = this.$outer.varFor("n");
                Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{(LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("Page", position);
                    }
                })}));
                Selectivity result = calculator.apply(PartialPredicate$.MODULE$.apply((Expression)this.$outer.withPos(new Serializable(this, variable2, seq2){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$5$1;
                    private final Seq eta$1$5$1;

                    public final HasLabels apply(InputPosition position) {
                        return new HasLabels((Expression)this.eta$0$5$1, this.eta$1$5$1, position);
                    }
                    {
                        this.eta$0$5$1 = eta$0$5$1;
                        this.eta$1$5$1 = eta$1$5$1;
                    }
                }), (Expression)this.$outer.mock(ManifestFactory$.MODULE$.classType(HasLabels.class))), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)result.factor())).should(this.$outer.equal(BoxesRunTime.boxToDouble((double)0.5)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should look at range predicates that could benefit from using an index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                semanticTable.resolvedLabelIds().put((Object)"Person", (Object)new LabelId(0));
                Variable variable = this.$outer.varFor("n");
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{(LabelName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabelName apply(InputPosition position) {
                        return new LabelName("Person", position);
                    }
                })}));
                Predicate n_is_Person = new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{new IdName("n")})), (Expression)this.$outer.withPos(new Serializable(this, variable, seq){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$6$1;
                    private final Seq eta$1$6$1;

                    public final HasLabels apply(InputPosition position) {
                        return new HasLabels((Expression)this.eta$0$6$1, this.eta$1$6$1, position);
                    }
                    {
                        this.eta$0$6$1 = eta$0$6$1;
                        this.eta$1$6$1 = eta$1$6$1;
                    }
                }));
                Variable variable2 = this.$outer.varFor("n");
                PropertyKeyName propertyKeyName = (PropertyKeyName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PropertyKeyName apply(InputPosition position) {
                        return new PropertyKeyName("prop", position);
                    }
                });
                Property n_prop = (Property)this.$outer.withPos(new Serializable(this, variable2, propertyKeyName){
                    public static final long serialVersionUID = 0L;
                    private final Variable eta$0$7$1;
                    private final PropertyKeyName eta$1$7$1;

                    public final Property apply(InputPosition position) {
                        return new Property((Expression)this.eta$0$7$1, this.eta$1$7$1, position);
                    }
                    {
                        this.eta$0$7$1 = eta$0$7$1;
                        this.eta$1$7$1 = eta$1$7$1;
                    }
                });
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = (SignedDecimalIntegerLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("3", position);
                    }
                });
                InequalityExpression[] inequalityExpressionArray = new InequalityExpression[1];
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral2 = (SignedDecimalIntegerLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("4", position);
                    }
                });
                inequalityExpressionArray[0] = (InequalityExpression)this.$outer.withPos(new Serializable(this, n_prop, signedDecimalIntegerLiteral2){
                    public static final long serialVersionUID = 0L;
                    private final Property n_prop$1;
                    private final SignedDecimalIntegerLiteral eta$0$9$1;

                    public final LessThan apply(InputPosition position) {
                        return new LessThan((Expression)this.n_prop$1, (Expression)this.eta$0$9$1, position);
                    }
                    {
                        this.n_prop$1 = n_prop$1;
                        this.eta$0$9$1 = eta$0$9$1;
                    }
                });
                Predicate n_gt_3_and_lt_4 = new Predicate((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{new IdName("n")})), (Expression)new AndedPropertyInequalities(this.$outer.varFor("n"), n_prop, NonEmptyList$.MODULE$.apply(this.$outer.withPos(new Serializable(this, n_prop, signedDecimalIntegerLiteral){
                    public static final long serialVersionUID = 0L;
                    private final Property n_prop$1;
                    private final SignedDecimalIntegerLiteral eta$0$8$1;

                    public final GreaterThan apply(InputPosition position) {
                        return new GreaterThan((Expression)this.n_prop$1, (Expression)this.eta$0$8$1, position);
                    }
                    {
                        this.n_prop$1 = n_prop$1;
                        this.eta$0$8$1 = eta$0$8$1;
                    }
                }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])inequalityExpressionArray))));
                Selections selections = new Selections((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{n_is_Person, n_gt_3_and_lt_4})));
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)None$.MODULE$)).thenReturn((Object)Cardinality$.MODULE$.lift(2000.0));
                Mockito.when((Object)stats.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(0)))).thenReturn((Object)Cardinality$.MODULE$.lift(1000.0));
                ExpressionSelectivityCalculator calculator = new ExpressionSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                Selectivity result = calculator.apply(n_gt_3_and_lt_4.expr(), semanticTable, selections);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)result.factor())).should(this.$outer.equal(BoxesRunTime.boxToDouble((double)0.06)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should optimize selectivity with respect to prefix length for STARTS WITH predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(0));
                semanticTable.resolvedPropertyKeyNames().put((Object)"prop", (Object)new PropertyKeyId(0));
                Selections selections = (Selections)this.$outer.mock(ManifestFactory$.MODULE$.classType(Selections.class));
                InputPosition$.MODULE$.NONE();
                LabelName label = new LabelName("A", null);
                InputPosition$.MODULE$.NONE();
                PropertyKeyName propKey = new PropertyKeyName("prop", null);
                Mockito.when((Object)selections.labelsOnNode(new IdName("a"))).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})));
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.indexSelectivity(new LabelId(0), new PropertyKeyId(0))).thenReturn((Object)new Some(Selectivity$.MODULE$.of(0.01).get()));
                Mockito.when((Object)stats.indexPropertyExistsSelectivity(new LabelId(0), new PropertyKeyId(0))).thenReturn((Object)new Some((Object)Selectivity$.MODULE$.ONE()));
                ExpressionSelectivityCalculator calculator = new ExpressionSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                Map prefixes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)BoxesRunTime.boxToDouble((double)0.23384596099184043)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p2"), (Object)BoxesRunTime.boxToDouble((double)0.2299568541948447)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p33"), (Object)BoxesRunTime.boxToDouble((double)0.22801230079634685)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p5555"), (Object)BoxesRunTime.boxToDouble((double)0.22606774739784896)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reallylong"), (Object)BoxesRunTime.boxToDouble((double)0.22429997158103274))}));
                prefixes.foreach((Function1)new Serializable(this, semanticTable, selections, propKey, calculator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final SemanticTable semanticTable$1;
                    private final Selections selections$1;
                    public final PropertyKeyName propKey$1;
                    private final ExpressionSelectivityCalculator calculator$1;

                    public final void apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String prefix = (String)tuple2._1();
                            double selectivity = tuple2._2$mcD$sp();
                            ExpressionSelectivityCalculatorTest expressionSelectivityCalculatorTest = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer();
                            Variable variable = (Variable)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().withPos(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Variable apply(InputPosition position) {
                                    return new Variable("a", position);
                                }
                            });
                            Property property = (Property)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().withPos(new Serializable(this, variable){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$1 $outer;
                                private final Variable eta$0$10$1;

                                public final Property apply(InputPosition position) {
                                    return new Property((Expression)this.eta$0$10$1, this.$outer.propKey$1, position);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.eta$0$10$1 = eta$0$10$1;
                                }
                            });
                            InputPosition$.MODULE$.NONE();
                            StringLiteral stringLiteral = new StringLiteral(prefix, null);
                            Selectivity actual = this.calculator$1.apply((Expression)expressionSelectivityCalculatorTest.withPos(new Serializable(this, property, stringLiteral){
                                public static final long serialVersionUID = 0L;
                                private final Property eta$0$11$1;
                                private final StringLiteral eta$1$8$1;

                                public final StartsWith apply(InputPosition position) {
                                    return new StartsWith((Expression)this.eta$0$11$1, (Expression)this.eta$1$8$1, position);
                                }
                                {
                                    this.eta$0$11$1 = eta$0$11$1;
                                    this.eta$1$8$1 = eta$1$8$1;
                                }
                            }), this.semanticTable$1, this.selections$1);
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)actual.factor()));
                            TripleEqualsSupport.Spread $org_scalatest_assert_macro_right = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)selectivity), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)(selectivity * 1.0E-15)));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.semanticTable$1 = semanticTable$1;
                        this.selections$1 = selections$1;
                        this.propKey$1 = propKey$1;
                        this.calculator$1 = calculator$1;
                    }
                });
            }

            public /* synthetic */ ExpressionSelectivityCalculatorTest org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Selectivity should never be worse than corresponding existence selectivity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSelectivityCalculatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(0));
                semanticTable.resolvedPropertyKeyNames().put((Object)"prop", (Object)new PropertyKeyId(0));
                Selections selections = (Selections)this.$outer.mock(ManifestFactory$.MODULE$.classType(Selections.class));
                InputPosition$.MODULE$.NONE();
                LabelName label = new LabelName("A", null);
                InputPosition$.MODULE$.NONE();
                PropertyKeyName propKey = new PropertyKeyName("prop", null);
                Mockito.when((Object)selections.labelsOnNode(new IdName("a"))).thenReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{label})));
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.indexSelectivity(new LabelId(0), new PropertyKeyId(0))).thenReturn((Object)new Some(Selectivity$.MODULE$.of(0.01).get()));
                double existenceSelectivity = 0.2285;
                Mockito.when((Object)stats.indexPropertyExistsSelectivity(new LabelId(0), new PropertyKeyId(0))).thenReturn((Object)new Some(Selectivity$.MODULE$.of(existenceSelectivity).get()));
                ExpressionSelectivityCalculator calculator = new ExpressionSelectivityCalculator(stats, (SelectivityCombiner)IndependenceCombiner$.MODULE$);
                Map prefixes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)BoxesRunTime.boxToDouble((double)existenceSelectivity)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p2"), (Object)BoxesRunTime.boxToDouble((double)existenceSelectivity)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p33"), (Object)BoxesRunTime.boxToDouble((double)0.22801230079634685)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p5555"), (Object)BoxesRunTime.boxToDouble((double)0.22606774739784896)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reallylong"), (Object)BoxesRunTime.boxToDouble((double)0.22429997158103274))}));
                prefixes.foreach((Function1)new Serializable(this, semanticTable, selections, propKey, calculator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final SemanticTable semanticTable$2;
                    private final Selections selections$2;
                    public final PropertyKeyName propKey$2;
                    private final ExpressionSelectivityCalculator calculator$2;

                    public final void apply(Tuple2<String, Object> x0$2) {
                        Tuple2<String, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String prefix = (String)tuple2._1();
                            double selectivity = tuple2._2$mcD$sp();
                            ExpressionSelectivityCalculatorTest expressionSelectivityCalculatorTest = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer();
                            Variable variable = (Variable)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().withPos(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Variable apply(InputPosition position) {
                                    return new Variable("a", position);
                                }
                            });
                            Property property = (Property)this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().withPos(new Serializable(this, variable){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$2 $outer;
                                private final Variable eta$0$12$1;

                                public final Property apply(InputPosition position) {
                                    return new Property((Expression)this.eta$0$12$1, this.$outer.propKey$2, position);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.eta$0$12$1 = eta$0$12$1;
                                }
                            });
                            InputPosition$.MODULE$.NONE();
                            StringLiteral stringLiteral = new StringLiteral(prefix, null);
                            Selectivity actual = this.calculator$2.apply((Expression)expressionSelectivityCalculatorTest.withPos(new Serializable(this, property, stringLiteral){
                                public static final long serialVersionUID = 0L;
                                private final Property eta$0$13$1;
                                private final StringLiteral eta$1$9$1;

                                public final StartsWith apply(InputPosition position) {
                                    return new StartsWith((Expression)this.eta$0$13$1, (Expression)this.eta$1$9$1, position);
                                }
                                {
                                    this.eta$0$13$1 = eta$0$13$1;
                                    this.eta$1$9$1 = eta$1$9$1;
                                }
                            }), this.semanticTable$2, this.selections$2);
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)actual.factor()));
                            TripleEqualsSupport.Spread $org_scalatest_assert_macro_right = this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().convertNumericToPlusOrMinusWrapper(BoxesRunTime.boxToDouble((double)selectivity), (Numeric)Numeric.DoubleIsFractional$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToDouble((double)(selectivity * 1.0E-15)));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                            this.$outer.org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.semanticTable$2 = semanticTable$2;
                        this.selections$2 = selections$2;
                        this.propKey$2 = propKey$2;
                        this.calculator$2 = calculator$2;
                    }
                });
            }

            public /* synthetic */ ExpressionSelectivityCalculatorTest org$neo4j$cypher$internal$compiler$v3_1$planner$logical$cardinality$ExpressionSelectivityCalculatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

