/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.spi;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.CardinalityByLabelsAndRelationshipType;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatisticsSnapshotTest$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.IndexSelectivity;
import org.neo4j.cypher.internal.compiler.v3_1.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.MutableGraphStatisticsSnapshot;
import org.neo4j.cypher.internal.compiler.v3_1.spi.MutableGraphStatisticsSnapshot$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.NodesWithLabelCardinality;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.RelTypeId;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001#\tYrI]1qQN#\u0018\r^5ti&\u001c7o\u00158baNDw\u000e\u001e+fgRT!a\u0001\u0003\u0002\u0007M\u0004\u0018N\u0003\u0002\u0006\r\u0005!aoM02\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003!1'o\u001c8uK:$\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\u001f\u001d\u0014\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN$\u0012a\t\n\u0004I\u0019bc\u0001B\u0013!\u0001\r\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0010.\u0013\tq#AA\bHe\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015\u0001D\u0005\"\u00012\u0003\u00191\u0017m\u0019;peR\u0011!'\u000e\t\u0003OMJ!\u0001\u000e\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006a=\u0002\rA\u000e\t\u0003O]J!\u0001\u000f\u0015\u0003\t1{gn\u001a")
public class GraphStatisticsSnapshotTest
extends CypherFunSuite {
    public GraphStatistics graphStatistics() {
        return new GraphStatistics(this){
            private long _factor;

            private long _factor() {
                return this._factor;
            }

            private void _factor_$eq(long x$1) {
                this._factor = x$1;
            }

            public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
                return new Cardinality((double)((long)BoxesRunTime.unboxToInt((Object)labelId.fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 500;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LabelId x$1) {
                        return x$1.id() * 10;
                    }
                })) * this._factor()));
            }

            public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
                return new Cardinality((double)((long)BoxesRunTime.unboxToInt((Object)relTypeId.fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 5000;
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(RelTypeId x$2) {
                        return x$2.id() * 10;
                    }
                })) * this._factor()));
            }

            public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
                return Selectivity$.MODULE$.of(1.0 / (double)((long)(property.id() + 1) * this._factor()));
            }

            public Option<Selectivity> indexPropertyExistsSelectivity(LabelId label, PropertyKeyId property) {
                return Selectivity$.MODULE$.of(1.0 / (double)((long)(property.id() + 1) * this._factor()));
            }

            public void factor(long factor) {
                this._factor_$eq(factor);
            }
            {
                this._factor = 1L;
            }
        };
    }

    public GraphStatisticsSnapshotTest() {
        this.test("records queries and its observed values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphStatisticsSnapshotTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MutableGraphStatisticsSnapshot snapshot = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                InstrumentedGraphStatistics instrumentedStatistics = new InstrumentedGraphStatistics(this.$outer.graphStatistics(), snapshot);
                instrumentedStatistics.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                instrumentedStatistics.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                instrumentedStatistics.cardinalityByLabelsAndRelationshipType((Option)new Some((Object)new LabelId(2)), (Option)None$.MODULE$, (Option)None$.MODULE$);
                instrumentedStatistics.cardinalityByLabelsAndRelationshipType((Option)None$.MODULE$, (Option)new Some((Object)new RelTypeId(1)), (Option)new Some((Object)new LabelId(2)));
                this.$outer.convertToAnyShouldWrapper(snapshot.freeze().map()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality((Option)None$.MODULE$)), (Object)BoxesRunTime.boxToInteger((int)500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new IndexSelectivity(new LabelId(0), new PropertyKeyId(3))), (Object)BoxesRunTime.boxToDouble((double)0.25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)))), (Object)BoxesRunTime.boxToInteger((int)40)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new CardinalityByLabelsAndRelationshipType((Option)new Some((Object)new LabelId(2)), (Option)None$.MODULE$, (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToInteger((int)5000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new CardinalityByLabelsAndRelationshipType((Option)None$.MODULE$, (Option)new Some((Object)new RelTypeId(1)), (Option)new Some((Object)new LabelId(2)))), (Object)BoxesRunTime.boxToInteger((int)10))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("a snapshot shouldn't diverge from itself", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphStatisticsSnapshotTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MutableGraphStatisticsSnapshot snapshot = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                InstrumentedGraphStatistics instrumentedStatistics = new InstrumentedGraphStatistics(this.$outer.graphStatistics(), snapshot);
                instrumentedStatistics.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                instrumentedStatistics.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                instrumentedStatistics.cardinalityByLabelsAndRelationshipType((Option)new Some((Object)new LabelId(2)), (Option)None$.MODULE$, (Option)None$.MODULE$);
                instrumentedStatistics.cardinalityByLabelsAndRelationshipType((Option)None$.MODULE$, (Option)new Some((Object)new RelTypeId(1)), (Option)new Some((Object)new LabelId(2)));
                GraphStatisticsSnapshot frozenSnapshot = snapshot.freeze();
                double smallNumber = 1.0E-10;
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)frozenSnapshot.diverges(frozenSnapshot, smallNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("a snapshot should pick up divergences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphStatisticsSnapshotTest $outer;
            private static Class[] reflParams$Cache1;
            private static volatile SoftReference reflPoly$Cache1;

            static {
                reflParams$Cache1 = new Class[]{Long.TYPE};
                reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
            }

            public static Method reflMethod$Method1(Class x$1) {
                Method method1;
                MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
                if (methodCache1 == null) {
                    methodCache1 = new EmptyMethodCache();
                    reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
                }
                if ((method1 = methodCache1.find(x$1)) != null) {
                    return method1;
                }
                method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("factor", reflParams$Cache1));
                reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
                return method1;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MutableGraphStatisticsSnapshot snapshot1 = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                GraphStatistics statistics = this.$outer.graphStatistics();
                InstrumentedGraphStatistics instrumentedStatistics1 = new InstrumentedGraphStatistics(statistics, snapshot1);
                instrumentedStatistics1.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics1.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                instrumentedStatistics1.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                MutableGraphStatisticsSnapshot snapshot2 = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                InstrumentedGraphStatistics instrumentedStatistics2 = new InstrumentedGraphStatistics(statistics, snapshot2);
                instrumentedStatistics2.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics2.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                GraphStatistics qual1 = statistics;
                try {
                    $anonfun$3.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, BoxesRunTime.boxToLong((long)2L));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                instrumentedStatistics2.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                GraphStatisticsSnapshot frozen1 = snapshot1.freeze();
                GraphStatisticsSnapshot frozen2 = snapshot2.freeze();
                double smallNumber = 0.1;
                double bigNumber = 0.6;
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)frozen1.diverges(frozen2, smallNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)frozen1.diverges(frozen2, bigNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if threshold is 1.0 nothing diverges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphStatisticsSnapshotTest $outer;
            private static Class[] reflParams$Cache2;
            private static volatile SoftReference reflPoly$Cache2;

            static {
                reflParams$Cache2 = new Class[]{Long.TYPE};
                reflPoly$Cache2 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
            }

            public static Method reflMethod$Method2(Class x$1) {
                Method method2;
                MethodCache methodCache2 = (MethodCache)reflPoly$Cache2.get();
                if (methodCache2 == null) {
                    methodCache2 = new EmptyMethodCache();
                    reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2);
                }
                if ((method2 = methodCache2.find(x$1)) != null) {
                    return method2;
                }
                method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("factor", reflParams$Cache2));
                reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2.add(x$1, method2));
                return method2;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MutableGraphStatisticsSnapshot snapshot1 = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                GraphStatistics statistics = this.$outer.graphStatistics();
                InstrumentedGraphStatistics instrumentedStatistics1 = new InstrumentedGraphStatistics(statistics, snapshot1);
                instrumentedStatistics1.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics1.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                instrumentedStatistics1.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                MutableGraphStatisticsSnapshot snapshot2 = new MutableGraphStatisticsSnapshot(MutableGraphStatisticsSnapshot$.MODULE$.apply$default$1());
                InstrumentedGraphStatistics instrumentedStatistics2 = new InstrumentedGraphStatistics(statistics, snapshot2);
                instrumentedStatistics2.nodesWithLabelCardinality((Option)None$.MODULE$);
                instrumentedStatistics2.nodesWithLabelCardinality((Option)new Some((Object)new LabelId(4)));
                GraphStatistics qual2 = statistics;
                try {
                    $anonfun$4.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                instrumentedStatistics2.indexSelectivity(new LabelId(0), new PropertyKeyId(3));
                GraphStatisticsSnapshot frozen1 = snapshot1.freeze();
                GraphStatisticsSnapshot frozen2 = snapshot2.freeze();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)frozen1.diverges(frozen2, 1.0))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

