/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_3.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.Rewritable;
import org.neo4j.cypher.internal.frontend.v3_3.Rewritable$;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.isolateAggregation$;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.frontend.v3_3.inSequence$;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001'\t1\u0012j]8mCR,\u0017iZ4sK\u001e\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005I!/Z<sSR,'o\u001d\u0006\u0003\u000b\u0019\t1!Y:u\u0015\t9\u0001\"\u0001\u0003wg}\u001b$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001F\u000f\"!\t)2$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\b3)\u0011!DC\u0001\tMJ|g\u000e^3oI&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tqr$D\u0001\u0003\u0013\t\u0001#AA\u0006SK^\u0014\u0018\u000e^3UKN$\bC\u0001\u0012%\u001b\u0005\u0019#BA\u0003\u0019\u0013\t)3E\u0001\u000eBgR\u001cuN\\:ueV\u001cG/[8o)\u0016\u001cHoU;qa>\u0014H\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011a\u0004\u0001\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0003E\u0011Xm\u001e:ji\u0016\u0014XK\u001c3feR+7\u000f^\u000b\u0002[9\u0011a\u0006M\u0007\u0002_)\u00111aI\u0005\u0003c=\n!#[:pY\u0006$X-Q4he\u0016<\u0017\r^5p]\"11\u0007\u0001Q\u0001\n5\n!C]3xe&$XM]+oI\u0016\u0014H+Z:uA!)Q\u0007\u0001C)m\u0005\t\u0002/\u0019:tK\u001a{'OU3xe&$\u0018N\\4\u0015\u0005]R\u0004C\u0001\u00129\u0013\tI4EA\u0005Ti\u0006$X-\\3oi\")1\b\u000ea\u0001y\u0005I\u0011/^3ssR+\u0007\u0010\u001e\t\u0003{\rs!AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\na\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!i\u0010")
public class IsolateAggregationTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final isolateAggregation$ rewriterUnderTest;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        RewriteTest$class.assertRewrite(this, originalQuery, expectedQuery);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    public isolateAggregation$ rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)RewriteTest$class.parseForRewriting(this, queryText)), inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
    }

    public IsolateAggregationTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.rewriterUnderTest = isolateAggregation$.MODULE$;
        this.test("does not rewrite things that should not be rewritten", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten("MATCH n RETURN n AS n");
                this.$outer.assertIsNotRewritten("MATCH n RETURN n AS n, count(*) AS count, max(n.prop) AS max");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN { name: n.name, count: count(*) } AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN { name: n.name, count: count(*) } AS result", "MATCH (n) WITH n.name AS `  AGGREGATION27`, count(*) AS `  AGGREGATION40` RETURN { name: `  AGGREGATION27`, count: `  AGGREGATION40` } AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN n.foo + count(*) AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN n.foo + count(*) AS result", "MATCH (n) WITH n.foo AS `  AGGREGATION19`, count(*) AS `  AGGREGATION25` RETURN `  AGGREGATION19` + `  AGGREGATION25` AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN count(*)/60/42 AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN count(*)/60/42 AS result", "MATCH (n) WITH count(*) AS `  AGGREGATION17` RETURN `  AGGREGATION17`/60/42 AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("WITH 60 as sixty, 42 as fortytwo MATCH (n) RETURN count(*)/sixty/fortytwo AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("WITH 60 as sixty, 42 as fortytwo MATCH (n) RETURN count(*)/sixty/fortytwo AS result", "WITH 60 as sixty, 42 as fortytwo MATCH (n) WITH count(*) AS `  AGGREGATION50`, sixty AS `  AGGREGATION59`, fortytwo AS `  AGGREGATION65` RETURN `  AGGREGATION50`/`  AGGREGATION59`/`  AGGREGATION65` AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("WITH 1 AS node, [] AS nodes1 RETURN ANY (n IN collect(distinct node) WHERE n IN nodes1) as count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS node, [] AS nodes1\n        |RETURN ANY (n IN collect(distinct node) WHERE n IN nodes1) as count")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS node, [] AS nodes1\n        |WITH collect(distinct node) AS `  AGGREGATION46`, nodes1 AS `  AGGREGATION80`\n        |RETURN ANY (n IN `  AGGREGATION46` WHERE n IN `  AGGREGATION80`) as count")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("WITH 1 AS node, [] AS nodes1 RETURN NONE(n IN collect(distinct node) WHERE n IN nodes1) as count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS node, [] AS nodes1\n        |RETURN NONE(n IN collect(distinct node) WHERE n IN nodes1) as count")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS node, [] AS nodes1\n        |WITH collect(distinct node) AS `  AGGREGATION46`, nodes1 AS `  AGGREGATION80`\n        |RETURN NONE(n IN `  AGGREGATION46` WHERE n IN `  AGGREGATION80`) as count")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n)-->() RETURN (n)-->({k: count(*)}) AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n)-->() RETURN (n)-->({k: count(*)}) AS result", "MATCH (n)-->() WITH n as `  AGGREGATION23`, count(*) AS `  AGGREGATION33` RETURN (`  AGGREGATION23`)-->({k:`  AGGREGATION33`}) AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN n.prop AS prop, n.foo + count(*) AS count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN n.prop AS prop, n.foo + count(*) AS count", "MATCH (n) WITH n.prop AS `  AGGREGATION19`, n.foo AS `  AGGREGATION35`, count(*) AS `  AGGREGATION41` RETURN `  AGGREGATION19` AS prop, `  AGGREGATION35` + `  AGGREGATION41` AS count");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN n AS n, count(n) + 3 AS count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN n AS n, count(n) + 3 AS count", "MATCH (n) WITH n AS `  AGGREGATION17`, count(n) as `  AGGREGATION25`  RETURN `  AGGREGATION17` AS n, `  AGGREGATION25` + 3 AS count");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN reduce(y=0, x IN collect(a) | x) AS z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN reduce(y=0, x IN collect(a) | x) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION44` RETURN reduce(y=0, x IN `  AGGREGATION44` | x) AS z");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN filter(x IN collect(a) WHERE x <> 0) AS z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN filter(x IN collect(a) WHERE x <> 0) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION39` RETURN filter(x IN `  AGGREGATION39` WHERE x <> 0) AS z");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN extract(x IN collect(a) | x) AS z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN extract(x IN collect(a) | x) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION40` RETURN extract(x IN `  AGGREGATION40` | x) AS z");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN [x IN collect(a) | x] AS z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN [x IN collect(a) | x] AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION33` RETURN [x IN `  AGGREGATION33` | x] AS z");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) WITH 60/60/count(*) AS x RETURN x AS x", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) WITH 60/60/count(*) AS x RETURN x AS x", "MATCH (n) WITH count(*) AS `  AGGREGATION21` WITH 60/60/`  AGGREGATION21` AS x RETURN x AS x");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a:Start)<-[:R]-(b) RETURN { foo:a.prop=42, bar:collect(b.prop2) } AS result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a:Start)<-[:R]-(b) RETURN { foo:a.prop=42, bar:collect(b.prop2) } AS result", "MATCH (a:Start)<-[:R]-(b) WITH a.prop=42 AS `  AGGREGATION45`, collect(b.prop2) AS `  AGGREGATION54` RETURN { foo:`  AGGREGATION45`, bar:`  AGGREGATION54`} AS result");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN count(*) + max(id(n)) AS r", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN count(*) + max(id(n)) AS r", "MATCH (n) WITH count(*) AS `  AGGREGATION17`, max(id(n)) AS `  AGGREGATION28` RETURN `  AGGREGATION17`+`  AGGREGATION28` AS r");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a) RETURN length(collect(a)) AS length", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a) RETURN length(collect(a)) AS length", "MATCH (a) WITH collect(a) AS `  AGGREGATION24` RETURN length(`  AGGREGATION24`) AS length");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a) RETURN count(a) > 0 AS bool", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a) RETURN count(a) > 0 AS bool", "MATCH (a) WITH count(a) AS `  AGGREGATION17` RETURN `  AGGREGATION17` > 0 AS bool");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a) RETURN count(a) > {param} AS bool", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a) RETURN count(a) > {param} AS bool", "MATCH (a) WITH count(a) AS `  AGGREGATION17` RETURN `  AGGREGATION17` > {param} AS bool");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce multiple return items for the same expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("WITH 1 AS x, 2 AS y RETURN sum(x)*y AS a, sum(x)*y AS b", "WITH 1 AS x, 2 AS y WITH sum(x) as `  AGGREGATION27`, y as `  AGGREGATION34` RETURN `  AGGREGATION27`* `  AGGREGATION34` AS a, `  AGGREGATION27`*`  AGGREGATION34` AS b");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a), (b) RETURN coalesce(a.prop, b.prop), b.prop, { x: count(b) }", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (a), (b)\n        |RETURN coalesce(a.prop, b.prop), b.prop, { x: count(b) }")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (a), (b)\n        |WITH coalesce(a.prop, b.prop) AS `  AGGREGATION22`,\n        |     b.prop AS `  AGGREGATION50`,\n        |     count(b) AS `  AGGREGATION61`\n        |RETURN `  AGGREGATION22` AS `coalesce(a.prop, b.prop)`,\n        |       `  AGGREGATION50` AS `b.prop`,\n        |       { x: `  AGGREGATION61` } AS `{ x: count(b) }`")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not extract expressions that do not contain on variables as implicit grouping key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (user:User {userId: 11})-[friendship:FRIEND]-()\n        |WITH user AS user, collect(friendship)[toInteger(rand() * count(friendship))] AS selectedFriendship\n        |RETURN id(selectedFriendship) AS friendshipId, selectedFriendship.propFive AS propertyValue")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (user:User {userId: 11})-[friendship:FRIEND]-()\n        |WITH user AS `  AGGREGATION59`, collect(friendship) AS `  AGGREGATION73`, count(friendship) AS `  AGGREGATION112`\n        |WITH `  AGGREGATION59` AS user, `  AGGREGATION73`[toInteger(rand() * `  AGGREGATION112`)] AS selectedFriendship\n        |RETURN id(selectedFriendship) AS friendshipId, selectedFriendship.propFive AS propertyValue")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

