/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_3.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v3_3.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.SyntaxException;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001'\tQbj\u001c:nC2L'0\u001a*fiV\u0014hn\u00117bkN,7\u000fV3ti*\u00111\u0001B\u0001\ne\u0016<(/\u001b;feNT!!\u0002\u0004\u0002\u0007\u0005\u001cHO\u0003\u0002\b\u0011\u0005!aoM04\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0005\u0001Qi\u0012\u0005\u0005\u0002\u001675\taC\u0003\u0002\u00181\u0005aA/Z:u?\",G\u000e]3sg*\u0011q!\u0007\u0006\u00035)\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00039Y\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tY!+Z<sSR,G+Z:u!\t\u0011C%D\u0001$\u0015\t)\u0001$\u0003\u0002&G\tQ\u0012i\u001d;D_:\u001cHO];di&|g\u000eV3tiN+\b\u000f]8si\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"\u0012!\u000b\t\u0003=\u0001Aqa\u000b\u0001C\u0002\u0013\u0005A&A\u0006nW\u0016C8-\u001a9uS>tW#A\u0017\u0011\u00059zS\"\u0001\u0004\n\u0005A2!AF*z]R\f\u00070\u0012=dKB$\u0018n\u001c8De\u0016\fGo\u001c:\t\rI\u0002\u0001\u0015!\u0003.\u00031i7.\u0012=dKB$\u0018n\u001c8!\u0011\u001d!\u0004A1A\u0005\u0002U\n\u0011C]3xe&$XM]+oI\u0016\u0014H+Z:u+\u00051\u0004CA\u001cJ\u001d\tAtI\u0004\u0002:\r:\u0011!(\u0012\b\u0003w\u0011s!\u0001P\"\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!A\u0007\u0006\n\u0005\u001dI\u0012B\u0001%\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!AS&\u0003\u0011I+wO]5uKJT!\u0001\u0013\r\t\r5\u0003\u0001\u0015!\u00037\u0003I\u0011Xm\u001e:ji\u0016\u0014XK\u001c3feR+7\u000f\u001e\u0011\t\u000b=\u0003A\u0011\u000b)\u0002\u001b\u0005\u001c8/\u001a:u%\u0016<(/\u001b;f)\r\tv\u000b\u0019\t\u0003%Vk\u0011a\u0015\u0006\u0002)\u0006)1oY1mC&\u0011ak\u0015\u0002\u0005+:LG\u000fC\u0003Y\u001d\u0002\u0007\u0011,A\u0007pe&<\u0017N\\1m#V,'/\u001f\t\u00035vs!AU.\n\u0005q\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X*\t\u000b\u0005t\u0005\u0019A-\u0002\u001b\u0015D\b/Z2uK\u0012\fV/\u001a:z\u0011\u0015\u0019\u0007\u0001\"\u0005e\u0003%\u0011Xm\u001e:ji&tw\r\u0006\u0002RK\")aM\u0019a\u00013\u0006I\u0011/^3ssR+\u0007\u0010\u001e")
public class NormalizeReturnClausesTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final SyntaxExceptionCreator mkException;
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    public SyntaxExceptionCreator mkException() {
        return this.mkException;
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.parseForRewriting(originalQuery);
        Statement expected = this.parseForRewriting(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
    }

    public void rewriting(String queryText) {
        this.endoRewrite(this.parseForRewriting(queryText));
    }

    public NormalizeReturnClausesTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.mkException = new SyntaxExceptionCreator("<Query>", (Option)new Some((Object)this.pos()));
        this.rewriterUnderTest = new normalizeReturnClauses((Function2)this.mkException());
        this.test("alias RETURN clause items", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN n, n.foo AS foo, n.bar\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN n AS `n`, n.foo AS foo, n.bar AS `n.bar`\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("introduce WITH clause for ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN n.foo AS foo, n.bar ORDER BY foo SKIP 2 LIMIT 5")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |WITH n.foo AS `  FRESHID19`, n.bar AS `  FRESHID33` ORDER BY `  FRESHID19` SKIP 2 LIMIT 5\n        |RETURN `  FRESHID19` AS foo, `  FRESHID33` AS `n.bar`")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("introduce WITH clause for ORDER BY where returning all IDs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN * ORDER BY n.foo SKIP 2 LIMIT 5")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |WITH * ORDER BY n.foo SKIP 2 LIMIT 5\n        |RETURN *")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match (n) return n, count(*) as c order by c", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("match (n) return n, count(*) as c order by c", new StringOps(Predef$.MODULE$.augmentString("match (n)\n        |with n as `  FRESHID17`, count(*) as `  FRESHID20` order by `  FRESHID20`\n        |return `  FRESHID17` as n, `  FRESHID20` as c")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match (n),(m) return n as m, m as m2 order by m", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("match (n),(m) return n as m, m as m2 order by m", new StringOps(Predef$.MODULE$.augmentString("match (n), (m)\n        |with n as `  FRESHID21`, m as `  FRESHID29` order by `  FRESHID21`\n        |return `  FRESHID21` as m, `  FRESHID29` as m2")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match (n),(m) return m as m2, n as m order by m", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("match (n),(m) return m as m2, n as m order by m", new StringOps(Predef$.MODULE$.augmentString("match (n), (m)\n        |with m as `  FRESHID21`, n as `  FRESHID30` order by `  FRESHID30`\n        |return `  FRESHID21` as m2, `  FRESHID30` as m")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rejects use of aggregation in ORDER BY if aggregation is not used in associated RETURN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.rewrite(this.$outer.parseForRewriting(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n          |RETURN n.prop AS prop ORDER BY max(n.foo)\n        ")).stripMargin()));
                    throw this.$outer.fail("We shouldn't get here");
                }
                catch (SyntaxException syntaxException) {
                    this.$outer.convertToStringShouldWrapper(syntaxException.getMessage()).should(this.$outer.equal("Cannot use aggregation in ORDER BY if there are no aggregate expressions in the preceding RETURN (line 2, column 1 (offset: 10))"), (Object)Equality$.MODULE$.default());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("accepts use of aggregation in ORDER BY if aggregation is used in associated RETURN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN n.prop AS prop, max(n.foo) AS m ORDER BY max(n.foo)\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |WITH n.prop AS `  FRESHID19`, max(n.foo) AS `  FRESHID33` ORDER BY `  FRESHID33`\n        |RETURN  `  FRESHID19` AS prop,  `  FRESHID33` AS m\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should replace the aggregation function in the order by", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |RETURN n as n, count(n) as count ORDER BY count(n)")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |WITH n AS `  FRESHID17`, count(n) AS `  FRESHID25` ORDER BY `  FRESHID25`\n        |RETURN `  FRESHID17` AS n, `  FRESHID25` as count")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

