/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner;

import java.time.Clock;
import org.neo4j.cypher.internal.compiler.v3_3.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.IDPPlannerName$;
import org.neo4j.cypher.internal.compiler.v3_3.UpdateStrategy;
import org.neo4j.cypher.internal.compiler.v3_3.phases.CompilerContext;
import org.neo4j.cypher.internal.compiler.v3_3.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.v3_3.phases.LogicalPlanState$;
import org.neo4j.cypher.internal.compiler.v3_3.planner.AstRewritingTestSupport;
import org.neo4j.cypher.internal.compiler.v3_3.planner.AstRewritingTestSupport$class;
import org.neo4j.cypher.internal.compiler.v3_3.planner.CheckForUnresolvedTokens$;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v3_3.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v3_3.test_helpers.ContextHelper$;
import org.neo4j.cypher.internal.frontend.v3_3.CypherException;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.LabelId;
import org.neo4j.cypher.internal.frontend.v3_3.PlannerName;
import org.neo4j.cypher.internal.frontend.v3_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_3.RelTypeId;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Query;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.MissingLabelNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.MissingRelTypeNotification;
import org.neo4j.cypher.internal.frontend.v3_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_3.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_3.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_3.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Monitors;
import org.neo4j.cypher.internal.frontend.v3_3.phases.RecordingNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_3.phases.RecordingNotificationLogger$;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001#\ta2\t[3dW\u001a{'/\u00168sKN|GN^3e)>\\WM\\:UKN$(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\tY\u001ctl\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00137A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uKB\u0011A$H\u0007\u0002\u0005%\u0011aD\u0001\u0002\u0018\u0003N$(+Z<sSRLgn\u001a+fgR\u001cV\u000f\u001d9peRDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005q\u0001\u0001\"\u0002\u0013\u0001\t\u0013)\u0013AD2iK\u000e\\gi\u001c:U_.,gn\u001d\u000b\u0004MYj\u0004cA\u0014.a9\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\u0007M+GO\u0003\u0002-SA\u0011\u0011\u0007N\u0007\u0002e)\u00111GF\u0001\r]>$\u0018NZ5dCRLwN\\\u0005\u0003kI\u0012A#\u00138uKJt\u0017\r\u001c(pi&4\u0017nY1uS>t\u0007\"B\u001c$\u0001\u0004A\u0014aA1tiB\u0011\u0011hO\u0007\u0002u)\u0011qGF\u0005\u0003yi\u0012Q!U;fefDQAP\u0012A\u0002}\nQb]3nC:$\u0018n\u0019+bE2,\u0007C\u0001!B\u001b\u00051\u0012B\u0001\"\u0017\u00055\u0019V-\\1oi&\u001cG+\u00192mK\")A\t\u0001C\u0005\u000b\u0006)\u0001/\u0019:tKR\u0011\u0001H\u0012\u0005\u0006\u000f\u000e\u0003\r\u0001S\u0001\u0006cV,'/\u001f\t\u0003O%K!AS\u0018\u0003\rM#(/\u001b8h\u0001")
public class CheckForUnresolvedTokensTest
extends CypherFunSuite
implements AstRewritingTestSupport {
    private final CypherParser parser;
    private final InputPosition pos;

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$AstRewritingTestSupport$_setter_$parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public Set<InternalNotification> org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(Query ast, SemanticTable semanticTable) {
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger(RecordingNotificationLogger$.MODULE$.$lessinit$greater$default$1());
        String x$1 = "apa";
        None$ x$2 = None$.MODULE$;
        IDPPlannerName$ x$3 = IDPPlannerName$.MODULE$;
        Some x$4 = new Some((Object)ast);
        Some x$5 = new Some((Object)semanticTable);
        Option x$6 = LogicalPlanState$.MODULE$.apply$default$5();
        Option x$7 = LogicalPlanState$.MODULE$.apply$default$6();
        Option x$8 = LogicalPlanState$.MODULE$.apply$default$8();
        Option x$9 = LogicalPlanState$.MODULE$.apply$default$9();
        Option x$10 = LogicalPlanState$.MODULE$.apply$default$10();
        Set x$11 = LogicalPlanState$.MODULE$.apply$default$11();
        LogicalPlanState compilationState = new LogicalPlanState(x$1, (Option)x$2, (PlannerName)x$3, (Option)x$4, x$6, x$7, (Option)x$5, x$8, x$9, x$10, x$11);
        RecordingNotificationLogger x$12 = notificationLogger;
        Function2<String, InputPosition, CypherException> x$13 = ContextHelper$.MODULE$.create$default$1();
        CompilationPhaseTracer x$14 = ContextHelper$.MODULE$.create$default$2();
        PlanContext x$15 = ContextHelper$.MODULE$.create$default$4();
        Monitors x$16 = ContextHelper$.MODULE$.create$default$5();
        Metrics x$17 = ContextHelper$.MODULE$.create$default$6();
        CypherCompilerConfiguration x$18 = ContextHelper$.MODULE$.create$default$7();
        QueryGraphSolver x$19 = ContextHelper$.MODULE$.create$default$8();
        UpdateStrategy x$20 = ContextHelper$.MODULE$.create$default$9();
        Set<String> x$21 = ContextHelper$.MODULE$.create$default$10();
        Clock x$22 = ContextHelper$.MODULE$.create$default$11();
        CompilerContext context = ContextHelper$.MODULE$.create(x$13, x$14, (InternalNotificationLogger)x$12, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        CheckForUnresolvedTokens$.MODULE$.transform((Object)compilationState, (BaseContext)context);
        return notificationLogger.notifications();
    }

    public Query org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse(String query) {
        Statement statement = this.parser().parse(query, this.parser().parse$default$2());
        if (statement instanceof Query) {
            Query query2;
            Query query3 = query2 = (Query)statement;
            return query3;
        }
        throw this.fail("Must be a Query");
    }

    public CheckForUnresolvedTokensTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        AstRewritingTestSupport$class.$init$(this);
        this.test("warn when missing label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-->(b:B) RETURN *");
                Set<InternalNotification> notifications = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable);
                this.$outer.convertToAnyShouldWrapper(notifications).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingLabelNotification[]{new MissingLabelNotification(new InputPosition(9, 1, 10), "A"), new MissingLabelNotification(new InputPosition(17, 1, 18), "B")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when labels are there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("warn when missing relationship type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-[r:R1|R2]->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingRelTypeNotification[]{new MissingRelTypeNotification(new InputPosition(15, 1, 16), "R1"), new MissingRelTypeNotification(new InputPosition(18, 1, 19), "R2")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when relationship types are there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedLabelIds().put((Object)"A", (Object)new LabelId(42));
                semanticTable.resolvedLabelIds().put((Object)"B", (Object)new LabelId(84));
                semanticTable.resolvedRelTypeNames().put((Object)"R1", (Object)new RelTypeId(1));
                semanticTable.resolvedRelTypeNames().put((Object)"R2", (Object)new RelTypeId(2));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a:A)-[r:R1|R2]->(b:B) RETURN *");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("warn when missing property key name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a) WHERE a.prop = 42 RETURN a");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MissingPropertyNameNotification[]{new MissingPropertyNameNotification(new InputPosition(18, 1, 19), "prop")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn when property key name is there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                semanticTable.resolvedPropertyKeyNames().put((Object)"prop", (Object)new PropertyKeyId(42));
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("MATCH (a {prop: 42}) RETURN a");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't warn for literal maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CheckForUnresolvedTokensTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable semanticTable = new SemanticTable(SemanticTable$.MODULE$.$lessinit$greater$default$1(), SemanticTable$.MODULE$.$lessinit$greater$default$2(), SemanticTable$.MODULE$.$lessinit$greater$default$3(), SemanticTable$.MODULE$.$lessinit$greater$default$4(), SemanticTable$.MODULE$.$lessinit$greater$default$5());
                Query ast = this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$parse("RETURN {prop: 'foo'}");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$CheckForUnresolvedTokensTest$$checkForTokens(ast, semanticTable)).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

