/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner;

import org.neo4j.cypher.internal.compiler.v3_3.planner.PlannerQueryTest$;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SortItem;
import org.neo4j.cypher.internal.frontend.v3_3.ast.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.ir.v3_3.LazyMode$;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_3.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_3.QueryGraph$;
import org.neo4j.cypher.internal.ir.v3_3.QueryHorizon;
import org.neo4j.cypher.internal.ir.v3_3.QueryProjection$;
import org.neo4j.cypher.internal.ir.v3_3.QueryShuffle;
import org.neo4j.cypher.internal.ir.v3_3.QueryShuffle$;
import org.neo4j.cypher.internal.ir.v3_3.RegularPlannerQuery;
import org.neo4j.cypher.internal.ir.v3_3.RegularPlannerQuery$;
import org.neo4j.cypher.internal.ir.v3_3.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.v3_3.Selections;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001#\t\u0001\u0002\u000b\\1o]\u0016\u0014\u0018+^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\u001d7b]:,'O\u0003\u0002\u0006\r\u0005!aoM04\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IY\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0017\u0003\r\t7\u000f^\u0005\u0003Au\u0011!$Q:u\u0007>t7\u000f\u001e:vGRLwN\u001c+fgR\u001cV\u000f\u001d9peRDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002")
public class PlannerQueryTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public PlannerQueryTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("pair map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph qg3;
                QueryGraph qg1 = QueryGraph$.MODULE$.empty();
                QueryGraph qg2 = QueryGraph$.MODULE$.empty();
                QueryGraph x$1 = qg3 = QueryGraph$.MODULE$.empty();
                None$ x$2 = None$.MODULE$;
                QueryHorizon x$3 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery pq3 = new RegularPlannerQuery(x$1, x$3, (Option)x$2);
                QueryGraph x$4 = qg2;
                Some x$5 = new Some((Object)pq3);
                QueryHorizon x$6 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery pq2 = new RegularPlannerQuery(x$4, x$6, (Option)x$5);
                QueryGraph x$7 = qg1;
                Some x$8 = new Some((Object)pq2);
                QueryHorizon x$9 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery pq1 = new RegularPlannerQuery(x$7, x$9, (Option)x$8);
                ObjectRef seenOnPos1 = ObjectRef.create((Object)List$.MODULE$.empty());
                ObjectRef seenOnPos2 = ObjectRef.create((Object)List$.MODULE$.empty());
                PlannerQuery result = pq1.foldMap((Function2)new Serializable(this, seenOnPos1, seenOnPos2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef seenOnPos1$1;
                    private final ObjectRef seenOnPos2$1;

                    public final PlannerQuery apply(PlannerQuery x0$1, PlannerQuery x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null) {
                                PlannerQuery plannerQuery = pq1;
                                if (pq2 != null) {
                                    PlannerQuery plannerQuery2 = pq2;
                                    this.seenOnPos1$1.elem = (List)((List)this.seenOnPos1$1.elem).$colon$plus((Object)plannerQuery, List$.MODULE$.canBuildFrom());
                                    this.seenOnPos2$1.elem = (List)((List)this.seenOnPos2$1.elem).$colon$plus((Object)plannerQuery2, List$.MODULE$.canBuildFrom());
                                    PlannerQuery plannerQuery3 = plannerQuery2;
                                    return plannerQuery3;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.seenOnPos1$1 = seenOnPos1$1;
                        this.seenOnPos2$1 = seenOnPos2$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos1.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RegularPlannerQuery[]{pq1, pq2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos2.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RegularPlannerQuery[]{pq2, pq3}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(pq1), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap on single plannerQuery returns that PQ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph x$10 = QueryGraph$.MODULE$.empty();
                None$ x$11 = None$.MODULE$;
                QueryHorizon x$12 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery input = new RegularPlannerQuery(x$10, x$12, (Option)x$11);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final PlannerQuery apply(PlannerQuery x0$2, PlannerQuery x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                throw this.$outer.org$neo4j$cypher$internal$compiler$v3_3$planner$PlannerQueryTest$$anonfun$$$outer().fail("should not pass through here");
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(input), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ PlannerQueryTest org$neo4j$cypher$internal$compiler$v3_3$planner$PlannerQueryTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap plannerQuery with tail should change when reverseMapped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularPlannerQuery tail = new RegularPlannerQuery(QueryGraph$.MODULE$.empty(), RegularPlannerQuery$.MODULE$.apply$default$2(), RegularPlannerQuery$.MODULE$.apply$default$3());
                QueryGraph firstQueryGraph = QueryGraph$.MODULE$.empty();
                Set x$13 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
                Set x$14 = QueryGraph$.MODULE$.apply$default$1();
                Set x$15 = QueryGraph$.MODULE$.apply$default$3();
                Selections x$16 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$17 = QueryGraph$.MODULE$.apply$default$5();
                Set x$18 = QueryGraph$.MODULE$.apply$default$6();
                Set x$19 = QueryGraph$.MODULE$.apply$default$7();
                IndexedSeq x$20 = QueryGraph$.MODULE$.apply$default$8();
                QueryGraph secondQueryGraph = new QueryGraph(x$14, x$13, x$15, x$16, x$17, x$18, x$19, x$20);
                QueryGraph x$21 = firstQueryGraph;
                Some x$22 = new Some((Object)tail);
                QueryHorizon x$23 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery input = new RegularPlannerQuery(x$21, x$23, (Option)x$22);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this, secondQueryGraph){
                    public static final long serialVersionUID = 0L;
                    private final QueryGraph secondQueryGraph$1;

                    public final PlannerQuery apply(PlannerQuery x0$3, PlannerQuery x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                PlannerQuery plannerQuery = pq2;
                                PlannerQuery plannerQuery2 = plannerQuery.withQueryGraph(this.secondQueryGraph$1);
                                return plannerQuery2;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.secondQueryGraph$1 = secondQueryGraph$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.not()).equal((Object)input, Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.queryGraph()).should(this.$outer.equal(firstQueryGraph), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((PlannerQuery)result.tail().get()).queryGraph()).should(this.$outer.equal(secondQueryGraph), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute lazyness preference correctly for a single planner query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                RegularQueryProjection shuffleWithLimit;
                RegularQueryProjection x$24 = QueryProjection$.MODULE$.empty();
                QueryGraph x$25 = RegularPlannerQuery$.MODULE$.apply$default$1();
                Option x$26 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery noLimit = new RegularPlannerQuery(x$25, (QueryHorizon)x$24, x$26);
                this.$outer.convertToAnyShouldWrapper(noLimit.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                Some x$27 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$28 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$29 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$30 = shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$28, x$29, (Option)x$27));
                QueryGraph x$31 = RegularPlannerQuery$.MODULE$.apply$default$1();
                Option x$32 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery hasLimit = new RegularPlannerQuery(x$31, (QueryHorizon)x$30, x$32);
                this.$outer.convertToAnyShouldWrapper(hasLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                Seq x$33 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$34 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$35 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$36 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$33, x$35, (Option)x$34));
                QueryGraph x$37 = RegularPlannerQuery$.MODULE$.apply$default$1();
                Option x$38 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery hasLimitAndSort = new RegularPlannerQuery(x$37, (QueryHorizon)x$36, x$38);
                this.$outer.convertToAnyShouldWrapper(hasLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider planner query tails when computing lazyness preference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                Some x$39 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$40 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$41 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$40, x$41, (Option)x$39));
                Seq x$42 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$43 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$44 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$45 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$42, x$44, (Option)x$43));
                QueryGraph x$46 = RegularPlannerQuery$.MODULE$.apply$default$1();
                Option x$47 = RegularPlannerQuery$.MODULE$.apply$default$3();
                RegularPlannerQuery pqWithLimitAndSort = new RegularPlannerQuery(x$46, (QueryHorizon)x$45, x$47);
                RegularQueryProjection x$48 = shuffleWithLimit;
                Some x$49 = new Some((Object)pqWithLimitAndSort);
                QueryGraph x$50 = RegularPlannerQuery$.MODULE$.apply$default$1();
                RegularPlannerQuery pqWithLimit = new RegularPlannerQuery(x$50, (QueryHorizon)x$48, (Option)x$49);
                Some x$51 = new Some((Object)pqWithLimit);
                QueryGraph x$52 = RegularPlannerQuery$.MODULE$.apply$default$1();
                QueryHorizon x$53 = RegularPlannerQuery$.MODULE$.apply$default$2();
                RegularPlannerQuery pq = new RegularPlannerQuery(x$52, x$53, (Option)x$51);
                this.$outer.convertToAnyShouldWrapper(pq.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

