/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner;

import org.neo4j.cypher.internal.frontend.v3_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.ir.v3_3.PatternLength;
import org.neo4j.cypher.internal.ir.v3_3.PatternRelationship;
import org.neo4j.cypher.internal.ir.v3_3.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_3.QueryGraph$;
import org.neo4j.cypher.internal.ir.v3_3.Selections;
import org.neo4j.cypher.internal.ir.v3_3.SimplePatternLength$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Containing$;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001#\tq\u0011+^3ss\u001e\u0013\u0018\r\u001d5UKN$(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\tY\u001ctl\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0003a,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A\u0006\u0001Q\u0001\n\r\n!\u0001\u001f\u0011\t\u000f9\u0002!\u0019!C\u0001E\u0005\ta\u000e\u0003\u00041\u0001\u0001\u0006IaI\u0001\u0003]\u0002BqA\r\u0001C\u0002\u0013\u0005!%A\u0001n\u0011\u0019!\u0004\u0001)A\u0005G\u0005\u0011Q\u000e\t\u0005\bm\u0001\u0011\r\u0011\"\u0001#\u0003\u0005\u0019\u0007B\u0002\u001d\u0001A\u0003%1%\u0001\u0002dA!9!\b\u0001b\u0001\n\u0003\u0011\u0013A\u0001:2\u0011\u0019a\u0004\u0001)A\u0005G\u0005\u0019!/\r\u0011\t\u000fy\u0002!\u0019!C\u0001E\u0005\u0011!O\r\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0012\u0002\u0007I\u0014\u0004\u0005C\u0004C\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0005I\u001c\u0004B\u0002#\u0001A\u0003%1%A\u0002sg\u0001\u0002")
public class QueryGraphTest
extends CypherFunSuite {
    private final String x;
    private final String n;
    private final String m;
    private final String c;
    private final String r1;
    private final String r2;
    private final String r3;

    public String x() {
        return this.x;
    }

    public String n() {
        return this.n;
    }

    public String m() {
        return this.m;
    }

    public String c() {
        return this.c;
    }

    public String r1() {
        return this.r1;
    }

    public String r2() {
        return this.r2;
    }

    public String r3() {
        return this.r3;
    }

    public QueryGraphTest() {
        this.x = "x";
        this.n = "n";
        this.m = "m";
        this.c = "c";
        this.r1 = "r1";
        this.r2 = "r2";
        this.r3 = "r3";
        this.test("returns no pattern relationships when the query graph doesn't contain any", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set rels = Predef$.MODULE$.Set().empty();
                QueryGraph qg = new QueryGraph(rels, QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.x())).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds single pattern relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship r = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{r})), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.x())).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.n())).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{r}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.m())).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{r}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds multiple pattern relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship pattRel1 = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel2 = new PatternRelationship(this.$outer.r2(), new Tuple2((Object)this.$outer.m(), (Object)this.$outer.c()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2})), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.x())).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.n())).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.m())).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(qg.findRelationshipsEndingOn(this.$outer.c())).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from a single element with a single node in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set x$1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n()}));
                Set x$2 = QueryGraph$.MODULE$.apply$default$1();
                Set x$3 = QueryGraph$.MODULE$.apply$default$3();
                Selections x$4 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$5 = QueryGraph$.MODULE$.apply$default$5();
                Set x$6 = QueryGraph$.MODULE$.apply$default$6();
                Set x$7 = QueryGraph$.MODULE$.apply$default$7();
                IndexedSeq x$8 = QueryGraph$.MODULE$.apply$default$8();
                QueryGraph qg = new QueryGraph(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from a single element with a single relationship in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship r = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{r})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from two nodes with a single relationship in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship r = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{r})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.r1()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from two nodes with two relationships in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship pattRel1 = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel2 = new PatternRelationship(this.$outer.r2(), new Tuple2((Object)this.$outer.m(), (Object)this.$outer.c()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.r1()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from two nodes with two relationships between the same nodes in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship pattRel1 = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel2 = new PatternRelationship(this.$outer.r2(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                Set result = qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.contain().apply((Object)this.$outer.n()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.contain().apply((Object)this.$outer.m()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.contain()).oneOf((Object)this.$outer.r1(), (Object)this.$outer.r2(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]), Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("finds shortest path starting from two nodes with an intermediate relationship in the QG", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship pattRel1 = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel2 = new PatternRelationship(this.$outer.r2(), new Tuple2((Object)this.$outer.m(), (Object)this.$outer.c()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.c()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c(), this.$outer.r1(), this.$outer.r2()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("find smallest graph that connect three nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternRelationship pattRel1 = new PatternRelationship(this.$outer.r1(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.m()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel2 = new PatternRelationship(this.$outer.r2(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.c()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                PatternRelationship pattRel3 = new PatternRelationship(this.$outer.r3(), new Tuple2((Object)this.$outer.n(), (Object)this.$outer.x()), (SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Seq)Seq$.MODULE$.empty(), (PatternLength)SimplePatternLength$.MODULE$);
                QueryGraph qg = new QueryGraph((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pattRel1, pattRel2, pattRel3})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c(), this.$outer.x()})), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8());
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m(), this.$outer.c(), this.$outer.r1(), this.$outer.r2()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("querygraphs containing only nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryGraphTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set x$9 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()}));
                Set x$10 = QueryGraph$.MODULE$.apply$default$1();
                Set x$11 = QueryGraph$.MODULE$.apply$default$3();
                Selections x$12 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$13 = QueryGraph$.MODULE$.apply$default$5();
                Set x$14 = QueryGraph$.MODULE$.apply$default$6();
                Set x$15 = QueryGraph$.MODULE$.apply$default$7();
                IndexedSeq x$16 = QueryGraph$.MODULE$.apply$default$8();
                QueryGraph qg = new QueryGraph(x$10, x$9, x$11, x$12, x$13, x$14, x$15, x$16);
                this.$outer.convertToAnyShouldWrapper(qg.smallestGraphIncluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.n(), this.$outer.m()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

