/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner.logical;

import org.neo4j.cypher.internal.compiler.v3_3.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.BeLikeMatcher$;
import org.neo4j.cypher.internal.compiler.v3_3.planner.FakePlan;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningTestSupport2;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningTestSupport2$class;
import org.neo4j.cypher.internal.compiler.v3_3.planner.RealLogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.QueryPlanner;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.ASTRewriter;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.rewriting.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v3_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality$;
import org.neo4j.cypher.internal.ir.v3_3.Cost;
import org.neo4j.cypher.internal.ir.v3_3.Cost$;
import org.neo4j.cypher.internal.ir.v3_3.PeriodicCommit;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_3.QueryGraph;
import org.neo4j.cypher.internal.ir.v3_3.RegularPlannerQuery;
import org.neo4j.cypher.internal.v3_3.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.v3_3.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.v3_3.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_3.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.v3_3.logical.plans.Selection;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.BeMatcher;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001'\t93)\u0019:uKNL\u0017M\u001c)s_\u0012,8\r\u001e)mC:t\u0017N\\4J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tAA^\u001a`g)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!R\u0004\u0005\u0002\u001675\taC\u0003\u0002\u00181\u0005aA/Z:u?\",G\u000e]3sg*\u0011q!\u0007\u0006\u00035)\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00039Y\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001f?5\tA!\u0003\u0002!\t\tYBj\\4jG\u0006d\u0007\u000b\\1o]&tw\rV3tiN+\b\u000f]8siJBQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002")
public class CartesianProductPlanningIntegrationTest
extends CypherFunSuite
implements LogicalPlanningTestSupport2 {
    private final RegularPlannerQuery solved;
    private CypherParser parser;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private ASTRewriter astRewriter;
    private QueryPlanner planner;
    private QueryGraphSolver queryGraphSolver;
    private final RealLogicalPlanningConfiguration realConfig;
    private final CypherCompilerConfiguration cypherCompilerConfig;
    private final InputPosition pos;

    @Override
    public RegularPlannerQuery solved() {
        return this.solved;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    @TraitSetter
    public void parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    @TraitSetter
    public void astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public final QueryPlanner planner() {
        return this.planner;
    }

    @Override
    @TraitSetter
    public final void planner_$eq(QueryPlanner x$1) {
        this.planner = x$1;
    }

    @Override
    public QueryGraphSolver queryGraphSolver() {
        return this.queryGraphSolver;
    }

    @Override
    @TraitSetter
    public void queryGraphSolver_$eq(QueryGraphSolver x$1) {
        this.queryGraphSolver = x$1;
    }

    @Override
    public RealLogicalPlanningConfiguration realConfig() {
        return this.realConfig;
    }

    @Override
    public CypherCompilerConfiguration cypherCompilerConfig() {
        return this.cypherCompilerConfig;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$solved_$eq(RegularPlannerQuery x$1) {
        this.solved = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$realConfig_$eq(RealLogicalPlanningConfiguration x$1) {
        this.realConfig = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$cypherCompilerConfig_$eq(CypherCompilerConfiguration x$1) {
        this.cypherCompilerConfig = x$1;
    }

    @Override
    public RegularPlannerQuery solvedWithEstimation(Cardinality cardinality) {
        return LogicalPlanningTestSupport2$class.solvedWithEstimation(this, cardinality);
    }

    @Override
    public <C extends LogicalPlanningConfiguration> LogicalPlanningTestSupport2.LogicalPlanningEnvironment<C> LogicalPlanningEnvironment(C config) {
        return LogicalPlanningTestSupport2$class.LogicalPlanningEnvironment(this, config);
    }

    @Override
    public FakePlan fakeLogicalPlanFor(Seq<String> id) {
        return LogicalPlanningTestSupport2$class.fakeLogicalPlanFor(this, id);
    }

    @Override
    public Tuple3<Option<PeriodicCommit>, LogicalPlan, SemanticTable> planFor(String queryString) {
        return LogicalPlanningTestSupport2$class.planFor(this, queryString);
    }

    @Override
    public PropertyKeyId propertyKeyId(String label, SemanticTable semanticTable) {
        return LogicalPlanningTestSupport2$class.propertyKeyId(this, label, semanticTable);
    }

    @Override
    public <T extends LogicalPlan> BeMatcher<LogicalPlan> using(ClassTag<T> tag) {
        return LogicalPlanningTestSupport2$class.using(this, tag);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public CartesianProductPlanningIntegrationTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanningTestSupport2$class.$init$(this);
        this.test("should build plans for simple cartesian product", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.planFor("MATCH (n), (m) RETURN n, m")._2()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new AllNodesScan("n", Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (LogicalPlan)new AllNodesScan("m", Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (PlannerQuery)this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans so the cheaper plan is on the left", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.cost_$eq((PartialFunction<Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput>, Cost>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Object object = A1 != null && A1._1() instanceof Selection ? Cost$.MODULE$.lift(1000.0) : (A1 != null && A1._1() instanceof NodeByLabelScan ? Cost$.MODULE$.lift(20.0) : function1.apply(x1));
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput> x1) {
                                Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput> tuple2 = x1;
                                boolean bl = tuple2 != null && tuple2._1() instanceof Selection ? true : tuple2 != null && tuple2._1() instanceof NodeByLabelScan;
                                return bl;
                            }
                        });
                        this.cardinality_$eq(this.mapCardinality((PartialFunction<PlannerQuery, Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends PlannerQuery, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                RegularPlannerQuery regularPlannerQuery;
                                QueryGraph queryGraph;
                                A1 A1 = x2;
                                Object object = A1 instanceof RegularPlannerQuery && (queryGraph = (regularPlannerQuery = (RegularPlannerQuery)A1).queryGraph()).selections().predicates().size() == 1 ? BoxesRunTime.boxToDouble((double)10.0) : function1.apply(x2);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(PlannerQuery x2) {
                                RegularPlannerQuery regularPlannerQuery;
                                QueryGraph queryGraph;
                                PlannerQuery plannerQuery = x2;
                                boolean bl = plannerQuery instanceof RegularPlannerQuery && (queryGraph = (regularPlannerQuery = (RegularPlannerQuery)plannerQuery).queryGraph()).selections().predicates().size() == 1;
                                return bl;
                            }
                        }));
                    }
                }).getLogicalPlanFor("MATCH (n), (m) WHERE n.prop = 12 AND m:Label RETURN n, m")._2()).should((Matcher)BeLikeMatcher$.MODULE$.beLike((PartialFunction<Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        CartesianProduct cartesianProduct;
                        A1 A1 = x3;
                        Object object = A1 instanceof CartesianProduct && (cartesianProduct = (CartesianProduct)A1).left() instanceof Selection && cartesianProduct.right() instanceof NodeByLabelScan ? BoxedUnit.UNIT : function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Object x3) {
                        CartesianProduct cartesianProduct;
                        Object object = x3;
                        boolean bl = object instanceof CartesianProduct && (cartesianProduct = (CartesianProduct)object).left() instanceof Selection && cartesianProduct.right() instanceof NodeByLabelScan;
                        return bl;
                    }
                }));
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should combine three plans so the cost is minimized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<Option<PeriodicCommit>, LogicalPlan, SemanticTable> plan = this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.labelCardinality_$eq((Map<String, Cardinality>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)Cardinality$.MODULE$.lift(30.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)Cardinality$.MODULE$.lift(20.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)Cardinality$.MODULE$.lift(10.0))}))));
                    }
                }).getLogicalPlanFor("MATCH (a), (b), (c) WHERE a:A AND b:B AND c:C RETURN a, b, c");
                this.$outer.convertToAnyShouldWrapper(plan._2()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new NodeByLabelScan("a", this.$outer.lblName("A"), Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (LogicalPlan)new CartesianProduct((LogicalPlan)new NodeByLabelScan("c", this.$outer.lblName("C"), Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (LogicalPlan)new NodeByLabelScan("b", this.$outer.lblName("B"), Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (PlannerQuery)this.$outer.solved()), (PlannerQuery)this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should combine two plans so the cost is minimized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<Option<PeriodicCommit>, LogicalPlan, SemanticTable> plan = this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.labelCardinality_$eq((Map<String, Cardinality>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)Cardinality$.MODULE$.lift(30.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)Cardinality$.MODULE$.lift(20.0))}))));
                    }
                }).getLogicalPlanFor("MATCH (a), (b) WHERE a:A AND b:B RETURN a, b");
                this.$outer.convertToAnyShouldWrapper(plan._2()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new NodeByLabelScan("b", this.$outer.lblName("B"), Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (LogicalPlan)new NodeByLabelScan("a", this.$outer.lblName("A"), Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (PlannerQuery)this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v3_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

