/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.planner.logical;

import org.neo4j.cypher.internal.compiler.v3_3.CypherCompilerConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.FakePlan;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningTestSupport2;
import org.neo4j.cypher.internal.compiler.v3_3.planner.LogicalPlanningTestSupport2$class;
import org.neo4j.cypher.internal.compiler.v3_3.planner.RealLogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v3_3.planner.logical.QueryPlanner;
import org.neo4j.cypher.internal.frontend.v3_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.ast.BoundGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.GraphUrl;
import org.neo4j.cypher.internal.frontend.v3_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.LessThan;
import org.neo4j.cypher.internal.frontend.v3_3.ast.ListLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.MapExpression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_3.ast.SingleGraphAs;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.ASTRewriter;
import org.neo4j.cypher.internal.frontend.v3_3.helpers.rewriting.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v3_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.WindowsStringSafe$;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality;
import org.neo4j.cypher.internal.ir.v3_3.PeriodicCommit;
import org.neo4j.cypher.internal.ir.v3_3.PlannerQuery;
import org.neo4j.cypher.internal.ir.v3_3.RegularPlannerQuery;
import org.neo4j.cypher.internal.v3_3.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.v3_3.logical.plans.DoNotIncludeTies$;
import org.neo4j.cypher.internal.v3_3.logical.plans.Limit;
import org.neo4j.cypher.internal.v3_3.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_3.logical.plans.Projection;
import org.neo4j.cypher.internal.v3_3.logical.plans.Ties;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.BeMatcher;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001'\tYr+\u001b;i!2\fgN\\5oO&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\ba2\fgN\\3s\u0015\t9\u0001\"\u0001\u0003wg}\u001b$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001F\u000f\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0004\u001a\u0015\tQ\"\"\u0001\u0005ge>tG/\u001a8e\u0013\tabC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\u0005yyR\"\u0001\u0003\n\u0005\u0001\"!a\u0007'pO&\u001c\u0017\r\u001c)mC:t\u0017N\\4UKN$8+\u001e9q_J$(\u0007C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0005!9q\u0005\u0001b\u0001\n\u0007A\u0013aC<j]\u0012|wo]*bM\u0016,\u0012!\u000b\b\u0003+)J!a\u000b\f\u0002#]Kg\u000eZ8xgN#(/\u001b8h'\u00064W\r\u0003\u0004.\u0001\u0001\u0006I!K\u0001\ro&tGm\\<t'\u00064W\r\t")
public class WithPlanningIntegrationTest
extends CypherFunSuite
implements LogicalPlanningTestSupport2 {
    private final WindowsStringSafe$ windowsSafe;
    private final RegularPlannerQuery solved;
    private CypherParser parser;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private ASTRewriter astRewriter;
    private QueryPlanner planner;
    private QueryGraphSolver queryGraphSolver;
    private final RealLogicalPlanningConfiguration realConfig;
    private final CypherCompilerConfiguration cypherCompilerConfig;
    private final InputPosition pos;

    @Override
    public RegularPlannerQuery solved() {
        return this.solved;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    @TraitSetter
    public void parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    @TraitSetter
    public void astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public final QueryPlanner planner() {
        return this.planner;
    }

    @Override
    @TraitSetter
    public final void planner_$eq(QueryPlanner x$1) {
        this.planner = x$1;
    }

    @Override
    public QueryGraphSolver queryGraphSolver() {
        return this.queryGraphSolver;
    }

    @Override
    @TraitSetter
    public void queryGraphSolver_$eq(QueryGraphSolver x$1) {
        this.queryGraphSolver = x$1;
    }

    @Override
    public RealLogicalPlanningConfiguration realConfig() {
        return this.realConfig;
    }

    @Override
    public CypherCompilerConfiguration cypherCompilerConfig() {
        return this.cypherCompilerConfig;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$solved_$eq(RegularPlannerQuery x$1) {
        this.solved = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$realConfig_$eq(RealLogicalPlanningConfiguration x$1) {
        this.realConfig = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v3_3$planner$LogicalPlanningTestSupport2$_setter_$cypherCompilerConfig_$eq(CypherCompilerConfiguration x$1) {
        this.cypherCompilerConfig = x$1;
    }

    @Override
    public RegularPlannerQuery solvedWithEstimation(Cardinality cardinality) {
        return LogicalPlanningTestSupport2$class.solvedWithEstimation(this, cardinality);
    }

    @Override
    public <C extends LogicalPlanningConfiguration> LogicalPlanningTestSupport2.LogicalPlanningEnvironment<C> LogicalPlanningEnvironment(C config) {
        return LogicalPlanningTestSupport2$class.LogicalPlanningEnvironment(this, config);
    }

    @Override
    public FakePlan fakeLogicalPlanFor(Seq<String> id) {
        return LogicalPlanningTestSupport2$class.fakeLogicalPlanFor(this, id);
    }

    @Override
    public Tuple3<Option<PeriodicCommit>, LogicalPlan, SemanticTable> planFor(String queryString) {
        return LogicalPlanningTestSupport2$class.planFor(this, queryString);
    }

    @Override
    public PropertyKeyId propertyKeyId(String label, SemanticTable semanticTable) {
        return LogicalPlanningTestSupport2$class.propertyKeyId(this, label, semanticTable);
    }

    @Override
    public <T extends LogicalPlan> BeMatcher<LogicalPlan> using(ClassTag<T> tag) {
        return LogicalPlanningTestSupport2$class.using(this, tag);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public LessThan propLessThan(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propLessThan((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public DecimalDoubleLiteral literalFloat(double floatValue) {
        return AstConstructionTestSupport.class.literalFloat((AstConstructionTestSupport)this, (double)floatValue);
    }

    public ListLiteral literalList(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.literalList((AstConstructionTestSupport)this, expressions);
    }

    public ListLiteral literalIntList(Seq<Object> intValues) {
        return AstConstructionTestSupport.class.literalIntList((AstConstructionTestSupport)this, intValues);
    }

    public ListLiteral literalFloatList(Seq<Object> floatValues) {
        return AstConstructionTestSupport.class.literalFloatList((AstConstructionTestSupport)this, floatValues);
    }

    public MapExpression literalIntMap(Seq<Tuple2<String, Object>> keyValues) {
        return AstConstructionTestSupport.class.literalIntMap((AstConstructionTestSupport)this, keyValues);
    }

    public ListLiteral listOf(Seq<Expression> expressions) {
        return AstConstructionTestSupport.class.listOf((AstConstructionTestSupport)this, expressions);
    }

    public Expression TRUE() {
        return AstConstructionTestSupport.class.TRUE((AstConstructionTestSupport)this);
    }

    public GraphUrl url(String addr) {
        return AstConstructionTestSupport.class.url((AstConstructionTestSupport)this, (String)addr);
    }

    public BoundGraphAs graph(String name) {
        return AstConstructionTestSupport.class.graph((AstConstructionTestSupport)this, (String)name);
    }

    public BoundGraphAs graphAs(String name, String alias) {
        return AstConstructionTestSupport.class.graphAs((AstConstructionTestSupport)this, (String)name, (String)alias);
    }

    public SingleGraphAs graphAt(String name, String address) {
        return AstConstructionTestSupport.class.graphAt((AstConstructionTestSupport)this, (String)name, (String)address);
    }

    public WindowsStringSafe$ windowsSafe() {
        return this.windowsSafe;
    }

    public WithPlanningIntegrationTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanningTestSupport2$class.$init$(this);
        this.windowsSafe = WindowsStringSafe$.MODULE$;
        this.test("should build plans for simple WITH that adds a constant to the rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = (LogicalPlan)this.$outer.planFor("MATCH (a) WITH a LIMIT 1 RETURN 1 as `b`")._2();
                Projection expected = new Projection((LogicalPlan)new Limit((LogicalPlan)new AllNodesScan("a", Predef$.MODULE$.Set().empty(), (PlannerQuery)this.$outer.solved()), (Expression)new SignedDecimalIntegerLiteral("1", this.$outer.pos()), (Ties)DoNotIncludeTies$.MODULE$, (PlannerQuery)this.$outer.solved()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("1", position);
                    }
                }))})), (PlannerQuery)this.$outer.solved());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that contain multiple WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = (LogicalPlan)this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r1]->(b) WITH a, b, r1 LIMIT 1 RETURN b as `b`")._2();
                this.$outer.convertToStringShouldWrapper(result.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |  LHS -> Expand(a, OUTGOING, List(), b, r1, ExpandAll) {\n        |    LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans with WITH and selections", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = (LogicalPlan)this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r1]->(b) WHERE r1.prop = 42 RETURN r1")._2();
                this.$outer.convertToStringShouldWrapper(result.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Selection(MutableList(In(Property(Variable(r1),PropertyKeyName(prop)),ListLiteral(List(SignedDecimalIntegerLiteral(42)))))) {\n        |  LHS -> Expand(a, OUTGOING, List(), b, r1, ExpandAll) {\n        |    LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans for two matches separated by WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = (LogicalPlan)this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r]->(b) RETURN b")._2();
                this.$outer.convertToStringShouldWrapper(result.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> AllNodesScan(a, Set()) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r]->(b) WITH r LIMIT 1 MATCH (u)-[r]->(v) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, u, false, v, false, None, true, SimplePatternLength) {\n        |    LHS -> Argument(Set(r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project endpoints of re-matched reversed directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r]->(b) WITH r AS r, a AS a LIMIT 1 MATCH (b2)<-[r]-(a) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, a, true, b2, false, None, true, SimplePatternLength) {\n        |    LHS -> Argument(Set(a, r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that verify endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r]->(b) WITH * LIMIT 1 MATCH (a)-[r]->(b) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, a, true, b, true, None, true, SimplePatternLength) {\n        |    LHS -> Argument(Set(a, b, r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r]->(b2) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, a, true, b2, false, None, true, SimplePatternLength) {\n        |    LHS -> Argument(Set(a, r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched undirected relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r]-(b2) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> Expand(a, OUTGOING, List(), b, r, ExpandAll) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, a, true, b2, false, None, false, SimplePatternLength) {\n        |    LHS -> Argument(Set(a, r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched directed var length relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = (LogicalPlan)this.$outer.planFor("MATCH (a)-[r*]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r*]->(b2) RETURN r")._2();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("Apply() {\n        |  LHS -> Limit(SignedDecimalIntegerLiteral(1), DoNotIncludeTies) {\n        |    LHS -> VarExpand(a, OUTGOING, OUTGOING, List(), b, r, VarPatternLength(1,None), ExpandAll, r_NODES, r_RELS, True(), True(), Vector()) {\n        |      LHS -> AllNodesScan(a, Set()) {}\n        |    }\n        |  }\n        |  RHS -> ProjectEndpoints(r, a, true, b2, false, None, true, VarPatternLength(1,None)) {\n        |    LHS -> Argument(Set(a, r)) {}\n        |  }\n        |}")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

