/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.prettifier;

import org.neo4j.cypher.internal.compiler.v3_3.prettifier.Prettifier$;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001#\tq\u0001K]3ui&4\u0017.\u001a:UKN$(BA\u0002\u0005\u0003)\u0001(/\u001a;uS\u001aLWM\u001d\u0006\u0003\u000b\u0019\tAA^\u001a`g)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u0015\t\u0003\u0001\"\u0003#\u0003\u0019\t7\r^;bYR\u00111e\u000b\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\")A\u0006\ta\u0001[\u0005!A/\u001a=u!\tqCG\u0004\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003UUR!a\r\u0019\t\u000b]\u0002A\u0011\u0002\u001d\u0002\u0011\u0015D\b/Z2uK\u0012$\"aI\u001d\t\u000b12\u0004\u0019A\u0017")
public class PrettifierTest
extends CypherFunSuite {
    public String org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual(String text) {
        return Prettifier$.MODULE$.apply(text);
    }

    public String org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected(String text) {
        return String.format(text, new Object[0]);
    }

    public PrettifierTest() {
        this.test("should upcase keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("create n")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("CREATE n")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break INDEX ON", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("create index on :Person(name)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("CREATE INDEX ON :Person(name)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break on ASC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("order by n.name asc")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("ORDER BY n.name ASC")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE in FOREACH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match p=n foreach(x in p | create x--())")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH p=n%nFOREACH (x IN p | CREATE x--())")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE in complex FOREACH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match p=n foreach(x in p | create x--() set x.foo = 'bar') return distinct p;")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH p=n%nFOREACH (x IN p | CREATE x--()%nSET x.foo = 'bar')%nRETURN DISTINCT p;")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break STARTS WITH ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("return 'apartment' starts with 'apa' as x")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("RETURN 'apartment' STARTS WITH 'apa' AS x")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break ENDS WITH ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("return 'apartment' ends with 'apa' as x")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("RETURN 'apartment' ENDS WITH 'apa' AS x")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CONSTRAINT ON", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("create constraint on (person:Person) assert person.age is unique")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("CREATE CONSTRAINT ON (person:Person) ASSERT person.age IS UNIQUE")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should break ON CREATE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("merge n on create set n.age=32")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MERGE n%nON CREATE SET n.age=32")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should correctly handle parenthesis in MATCH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match (a)-->(b) return b")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (a)-->(b)%nRETURN b")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase multiple keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match (n) where n.name='B' return n")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (n)%nWHERE n.name='B'%nRETURN n")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase multiple keywords 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match (a) where a.name='A' return a.age as SomethingTotallyDifferent")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (a)%nWHERE a.name='A'%nRETURN a.age AS SomethingTotallyDifferent")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE UNIQUE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("start me=node(3) match p1 = me-[*2]-friendOfFriend create p2 = me-[:MARRIED_TO]-(wife { name: \"Gunhild\" }) create unique p3 = wife-[:KNOWS]-friendOfFriend return p1,p2,p3")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("START me=node(3)%nMATCH p1 = me-[*2]-friendOfFriend%nCREATE p2 = me-[:MARRIED_TO]-(wife { name: \"Gunhild\" })%nCREATE UNIQUE p3 = wife-[:KNOWS]-friendOfFriend%nRETURN p1,p2,p3")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break WHERE in comprehensions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("return [x in range(0,10) where x + 2 = 0 | x^3] as result")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("RETURN [x IN range(0,10) WHERE x + 2 = 0 | x^3] AS result")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase extra keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match david--otherPerson-->() where david.name='David' with otherPerson, count(*) as foaf where foaf > 1 return otherPerson")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH david--otherPerson-->()%nWHERE david.name='David'%nWITH otherPerson, count(*) AS foaf%nWHERE foaf > 1%nRETURN otherPerson")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break after OPTIONAL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("optional MATCH (n)-->(x) return n, x")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("OPTIONAL MATCH (n)-->(x)%nRETURN n, x")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("LOAD CSV FROM \"f\" AS line")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("LOAD CSV FROM \"f\" AS line")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV WITH HEADERS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("LOAD CSV wiTh HEADERS FROM \"f\" AS line")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("LOAD CSV WITH HEADERS FROM \"f\" AS line")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify and break LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("MATCH (n) LOAD CSV FROM \"f\" AS line return (n)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (n)%nLOAD CSV FROM \"f\" AS line%nRETURN (n)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break after DETACH in DETACH DELETE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("MATCH (n) DETACH DELETE (n)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (n)%nDETACH DELETE (n)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify and break USING PERIODIC COMMIT LOAD CSV", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("using periodic commit match () MATCH (n) LOAD CSV FROM \"f\" AS line return (n)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("USING PERIODIC COMMIT%nMATCH ()%nMATCH (n)%nLOAD CSV FROM \"f\" AS line%nRETURN (n)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify with correct string quotes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("mATCH a WhERE a.name='A' RETURN a.age > 30, \"I'm a literal\", a-->()")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH a%nWHERE a.name='A'%nRETURN a.age > 30, \"I'm a literal\", a-->()")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle join hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match (a:A)-->(b:B) USING join ON b return a.prop")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (a:A)-->(b:B)%nUSING JOIN ON b%nRETURN a.prop")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle CALL YIELD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("match (n) call db.indexes yield state RETURN *")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MATCH (n)%nCALL db.indexes YIELD state%nRETURN *")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MERGE should start on a new line", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("MERGE (a:A) MERGE (b:B) MERGE (a)-[:T]->(b) RETURN *")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("MERGE (a:A)%nMERGE (b:B)%nMERGE (a)-[:T]->(b)%nRETURN *")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND should start on a new line", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$actual("WITH [1,2,2] AS coll UNWIND coll AS x RETURN collect(x)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v3_3$prettifier$PrettifierTest$$expected("WITH [1,2,2] AS coll%nUNWIND coll AS x%nRETURN collect(x)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

