/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_3.test_helpers;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.neo4j.cypher.internal.compiler.v3_3.test_helpers.CreateTempFileTestSupport;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.io.fs.FileUtils;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.io.Codec$;
import scala.reflect.io.File;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CreateTempFileTestSupport$class {
    public static void stopTest(CypherFunSuite $this) {
        try {
            ((IterableLike)((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths().filter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Path x$1) {
                    return Files.exists(x$1, new LinkOption[0]);
                }
            })).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Path p) {
                    Object object;
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        object = BoxesRunTime.boxToBoolean((boolean)p.toFile().delete());
                    } else {
                        FileUtils.deletePathRecursively((Path)p);
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
            });
            return;
        }
        finally {
            ((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$super$stopTest();
        }
    }

    public static String createCSVTempFileURL(CypherFunSuite $this, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createCSVTempFileURL("cypher", null, (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
    }

    public static String createCSVTempFileURL(CypherFunSuite $this, String filename, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createCSVTempFileURL(filename, null, (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
    }

    public static String createCSVTempFileURL(CypherFunSuite $this, String filename, String dir, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createTempFileURL(filename, ".csv", (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
    }

    public static Function1 createCSVTempFileURL$default$2(CypherFunSuite $this, Function1 f) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherFunSuite $outer;

            public final PrintWriter apply(File file) {
                return ((CreateTempFileTestSupport)this.$outer).normalWriter(file);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static String createGzipCSVTempFileURL(CypherFunSuite $this, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createGzipCSVTempFileURL(((CreateTempFileTestSupport)$this).createGzipCSVTempFileURL$default$1(), ((CreateTempFileTestSupport)$this).createGzipCSVTempFileURL$default$2(), (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
    }

    public static String createGzipCSVTempFileURL(CypherFunSuite $this, String filename, String dir, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createTempFileURL(filename, ".csv.gz", (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherFunSuite $outer;

            public final PrintWriter apply(File file) {
                return ((CreateTempFileTestSupport)this.$outer).gzipWriter(file);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static String createGzipCSVTempFileURL$default$1(CypherFunSuite $this) {
        return "cypher";
    }

    public static String createGzipCSVTempFileURL$default$2(CypherFunSuite $this) {
        return null;
    }

    public static String createZipCSVTempFileURL(CypherFunSuite $this, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createZipCSVTempFileURL(((CreateTempFileTestSupport)$this).createZipCSVTempFileURL$default$1(), ((CreateTempFileTestSupport)$this).createZipCSVTempFileURL$default$2(), (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
    }

    public static String createZipCSVTempFileURL(CypherFunSuite $this, String filename, String dir, Function1 f, Function1 writer) {
        return ((CreateTempFileTestSupport)$this).createTempFileURL(filename, ".csv.zip", (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherFunSuite $outer;

            public final PrintWriter apply(File file) {
                return ((CreateTempFileTestSupport)this.$outer).zipWriter(file);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static String createZipCSVTempFileURL$default$1(CypherFunSuite $this) {
        return "cypher";
    }

    public static String createZipCSVTempFileURL$default$2(CypherFunSuite $this) {
        return null;
    }

    public static String createTempFile(CypherFunSuite $this, String name, String ext, Function1 f, Function1 writer) {
        CypherFunSuite cypherFunSuite = $this;
        synchronized (cypherFunSuite) {
            String string = CreateTempFileTestSupport$class.withTempFileWriter((CypherFunSuite)((CreateTempFileTestSupport)$this), name, ext, f, writer).toAbsolute().path();
            return string;
        }
    }

    public static Path createTempDirectory(CypherFunSuite $this, String name) {
        CypherFunSuite cypherFunSuite = $this;
        synchronized (cypherFunSuite) {
            Path dir = Files.createTempDirectory(name, new FileAttribute[0]);
            ((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths_$eq((Seq<Path>)((Seq)((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths().$colon$plus((Object)dir, Seq$.MODULE$.canBuildFrom())));
            Path path = dir;
            return path;
        }
    }

    public static String createTempFileURL(CypherFunSuite $this, String name, String ext, Function1 f, Function1 writer) {
        CypherFunSuite cypherFunSuite = $this;
        synchronized (cypherFunSuite) {
            String string = CreateTempFileTestSupport$class.withTempFileWriter((CypherFunSuite)((CreateTempFileTestSupport)$this), name, ext, f, writer).toURI().toURL().toString();
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File withTempFileWriter(CypherFunSuite $this, String name, String ext, Function1 f, Function1 writer) {
        Path path = Files.createTempFile(name, ext, new FileAttribute[0]);
        File file = new File(path.toFile(), Codec$.MODULE$.fallbackSystemCodec());
        try {
            ((CreateTempFileTestSupport)$this).fileWrite(file, (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)writer);
            ((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths_$eq((Seq<Path>)((Seq)((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths().$colon$plus((Object)path, Seq$.MODULE$.canBuildFrom())));
        }
        catch (Throwable throwable) {
            void var5_5;
            ((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths_$eq((Seq<Path>)((Seq)((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths().$colon$plus((Object)var5_5, Seq$.MODULE$.canBuildFrom())));
            throw throwable;
        }
        return file;
    }

    public static Path pathWrite(CypherFunSuite $this, Path path, Function1 f) {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        ((CreateTempFileTestSupport)$this).fileWrite(new File(path.toFile(), Codec$.MODULE$.fallbackSystemCodec()), (Function1<PrintWriter, BoxedUnit>)f, (Function1<File, PrintWriter>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherFunSuite $outer;

            public final PrintWriter apply(File file) {
                return ((CreateTempFileTestSupport)this.$outer).normalWriter(file);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public static File fileWrite(CypherFunSuite $this, File file, Function1 f, Function1 writerFactory) {
        PrintWriter writer = (PrintWriter)writerFactory.apply((Object)file);
        try {
            f.apply((Object)writer);
            writer.close();
            return file;
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
    }

    public static PrintWriter normalWriter(CypherFunSuite $this, File file) {
        return new PrintWriter(file.bufferedWriter(false, Codec$.MODULE$.UTF8()));
    }

    public static PrintWriter gzipWriter(CypherFunSuite $this, File file) {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file.jfile(), false)), Codec$.MODULE$.UTF8().charSet()));
    }

    public static PrintWriter zipWriter(CypherFunSuite $this, File file) {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file.jfile()));
        ZipEntry ze = new ZipEntry(file.name());
        zos.putNextEntry(ze);
        return new PrintWriter(new OutputStreamWriter(zos));
    }

    public static void $init$(CypherFunSuite $this) {
        ((CreateTempFileTestSupport)$this).org$neo4j$cypher$internal$compiler$v3_3$test_helpers$CreateTempFileTestSupport$$paths_$eq((Seq<Path>)((Seq)Seq$.MODULE$.empty()));
    }
}

