/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011q\"Q4he\u0016<\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001Z8dO\u0016t'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111\u0003R8dk6,g\u000e^5oOR+7\u000f\u001e\"bg\u0016DQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001\"B\u000b\u0001\t\u00032\u0012\u0001E4sCBDG)Z:de&\u0004H/[8o+\u00059\u0002c\u0001\r C5\t\u0011D\u0003\u0002\u001b7\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039u\t!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001a\u0005\u0011a\u0015n\u001d;\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t11\u000b\u001e:j]\u001eDqA\u000b\u0001C\u0002\u0013\u00053&\u0001\u0006qe>\u0004XM\u001d;jKN,\u0012\u0001\f\t\u0005[E\"dG\u0004\u0002/_5\tQ$\u0003\u00021;\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\u00075\u000b\u0007O\u0003\u00021;A\u0011Q&N\u0005\u0003QM\u0002B!L\u00195oA\u0011a\u0006O\u0005\u0003su\u00111!\u00118z\u0011\u0019Y\u0004\u0001)A\u0005Y\u0005Y\u0001O]8qKJ$\u0018.Z:!\u0011\u0015i\u0004\u0001\"\u0015?\u0003A9W\r^$sCBDg/\u001b>TifdW-F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0005he\u0006\u0004\bN^5{\u0015\t!e!A\u0007wSN,\u0018\r\\5{CRLwN\\\u0005\u0003\r\u0006\u0013!b\u0012:ba\"\u001cF/\u001f7f\u0011\u0015A\u0005\u0001\"\u0001J\u0003\u001d\u0019Xm\u0019;j_:,\u0012!\t\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u000bG>,h\u000e\u001e(pI\u0016\u001cH#A'\u0011\u00059r\u0015BA(\u001e\u0005\u0011)f.\u001b;)\u0005)\u000b\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\t\u0003\u0015QWO\\5u\u0013\t16K\u0001\u0003UKN$\b\"\u0002-\u0001\t\u0003a\u0015\u0001G2pk:$(+\u001a7bi&|gn\u001d5jaN\u0014\u0015\u0010V=qK\"\u0012q+\u0015\u0005\u00067\u0002!\t\u0001T\u0001\u000eG>,h\u000e^#oi&$\u0018.Z:)\u0005i\u000b\u0006\"\u00020\u0001\t\u0003a\u0015AE2pk:$hj\u001c8Ok2dg+\u00197vKND#!X)\t\u000b\u0005\u0004A\u0011\u0001'\u0002\u0017M,X\u000e\u0015:pa\u0016\u0014H/\u001f\u0015\u0003AFCQ\u0001\u001a\u0001\u0005\u00021\u000b1!\u0019<hQ\t\u0019\u0017\u000bC\u0003h\u0001\u0011\u0005A*A\u0002nS:D#AZ)\t\u000b)\u0004A\u0011\u0001'\u0002\u00075\f\u0007\u0010\u000b\u0002j#\")Q\u000e\u0001C\u0001\u0019\u000691m\u001c7mK\u000e$\bF\u00017R\u0011\u0015\u0001\b\u0001\"\u0001M\u00039\u0019w.\u001e8u?\u0012L7\u000f^5oGRD#a\\)\t\u000bM\u0004A\u0011\u0001'\u0002\u000b%tGO]8)\u0005I\f\u0006\"\u0002<\u0001\t\u0003a\u0015A\u00049fe\u000e,g\u000e^5mK\u0012K7o\u0019\u0015\u0003kFCQ!\u001f\u0001\u0005\u00021\u000ba\u0002]3sG\u0016tG/\u001b7f\u0007>tG\u000f\u000b\u0002y#\")A\u0010\u0001C\u0001\u0019\u0006)1\u000f\u001e3fm\"\u001210\u0015\u0005\u0006\u007f\u0002!\t\u0001T\u0001\u0007gR$WM\u001e9)\u0005y\f\u0006")
public class AggregationTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"property"), (Object)BoxesRunTime.boxToInteger((int)13))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"B"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"property"), (Object)BoxesRunTime.boxToInteger((int)33)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"blue")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"C"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"property"), (Object)BoxesRunTime.boxToInteger((int)44)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"blue")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"D"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"brown")})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A:Person KNOWS B:Person", "A KNOWS C:Person", "A KNOWS D:Person"}));
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "Aggregation";
    }

    @Test
    public void countNodes() {
        this.testQuery("Count nodes", "To count the number of nodes, for example the number of nodes connected to one node, you can use `count(*)`.", "match (n {name: 'A'})-->(x) return n, count(*)", "This returns the start node and the count of related nodes.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("A")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(*)"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)p.toList().head());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void countRelationshipsByType() {
        this.testQuery("Group Count Relationship Types", "To count the groups of relationship types, return the types and count them with `count(*)`.", "match (n {name: 'A'})-[r]->() return type(r), count(*)", "The relationship types and their group count is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"type(r)"), (Object)"KNOWS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(*)"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void countEntities() {
        this.testQuery("Count entities", "Instead of counting the number of results with `count(*)`, it might be more expressive to include the name of the identifier you care about.", "match (n {name: 'A'})-->(x) return count(x)", "The example query returns the number of connected nodes from the start node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(x)"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void countNonNullValues() {
        this.testQuery("Count non-null values", "You can count the non-`null` values by using +count(<identifier>)+.", "match (n:Person) return count(n.property)", "The count of related nodes with the `property` property set is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(n.property)"), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void sumProperty() {
        this.testQuery("sum", "The +sum+ aggregation function simply sums all the numeric values it encounters. ++NULL++s are silently dropped.", "match (n:Person) return sum(n.property)", "This returns the sum of all the values in the property `property`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sum(n.property)"), (Object)BoxesRunTime.boxToInteger((int)90))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void avg() {
        this.testQuery("avg", "+avg+ calculates the average of a numeric column.", "match (n:Person) return avg(n.property)", "The average of all the values in the property `property` is returned by the example query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"avg(n.property)"), (Object)BoxesRunTime.boxToInteger((int)30))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void min() {
        this.testQuery("min", "+min+ takes a numeric property as input, and returns the smallest value in that column.", "match (n:Person) return min(n.property)", "This returns the smallest of all the values in the property `property`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"min(n.property)"), (Object)BoxesRunTime.boxToInteger((int)13))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void max() {
        this.testQuery("max", "+max+ find the largest value in a numeric column.", "match (n:Person) return max(n.property)", "The largest of all the values in the property `property` is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"max(n.property)"), (Object)BoxesRunTime.boxToInteger((int)44))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void collect() {
        this.testQuery("collect", "+collect+ collects all the values into a list. It will ignore ++NULL++s.", "match (n:Person) return collect(n.property)", "Returns a single row, with all the values collected.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collect(n.property)"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{13, 33, 44})))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void count_distinct() {
        this.testQuery("DISTINCT", "All aggregation functions also take the +DISTINCT+ modifier, which removes duplicates from the values.\nSo, to count the number of unique eye colors from nodes related to `a`, this query can be used: ", "match (a:Person {name: 'A'})-->(b) return count(distinct b.eyes)", "Returns the number of eye colors.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(distinct b.eyes)"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void intro() {
        String x$1 = "Introduction";
        String x$2 = "To calculate aggregated data, Cypher offers aggregation, much like SQL's +GROUP BY+.\n\nAggregate functions take multiple input values and calculate an aggregated value from them.\nExamples are +avg+ that calculates the average of multiple numeric values, or +min+ that finds the smallest numeric value in a set of values.\n\nAggregation can be done over all the matching sub graphs, or it can be further divided by introducing key values.\nThese are non-aggregate expressions, that are used to group the values going into the aggregate functions.\n\nSo, if the return statement looks something like this:\n\n[source,cypher]\n----\nRETURN n, count(*)\n----\n\nWe have two return expressions -- `n`, and `count(*)`.\nThe first, `n`, is no aggregate function, and so it will be the grouping key.\nThe latter, `count(*)` is an aggregate expression.\nSo the matching subgraphs will be divided into different buckets, depending on the grouping key.\nThe aggregate function will then run on these buckets, calculating the aggregate values.\n\nIf you want to use aggregations to sort your result set, the aggregation must be included in the +RETURN+ to be used in your +ORDER BY+.\n\nThe last piece of the puzzle is the +DISTINCT+ keyword.\nIt is used to make all values unique before running them through an aggregate function.\n\nAn example might be helpful.\nIn this case, we are running the query against the following data:\n\ninclude::includes/aggregation-introduction.preparation-graph.asciidoc[]\n\n";
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executePreparationQueries((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nMATCH (b:Person {name: 'B'}), (c:Person {name: 'C'})\nCREATE (d:Person {name: 'D'}), (b)-[:KNOWS]->(d), (c)-[:KNOWS]->(d) \n"})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$4 = "MATCH (me:Person)-->(friend:Person)-->(friend_of_friend:Person) WHERE me.name = 'A'RETURN count(distinct friend_of_friend), count(friend_of_friend)";
        String x$5 = "\nIn this example we are trying to find all our friends of friends, and count them.\nThe first aggregate function, +count(DISTINCT friend_of_friend)+, will only see a `friend_of_friend` once -- +DISTINCT+ removes the duplicates.\nThe latter aggregate function, +count(friend_of_friend)+, might very well see the same `friend_of_friend` multiple times.\nIn this case, both +B+ and +C+ know +D+ and thus +D+ will get counted twice, when not using ++DISTINCT++.\n";
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(distinct friend_of_friend)"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(friend_of_friend)"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Object)p.toList().head());
            }
        }}));
        this.prepareAndTestQuery(x$1, x$2, x$4, x$5, (Function0<Object>)x$3, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$6);
    }

    @Test
    public void percentileDisc() {
        this.testQuery("percentileDisc", "\n+percentileDisc+ calculates the percentile of a given value over a group, with a percentile from 0.0 to 1.0.\nIt uses a rounding method, returning the nearest value to the percentile.\nFor interpolated values, see ++percentileCont++.", "match (n:Person) return percentileDisc(n.property, 0.5)", "The 50th percentile of the values in the property `property` is returned by the example query. In this case, 0.5 is the median, or 50th percentile.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"percentileDisc(n.property, 0.5)"), (Object)BoxesRunTime.boxToInteger((int)33))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void percentileCont() {
        this.testQuery("percentileCont", "\n+percentileCont+ calculates the percentile of a given value over a group, with a percentile from 0.0 to 1.0.\nIt uses a linear interpolation method, calculating a weighted average between two values, if the desired percentile lies between them.\nFor nearest values using a rounding method, see ++percentileDisc++.", "match (n:Person) return percentileCont(n.property, 0.4)", "The 40th percentile of the values in the property `property` is returned by the example query, calculated with a weighted average.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"percentileCont(n.property, 0.4)"), (Object)BoxesRunTime.boxToInteger((int)29))})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void stdev() {
        this.testQuery("stdev", "\n+stdev+ calculates the standard deviation for a given value over a group.\nIt uses a standard two-pass method, with `N - 1` as the denominator, and should be used when taking a sample of the population for an unbiased estimate.\nWhen the standard variation of the entire population is being calculated, +stdevp+ should be used.", "match (n) where n.name IN ['A','B','C'] return stdev(n.property)", "The standard deviation of the values in the property `property` is returned by the example query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)15.7162336455, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"stdev(n.property)")), (double)1.0E-7);
            }
        }}));
    }

    @Test
    public void stdevp() {
        this.testQuery("stdevp", "\n+stdevp+ calculates the standard deviation for a given value over a group.\nIt uses a standard two-pass method, with `N` as the denominator, and should be used when calculating the standard deviation for an entire population.\nWhen the standard variation of only a sample of the population is being calculated, +stdev+ should be used.", "match (n) where n.name IN ['A','B','C'] return stdevp(n.property)", "The population standard deviation of the values in the property `property` is returned by the example query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)12.8322510366, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"stdevp(n.property)")), (double)1.0E-7);
            }
        }}));
    }
}

