/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Test;
import org.neo4j.cypher.CypherExecutionException;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u0017\ty1i\u001c8tiJ\f\u0017N\u001c;t)\u0016\u001cHO\u0003\u0002\u0004\t\u00051Am\\2hK:T!!\u0002\u0004\u0002\r\rL\b\u000f[3s\u0015\t9\u0001\"A\u0003oK>$$NC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t\u0019Bi\\2v[\u0016tG/\u001b8h)\u0016\u001cHOQ1tK\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005\u0002Y\tqa]3di&|g.F\u0001\u0018!\tAbD\u0004\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u001b\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003a\u0019'/Z1uK~+h.[9vK~\u001bwN\\:ue\u0006Lg\u000e\u001e\u000b\u0002IA\u0011\u0011$J\u0005\u0003Mi\u0011A!\u00168ji\"\u0012\u0011\u0005\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W!\tQA[;oSRL!!\f\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006_\u0001!\taI\u0001\u0017IJ|\u0007oX;oSF,XmX2p]N$(/Y5oi\"\u0012a\u0006\u000b\u0005\u0006e\u0001!\taI\u0001\u001aa2\f\u0017p\u00188jG\u0016|v/\u001b;i?\u000e|gn\u001d;sC&tG\u000f\u000b\u00022Q!)Q\u0007\u0001C\u0001G\u0005\u0001\"M]3bW~\u001bwN\\:ue\u0006Lg\u000e\u001e\u0015\u0003i!BQ\u0001\u000f\u0001\u0005\ne\nA$Y:tKJ$8i\u001c8tiJ\f\u0017N\u001c;E_\u0016\u001chj\u001c;Fq&\u001cH\u000fF\u0002%uqBQaO\u001cA\u0002]\t\u0011\u0002\\1cK2t\u0015-\\3\t\u000bu:\u0004\u0019A\f\u0002\u0011A\u0014x\u000e\u001d(b[\u0016DQa\u0010\u0001\u0005\n\u0001\u000bQ#Y:tKJ$8i\u001c8tiJ\f\u0017N\u001c;Fq&\u001cH\u000fF\u0002%\u0003\nCQa\u000f A\u0002]AQ!\u0010 A\u0002]AQ\u0001\u0012\u0001\u0005\n\u0015\u000bQcZ3u\u0007>t7\u000f\u001e:bS:$\u0018\n^3sCR|'\u000fF\u0002G9v\u00032aR(S\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002L\u0015\u00051AH]8pizJ\u0011aG\u0005\u0003\u001dj\tq\u0001]1dW\u0006<W-\u0003\u0002Q#\nA\u0011\n^3sCR|'O\u0003\u0002O5A\u00111KW\u0007\u0002)*\u0011QKV\u0001\fG>t7\u000f\u001e:bS:$8O\u0003\u0002X1\u0006\u0019\u0011\r]5\u000b\u0005e3\u0011AB6fe:,G.\u0003\u0002\\)\n!RK\\5rk\u0016tWm]:D_:\u001cHO]1j]RDQaO\"A\u0002]AQ!P\"A\u0002]\u0001")
public class ConstraintsTest
extends DocumentingTestBase {
    @Override
    public String section() {
        return "Constraints";
    }

    @Test
    public void create_unique_constraint() {
        this.testQuery("Create uniqueness constraint", "To create a constraint that makes sure that your database will never contain more than one node with a specific label and one property value, use the +IS+ +UNIQUE+ syntax.", "CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConstraintsTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.org$neo4j$cypher$docgen$ConstraintsTest$$assertConstraintExist("Book", "isbn");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void drop_unique_constraint() {
        this.generateConsole_$eq(false);
        this.engine().execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        this.testQuery("Drop uniqueness constraint", "By using +DROP+ +CONSTRAINT+, you remove a constraint from the database.", "DROP CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConstraintsTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.org$neo4j$cypher$docgen$ConstraintsTest$$assertConstraintDoesNotExist("Book", "isbn");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void play_nice_with_constraint() {
        this.generateConsole_$eq(false);
        this.engine().execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        this.testQuery("Create a node that complies with constraints", "Create a `Book` node with an `isbn` that isn't already in the database.", "CREATE (book:Book {isbn: '1449356265', title: 'Graph Databases'})", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConstraintsTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.org$neo4j$cypher$docgen$ConstraintsTest$$assertConstraintExist("Book", "isbn");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void break_constraint() {
        this.generateConsole_$eq(false);
        this.engine().execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        this.engine().execute("CREATE (book:Book {isbn: '1449356265', title: 'Graph Databases'})");
        this.testFailingQuery("Create a node that breaks a constraint", "Create a `Book` node with an `isbn` that is already used in the database.", "CREATE (book:Book {isbn: '1449356265', title: 'Graph Databases'})", "", ClassTag$.MODULE$.apply(CypherExecutionException.class));
    }

    public void org$neo4j$cypher$docgen$ConstraintsTest$$assertConstraintDoesNotExist(String labelName, String propName) {
        this.assertionsHelper().macroAssert(this.getConstraintIterator(labelName, propName).isEmpty(), (Option)new Some((Object)"Expected constraint iterator to be empty"));
    }

    public void org$neo4j$cypher$docgen$ConstraintsTest$$assertConstraintExist(String labelName, String propName) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.getConstraintIterator(labelName, propName).size()));
        int $org_scalatest_assert_macro_right = 1;
        boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
        this.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
    }

    private Iterator<UniquenessConstraint> getConstraintIterator(String labelName, String propName) {
        Statement statement = this.RichGraph(this.db()).statement();
        int prop = statement.readOperations().propertyKeyGetForName(propName);
        int label = statement.readOperations().labelGetForName(labelName);
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(statement.readOperations().constraintsGetForLabelAndPropertyKey(label, prop)).asScala();
    }
}

