/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u0017\tQ1I]3bi\u0016$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0003\u0013\ty!AA\nE_\u000e,X.\u001a8uS:<G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\tQ\u0012+^3ssN#\u0018\r^5ti&\u001c7\u000fV3tiN+\b\u000f]8si\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u0003\u001b\u0001AQ!\u0007\u0001\u0005\u0002i\tqa]3di&|g.F\u0001\u001c!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003mC:<'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011aa\u0015;sS:<\u0007\"\u0002\u0013\u0001\t\u0003)\u0013AE2sK\u0006$XmX:j]\u001edWm\u00188pI\u0016$\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005+:LG\u000f\u000b\u0002$[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007C\u0001\u0006UVt\u0017\u000e^\u0005\u0003e=\u0012A\u0001V3ti\")A\u0007\u0001C\u0001K\u0005i2M]3bi\u0016|6/\u001b8hY\u0016|fn\u001c3f?^LG\u000f[0mC\n,G\u000e\u000b\u00024[!)q\u0007\u0001C\u0001K\u0005q2M]3bi\u0016|6/\u001b8hY\u0016|fn\u001c3f?^LG\u000f[0mC\n,Gn\u001d\u0015\u0003m5BQA\u000f\u0001\u0005\u0002\u0015\nQf\u0019:fCR,wl]5oO2,wL\\8eK~;\u0018\u000e\u001e5`Y\u0006\u0014W\r\\:`C:$w\f\u001d:pa\u0016\u0014H/[3tQ\tIT\u0006C\u0003>\u0001\u0011\u0005Q%\u0001\u0011de\u0016\fG/Z0tS:<G.Z0o_\u0012,w,\u00198e?J,G/\u001e:o?&$\bF\u0001\u001f.\u0011\u0015\u0001\u0005\u0001\"\u0001B\u00039\u0019'/Z1uKR;xNT8eKN,\u0012A\u0011\t\u0005O\r+U)\u0003\u0002EQ\t1A+\u001e9mKJ\u0002\"a\n$\n\u0005\u001dC#\u0001\u0002'p]\u001eDQ!\u0013\u0001\u0005\u0002\u0015\nQeY8o]\u0016\u001cGo\u0018;x_~sw\u000eZ3t?^LG\u000f[0b?J,G.\u0019;j_:\u001c\b.\u001b9)\u0005!k\u0003\"\u0002'\u0001\t\u0003)\u0013\u0001H:fi~\u0003(o\u001c9feRLx\f^8`C~\u001bw\u000e\u001c7fGRLwN\u001c\u0015\u0003\u00176BQa\u0014\u0001\u0005\u0002\u0015\n!d\u0019:fCR,wLZ;mY~\u0003\u0018\r\u001e5`S:|vN\\3`O>D#AT\u0017\t\u000bI\u0003A\u0011A\u0013\u0002G\r\u0014X-\u0019;f?J,G.\u0019;j_:\u001c\b.\u001b9`o&$\bn\u00189s_B,'\u000f^5fg\"\u0012\u0011+\f\u0005\u0006+\u0002!\t!J\u0001\u001cGJ,\u0017\r^3`g&tw\r\\3`]>$Wm\u00184s_6|V.\u00199)\u0005Qk\u0003\"\u0002-\u0001\t\u0003)\u0013aH2sK\u0006$XmX7vYRL\u0007\u000f\\3`]>$Wm]0ge>lw,\\1qg\"\u0012q+\f")
public class CreateTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public String section() {
        return "Create";
    }

    @Test
    public void create_single_node() {
        this.testQuery("Create single node", "Creating a single node is done by issuing the following query.", "create (n)", "Nothing is returned from this query, except the count of affected nodes.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
            }
        }}));
    }

    @Test
    public void create_single_node_with_label() {
        this.testQuery("Create a node with a label", "To add a label when creating a node, use the syntax below.", "create (n:Person)", "Nothing is returned from this query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$1 = p;
                int x$2 = 1;
                int x$3 = 1;
                int x$4 = this.$outer.assertStats$default$3();
                int x$5 = this.$outer.assertStats$default$4();
                int x$6 = this.$outer.assertStats$default$5();
                int x$7 = this.$outer.assertStats$default$6();
                int x$8 = this.$outer.assertStats$default$8();
                int x$9 = this.$outer.assertStats$default$9();
                int x$10 = this.$outer.assertStats$default$10();
                int x$11 = this.$outer.assertStats$default$11();
                int x$12 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$1, x$2, x$4, x$5, x$6, x$7, x$3, x$8, x$9, x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_single_node_with_labels() {
        this.testQuery("Create a node with multiple labels", "To add labels when creating a node, use the syntax below. In this case, we add two labels.", "create (n:Person:Swedish)", "Nothing is returned from this query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$13 = p;
                int x$14 = 1;
                int x$15 = 2;
                int x$16 = this.$outer.assertStats$default$3();
                int x$17 = this.$outer.assertStats$default$4();
                int x$18 = this.$outer.assertStats$default$5();
                int x$19 = this.$outer.assertStats$default$6();
                int x$20 = this.$outer.assertStats$default$8();
                int x$21 = this.$outer.assertStats$default$9();
                int x$22 = this.$outer.assertStats$default$10();
                int x$23 = this.$outer.assertStats$default$11();
                int x$24 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$13, x$14, x$16, x$17, x$18, x$19, x$15, x$20, x$21, x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_single_node_with_labels_and_properties() {
        this.testQuery("Create node and add labels and properties", "When creating a new node with labels, you can add properties at the same time.", "create (n:Person {name : 'Andres', title : 'Developer'})", "Nothing is returned from this query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$25 = p;
                int x$26 = 1;
                int x$27 = 2;
                int x$28 = 1;
                int x$29 = this.$outer.assertStats$default$3();
                int x$30 = this.$outer.assertStats$default$5();
                int x$31 = this.$outer.assertStats$default$6();
                int x$32 = this.$outer.assertStats$default$8();
                int x$33 = this.$outer.assertStats$default$9();
                int x$34 = this.$outer.assertStats$default$10();
                int x$35 = this.$outer.assertStats$default$11();
                int x$36 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$25, x$26, x$29, x$27, x$30, x$31, x$28, x$32, x$33, x$34, x$35, x$36);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_single_node_and_return_it() {
        this.testQuery("Return created node", "Creating a single node is done by issuing the following query.", "create (a {name : 'Andres'}) return a", "The newly created node is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)p.size()));
                int $org_scalatest_assert_macro_right = 1;
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    public Tuple2<Object, Object> createTwoNodes() {
        return (Tuple2)this.RichGraph(this.db()).inTx((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final Tuple2<Object, Object> apply() {
                Node a = this.$outer.db().createNode(new Label[]{DynamicLabel.label((String)"Person")});
                Node b = this.$outer.db().createNode(new Label[]{DynamicLabel.label((String)"Person")});
                a.setProperty("name", (Object)"Node A");
                b.setProperty("name", (Object)"Node B");
                return new Tuple2.mcJJ.sp(a.getId(), b.getId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void connect_two_nodes_with_a_relationship() {
        this.createTwoNodes();
        this.testQuery("Create a relationship between two nodes", "To create a relationship between two nodes, we first get the two nodes. Once the nodes are loaded, we simply create a relationship between them.", "match (a:Person), (b:Person) where a.name = 'Node A' and b.name = 'Node B' create (a)-[r:RELTYPE]->(b) return r", "The created relationship is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)p.size()));
                int $org_scalatest_assert_macro_right = 1;
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_property_to_a_collection() {
        this.RichGraph(this.db()).inTx((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node a = this.$outer.db().createNode();
                Node b = this.$outer.db().createNode();
                a.setProperty("name", (Object)"Andres");
                b.setProperty("name", (Object)"Michael");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testQuery("Set a property to an array", "When you set a property to an expression that returns a collection of values,\nCypher will turn that into an array. All the elements in the collection must be of the same type\nfor this to work.", "match (n) where has(n.name) with collect(n.name) as names create (new { name : names }) return new", "A node with an array property named name is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                Node createdNode = (Node)((MapLike)p.toList().head()).apply((Object)"new");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(createdNode.getProperty("name"));
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"Andres", "Michael"});
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_full_path_in_one_go() {
        this.testQuery("Create a full path", "When you use `CREATE` and a pattern, all parts of the pattern that are not already in scope at this time\nwill be created. ", "create p = (andres {name:'Andres'})-[:WORKS_AT]->(neo)<-[:WORKS_AT]-(michael {name:'Michael'}) return p", "This query creates three nodes and two relationships in one go, assigns it to a path identifier, and returns it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.assertStats(p, 3, 2, 2, this.$outer.assertStats$default$5(), this.$outer.assertStats$default$6(), this.$outer.assertStats$default$7(), this.$outer.assertStats$default$8(), this.$outer.assertStats$default$9(), this.$outer.assertStats$default$10(), this.$outer.assertStats$default$11(), this.$outer.assertStats$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_relationship_with_properties() {
        this.createTwoNodes();
        this.testQuery("Create a relationship and set properties", "Setting properties on relationships is done in a similar manner to how it's done when creating nodes. Note that the values can be any expression.", "match (a:Person), (b:Person) where a.name = 'Node A' and b.name = 'Node B' create (a)-[r:RELTYPE {name : a.name + '<->' + b.name }]->(b) return r", "The newly created relationship is returned by the example query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                List result = p.toList();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.size()));
                int $org_scalatest_assert_macro_right = 1;
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
                Relationship r = (Relationship)((MapLike)result.head()).apply((Object)"r");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(r.getProperty("name"));
                String $org_scalatest_assert_macro_right2 = "Node A<->Node B";
                boolean $org_scalatest_assert_macro_result2 = $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_result2, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_single_node_from_map() {
        String x$49 = "Create node with a parameter for the properties";
        String x$50 = "\nYou can also create a graph entity from a map.\nAll the key/value pairs in the map will be set as properties on the created relationship or node.\nIn this case we add a +Person+ label to the node as well.\n";
        Serializable x$51 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"props"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Andres"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"position"), (Object)"Developer")})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$52 = "create (n:Person {props}) return n";
        String x$53 = "";
        Seq x$54 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$37 = p;
                int x$38 = 1;
                int x$39 = 2;
                int x$40 = 1;
                int x$41 = this.$outer.assertStats$default$3();
                int x$42 = this.$outer.assertStats$default$5();
                int x$43 = this.$outer.assertStats$default$6();
                int x$44 = this.$outer.assertStats$default$8();
                int x$45 = this.$outer.assertStats$default$9();
                int x$46 = this.$outer.assertStats$default$10();
                int x$47 = this.$outer.assertStats$default$11();
                int x$48 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$37, x$38, x$41, x$39, x$42, x$43, x$40, x$44, x$45, x$46, x$47, x$48);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$49, x$50, x$52, x$53, (Function0<Object>)x$51, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$54);
    }

    @Test
    public void create_multiple_nodes_from_maps() {
        String x$67 = "Create multiple nodes with a parameter for their properties";
        String x$68 = "\nBy providing Cypher an array of maps, it will create a node for each map.\n\nNOTE: When you do this, you can't create anything else in the same +CREATE+ clause.\n";
        Serializable x$69 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"props"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Andres"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"position"), (Object)"Developer")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Michael"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"position"), (Object)"Developer")}))})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$70 = "create (n {props}) return n";
        String x$71 = "";
        Seq x$72 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$55 = p;
                int x$56 = 2;
                int x$57 = 4;
                int x$58 = this.$outer.assertStats$default$3();
                int x$59 = this.$outer.assertStats$default$5();
                int x$60 = this.$outer.assertStats$default$6();
                int x$61 = this.$outer.assertStats$default$7();
                int x$62 = this.$outer.assertStats$default$8();
                int x$63 = this.$outer.assertStats$default$9();
                int x$64 = this.$outer.assertStats$default$10();
                int x$65 = this.$outer.assertStats$default$11();
                int x$66 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$55, x$56, x$58, x$57, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$67, x$68, x$70, x$71, (Function0<Object>)x$69, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$72);
    }

    public CreateTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
    }
}

