/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0017\t\u00012I]3bi\u0016,f.[9vKR+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001Z8dO\u0016t'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\t\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007CA\t\u0013\u001b\u0005!\u0011BA\n\u0005\u0005i\tV/\u001a:z'R\fG/[:uS\u000e\u001cH+Z:u'V\u0004\bo\u001c:u\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u000e\u0001!)\u0011\u0004\u0001C)5\u0005\u0001r-\u001a;He\u0006\u0004\bN^5{'RLH.Z\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\tOJ\f\u0007\u000f\u001b<ju*\u0011\u0001EB\u0001\u000em&\u001cX/\u00197ju\u0006$\u0018n\u001c8\n\u0005\tj\"AC$sCBD7\u000b^=mK\")A\u0005\u0001C!K\u0005\u0001rM]1qQ\u0012+7o\u0019:jaRLwN\\\u000b\u0002MA\u0019qE\f\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0013%lW.\u001e;bE2,'BA\u0016-\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\rM#(/\u001b8h\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u001d\u0019Xm\u0019;j_:,\u0012\u0001\r\u0005\u0006y\u0001!\t!P\u0001!GJ,\u0017\r^3`e\u0016d\u0017\r^5p]ND\u0017\u000e]0xQ\u0016tw,\\5tg&tw\rF\u0001?!\ty\u0004)D\u0001-\u0013\t\tEF\u0001\u0003V]&$\bFA\u001eD!\t!u)D\u0001F\u0015\t1\u0005\"A\u0003kk:LG/\u0003\u0002I\u000b\n!A+Z:u\u0011\u0015Q\u0005\u0001\"\u0001>\u0003q\u0019'/Z1uK~sw\u000eZ3`S\u001a|\u0016\u000e^0jg~k\u0017n]:j]\u001eD#!S\"\t\u000b5\u0003A\u0011A\u001f\u0002/\r\u0014X-\u0019;f?:|G-Z0xSRDwL^1mk\u0016\u001c\bF\u0001'D\u0011\u0015\u0001\u0006\u0001\"\u0001>\u0003}\u0019'/Z1uK~\u0013X\r\\1uS>t7\u000f[5q?^LG\u000f[0wC2,Xm\u001d\u0015\u0003\u001f\u000eCQa\u0015\u0001\u0005\u0002u\n\u0001dY8n[\u0006$wl]3qCJ\fG/\u001a3`a\u0006$H/\u001a:oQ\t\u00116\tC\u0003W\u0001\u0011\u0005Q(A\u0013de\u0016\fG/Z0mC\n,G.\u001a3`]>$WmX5g?2\f'-\u001a7t?6L7o]5oO\"\u0012Qk\u0011")
public class CreateUniqueTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"root X A", "root X B", "root X C", "A KNOWS C"}));
    }

    @Override
    public String section() {
        return "Create Unique";
    }

    @Test
    public void create_relationship_when_missing() {
        this.testQuery("Create relationship if it is missing", "+CREATE UNIQUE+ is used to describe the pattern that should be found or created.", "match (lft {name: 'A'}), (rgt) where rgt.name in ['B','C'] create unique (lft)-[r:KNOWS]->(rgt) return r", "The left node is matched agains the two right nodes. One relationship already exists and can be matched, and the other relationship is created before it is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$1 = p;
                int x$2 = 1;
                int x$3 = this.$outer.assertStats$default$2();
                int x$4 = this.$outer.assertStats$default$4();
                int x$5 = this.$outer.assertStats$default$5();
                int x$6 = this.$outer.assertStats$default$6();
                int x$7 = this.$outer.assertStats$default$7();
                int x$8 = this.$outer.assertStats$default$8();
                int x$9 = this.$outer.assertStats$default$9();
                int x$10 = this.$outer.assertStats$default$10();
                int x$11 = this.$outer.assertStats$default$11();
                int x$12 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_node_if_it_is_missing() {
        this.testQuery("Create node if missing", "If the pattern described needs a node, and it can't be matched, a new node will be created.", "match (root {name: 'root'}) create unique (root)-[:LOVES]-(someone) return someone", "The root node doesn't have any `LOVES` relationships, and so a node is created, and also a relationship to that node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$13 = p;
                int x$14 = 1;
                int x$15 = 1;
                int x$16 = this.$outer.assertStats$default$4();
                int x$17 = this.$outer.assertStats$default$5();
                int x$18 = this.$outer.assertStats$default$6();
                int x$19 = this.$outer.assertStats$default$7();
                int x$20 = this.$outer.assertStats$default$8();
                int x$21 = this.$outer.assertStats$default$9();
                int x$22 = this.$outer.assertStats$default$10();
                int x$23 = this.$outer.assertStats$default$11();
                int x$24 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$13, x$15, x$14, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_node_with_values() {
        this.testQuery("Create nodes with values", "The pattern described can also contain values on the node. These are given using the following syntax: `prop : <expression>`.", "match (root {name: 'root'}) create unique (root)-[:X]-(leaf {name:'D'} ) return leaf", "No node connected with the root node has the name +D+, and so a new node is created to match the pattern.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$25 = p;
                int x$26 = 1;
                int x$27 = 1;
                int x$28 = 1;
                int x$29 = this.$outer.assertStats$default$5();
                int x$30 = this.$outer.assertStats$default$6();
                int x$31 = this.$outer.assertStats$default$7();
                int x$32 = this.$outer.assertStats$default$8();
                int x$33 = this.$outer.assertStats$default$9();
                int x$34 = this.$outer.assertStats$default$10();
                int x$35 = this.$outer.assertStats$default$11();
                int x$36 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$25, x$27, x$26, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_relationship_with_values() {
        this.testQuery("Create relationship with values", "Relationships to be created can also be matched on values.", "match (root {name: 'root'}) create unique (root)-[r:X {since:'forever'}]-() return r", "In this example, we want the relationship to have a value, and since no such relationship can be found, a new node and relationship are created. Note that since we are not interested in the created node, we don't name it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$37 = p;
                int x$38 = 1;
                int x$39 = 1;
                int x$40 = 1;
                int x$41 = this.$outer.assertStats$default$5();
                int x$42 = this.$outer.assertStats$default$6();
                int x$43 = this.$outer.assertStats$default$7();
                int x$44 = this.$outer.assertStats$default$8();
                int x$45 = this.$outer.assertStats$default$9();
                int x$46 = this.$outer.assertStats$default$10();
                int x$47 = this.$outer.assertStats$default$11();
                int x$48 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$37, x$39, x$38, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void commad_separated_pattern() {
        this.testQuery("Describe complex pattern", "The pattern described by +CREATE UNIQUE+ can be separated by commas, just like in +MATCH+ and +CREATE+.", "match (root {name: 'root'}) create unique (root)-[:FOO]->(x), (root)-[:BAR]->(x) return x", "This example pattern uses two paths, separated by a comma.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$49 = p;
                int x$50 = 2;
                int x$51 = 1;
                int x$52 = this.$outer.assertStats$default$4();
                int x$53 = this.$outer.assertStats$default$5();
                int x$54 = this.$outer.assertStats$default$6();
                int x$55 = this.$outer.assertStats$default$7();
                int x$56 = this.$outer.assertStats$default$8();
                int x$57 = this.$outer.assertStats$default$9();
                int x$58 = this.$outer.assertStats$default$10();
                int x$59 = this.$outer.assertStats$default$11();
                int x$60 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$49, x$51, x$50, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void create_labeled_node_if_labels_missing() {
        this.testQuery("Create labeled node if missing", "If the pattern described needs a labeled node and there is none with the given labels, Cypher will create a new one.", "match (a {name: 'A'}) create unique (a)-[:KNOWS]-(c:blue) return c", "The A node is connected in a `KNOWS` relationship to the c node, but since C doesn't have the `:blue` label, a new node labeled as `:blue` is created along with a `KNOWS` relationship from A to it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateUniqueTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$61 = p;
                int x$62 = 1;
                int x$63 = 1;
                int x$64 = 1;
                int x$65 = this.$outer.assertStats$default$4();
                int x$66 = this.$outer.assertStats$default$5();
                int x$67 = this.$outer.assertStats$default$6();
                int x$68 = this.$outer.assertStats$default$8();
                int x$69 = this.$outer.assertStats$default$9();
                int x$70 = this.$outer.assertStats$default$10();
                int x$71 = this.$outer.assertStats$default$11();
                int x$72 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$61, x$63, x$62, x$65, x$66, x$67, x$64, x$68, x$69, x$70, x$71, x$72);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    public CreateUniqueTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
    }
}

