/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.neo4j.cypher.docgen.DocumentationHelper;
import org.neo4j.cypher.internal.compiler.v2_1.prettifier.Prettifier$;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.AsciiDocGenerator;
import org.neo4j.visualization.asciidoc.AsciidocHelper;
import org.neo4j.visualization.graphviz.AsciiDocStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.neo4j.visualization.graphviz.GraphvizWriter;
import org.neo4j.walk.Walker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DocumentationHelper$class {
    public static String nicefy(DocumentationHelper $this, String in) {
        return in.toLowerCase().replace(" ", "-");
    }

    public static String simpleName(DocumentationHelper $this) {
        return $this.getClass().getSimpleName().replaceAll("Test", "").toLowerCase();
    }

    public static File createDir(DocumentationHelper $this, String folder) {
        return $this.createDir($this.path(), folder);
    }

    /*
     * WARNING - void declaration
     */
    public static File createDir(DocumentationHelper $this, File where, String folder) {
        void var3_3;
        File dir = new File(where, $this.nicefy(folder));
        Object object = dir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)dir.mkdirs());
        return var3_3;
    }

    public static PrintWriter createWriter(DocumentationHelper $this, String title, File dir) {
        return new PrintWriter(new File(dir, new StringBuilder().append((Object)$this.nicefy(title)).append((Object)".asciidoc").toString()), "UTF-8");
    }

    public static String createCypherSnippet(DocumentationHelper $this, String query) {
        String prettifiedQuery = Prettifier$.MODULE$.apply(query.trim());
        return AsciidocHelper.createCypherSnippetFromPreformattedQuery((String)prettifiedQuery);
    }

    public static String prepareFormatting(DocumentationHelper $this, String query) {
        String str2 = Prettifier$.MODULE$.apply(query.trim());
        Object object = new StringOps(Predef$.MODULE$.augmentString(str2)).takeRight(1);
        String string = ";";
        return !(object != null ? !object.equals(string) : string != null) ? str2 : new StringBuilder().append((Object)str2).append((Object)";").toString();
    }

    public static void dumpSetupQueries(DocumentationHelper $this, List queries, File dir) {
        DocumentationHelper$class.dumpQueries($this, queries, dir, new StringBuilder().append((Object)$this.simpleName()).append((Object)"-setup").toString());
    }

    public static void dumpSetupConstraintsQueries(DocumentationHelper $this, List queries, File dir) {
        DocumentationHelper$class.dumpQueries($this, queries, dir, new StringBuilder().append((Object)$this.simpleName()).append((Object)"-setup-constraints").toString());
    }

    public static void dumpPreparationQueries(DocumentationHelper $this, List queries, File dir, String testid) {
        DocumentationHelper$class.dumpQueries($this, queries, dir, new StringBuilder().append((Object)$this.simpleName()).append((Object)"-").append((Object)$this.nicefy(testid)).append((Object)".preparation").toString());
    }

    private static String dumpQueries(DocumentationHelper $this, List queries, File dir, String testid) {
        String string;
        if (queries.isEmpty()) {
            string = "";
        } else {
            List queryStrings = (List)queries.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DocumentationHelper $outer;

                public final String apply(String query) {
                    return this.$outer.prepareFormatting(query);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, List$.MODULE$.canBuildFrom());
            String output = AsciidocHelper.createCypherSnippetFromPreformattedQuery((String)queryStrings.mkString("\n"));
            string = AsciiDocGenerator.dumpToSeparateFile((File)dir, (String)testid, (String)output);
        }
        return string;
    }

    public static String dumpGraphViz(DocumentationHelper $this, File dir, String graphVizOptions) {
        return DocumentationHelper$class.emitGraphviz($this, dir, $this.graphvizFileName(), graphVizOptions);
    }

    public static String dumpPreparationGraphviz(DocumentationHelper $this, File dir, String testid, String graphVizOptions) {
        return DocumentationHelper$class.emitGraphviz($this, dir, new StringBuilder().append((Object)$this.simpleName()).append((Object)"-").append((Object)$this.nicefy(testid)).append((Object)".preparation-graph").toString(), graphVizOptions);
    }

    private static String emitGraphviz(DocumentationHelper $this, File dir, String testid, String graphVizOptions) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GraphvizWriter writer = new GraphvizWriter($this.getGraphvizStyle());
        $this.RichGraph($this.db()).inTx((Function0)new Serializable($this, out, writer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentationHelper $outer;
            private final ByteArrayOutputStream out$1;
            private final GraphvizWriter writer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.writer$1.emit((OutputStream)this.out$1, Walker.fullGraph((GraphDatabaseService)this.$outer.db()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.writer$1 = writer$1;
            }
        });
        String graphOutput = new StringOps(Predef$.MODULE$.augmentString("[\"dot\", \"%s.svg\", \"neoviz\", \"%s\"]\n----\n%s\n----\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testid, graphVizOptions, out}));
        return new StringBuilder().append((Object)".Graph\n").append((Object)AsciiDocGenerator.dumpToSeparateFile((File)dir, (String)testid, (String)graphOutput)).toString();
    }

    public static GraphStyle getGraphvizStyle(DocumentationHelper $this) {
        return AsciiDocStyle.withAutomaticRelationshipTypeColors();
    }

    public static void $init$(DocumentationHelper $this) {
        $this.org$neo4j$cypher$docgen$DocumentationHelper$_setter_$path_$eq(new File("target/docs/dev/ql/"));
        $this.org$neo4j$cypher$docgen$DocumentationHelper$_setter_$graphvizFileName_$eq(new StringBuilder().append((Object)"cypher-").append((Object)$this.simpleName()).append((Object)"-graph").toString());
    }
}

