/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.scalatest.Assertions;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\u0001\u0003\u0001-\u0011QBR;oGRLwN\\:UKN$(BA\u0002\u0005\u0003\u0019!wnY4f]*\u0011QAB\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005\u001dA\u0011!\u00028f_RR'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005M!unY;nK:$\u0018N\\4UKN$()Y:f\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000e\u0001!)Q\u0003\u0001C!-\u0005\u0001rM]1qQ\u0012+7o\u0019:jaRLwN\\\u000b\u0002/A\u0019\u0001dH\u0011\u000e\u0003eQ!AG\u000e\u0002\u0013%lW.\u001e;bE2,'B\u0001\u000f\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\rM#(/\u001b8h\u0011\u001dQ\u0003A1A\u0005B-\n!\u0002\u001d:pa\u0016\u0014H/[3t+\u0005a\u0003\u0003\u0002\r.C=J!AL\r\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0019[\u0005\u0002\u0004CA\u00193\u001b\u0005i\u0012BA\u001a\u001e\u0005\r\te.\u001f\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0017A\u0014x\u000e]3si&,7\u000f\t\u0005\u0006o\u0001!\t\u0006O\u0001\u0011O\u0016$xI]1qQZL'p\u0015;zY\u0016,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n\u0001b\u001a:ba\"4\u0018N\u001f\u0006\u0003}\u0019\tQB^5tk\u0006d\u0017N_1uS>t\u0017B\u0001!<\u0005)9%/\u00199i'RLH.\u001a\u0005\u0006\u0005\u0002!\taQ\u0001\bg\u0016\u001cG/[8o+\u0005\t\u0003bB#\u0001\u0005\u0004%\tAR\u0001\u0011G>lWn\u001c8`CJ<W/\\3oiN,\u0012a\u0012\t\u00041}A\u0005\u0003B\u0019JC\u0005J!AS\u000f\u0003\rQ+\b\u000f\\33\u0011\u0019a\u0005\u0001)A\u0005\u000f\u0006\t2m\\7n_:|\u0016M]4v[\u0016tGo\u001d\u0011\t\u000b9\u0003A\u0011A(\u0002\u0007\u0005dG\u000eF\u0001Q!\t\t\u0014+\u0003\u0002S;\t!QK\\5uQ\tiE\u000b\u0005\u0002V16\taK\u0003\u0002X\u0011\u0005)!.\u001e8ji&\u0011\u0011L\u0016\u0002\u0005)\u0016\u001cH\u000fC\u0003\\\u0001\u0011\u0005q*A\u0002b]fD#A\u0017+\t\u000by\u0003A\u0011A(\u0002\t9|g.\u001a\u0015\u0003;RCQ!\u0019\u0001\u0005\u0002=\u000baa]5oO2,\u0007F\u00011U\u0011\u0015!\u0007\u0001\"\u0001P\u0003\u0019)\u00070[:ug\"\u00121\r\u0016\u0005\u0006O\u0002!\taT\u0001\u0012e\u0016d\u0017\r^5p]ND\u0017\u000e]0usB,\u0007F\u00014U\u0011\u0015Q\u0007\u0001\"\u0001P\u0003\u0019aWM\\4uQ\"\u0012\u0011\u000e\u0016\u0005\u0006[\u0002!\taT\u0001\u0007Y\u0006\u0014W\r\\:)\u00051$\u0006\"\u00029\u0001\t\u0003y\u0015aB3yiJ\f7\r\u001e\u0015\u0003_RCQa\u001d\u0001\u0005\u0002=\u000baA]3ek\u000e,\u0007F\u0001:U\u0011\u00151\b\u0001\"\u0001P\u0003\u0011AW-\u00193)\u0005U$\u0006\"B=\u0001\t\u0003y\u0015\u0001\u00027bgRD#\u0001\u001f+\t\u000bq\u0004A\u0011A(\u0002\tQ\f\u0017\u000e\u001c\u0015\u0003wRCQa \u0001\u0005\u0002=\u000baAZ5mi\u0016\u0014\bF\u0001@U\u0011\u0019\t)\u0001\u0001C\u0001\u001f\u0006ian\u001c3fg~Kgn\u00189bi\"D3!a\u0001U\u0011\u0019\tY\u0001\u0001C\u0001\u001f\u0006a!/\u001a7t?&tw\f]1uQ\"\u001a\u0011\u0011\u0002+\t\r\u0005E\u0001\u0001\"\u0001P\u0003\tIG\rK\u0002\u0002\u0010QCa!a\u0006\u0001\t\u0003y\u0015\u0001C2pC2,7oY3)\u0007\u0005UA\u000b\u0003\u0004\u0002\u001e\u0001!\taT\u0001\u0004C\n\u001c\bfAA\u000e)\"1\u00111\u0005\u0001\u0005\u0002=\u000bA!Y2pg\"\u001a\u0011\u0011\u0005+\t\r\u0005%\u0002\u0001\"\u0001P\u0003\u0011\t7/\u001b8)\u0007\u0005\u001dB\u000b\u0003\u0004\u00020\u0001!\taT\u0001\u0005CR\fg\u000eK\u0002\u0002.QCa!!\u000e\u0001\t\u0003y\u0015!B1uC:\u0014\u0004fAA\u001a)\"1\u00111\b\u0001\u0005\u0002=\u000bAaY3jY\"\u001a\u0011\u0011\b+\t\r\u0005\u0005\u0003\u0001\"\u0001P\u0003\r\u0019wn\u001d\u0015\u0004\u0003\u007f!\u0006BBA$\u0001\u0011\u0005q*A\u0002d_RD3!!\u0012U\u0011\u0019\ti\u0005\u0001C\u0001\u001f\u00069A-Z4sK\u0016\u001c\bfAA&)\"1\u00111\u000b\u0001\u0005\u0002=\u000b\u0011!\u001a\u0015\u0004\u0003#\"\u0006BBA-\u0001\u0011\u0005q*A\u0002fqBD3!a\u0016U\u0011\u0019\ty\u0006\u0001C\u0001\u001f\u0006)a\r\\8pe\"\u001a\u0011Q\f+\t\r\u0005\u0015\u0004\u0001\"\u0001P\u0003!A\u0017M^3sg&t\u0007fAA2)\"1\u00111\u000e\u0001\u0005\u0002=\u000b1\u0004[1wKJ\u001c\u0018N\\0ta\",'/[2bY~#\u0017n\u001d;b]\u000e,\u0007fAA5)\"1\u0011\u0011\u000f\u0001\u0005\u0002=\u000b1\u0001\\8hQ\r\ty\u0007\u0016\u0005\u0007\u0003o\u0002A\u0011A(\u0002\u000b1|w-\r\u0019)\u0007\u0005UD\u000b\u0003\u0004\u0002~\u0001!\taT\u0001\u0003a&D3!a\u001fU\u0011\u0019\t\u0019\t\u0001C\u0001\u001f\u00069!/\u00193jC:\u001c\bfAAA)\"1\u0011\u0011\u0012\u0001\u0005\u0002=\u000b1a]5oQ\r\t9\t\u0016\u0005\u0007\u0003\u001f\u0003A\u0011A(\u0002\u0007Q\fg\u000eK\u0002\u0002\u000eRCa!!&\u0001\t\u0003y\u0015!\u0002:pk:$\u0007fAAJ)\"1\u00111\u0014\u0001\u0005\u0002=\u000bAa]9si\"\u001a\u0011\u0011\u0014+\t\r\u0005\u0005\u0006\u0001\"\u0001P\u0003\u0011\u0019\u0018n\u001a8)\u0007\u0005}E\u000b\u0003\u0004\u0002(\u0002!\taT\u0001\u0005e\u0006tG\rK\u0002\u0002&RCa!!,\u0001\t\u0003y\u0015!\u0002:b]\u001e,\u0007fAAV)\"1\u00111\u0017\u0001\u0005\u0002=\u000bqA]3qY\u0006\u001cW\rK\u0002\u00022RCa!!/\u0001\t\u0003y\u0015!B:qY&$\bfAA\\)\"1\u0011q\u0018\u0001\u0005\u0002=\u000bA\u0001\\3gi\"\u001a\u0011Q\u0018+\t\r\u0005\u0015\u0007\u0001\"\u0001P\u0003\u0015\u0011\u0018n\u001a5uQ\r\t\u0019\r\u0016\u0005\u0007\u0003\u0017\u0004A\u0011A(\u0002\u0013M,(m\u001d;sS:<\u0007fAAe)\"1\u0011\u0011\u001b\u0001\u0005\u0002=\u000bQ\u0001\\8xKJD3!a4U\u0011\u0019\t9\u000e\u0001C\u0001\u001f\u0006)Q\u000f\u001d9fe\"\u001a\u0011Q\u001b+\t\r\u0005u\u0007\u0001\"\u0001P\u0003\u0015aGO]5nQ\r\tY\u000e\u0016\u0005\u0007\u0003G\u0004A\u0011A(\u0002\u000bI$(/[7)\u0007\u0005\u0005H\u000b\u0003\u0004\u0002j\u0002!\taT\u0001\u0005iJLW\u000eK\u0002\u0002hRCa!a<\u0001\t\u0003y\u0015aA:ue\"\u001a\u0011Q\u001e+\t\r\u0005U\b\u0001\"\u0001P\u0003\u0015!x.\u00138uQ\r\t\u0019\u0010\u0016\u0005\u0007\u0003w\u0004A\u0011A(\u0002\u000fQ|g\t\\8bi\"\u001a\u0011\u0011 +\t\r\t\u0005\u0001\u0001\"\u0001P\u00031!xn\u0015;sS:<g)\u001e8dQ\r\ty\u0010\u0016\u0005\u0007\u0005\u000f\u0001A\u0011A(\u0002\u00079|w\u000fK\u0002\u0003\u0006QCaA!\u0004\u0001\t\u0003y\u0015!C:uCJ$hj\u001c3fQ\r\u0011Y\u0001\u0016\u0005\u0007\u0005'\u0001A\u0011A(\u0002\u000f\u0015tGMT8eK\"\u001a!\u0011\u0003+\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c\u0005AA/Z:u)\"L7\u000fF\bQ\u0005;\u0011iC!\r\u0003N\tE#Q\u000bB-\u0011!\u0011yBa\u0006A\u0002\t\u0005\u0012!\u0002;ji2,\u0007\u0003\u0002B\u0012\u0005Sq1!\rB\u0013\u0013\r\u00119#H\u0001\u0007!J,G-\u001a4\n\u0007!\u0012YCC\u0002\u0003(uA\u0001Ba\f\u0003\u0018\u0001\u0007!\u0011E\u0001\u0007gftG/\u0019=\t\u0011\tM\"q\u0003a\u0001\u0005k\t\u0011\"\u0019:hk6,g\u000e^:\u0011\r\t]\"q\tB&\u001d\u0011\u0011IDa\u0011\u000f\t\tm\"\u0011I\u0007\u0003\u0005{Q1Aa\u0010\u000b\u0003\u0019a$o\\8u}%\ta$C\u0002\u0003Fu\tq\u0001]1dW\u0006<W-C\u0002!\u0005\u0013R1A!\u0012\u001e!\u0019\t\u0014J!\t\u0003\"!A!q\nB\f\u0001\u0004\u0011\t#\u0001\u0003uKb$\b\u0002\u0003B*\u0005/\u0001\rA!\t\u0002\u0013E,XM]=UKb$\b\u0002\u0003B,\u0005/\u0001\rA!\t\u0002\u000fI,G/\u001e:og\"A!1\fB\f\u0001\u0004\u0011i&\u0001\u0006bgN,'\u000f^5p]N\u0004R!\rB0\u0005GJ1A!\u0019\u001e\u0005)a$/\u001a9fCR,GM\u0010\t\u0007c\t\u0015$\u0011\u000e)\n\u0007\t\u001dTDA\u0005Gk:\u001cG/[8ocA!!1\u000eB7\u001b\u0005!\u0011b\u0001B8\t\tyQ\t_3dkRLwN\u001c*fgVdG\u000f")
public class FunctionsTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Alice"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)38)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"brown")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"B"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Bob"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"blue")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"C"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Charlie"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)53)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"green")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"D"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Daniel"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)54)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"brown")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"E"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Eskil"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)41)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eyes"), (Object)"blue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"array"), (Object)new String[]{"one", "two", "three"})})))}));
    private final List<Tuple2<String, String>> common_arguments = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collection"), (Object)"An expression that returns a collection"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identifier"), (Object)"This is the identifier that can be used from the predicate."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"predicate"), (Object)"A predicate that is tested against all items in the collection.")}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A:foo:bar KNOWS B", "A KNOWS C", "B KNOWS D", "C KNOWS D", "B MARRIED E:Spouse"}));
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "functions";
    }

    public List<Tuple2<String, String>> common_arguments() {
        return this.common_arguments;
    }

    @Test
    public void all() {
        this.testThis("ALL", "ALL(identifier in collection WHERE predicate)", this.common_arguments(), "Tests whether a predicate holds for all element of this collection collection.", "match p=(a)-[*1..3]->(b) where a.name='Alice' and b.name='Daniel' and all(x in nodes(p) WHERE x.age > 30) return p", "All nodes in the returned paths will have an `age` property of at least 30.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void any() {
        this.testThis("ANY", "ANY(identifier in collection WHERE predicate)", this.common_arguments(), "Tests whether a predicate holds for at least one element in the collection.", "match (a) where a.name='Eskil' and any(x in a.array WHERE x = \"one\") return a", "All nodes in the returned paths has at least one `one` value set in the array property named `array`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)this.$outer.node("E"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void none() {
        this.testThis("NONE", "NONE(identifier in collection WHERE predicate)", this.common_arguments(), "Returns true if the predicate holds for no element in the collection.", "match p=(n)-[*1..3]->(b) where n.name='Alice' and NONE(x in nodes(p) WHERE x.age = 25) return p", "No nodes in the returned paths has a `age` property set to `25`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void single() {
        this.testThis("SINGLE", "SINGLE(identifier in collection WHERE predicate)", this.common_arguments(), "Returns true if the predicate holds for exactly one of the elements in the collection.", "match p=(n)-->(b) where n.name='Alice' and SINGLE(var in nodes(p) WHERE var.eyes = \"blue\") return p", "Exactly one node in every returned path will have the `eyes` property set to `\"blue\"`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void exists() {
        this.testThis("EXISTS", "EXISTS( pattern-or-property )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"pattern-or-property"), (Object)"A pattern or a property (in the form 'identifier.prop').")})), "Returns true if a match for the pattern exists in the graph, or the property exists in the node, relationship or map.", "match (n) where EXISTS(n.name) return n.name AS name, EXISTS( (n)-[:MARRIED]->() ) AS is_married", "This query returns all the nodes with a name property along with a boolean true/false indicating if they are married.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)5L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void relationship_type() {
        this.testThis("TYPE", "TYPE( relationship )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationship"), (Object)"A relationship.")})), "Returns a string representation of the relationship type.", "match (n)-[r]->() where n.name='Alice' return type(r)", "The relationship type of `r` is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)"KNOWS", (Object)p.columnAs("type(r)").toList().head());
            }
        }}));
    }

    @Test
    public void length() {
        this.testThis("LENGTH", "LENGTH( collection )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collection"), (Object)"An expression that returns a collection")})), "To return or filter on the length of a collection, use the `LENGTH()` function.", "match p=(a)-->(b)-->(c) where a.name='Alice' return length(p)", "The length of the path `p` is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)p.columnAs("length(p)").toList().head()));
            }
        }}));
    }

    @Test
    public void labels() {
        this.testThis("LABELS", "LABELS( node )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"node"), (Object)"Any expression that returns a single node")})), "Returns a collection of string representations for the labels attached to a node.", "match (a) where a.name='Alice' return labels(a)", "The labels of `n` is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                Iterable iter = (Iterable)p.columnAs("labels(a)").next();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(iter.toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void extract() {
        this.testThis("EXTRACT", "EXTRACT( identifier in collection | expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collection"), (Object)"An expression that returns a collection"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identifier"), (Object)"The closure will have an identifier introduced in it's context. Here you decide which identifier to use."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"This expression will run once per value in the collection, and produces the result collection.")})), "To return a single property, or the value of a function from a collection of nodes or relationships,\n you can use `EXTRACT`. It will go through a collection, run an expression on every element, and return the results\n in an collection with these values. It works like the `map` method in functional languages such as Lisp and Scala.", "match p=(a)-->(b)-->(c) where a.name='Alice' and b.name='Bob' and c.name='Daniel' return extract(n in nodes(p) | n.age) AS extracted", "The age property of all nodes in the path are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"extracted"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{38, 25, 54})))}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void reduce() {
        this.testThis("REDUCE", "REDUCE( accumulator = initial,  identifier in collection | expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"accumulator"), (Object)"An identifier that will hold the result and the partial results as the collection is iterated"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"initial"), (Object)"An expression that runs once to give a starting value to the accumulator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collection"), (Object)"An expression that returns a collection"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identifier"), (Object)"The closure will have an identifier introduced in it's context. Here you decide which identifier to use."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"This expression will run once per value in the collection, and produces the result value.")})), "To run an expression against individual elements of a collection, and store the result of the expression in\n an accumulator, you can use `REDUCE`. It will go through a collection, run an expression on every element, storing the partial result\n in the accumulator. It works like the `fold` or `reduce` method in functional languages such as Lisp and Scala.", "match p=(a)-->(b)-->(c) where a.name='Alice' and b.name='Bob' and c.name='Daniel' return reduce(totalAge = 0, n in nodes(p) | totalAge + n.age) AS reduction", "The age property of all nodes in the path are summed and returned as a single value.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"reduction"), (Object)BoxesRunTime.boxToInteger((int)117))}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void head() {
        this.testThis("HEAD", "HEAD( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"This expression should return a collection of some kind.")})), "`HEAD` returns the first element in a collection.", "match (a) where a.name='Eskil' return a.array, head(a.array)", "The first node in the path is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one"})), (Object)p.columnAs("head(a.array)").toList());
            }
        }}));
    }

    @Test
    public void last() {
        this.testThis("LAST", "LAST( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"This expression should return a collection of some kind.")})), "`LAST` returns the last element in a collection.", "match (a) where a.name='Eskil' return a.array, last(a.array)", "The last node in the path is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"three"})), (Object)p.columnAs("last(a.array)").toList());
            }
        }}));
    }

    @Test
    public void tail() {
        this.testThis("TAIL", "TAIL( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"This expression should return a collection of some kind.")})), "`TAIL` returns all but the first element in a collection.", "match (a) where a.name='Eskil' return a.array, tail(a.array)", "This returns the property named `array` and all elements of that property except the first one.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                List toList = ((TraversableOnce)p.columnAs("tail(a.array)").toList().head()).toList();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(toList);
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"two", "three"}));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void filter() {
        this.testThis("FILTER", "FILTER(identifier in collection WHERE predicate)", this.common_arguments(), "`FILTER` returns all the elements in a collection that comply to a predicate.", "match (a) where a.name='Eskil' return a.array, filter(x in a.array WHERE length(x) = 3)", "This returns the property named `array` and a list of values in it, which have the length `3`.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                Iterable array = (Iterable)p.columnAs("filter(x in a.array WHERE length(x) = 3)").toList().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one", "two"})));
                List $org_scalatest_assert_macro_right = array.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void nodes_in_path() {
        this.testThis("NODES", "NODES( path )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"path"), (Object)"A path.")})), "Returns all nodes in a path.", "match p=(a)-->(b)-->(c) where a.name='Alice' and c.name='Eskil' return nodes(p)", "All the nodes in the path `p` are returned by the example query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A"), this.$outer.node("B"), this.$outer.node("E")})));
                Seq $org_scalatest_assert_macro_right = (Seq)p.columnAs("nodes(p)").toList().head();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void rels_in_path() {
        this.testThis("RELATIONSHIPS", "RELATIONSHIPS( path )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"path"), (Object)"A path.")})), "Returns all relationships in a path.", "match p=(a)-->(b)-->(c) where a.name='Alice' and c.name='Eskil' return relationships(p)", "All the relationships in the path `p` are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
                int $org_scalatest_assert_macro_right = ((SeqLike)p.columnAs("relationships(p)").toSeq().head()).length();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void id() {
        this.testThis("ID", "ID( property-container )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"property-container"), (Object)"A node or a relationship.")})), "Returns the id of the relationship or node.", "match (a) return id(a)", "This returns the node id for three nodes.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
                Seq $org_scalatest_assert_macro_right = p.columnAs("id(a)").toSeq();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void coalesce() {
        this.testThis("COALESCE", "COALESCE( expression [, expression]* )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"The expression that might return NULL.")})), "Returns the first non-++NULL++ value in the list of expressions passed to it.\nIn case all arguments are +NULL+, +NULL+ will be returned.", "match (a) where a.name='Alice' return coalesce(a.hairColor, a.eyes)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"brown"})));
                Seq $org_scalatest_assert_macro_right = p.columnAs("coalesce(a.hairColor, a.eyes)").toSeq();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void abs() {
        this.testThis("ABS", "ABS( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`ABS` returns the absolute value of a number.", "match (a), (e) where a.name = 'Alice' and e.name = 'Eskil' return a.age, e.age, abs(a.age - e.age)", "The absolute value of the age difference is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"abs(a.age - e.age)"), (Object)BoxesRunTime.boxToDouble((double)3.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a.age"), (Object)BoxesRunTime.boxToInteger((int)38)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"e.age"), (Object)BoxesRunTime.boxToInteger((int)41))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void acos() {
        this.testThis("ACOS", "ACOS( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`ACOS` returns the arccosine of the expression, in radians.", "return acos(0.5)", "The arccosine of 0.5.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)1.0471975511965979, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"acos(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void asin() {
        this.testThis("ASIN", "ASIN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`ASIN` returns the arcsine of the expression, in radians.", "return asin(0.5)", "The arcsine of 0.5.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.5235987755982989, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"asin(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void atan() {
        this.testThis("ATAN", "ATAN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`ATAN` returns the arctangent of the expression, in radians.", "return atan(0.5)", "The arctangent of 0.5.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.4636476090008061, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"atan(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void atan2() {
        this.testThis("ATAN2", "ATAN2( expression , expression)", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression for y."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression for x.")})), "`ATAN2` returns the arctangent2 of a set of coordinates, in radians.", "return atan2(0.5, 0.6)", "The arctangent2 of 0.5, 0.6.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.6947382761967033, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"atan2(0.5, 0.6)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void ceil() {
        this.testThis("CEIL", "CEIL( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`CEIL` returns the smallest integer greater than or equal to the number.", "return ceil(0.1)", "The ceil of 0.1", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"ceil(0.1)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void cos() {
        this.testThis("COS", "COS( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`COS` returns the cosine of the expression.", "return cos(0.5)", "The cosine of 0.5 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.87758256189, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"cos(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void cot() {
        this.testThis("COT", "COT( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`COT` returns the cotangent of the expression.", "return cot(0.5)", "The cotangent of 0.5 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)1.830487721712452, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"cot(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void degrees() {
        this.testThis("DEGREES", "DEGREES( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`DEGREES` converts radians to degrees.", "return degrees(3.14159)", "The number of degrees in something close to pi.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)180.0, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"degrees(3.14159)")), (double)0.001);
            }
        }}));
    }

    @Test
    public void e() {
        this.testThis("E", "E()", (List<Tuple2<String, String>>)List$.MODULE$.empty(), "`E` returns the constant, e.", "return e()", "The constant e is returned (the base of natural log).", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)Math.E, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"e()")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void exp() {
        this.testThis("EXP", "EXP( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`EXP` returns the value e raised to the power of the expression.", "return exp(2)", "The exp of 2 is returned: e^2^.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)7.38905609893065, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"exp(2)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void floor() {
        this.testThis("FLOOR", "FLOOR( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`FLOOR` returns the greatest integer less than or equal to the expression.", "return floor(0.9)", "The floor of 0.9 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"floor(0.9)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void haversin() {
        this.testThis("HAVERSIN", "HAVERSIN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`HAVERSIN` returns half the versine of the expression.", "return haversin(0.5)", "The haversine of 0.5 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.061208719054813, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"haversin(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void haversin_spherical_distance() {
        this.testQuery("Spherical distance using the haversin function", "The +haversin+ function may be used to compute the distance on the surface of a sphere between two points (each given by their latitude and longitude). In this example the spherical distance (in km) between Berlin in Germany (at lat 52.5, lon 13.4) and San Mateo in California (at lat 37.5, lon -122.3) is calculated using an average earth radius of 6371 km.", "CREATE (ber:City {lat: 52.5, lon: 13.4}), (sm:City {lat: 37.5, lon: -122.3}) RETURN 2 * 6371 * asin(sqrt(haversin(radians( sm.lat - ber.lat )) + cos(radians( sm.lat )) * cos(radians( ber.lat )) * haversin(radians( sm.lon - ber.lon )))) AS dist", "The distance between Berlin and San Mateo is returned (about 9129 km).", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)9129.0, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"dist")), (double)1.0);
            }
        }}));
    }

    @Test
    public void log() {
        this.testThis("LOG", "LOG( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`LOG` returns the natural logarithm of the expression.", "return log(27)", "The log of 27 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)3.295836866004329, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"log(27)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void log10() {
        this.testThis("LOG10", "LOG10( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`LOG10` returns the base 10 logarithm of the expression.", "return log10(27)", "The log10 of 27 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)1.4313637641589874, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"log10(27)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void pi() {
        this.testThis("PI", "PI()", (List<Tuple2<String, String>>)List$.MODULE$.empty(), "`PI` returns the mathematical constant pi.", "return pi()", "The constant pi is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)Math.PI, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"pi()")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void radians() {
        this.testThis("RADIANS", "RADIANS( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`RADIANS` converts degrees to radians.", "return radians(180)", "The number of radians in 180 is returned (pi).", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)Math.PI, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"radians(180)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void sin() {
        this.testThis("SIN", "SIN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`SIN` returns the sine of the expression.", "return sin(0.5)", "The sine of 0.5 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.479425538604203, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"sin(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void tan() {
        this.testThis("TAN", "TAN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`TAN` returns the tangent of the expression.", "return tan(0.5)", "The tangent of 0.5 is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((double)0.5463024898437905, (double)BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"tan(0.5)")), (double)1.0E-6);
            }
        }}));
    }

    @Test
    public void round() {
        this.testThis("ROUND", "ROUND( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numerical expression.")})), "`ROUND` returns the numerical expression, rounded to the nearest integer.", "return round(3.141592)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"round(3.141592)"), (Object)BoxesRunTime.boxToInteger((int)3))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void sqrt() {
        this.testThis("SQRT", "SQRT( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numerical expression")})), "`SQRT` returns the square root of a number.", "return sqrt(256)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sqrt(256)"), (Object)BoxesRunTime.boxToInteger((int)16))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void sign() {
        this.testThis("SIGN", "SIGN( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numerical expression")})), "`SIGN` returns the signum of a number -- zero if the expression is zero, `-1` for any negative number, and `1` for any positive number.", "return sign(-17), sign(0.1)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sign(-17)"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sign(0.1)"), (Object)BoxesRunTime.boxToInteger((int)1))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void rand() {
        this.testThis("RAND", "RAND( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"A numeric expression.")})), "`RAND` returns a random double between 0 and 1.0.", "return rand() as x1", "A random number is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                int $org_scalatest_assert_macro_right;
                double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)((MapLike)p.toList().head()).apply((Object)"x1"));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left >= (double)($org_scalatest_assert_macro_right = 0);
                this.$outer.assertionsHelper().macroAssert((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void range() {
        this.testThis("RANGE", "RANGE( start, end [, step] )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"start"), (Object)"A numerical expression."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"end"), (Object)"A numerical expression."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"step"), (Object)"A numerical expression.")})), "Returns numerical values in a range with a non-zero step value step. Range is inclusive in both ends.", "return range(0,10), range(2,18,3)", "Two lists of numbers are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"range(0,10)"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"range(2,18,3)"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 8, 11, 14, 17})))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void replace() {
        this.testThis("REPLACE", "REPLACE( original, search, replace )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"search"), (Object)"An expression that returns a string to search for"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"replace"), (Object)"An expression that returns the string to replace the search string with")})), "`REPLACE` returns a string with the search string replaced by the replace string. It replaces all occurrences.", "return replace(\"hello\", \"l\", \"w\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hewwo"})));
                Seq $org_scalatest_assert_macro_right = p.columnAs("replace(\"hello\", \"l\", \"w\")").toSeq();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void split() {
        this.testThis("SPLIT", "SPLIT( original, splitPattern )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"splitPattern"), (Object)"The string to split to original string with")})), "`SPLIT` returns the sequence of strings witch are delimited by split patterns.", "return split(\"one,two\", \",\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"split(\"one,two\", \",\")"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one", "two"})))}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void left() {
        this.testThis("LEFT", "LEFT( original, length )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)"An expression that returns a positive number")})), "`LEFT` returns a string containing the left n characters of the original string.", "return left(\"hello\", 3)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hel"})));
                Seq $org_scalatest_assert_macro_right = p.columnAs("left(\"hello\", 3)").toSeq();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void right() {
        this.testThis("RIGHT", "RIGHT( original, length )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)"An expression that returns a positive number")})), "`RIGHT` returns a string containing the right n characters of the original string.", "return right(\"hello\", 3)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"llo"})));
                Seq $org_scalatest_assert_macro_right = p.columnAs("right(\"hello\", 3)").toSeq();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void substring() {
        this.testThis("SUBSTRING", "SUBSTRING( original, start [, length] )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"start"), (Object)"An expression that returns a positive number"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length"), (Object)"An expression that returns a positive number")})), "`SUBSTRING` returns a substring of the original, with a 0-based index start and length. If length is omitted, it returns a substring from start until the end of the string.", "return substring(\"hello\", 1, 3), substring(\"hello\", 2)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"substring(\"hello\", 1, 3)"), (Object)"ell"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"substring(\"hello\", 2)"), (Object)"llo")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void lower() {
        this.testThis("LOWER", "LOWER( original )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string")})), "`LOWER` returns the original string in lowercase.", "return lower(\"HELLO\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lower(\"HELLO\")"), (Object)"hello")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void upper() {
        this.testThis("UPPER", "UPPER( original )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string")})), "`UPPER` returns the original string in uppercase.", "return upper(\"hello\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"upper(\"hello\")"), (Object)"HELLO")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void ltrim() {
        this.testThis("LTRIM", "LTRIM( original )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string")})), "`LTRIM` returns the original string with whitespace removed from the left side.", "return ltrim(\"   hello\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ltrim(\"   hello\")"), (Object)"hello")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void rtrim() {
        this.testThis("RTRIM", "RTRIM( original )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string")})), "`RTRIM` returns the original string with whitespace removed from the right side.", "return rtrim(\"hello   \")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rtrim(\"hello   \")"), (Object)"hello")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void trim() {
        this.testThis("TRIM", "TRIM( original )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"original"), (Object)"An expression that returns a string")})), "`TRIM` returns the original string with whitespace removed from both sides.", "return trim(\"   hello   \")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"trim(\"   hello   \")"), (Object)"hello")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void str() {
        this.testThis("STR", "STR( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"An expression that returns anything")})), "`STR` returns a string representation of the expression.", "return str(1)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"str(1)"), (Object)"1")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void toInt() {
        this.testThis("TOINT", "TOINT( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"An expression that returns anything")})), "`TOINT` converts the argument to an integer. A string is parsed as if it was an integer number. If the parsing fails, +NULL+ will be returned. A floating point number will be cast into an integer.", "return toInt(\"42\"), toInt(\"not a number\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                Map[] mapArray = new Map[1];
                Tuple2[] tuple2Array = new Tuple2[2];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toInt(\"42\")"), (Object)BoxesRunTime.boxToInteger((int)42));
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toInt(\"not a number\")"), null);
                mapArray[0] = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])mapArray)));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void toFloat() {
        this.testThis("TOFLOAT", "TOFLOAT( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"An expression that returns anything")})), "`TOFLOAT` converts the argument to a float. A string is parsed as if it was an floating point number. If the parsing fails, +NULL+ will be returned. An integer will be cast to a floating point number.", "return toFloat(\"11.5\"), toFloat(\"not a number\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                Map[] mapArray = new Map[1];
                Tuple2[] tuple2Array = new Tuple2[2];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toFloat(\"11.5\")"), (Object)BoxesRunTime.boxToDouble((double)11.5));
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toFloat(\"not a number\")"), null);
                mapArray[0] = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])mapArray)));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void toStringFunc() {
        this.testThis("TOSTRING", "TOSTRING( expression )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"expression"), (Object)"An expression that returns anything")})), "`TOSTRING` converts the argument to a string. It converts integers and floating point numbers to strings, and if called with a string will leave it unchanged.", "return toString(11.5), toString(\"already a string\")", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toString(11.5)"), (Object)"11.5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"toString(\"already a string\")"), (Object)"already a string")}))})));
                List $org_scalatest_assert_macro_right = p.toList();
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void now() {
        this.testThis("TIMESTAMP", "TIMESTAMP()", (List<Tuple2<String, String>>)List$.MODULE$.empty(), "`TIMESTAMP` returns the difference, measured in milliseconds, between the current time and midnight, January 1, 1970 UTC. It will return the same value during the whole one query, even if the query is a long running one.", "return timestamp()", "The time in milliseconds is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                boolean bl;
                Assertions.AssertionsHelper assertionsHelper = this.$outer.assertionsHelper();
                Object object = ((MapLike)p.toList().head()).apply((Object)"timestamp()");
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    bl = System.currentTimeMillis() - l < 100000L;
                } else {
                    bl = false;
                }
                assertionsHelper.macroAssert(bl, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void startNode() {
        this.testThis("STARTNODE", "STARTNODE( relationship )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationship"), (Object)"An expression that returns a relationship")})), "`STARTNODE` returns the starting node of a relationship", "MATCH (x:foo)-[r]-() return startNode(r)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((MapLike)p.toList().head()).apply((Object)"startNode(r)"));
                Node $org_scalatest_assert_macro_right = this.$outer.node("A");
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void endNode() {
        this.testThis("ENDNODE", "ENDNODE( relationship )", (List<Tuple2<String, String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationship"), (Object)"An expression that returns a relationship")})), "`ENDNODE` returns the end node of a relationship", "MATCH (x:foo)-[r]-() return endNode(r)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionsTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((MapLike)p.toList().head()).apply((Object)"endNode(r)"));
                Node $org_scalatest_assert_macro_right = this.$outer.node("B");
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    private void testThis(String title, String syntax, List<Tuple2<String, String>> arguments, String text, String queryText, String returns, Seq<Function1<ExecutionResult, BoxedUnit>> assertions) {
        String argsText = ((TraversableOnce)arguments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x) {
                return new StringBuilder().append((Object)"* _").append(x._1()).append((Object)":_ ").append(x._2()).toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString("\r\n\r\n");
        String fullText = String.format("%s\n\n*Syntax:* `%s`\n\n*Arguments:*\n\n%s", text, syntax, argsText);
        this.testQuery(title, fullText, queryText, returns, assertions);
    }
}

