/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.CsvFile;
import org.neo4j.cypher.docgen.CsvFile$;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0017\tYAj\\1e\u0007N3F+Z:u\u0015\t\u0019A!\u0001\u0004e_\u000e<WM\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r!A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0014\t>\u001cW/\\3oi&tw\rV3ti\n\u000b7/\u001a\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011!$U;fef\u001cF/\u0019;jgRL7m\u001d+fgR\u001cV\u000f\u001d9peRDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u00055\u0001\u0001\"B\r\u0001\t#R\u0012\u0001E4fi\u001e\u0013\u0018\r\u001d5wSj\u001cF/\u001f7f+\u0005Y\u0002C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003!9'/\u00199im&T(B\u0001\u0011\u0007\u000351\u0018n];bY&T\u0018\r^5p]&\u0011!%\b\u0002\u000b\u000fJ\f\u0007\u000f[*us2,\u0007b\u0002\u0013\u0001\u0001\u0004%\u0019!J\u0001\fGN4h)\u001b7fg\u0012K'/F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0002j_*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u00111\u0015\u000e\\3\t\u000f=\u0002\u0001\u0019!C\u0001a\u0005y1m\u001d<GS2,7\u000fR5s?\u0012*\u0017\u000f\u0006\u00022oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t!QK\\5u\u0011\u001dAd&!AA\u0002\u0019\n1\u0001\u001f\u00132\u0011\u0019Q\u0004\u0001)Q\u0005M\u0005a1m\u001d<GS2,7\u000fR5sA!)A\b\u0001C\u0001{\u000591/Z2uS>tW#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0013\u0001\u00027b]\u001eL!a\u0011!\u0003\rM#(/\u001b8h\u0011\u001d)\u0005A1A\u0005\n\u0015\na!\u0019:uSN$\bBB$\u0001A\u0003%a%A\u0004beRL7\u000f\u001e\u0011\t\u000f%\u0003!\u0019!C\u0005K\u0005\t\u0012M\u001d;jgR<\u0016\u000e\u001e5IK\u0006$WM]:\t\r-\u0003\u0001\u0015!\u0003'\u0003I\t'\u000f^5ti^KG\u000f\u001b%fC\u0012,'o\u001d\u0011\t\u000f5\u0003!\u0019!C\u0005K\u0005)\u0012M\u001d;jgR4\u0015.\u001a7e)\u0016\u0014X.\u001b8bi>\u0014\bBB(\u0001A\u0003%a%\u0001\fbeRL7\u000f\u001e$jK2$G+\u001a:nS:\fGo\u001c:!\u0011\u001d\t\u0006A1A\u0005\n\u0015\nQ#\u0019:uSN$8oV5uQ\u0016\u001b8-\u00199f\u0007\"\f'\u000f\u0003\u0004T\u0001\u0001\u0006IAJ\u0001\u0017CJ$\u0018n\u001d;t/&$\b.R:dCB,7\t[1sA!)Q\u000b\u0001C\u0001-\u0006\u00113\u000f[8vY\u0012|\u0016.\u001c9peR|F-\u0019;b?\u001a\u0014x.\\0b?\u000e\u001cho\u00184jY\u0016$\u0012!\r\u0015\u0003)b\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0005\u0002\u000b),h.\u001b;\n\u0005uS&\u0001\u0002+fgRDQa\u0018\u0001\u0005\u0002Y\u000bqf\u001d5pk2$w,[7q_J$x\fZ1uC~3'o\\7`C~\u001b7O^0gS2,wl^5uQ~CW-\u00193feND#A\u0018-\t\u000b\t\u0004A\u0011\u0001,\u0002\u007fMDw.\u001e7e?&l\u0007o\u001c:u?\u0012\fG/Y0ge>lw,Y0dgZ|f-\u001b7f?^LG\u000f[0dkN$x.\\0gS\u0016dGm\u0018;fe6Lg.\u0019;pe\"\u0012\u0011\r\u0017\u0005\u0006K\u0002!\tAV\u00018g\"|W\u000f\u001c3`S6\u0004xN\u001d;`I\u0006$\u0018m\u00184s_6|\u0016mX2tm~3\u0017\u000e\\3`o&$\bn\u00189fe&|G-[2`G>lW.\u001b;)\u0005\u0011D\u0006\"\u00025\u0001\t\u00031\u0016AR:i_VdGmX5na>\u0014Ho\u00183bi\u0006|fM]8n?\u0006|6m\u001d<`M&dWmX<ji\"|\u0006/\u001a:j_\u0012L7mX2p[6LGoX1gi\u0016\u0014x,\u000e\u00191?J|wo\u001d\u0015\u0003ObCQa\u001b\u0001\u0005\u0002Y\u000bQh\u001d5pk2$w,[7q_J$x\fZ1uC~3'o\\7`C~\u001b7O^0gS2,wl\u001e5jG\"|Vo]3t?RDWmX3tG\u0006\u0004XmX2iCJD#A\u001b-")
public class LoadCSVTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    private File csvFilesDir;
    private final File artist;
    private final File artistWithHeaders;
    private final File artistFieldTerminator;
    private final File artistsWithEscapeChar;

    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    public File csvFilesDir() {
        return this.csvFilesDir;
    }

    public void csvFilesDir_$eq(File x$1) {
        this.csvFilesDir = x$1;
    }

    @Override
    public String section() {
        return "Load CSV";
    }

    private File artist() {
        return this.artist;
    }

    private File artistWithHeaders() {
        return this.artistWithHeaders;
    }

    private File artistFieldTerminator() {
        return this.artistFieldTerminator;
    }

    private File artistsWithEscapeChar() {
        return this.artistsWithEscapeChar;
    }

    @Test
    public void should_import_data_from_a_csv_file() {
        this.testQuery("Import data from a CSV file", "\nTo import data from a CSV file into Neo4j, you can use +LOAD CSV+ to get the data into your query.\nThen you write it to your database using the normal updating clauses of Cypher.\n\n.artists.csv\n[source]\n----\ninclude::csv-files/artists.csv[]\n----\n", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD CSV FROM '%ARTIST%' AS line CREATE (:Artist {name: line[1], year: toInt(line[2])})"})).s((Seq)Nil$.MODULE$), "\nA new node with the +Artist+ label is created for each row in the CSV file.\nIn addition, two columns from the CSV file are set as properties on the nodes.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$1 = p;
                int x$2 = 4;
                int x$3 = 8;
                int x$4 = 4;
                int x$5 = this.$outer.assertStats$default$3();
                int x$6 = this.$outer.assertStats$default$5();
                int x$7 = this.$outer.assertStats$default$6();
                int x$8 = this.$outer.assertStats$default$8();
                int x$9 = this.$outer.assertStats$default$9();
                int x$10 = this.$outer.assertStats$default$10();
                int x$11 = this.$outer.assertStats$default$11();
                int x$12 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$1, x$2, x$5, x$3, x$6, x$7, x$4, x$8, x$9, x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void should_import_data_from_a_csv_file_with_headers() {
        this.testQuery("Import data from a CSV file containing headers", "\nWhen your CSV file has headers, you can view each row in the file as a map instead of as an array of strings.\n\n.artists-with-headers.csv\n[source]\n----\ninclude::csv-files/artists-with-headers.csv[]\n----\n", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD CSV WITH HEADERS FROM '%ARTIS_WITH_HEADER%' AS line CREATE (:Artist {name: line.Name, year: toInt(line.Year)})"})).s((Seq)Nil$.MODULE$), "\nThis time, the file starts with a single row containing column names.\nIndicate this using +WITH HEADERS+ and you can access specific fields by their corresponding column name.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$13 = p;
                int x$14 = 4;
                int x$15 = 8;
                int x$16 = 4;
                int x$17 = this.$outer.assertStats$default$3();
                int x$18 = this.$outer.assertStats$default$5();
                int x$19 = this.$outer.assertStats$default$6();
                int x$20 = this.$outer.assertStats$default$8();
                int x$21 = this.$outer.assertStats$default$9();
                int x$22 = this.$outer.assertStats$default$10();
                int x$23 = this.$outer.assertStats$default$11();
                int x$24 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$13, x$14, x$17, x$15, x$18, x$19, x$16, x$20, x$21, x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void should_import_data_from_a_csv_file_with_custom_field_terminator() {
        this.testQuery("Import data from a CSV file with a custom field delimiter", "\nSometimes, your CSV file has other field delimiters than commas.\nYou can specify which delimiter your file uses using +FIELDTERMINATOR+.\n\n.artists-fieldterminator.csv\n[source]\n----\ninclude::csv-files/artists-fieldterminator.csv[]\n----\n", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD CSV FROM '%ARTIST_WITH_FIELD_DELIMITER%' AS line FIELDTERMINATOR ';' CREATE (:Artist {name: line[1], year: toInt(line[2])})"})).s((Seq)Nil$.MODULE$), "As values in this file are separated by a semicolon, a custom +FIELDTERMINATOR+ is specified in the +LOAD CSV+ clause.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$25 = p;
                int x$26 = 4;
                int x$27 = 8;
                int x$28 = 4;
                int x$29 = this.$outer.assertStats$default$3();
                int x$30 = this.$outer.assertStats$default$5();
                int x$31 = this.$outer.assertStats$default$6();
                int x$32 = this.$outer.assertStats$default$8();
                int x$33 = this.$outer.assertStats$default$9();
                int x$34 = this.$outer.assertStats$default$10();
                int x$35 = this.$outer.assertStats$default$11();
                int x$36 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$25, x$26, x$29, x$27, x$30, x$31, x$28, x$32, x$33, x$34, x$35, x$36);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void should_import_data_from_a_csv_file_with_periodic_commit() {
        this.testQuery("Importing large amounts of data", "\nIf the CSV file contains a significant number of rows (approaching hundreds of thousands or millions), +USING PERIODIC COMMIT+\ncan be used to instruct Neo4j to perform a commit after a number of rows.\nThis reduces the memory overhead of the transaction state.\nBy default, the commit will happen every 1000 rows.\nFor more information, see <<query-periodic-commit>>.\n", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING PERIODIC COMMIT LOAD CSV FROM '%ARTIST%' AS line CREATE (:Artist {name: line[1], year: toInt(line[2])})"})).s((Seq)Nil$.MODULE$), "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$37 = p;
                int x$38 = 4;
                int x$39 = 8;
                int x$40 = 4;
                int x$41 = this.$outer.assertStats$default$3();
                int x$42 = this.$outer.assertStats$default$5();
                int x$43 = this.$outer.assertStats$default$6();
                int x$44 = this.$outer.assertStats$default$8();
                int x$45 = this.$outer.assertStats$default$9();
                int x$46 = this.$outer.assertStats$default$10();
                int x$47 = this.$outer.assertStats$default$11();
                int x$48 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$37, x$38, x$41, x$39, x$42, x$43, x$40, x$44, x$45, x$46, x$47, x$48);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void should_import_data_from_a_csv_file_with_periodic_commit_after_500_rows() {
        this.testQuery("Setting the rate of periodic commits", "You can set the number of rows as in the example, where it is set to 500 rows.", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING PERIODIC COMMIT 500 LOAD CSV FROM '%ARTIST%' AS line CREATE (:Artist {name: line[1], year: toInt(line[2])})"})).s((Seq)Nil$.MODULE$), "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$49 = p;
                int x$50 = 4;
                int x$51 = 8;
                int x$52 = 4;
                int x$53 = this.$outer.assertStats$default$3();
                int x$54 = this.$outer.assertStats$default$5();
                int x$55 = this.$outer.assertStats$default$6();
                int x$56 = this.$outer.assertStats$default$8();
                int x$57 = this.$outer.assertStats$default$9();
                int x$58 = this.$outer.assertStats$default$10();
                int x$59 = this.$outer.assertStats$default$11();
                int x$60 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$49, x$50, x$53, x$51, x$54, x$55, x$52, x$56, x$57, x$58, x$59, x$60);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void should_import_data_from_a_csv_file_which_uses_the_escape_char() {
        this.testQuery("Import data containing escape characters", "", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD CSV FROM '%ARTIST_WITH_ESCAPE_CHAR%' AS line CREATE (a:Artist {name: line[1], year: toInt(line[2])}) return a.name as name"})).s((Seq)Nil$.MODULE$), "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"\"The \"Symbol\"\"")}))})), (Object)p.toList());
            }
        }}));
    }

    public LoadCSVTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
        this.csvFilesDir = this.createDir(this.dir(), "csv-files");
        this.artist = new CsvFile("artists.csv", CsvFile$.MODULE$.$lessinit$greater$default$2(), this.csvFilesDir()).withContentsF((Seq<Seq<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "ABBA", "1992"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "Roxette", "1986"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "Europe", "1979"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4", "The Cardigans", "1992"}))}));
        this.artistWithHeaders = new CsvFile("artists-with-headers.csv", CsvFile$.MODULE$.$lessinit$greater$default$2(), this.csvFilesDir()).withContentsF((Seq<Seq<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Id", "Name", "Year"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "ABBA", "1992"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "Roxette", "1986"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "Europe", "1979"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4", "The Cardigans", "1992"}))}));
        this.artistFieldTerminator = new CsvFile("artists-fieldterminator.csv", ';', this.csvFilesDir()).withContentsF((Seq<Seq<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "ABBA", "1992"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "Roxette", "1986"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3", "Europe", "1979"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4", "The Cardigans", "1992"}))}));
        this.artistsWithEscapeChar = new CsvFile("artists-with-escape-char.csv", CsvFile$.MODULE$.$lessinit$greater$default$2(), this.csvFilesDir()).withContentsF((Seq<Seq<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "\"The \\\"Symbol\\\"\"", "1992"}))}));
        this.filePaths_$eq((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST%"), (Object)CsvFile$.MODULE$.urify(this.artist())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIS_WITH_HEADER%"), (Object)CsvFile$.MODULE$.urify(this.artistWithHeaders())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST_WITH_FIELD_DELIMITER%"), (Object)CsvFile$.MODULE$.urify(this.artistFieldTerminator())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST_WITH_ESCAPE_CHAR%"), (Object)CsvFile$.MODULE$.urify(this.artistsWithEscapeChar()))}))));
        this.urls_$eq((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST%"), (Object)new StringBuilder().append((Object)this.baseUrl()).append((Object)this.artist().getName()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIS_WITH_HEADER%"), (Object)new StringBuilder().append((Object)this.baseUrl()).append((Object)this.artistWithHeaders().getName()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST_WITH_FIELD_DELIMITER%"), (Object)new StringBuilder().append((Object)this.baseUrl()).append((Object)this.artistFieldTerminator().getName()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"%ARTIST_WITH_ESCAPE_CHAR%"), (Object)new StringBuilder().append((Object)this.baseUrl()).append((Object)this.artistsWithEscapeChar().getName()).toString())}))));
    }
}

