/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.tooling.GlobalGraphOperations;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001-\u0011\u0011\"T1uG\"$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0003\u0016\u0001\u0011\u0005c#\u0001\the\u0006\u0004\b\u000eR3tGJL\u0007\u000f^5p]V\tq\u0003E\u0002\u0019?\u0005j\u0011!\u0007\u0006\u00035m\t\u0011\"[7nkR\f'\r\\3\u000b\u0005qi\u0012AC2pY2,7\r^5p]*\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!3\t!A*[:u!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0007b\u0002\u0016\u0001\u0005\u0004%\teK\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u0001\u0017\u0011\tai\u0013eL\u0005\u0003]e\u00111!T1q!\u0011AR&I\u0011\t\rE\u0002\u0001\u0015!\u0003-\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\t\u000bM\u0002A\u0011\u000b\u001b\u0002!\u001d,Go\u0012:ba\"4\u0018N_*us2,W#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001C4sCBDg/\u001b>\u000b\u0005i2\u0011!\u0004<jgV\fG.\u001b>bi&|g.\u0003\u0002=o\tQqI]1qQN#\u0018\u0010\\3\t\u000by\u0002A\u0011A \u0002\u000fM,7\r^5p]V\t\u0001\t\u0005\u0002B\u000b:\u0011!iQ\u0007\u0002;%\u0011A)H\u0001\u0007!J,G-\u001a4\n\u0005!2%B\u0001#\u001e\u0011\u0015A\u0005\u0001\"\u0001J\u000359W\r^0bY2|fn\u001c3fgR\t!\n\u0005\u0002C\u0017&\u0011A*\b\u0002\u0005+:LG\u000f\u000b\u0002H\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bC\u0001\u0006UVt\u0017\u000e^\u0005\u0003'B\u0013A\u0001V3ti\")Q\u000b\u0001C\u0001\u0013\u0006)r-\u001a;`C2dw\f\\1cK2,Gm\u00188pI\u0016\u001c\bF\u0001+O\u0011\u0015A\u0006\u0001\"\u0001J\u0003A\tG\u000e\u001c*fY\u0006$\u0018n\u001c8tQ&\u00048\u000f\u000b\u0002X\u001d\")1\f\u0001C\u0001\u0013\u0006A\u0012\r\u001c7PkR<w.\u001b8h%\u0016d\u0017\r^5p]ND\u0017\u000e]:)\u0005is\u0005\"\u00020\u0001\t\u0003I\u0015!G1mY>+HoZ8j]\u001e\u0014V\r\\1uS>t7\u000f[5qgJB#!\u0018(\t\u000b\u0005\u0004A\u0011A%\u0002=I,G.\u0019;fI:{G-Z:CsJ+G.\u0019;j_:\u001c\b.\u001b9UsB,\u0007F\u00011O\u0011\u0015!\u0007\u0001\"\u0001J\u0003\u001d\u0012X\r\\1uK\u0012tu\u000eZ3t\u0005flU\u000f\u001c;ja2,'+\u001a7bi&|gn\u001d5jaRK\b/Z:)\u0005\rt\u0005\"B4\u0001\t\u0003I\u0015a\u0005:fY\u0006$\u0018n\u001c8tQ&\u00048OQ=UsB,\u0007F\u00014O\u0011\u0015Q\u0007\u0001\"\u0001J\u0003q\u0011X\r\\1uS>t7\u000f[5qg\nKH+\u001f9f/&$\bn\u00159bG\u0016D#!\u001b(\t\u000b5\u0004A\u0011A%\u0002-5,H\u000e^5Ti\u0016\u0004(+\u001a7bi&|gn\u001d5jaND#\u0001\u001c(\t\u000bA\u0004A\u0011A%\u0002%Y\f'/[1cY\u0016dUM\\4uQB\u000bG\u000f\u001b\u0015\u0003_:CQa\u001d\u0001\u0005\u0002%\u000b!E^1sS\u0006\u0014G.\u001a'f]\u001e$\b\u000eU1uQ^KG\u000f[%uKJ\f'\r\\3SK2\u001c\bF\u0001:O\u0011\u00151\b\u0001\"\u0001J\u00039QXM]8MK:<G\u000f\u001b)bi\"D#!\u001e(\t\u000be\u0004A\u0011A%\u0002\u001f\u0019L\u00070\u001a3MK:<G\u000f\u001b)bi\"D#\u0001\u001f(\t\u000bq\u0004A\u0011A%\u00027MDwN\u001d;fgR\u0004\u0016\r\u001e5CKR<X-\u001a8Uo>tu\u000eZ3tQ\tYh\nC\u0003\u0000\u0001\u0011\u0005\u0011*A\u0010bY2\u001c\u0006n\u001c:uKN$\b+\u0019;ig\n+Go^3f]R;xNT8eKND#A (\t\r\u0005\u0015\u0001\u0001\"\u0001J\u0003IIg\u000e\u001e:pIV\u001cWMT1nK\u0012\u0004\u0016\r\u001e5)\u0007\u0005\ra\n\u0003\u0004\u0002\f\u0001!\t!S\u0001\u001c[\u0006$8\r[0p]~\u0013w.\u001e8e?J,G.\u0019;j_:\u001c\b.\u001b9)\u0007\u0005%a\n\u0003\u0004\u0002\u0012\u0001!\t!S\u0001\u0012[\u0006$8\r[0xSRDw\f\\1cK2\u001c\bfAA\b\u001d\"1\u0011q\u0003\u0001\u0005\u0002%\u000bq&\\1uG\"|v/\u001b;i?B\u0014x\u000e]3si&,7oX8o?\u0006|f/\u0019:jC\ndWm\u00187f]\u001e$\bn\u00189bi\"D3!!\u0006O\u0001")
public class MatchTest
extends DocumentingTestBase {
    private final Map<String, Map<String, String>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Charlie"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Charlie Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Oliver"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Oliver Stone")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Michael"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Michael Douglas")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Rob"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Rob Reiner")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Martin"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Martin Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"WallStreet"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"Wall Street")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"TheAmericanPresident"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"The American President")})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Charlie:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN WallStreet:Movie", "Michael:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN TheAmericanPresident:Movie", "Michael:Person ACTED_IN TheAmericanPresident:Movie", "Oliver:Person DIRECTED WallStreet:Movie", "Rob:Person DIRECTED TheAmericanPresident:Movie", "Charlie:Person FATHER Martin:Person"}));
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "MATCH";
    }

    @Test
    public void get_all_nodes() {
        this.testQuery("Get all nodes", "By just specifying a pattern with a single node and no labels, all nodes in the graph will be returned.", "match (n) return n", "Returns all the nodes in the database.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                List allNodes = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(GlobalGraphOperations.at((GraphDatabaseService)this.$outer.db()).getAllNodes()).asScala()).toList();
                Assert.assertEquals((Object)allNodes, (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void get_all_labeled_nodes() {
        this.testQuery("Get all nodes with a label", "Getting all nodes with a label on them is done with a single node pattern where the node has a label on it.", "match (movie:Movie) return movie", "Returns all the movies in the database.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)this.$outer.nodes((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WallStreet", "TheAmericanPresident"})).toSet(), (Object)p.columnAs("movie").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void allRelationships() {
        this.testQuery("Related nodes", "The symbol `--` means _related to,_ without regard to type or direction of the relationship.", "match (director {name:'Oliver Stone'})--(movie) return movie.title", "Returns all the movies directed by Oliver Stone.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wall Street"})), (Object)p.columnAs("movie.title").toList());
            }
        }}));
    }

    @Test
    public void allOutgoingRelationships() {
        this.testQuery("Outgoing relationships", "When the direction of a relationship is interesting, it is shown by using `-->` or `<--`, like this: ", "match (martin {name:'Martin Sheen'})-->(movie) return movie.title", "Returns nodes connected to Martin by outgoing relationships.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wall Street", "The American President"})), (Object)p.columnAs("movie.title").toSet());
            }
        }}));
    }

    @Test
    public void allOutgoingRelationships2() {
        this.testQuery("Directed relationships and identifier", "If an identifier is needed, either for filtering on properties of the relationship, or to return the relationship, this is how you introduce the identifier.", "match (martin {name:'Martin Sheen'})-[r]->(movie) return r", "Returns all outgoing relationships from Martin.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.size());
            }
        }}));
    }

    @Test
    public void relatedNodesByRelationshipType() {
        this.testQuery("Match by relationship type", "When you know the relationship type you want to match on, you can specify it by using a colon together with the relationship type.", "match (wallstreet {title:'Wall Street'})<-[:ACTED_IN]-(actor) return actor", "Returns nodes that +ACTED_IN+ Wall Street.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)this.$outer.nodes((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Michael", "Martin", "Charlie"})).toSet(), (Object)p.columnAs("actor").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void relatedNodesByMultipleRelationshipTypes() {
        this.testQuery("Match by multiple relationship types", "To match on one of multiple types, you can specify this by chaining them together with the pipe symbol `|`.", "match (wallstreet {title:'Wall Street'})<-[:ACTED_IN|:DIRECTED]-(person) return person", "Returns nodes with a +ACTED_IN+ or +DIRECTED+ relationship to Wall Street.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)this.$outer.nodes((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Michael", "Martin", "Charlie", "Oliver"})).toSet(), (Object)p.columnAs("person").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void relationshipsByType() {
        this.testQuery("Match by relationship type and use an identifier", "If you both want to introduce an identifier to hold the relationship, and specify the relationship type you want, just add them both, like this.", "match (wallstreet {title:'Wall Street'})<-[r:ACTED_IN]-(actor) return r", "Returns nodes that +ACTED_IN+ Wall Street.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)3L, (long)p.size());
            }
        }}));
    }

    @Test
    public void relationshipsByTypeWithSpace() {
        this.RichGraph(this.db()).inTx((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final Relationship apply() {
                Node a = this.$outer.node("Rob");
                Node b = this.$outer.node("Charlie");
                return a.createRelationshipTo(b, (RelationshipType)DynamicRelationshipType.withName((String)"TYPE THAT HAS SPACE IN IT"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testQuery("Relationship types with uncommon characters", "Sometime your database will have types with non-letter characters, or with spaces in them. Use +`+ (backtick) to quote these.", "match (n {name:'Rob Reiner'})-[r:`TYPE THAT HAS SPACE IN IT`]->() return r", "Returns a relationship of a type with spaces in it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.size());
            }
        }}));
    }

    @Test
    public void multiStepRelationships() {
        this.testQuery("Multiple relationships", "Relationships can be expressed by using multiple statements in the form of `()--()`, or they can be strung together, like this:", "match (charlie {name:'Charlie Sheen'})-[:ACTED_IN]->(movie)<-[:DIRECTED]-(director) return charlie,movie,director", "Returns the three nodes in the path.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"charlie"), (Object)this.$outer.node("Charlie")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"movie"), (Object)this.$outer.node("WallStreet")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"director"), (Object)this.$outer.node("Oliver"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void variableLengthPath() {
        this.testQuery("Variable length relationships", "Nodes that are a variable number of relationship->node hops away can be found using the following syntax: `-[:TYPE*minHops..maxHops]->`. minHops and maxHops are optional and default to 1 and infinity respectively. When no bounds are given the dots may be omitted.", "match (martin {name:\"Martin Sheen\"})-[:ACTED_IN*1..2]-(x) return x", "Returns nodes that are 1 or 2 relationships away from Martin.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Charlie"), this.$outer.node("WallStreet"), this.$outer.node("Michael"), this.$outer.node("TheAmericanPresident")})), (Object)p.columnAs("x").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void variableLengthPathWithIterableRels() {
        this.testQuery("Relationship identifier in variable length relationships", "When the connection between two nodes is of variable length, a relationship identifier becomes an collection of relationships.", "match (actor {name:'Charlie Sheen'})-[r:ACTED_IN*2]-(co_actor) return r", "The query returns a collection of relationships.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.size());
            }
        }}));
    }

    @Test
    public void zeroLengthPath() {
        this.testQuery("Zero length paths", "Using variable length paths that have the lower bound zero means that two identifiers can point to the same node. If the distance between two nodes is zero, they are by definition the same node. Note that when matching zero length paths the result may contain a match even when matching on a relationship type not in use.", "match (wallstreet:Movie {title:'Wall Street'})-[*0..1]-(x) return x", "Returns all nodes that are zero or one relationships away from Wall Street.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("WallStreet"), this.$outer.node("Charlie"), this.$outer.node("Michael"), this.$outer.node("Martin"), this.$outer.node("Oliver")})), (Object)p.columnAs("x").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void fixedLengthPath() {
        this.testQuery("Fixed length relationships", "Elements that are a fixed number of hops away can be matched by using [*numberOfHops]. ", "match (michael {name:'Michael Douglas'})-[:ACTED_IN*2]-(co_actor) return co_actor.name", "Returns the 2 nodes connected to Michael by a length-2 chain of ACTED_IN relationships.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Martin Sheen", "Charlie Sheen"})), (Object)p.columnAs("co_actor.name").toSet());
            }
        }}));
    }

    @Test
    public void shortestPathBetweenTwoNodes() {
        this.testQuery("Single shortest path", "Finding a single shortest path between two nodes is as easy as using the `shortestPath` function. It's done like this:", "\nmatch (martin:Person {name:\"Martin Sheen\"} ),\n      (oliver:Person {name:\"Oliver Stone\"}),\n      p = shortestPath( (martin)-[*..15]-(oliver) )\nreturn p", "This means: find a single shortest path between two nodes, as long as the path is max 15 relationships long. Inside of the parentheses\n you define a single link of a path -- the starting node, the connecting relationship and the end node. Characteristics describing the relationship\n like relationship type, max hops and direction are all used when finding the shortest path. You can also mark the path as optional.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)((Path)((MapLike)p.toList().head()).apply((Object)"p")).length());
            }
        }}));
    }

    @Test
    public void allShortestPathsBetweenTwoNodes() {
        this.testQuery("All shortest paths", "Finds all the shortest paths between two nodes.", "\nmatch (martin:Person {name:\"Martin Sheen\"} ),\n      (michael:Person {name:\"Michael Douglas\"}),\n      p = allShortestPaths( (martin)-[*]-(michael) ) return p", "Finds the two shortest paths between Martin and Michael.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.toList().size());
            }
        }}));
    }

    @Test
    public void introduceNamedPath() {
        this.testQuery("Named path", "If you want to return or filter on a path in your pattern graph, you can a introduce a named path.", "match p = (michael {name:'Michael Douglas'})-->() return p", "Returns the two paths starting from Michael.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void match_on_bound_relationship() {
        this.testQuery("Matching on a bound relationship", "When your pattern contains a bound relationship, and that relationship pattern doesn't specify direction,\nCypher will try to match the relationship in both directions.", "match (a)-[r]-(b) where id(r) = 0 return a,b", "This returns the two connected nodes, once as the start node, and once as the end node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.toSeq().length());
            }
        }}));
    }

    @Test
    public void match_with_labels() {
        this.testQuery("Match with labels", "To constrain your pattern with labels on nodes, you add it to your pattern nodes, using the label syntax.", "match (charlie:Person {name:'Charlie Sheen'})--(movie:Movie) return movie", "Return any nodes connected with the +Person+ Charlie that are labeled +Movie+.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("WallStreet")})), (Object)p.columnAs("movie").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void match_with_properties_on_a_variable_length_path() {
        String preparationQuery = "MATCH (charlie:Person {name:'Charlie Sheen'}), (martin:Person {name:'Martin Sheen'})\n      CREATE (charlie)-[:X {blocked:false}]->(:Unblocked)<-[:X {blocked:false}]-(martin)\n      CREATE (charlie)-[:X {blocked:true}]->(:Blocked)<-[:X {blocked:false}]-(martin)";
        Serializable x$1 = new Serializable(this, preparationQuery){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;
            private final String preparationQuery$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executePreparationQueries((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.preparationQuery$1})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.preparationQuery$1 = preparationQuery$1;
            }
        };
        String x$2 = "Match with properties on a variable length path";
        String x$3 = "A variable length relationship with properties defined on in it means that all relationships in the path\nmust have the property set to the given value. In this query, there are two paths between Charile Sheen and his\ndad Martin Sheen. One of the includes a ``blocked'' relationship and the other doesn't.\nIn this case we first alter the original graph by using the following query to add ``blocked'' and ``unblocked'' relationships:\n\ninclude::includes/match-match-with-properties-on-a-variable-length-path.preparation.asciidoc[]\n\nThis means that we are starting out with the following graph:\n\ninclude::includes/match-match-with-properties-on-a-variable-length-path.preparation-graph.asciidoc[]\n\n";
        String x$4 = "MATCH p = (charlie:Person)-[* {blocked:false}]-(martin:Person) WHERE charlie.name = 'Charlie Sheen' AND martin.name = 'Martin Sheen' RETURN p";
        String x$5 = "Returns the paths between Charlie and Martin Sheen where all relationships have the +blocked+ property set to +FALSE+.";
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchTest $outer;

            public final void apply(ExecutionResult p) {
                Iterable path = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)((Path)((MapLike)p.next()).apply((Object)"p"))).asScala();
                this.$outer.assertionsHelper().macroAssert(!path.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(PropertyContainer x0$1) {
                        boolean bl;
                        PropertyContainer propertyContainer = x0$1;
                        if (propertyContainer instanceof Node) {
                            Node node2 = (Node)propertyContainer;
                            bl = node2.hasLabel(DynamicLabel.label((String)"Blocked"));
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                }), (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$2, x$3, x$4, x$5, (Function0<Object>)x$1, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$6);
    }
}

