/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.MergeConstraintConflictException;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u0011\u0011\"T3sO\u0016$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0003\u0013\ty!AA\nE_\u000e,X.\u001a8uS:<G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\tQ\u0012+^3ssN#\u0018\r^5ti&\u001c7\u000fV3tiN+\b\u000f]8si\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u0003\u001b\u0001AQ!\u0007\u0001\u0005Ri\t\u0001cZ3u\u000fJ\f\u0007\u000f\u001b<juN#\u0018\u0010\\3\u0016\u0003m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u0011\u001d\u0014\u0018\r\u001d5wSjT!\u0001\t\u0004\u0002\u001bYL7/^1mSj\fG/[8o\u0013\t\u0011SD\u0001\u0006He\u0006\u0004\bn\u0015;zY\u0016DQ\u0001\n\u0001\u0005\u0002\u0015\nqa]3di&|g.F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0007\"B\u0018\u0001\t\u0003\u0002\u0014\u0001E4sCBDG)Z:de&\u0004H/[8o+\u0005\t\u0004c\u0001\u001a:M5\t1G\u0003\u00025k\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003m]\n!bY8mY\u0016\u001cG/[8o\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e4\u0005\u0011a\u0015n\u001d;\t\u000fq\u0002!\u0019!C!{\u0005Q\u0001O]8qKJ$\u0018.Z:\u0016\u0003y\u0002BAM '\u0003&\u0011\u0001i\r\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002\u001a@M\u0019Baa\u0011\u0001!\u0002\u0013q\u0014a\u00039s_B,'\u000f^5fg\u0002Bq!\u0012\u0001C\u0002\u0013\u0005\u0003'\u0001\ftKR,\boQ8ogR\u0014\u0018-\u001b8u#V,'/[3t\u0011\u00199\u0005\u0001)A\u0005c\u000592/\u001a;va\u000e{gn\u001d;sC&tG/U;fe&,7\u000f\t\u0005\u0006\u0013\u0002!\tAS\u0001\u001d[\u0016\u0014x-Z0tS:<G.Z0o_\u0012,wl^5uQ~c\u0017MY3m)\u0005Y\u0005C\u0001'N\u001b\u00059\u0014B\u0001(8\u0005\u0011)f.\u001b;)\u0005!\u0003\u0006CA)U\u001b\u0005\u0011&BA*\t\u0003\u0015QWO\\5u\u0013\t)&K\u0001\u0003UKN$\b\"B,\u0001\t\u0003Q\u0015!I7fe\u001e,wl]5oO2,wL\\8eK~;\u0018\u000e\u001e5`aJ|\u0007/\u001a:uS\u0016\u001c\bF\u0001,Q\u0011\u0015Q\u0006\u0001\"\u0001K\u0003%jWM]4f?NLgn\u001a7f?:|G-Z0xSRDw\f\\1cK2|\u0016M\u001c3`aJ|\u0007/\u001a:us\"\u0012\u0011\f\u0015\u0005\u0006;\u0002!\tAS\u0001([\u0016\u0014x-Z0o_\u0012,w,\u00198e?N,Go\u00189s_B,'\u000f^=`_:|6M]3bi&|g\u000e\u000b\u0002]!\")\u0001\r\u0001C\u0001\u0015\u0006!S.\u001a:hK~sw\u000eZ3`C:$wl]3u?B\u0014x\u000e]3sif|vN\\0nCR\u001c\u0007\u000e\u000b\u0002`!\")1\r\u0001C\u0001\u0015\u00061T.\u001a:hK~sw\u000eZ3`C:$wl]3u?B\u0014x\u000e]3sif|vN\\0de\u0016\fG/[8o?>\u0014x,\u001e9eCR,w\f\u001d:pa\"\u0012!\r\u0015\u0005\u0006M\u0002!\tAS\u0001+[\u0016\u0014x-Z0b]\u0012|6/\u001a;`[VdG/\u001b9mK~\u0003(o\u001c9feRLWm]0p]~k\u0017\r^2iQ\t)\u0007\u000bC\u0003j\u0001\u0011\u0005!*\u0001\u0017nKJ<Wm\u00188pI\u0016|\u0016M\u001c3`GJ,\u0017\r^3`o&$\bnX;oSF,XmX2p]N$(/Y5oi\"\u0012\u0001\u000e\u0015\u0005\u0006Y\u0002!\tAS\u0001,[\u0016\u0014x-Z0o_\u0012,w,\u00198e?6\fGo\u00195`o&$\bnX;oSF,XmX2p]N$(/Y5oi\"\u00121\u000e\u0015\u0005\u0006_\u0002!\tAS\u0001K[\u0016\u0014x-Z0o_\u0012,w,\u00198e?6\fGo\u00195`[\u0006t\u0017pX<ji\"|VO\\5rk\u0016|6m\u001c8tiJ\f\u0017N\u001c;`M\u0006LGn]0g_J|\u0006/\u0019:uS\u0006dw,\\1uG\",7\u000f\u000b\u0002o!\")!\u000f\u0001C\u0001\u0015\u0006qU.\u001a:hK~sw\u000eZ3`C:$w,\\1uG\"|V.\u00198z?^LG\u000f[0v]&\fX/Z0d_:\u001cHO]1j]R|f-Y5mg~3wN]0d_:4G.[2uS:<w,\\1uG\",7\u000f\u000b\u0002r!\")Q\u000f\u0001C\u0001\u0015\u0006yRo]5oO~k\u0017\r]0qCJ\fW.\u001a;feN|v/\u001b;i?6,'oZ3)\u0005Q\u0004\u0006\"\u0002=\u0001\t\u0003Q\u0015\u0001I7fe\u001eLgnZ0p]~\u000bwl]5oO2,wL]3mCRLwN\\:iSBD#a\u001e)\t\u000bm\u0004A\u0011\u0001&\u000275,'oZ5oO~{gnX1`Y>tw-\u001a:`a\u0006$H/\u001a:oQ\tQ\b\u000bC\u0003\u007f\u0001\u0011\u0005!*\u0001\u0012nKJ<\u0017N\\4`_:|VO\u001c3je\u0016\u001cG/\u001a3`e\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u0015\u0003{B\u0003")
public class MergeTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    private final Map<String, Map<String, String>> properties;
    private final List<String> setupConstraintQueries;

    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "Merge";
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Charlie:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN WallStreet:Movie", "Michael:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN TheAmericanPresident:Movie", "Michael:Person ACTED_IN TheAmericanPresident:Movie", "Oliver:Person DIRECTED WallStreet:Movie", "Rob:Person DIRECTED TheAmericanPresident:Movie", "Charlie:Person FATHER Martin:Person"}));
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public List<String> setupConstraintQueries() {
        return this.setupConstraintQueries;
    }

    @Test
    public void merge_single_node_with_label() {
        this.testQuery("Merge single node with a label", "Merging a single node with a given label.", "merge (robert:Critic)\nreturn robert, labels(robert)", "Because there are no nodes labeled +Critic+ in the database, a new node is created.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$1 = p;
                int x$2 = 1;
                int x$3 = 1;
                int x$4 = this.$outer.assertStats$default$3();
                int x$5 = this.$outer.assertStats$default$4();
                int x$6 = this.$outer.assertStats$default$5();
                int x$7 = this.$outer.assertStats$default$6();
                int x$8 = this.$outer.assertStats$default$8();
                int x$9 = this.$outer.assertStats$default$9();
                int x$10 = this.$outer.assertStats$default$10();
                int x$11 = this.$outer.assertStats$default$11();
                int x$12 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$1, x$2, x$4, x$5, x$6, x$7, x$3, x$8, x$9, x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_single_node_with_properties() {
        this.testQuery("Merge single node with properties", "Merging a single node with properties where not all properties match any existing node.", "merge (charlie {name:'Charlie Sheen', age:10})\nreturn charlie", "A new node with the name Charlie Sheen will be created since not all properties matched the existing Charlie Sheen node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$13 = p;
                int x$14 = 1;
                int x$15 = 2;
                int x$16 = this.$outer.assertStats$default$3();
                int x$17 = this.$outer.assertStats$default$5();
                int x$18 = this.$outer.assertStats$default$6();
                int x$19 = this.$outer.assertStats$default$7();
                int x$20 = this.$outer.assertStats$default$8();
                int x$21 = this.$outer.assertStats$default$9();
                int x$22 = this.$outer.assertStats$default$10();
                int x$23 = this.$outer.assertStats$default$11();
                int x$24 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$13, x$14, x$16, x$15, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_single_node_with_label_and_property() {
        this.testQuery("Merge single node specifying both label and property", "Merging a single node with both label and property matching an existing node.", "merge (michael:Person {name:'Michael Douglas'})\nreturn michael", "Michael Douglas will be matched and returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$25 = p;
                int x$26 = 0;
                int x$27 = 0;
                int x$28 = this.$outer.assertStats$default$3();
                int x$29 = this.$outer.assertStats$default$5();
                int x$30 = this.$outer.assertStats$default$6();
                int x$31 = this.$outer.assertStats$default$7();
                int x$32 = this.$outer.assertStats$default$8();
                int x$33 = this.$outer.assertStats$default$9();
                int x$34 = this.$outer.assertStats$default$10();
                int x$35 = this.$outer.assertStats$default$11();
                int x$36 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$25, x$26, x$28, x$27, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_set_property_on_creation() {
        this.testQuery("Merge with ON CREATE", "Merge a node and set properties if the node needs to be created.", "merge (keanu:Person {name:'Keanu Reeves'})\non create set keanu.created = timestamp()\nreturn keanu", "Creates the Keanu node, and sets a timestamp on creation time.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$37 = p;
                int x$38 = 1;
                int x$39 = 2;
                int x$40 = 1;
                int x$41 = this.$outer.assertStats$default$3();
                int x$42 = this.$outer.assertStats$default$5();
                int x$43 = this.$outer.assertStats$default$6();
                int x$44 = this.$outer.assertStats$default$8();
                int x$45 = this.$outer.assertStats$default$9();
                int x$46 = this.$outer.assertStats$default$10();
                int x$47 = this.$outer.assertStats$default$11();
                int x$48 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$37, x$38, x$41, x$39, x$42, x$43, x$40, x$44, x$45, x$46, x$47, x$48);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_set_property_on_match() {
        this.testQuery("Merge with ON MATCH", "Merging nodes and setting properties on found nodes.", "merge (person:Person)\non match set person.found = true\nreturn person", "Finds all the +Person+ nodes, sets a property on them, and returns them.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$49 = p;
                int x$50 = 5;
                int x$51 = this.$outer.assertStats$default$2();
                int x$52 = this.$outer.assertStats$default$3();
                int x$53 = this.$outer.assertStats$default$5();
                int x$54 = this.$outer.assertStats$default$6();
                int x$55 = this.$outer.assertStats$default$7();
                int x$56 = this.$outer.assertStats$default$8();
                int x$57 = this.$outer.assertStats$default$9();
                int x$58 = this.$outer.assertStats$default$10();
                int x$59 = this.$outer.assertStats$default$11();
                int x$60 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$49, x$51, x$52, x$50, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_set_property_on_creation_or_update_prop() {
        this.testQuery("Merge with ON CREATE and ON MATCH", "Merge a node and set properties if the node needs to be created.", "merge (keanu:Person {name:'Keanu Reeves'})\non create set keanu.created = timestamp()\non match set keanu.lastSeen = timestamp()\nreturn keanu", "The query creates the Keanu node, and sets a timestamp on creation time. If Keanu already existed, a different property would have been set.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$61 = p;
                int x$62 = 1;
                int x$63 = 2;
                int x$64 = 1;
                int x$65 = this.$outer.assertStats$default$3();
                int x$66 = this.$outer.assertStats$default$5();
                int x$67 = this.$outer.assertStats$default$6();
                int x$68 = this.$outer.assertStats$default$8();
                int x$69 = this.$outer.assertStats$default$9();
                int x$70 = this.$outer.assertStats$default$10();
                int x$71 = this.$outer.assertStats$default$11();
                int x$72 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$61, x$62, x$65, x$63, x$66, x$67, x$64, x$68, x$69, x$70, x$71, x$72);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_and_set_multiple_properties_on_match() {
        this.testQuery("Merge with ON MATCH setting multiple properties", "If multiple properties should be set, simply separate them with commas.", new StringOps(Predef$.MODULE$.augmentString("merge (person:Person)\n                    |on match set person.found = true, person.lastAccessed = timestamp()\n                    |return person")).stripMargin(), "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$73 = p;
                int x$74 = 10;
                int x$75 = this.$outer.assertStats$default$2();
                int x$76 = this.$outer.assertStats$default$3();
                int x$77 = this.$outer.assertStats$default$5();
                int x$78 = this.$outer.assertStats$default$6();
                int x$79 = this.$outer.assertStats$default$7();
                int x$80 = this.$outer.assertStats$default$8();
                int x$81 = this.$outer.assertStats$default$9();
                int x$82 = this.$outer.assertStats$default$10();
                int x$83 = this.$outer.assertStats$default$11();
                int x$84 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$73, x$75, x$76, x$74, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_create_with_unique_constraint() {
        this.testQuery("Merge using unique constraints creates a new node if no node is found", "Merge using unique constraints creates a new node if no node is found.", "merge (laurence:Person {name: 'Laurence Fishburne'}) return laurence", "The query creates the laurence node. If laurence already existed, merge would just return the existing node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$85 = p;
                int x$86 = 1;
                int x$87 = 1;
                int x$88 = 1;
                int x$89 = this.$outer.assertStats$default$3();
                int x$90 = this.$outer.assertStats$default$5();
                int x$91 = this.$outer.assertStats$default$6();
                int x$92 = this.$outer.assertStats$default$8();
                int x$93 = this.$outer.assertStats$default$9();
                int x$94 = this.$outer.assertStats$default$10();
                int x$95 = this.$outer.assertStats$default$11();
                int x$96 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$85, x$86, x$89, x$87, x$90, x$91, x$88, x$92, x$93, x$94, x$95, x$96);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_match_with_unique_constraint() {
        this.testQuery("Merge using unique constraints matches an existing node", "Merge using unique constraints matches an existing node.", "merge (oliver:Person {name:'Oliver Stone'}) return oliver", "The oliver node already exists, so merge just returns it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$97 = p;
                int x$98 = 0;
                int x$99 = 0;
                int x$100 = 0;
                int x$101 = this.$outer.assertStats$default$3();
                int x$102 = this.$outer.assertStats$default$5();
                int x$103 = this.$outer.assertStats$default$6();
                int x$104 = this.$outer.assertStats$default$8();
                int x$105 = this.$outer.assertStats$default$9();
                int x$106 = this.$outer.assertStats$default$10();
                int x$107 = this.$outer.assertStats$default$11();
                int x$108 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$97, x$98, x$101, x$99, x$102, x$103, x$100, x$104, x$105, x$106, x$107, x$108);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merge_node_and_match_many_with_unique_constraint_fails_for_partial_matches() {
        this.generateConsole_$eq(false);
        this.testFailingQuery("Merge with unique constraints and partial matches", "Merge using unique constraints fails when finding partial matches.", "merge (michael:Person {name:'Michael Douglas', role:'Gordon Gekko'}) return michael", "While there is a matching unique michael node with the name 'Michael Douglas', there is no unique node with the role of 'Gordon Gekko' and merge fails to match.", ClassTag$.MODULE$.apply(MergeConstraintConflictException.class));
    }

    @Test
    public void merge_node_and_match_many_with_unique_constraint_fails_for_conflicting_matches() {
        this.generateConsole_$eq(false);
        this.testFailingQuery("Merge with unique constraints and conflicting matches", "Merge using unique constraints fails when finding conflicting matches.", "merge (oliver:Person {name:'Oliver Stone', role:'Gordon Gekko'}) return oliver", "While there is a matching unique oliver node with the name 'Oliver Stone', there is also another unique node with the role of 'Gordon Gekko' and merge fails to match.", ClassTag$.MODULE$.apply(MergeConstraintConflictException.class));
    }

    @Test
    public void using_map_parameters_with_merge() {
        String x$121 = "Using map parameters with MERGE";
        String x$122 = "+MERGE+ does not support map parameters like for example +CREATE+ does.\nTo use map parameters with +MERGE+, it is necessary to explicitly use the expected properties, like in the following example.\nFor more information on parameters, see <<cypher-parameters>>.";
        Serializable x$123 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"param"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Keanu Reeves"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"role"), (Object)"Neo")})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$124 = "merge (oliver:Person {name:{param}.name, role:{param}.role}) return oliver";
        String x$125 = "";
        Seq x$126 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$109 = p;
                int x$110 = 1;
                int x$111 = 2;
                int x$112 = 1;
                int x$113 = this.$outer.assertStats$default$3();
                int x$114 = this.$outer.assertStats$default$5();
                int x$115 = this.$outer.assertStats$default$6();
                int x$116 = this.$outer.assertStats$default$8();
                int x$117 = this.$outer.assertStats$default$9();
                int x$118 = this.$outer.assertStats$default$10();
                int x$119 = this.$outer.assertStats$default$11();
                int x$120 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$109, x$110, x$113, x$111, x$114, x$115, x$112, x$116, x$117, x$118, x$119, x$120);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$121, x$122, x$124, x$125, (Function0<Object>)x$123, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$126);
    }

    @Test
    public void merging_on_a_single_relationship() {
        this.testQuery("Merge on a relationship", "+MERGE+ can be used to match or create a relationship.", "match (charlie:Person {name:'Charlie Sheen'}), (wallStreet:Movie {title:'Wall Street'})\nmerge (charlie)-[r:ACTED_IN]->(wallStreet)\nreturn r", "Charlie Sheen had already been marked as acting on Wall Street, so the existing relationship is found and returned. Note that in order to match or create a relationship when using +MERGE+, at least one bound node must be specified, which is done via the +MATCH+ clause in the above example.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$127 = p;
                int x$128 = 0;
                int x$129 = this.$outer.assertStats$default$2();
                int x$130 = this.$outer.assertStats$default$4();
                int x$131 = this.$outer.assertStats$default$5();
                int x$132 = this.$outer.assertStats$default$6();
                int x$133 = this.$outer.assertStats$default$7();
                int x$134 = this.$outer.assertStats$default$8();
                int x$135 = this.$outer.assertStats$default$9();
                int x$136 = this.$outer.assertStats$default$10();
                int x$137 = this.$outer.assertStats$default$11();
                int x$138 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$127, x$129, x$128, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merging_on_a_longer_pattern() {
        this.testQuery("Merge on multiple relationships", "When +MERGE+ is used on a whole pattern, either everything matches, or everything is created.", "match (oliver:Person {name:'Oliver Stone'}), (reiner:Person {name:'Rob Reiner'})\nmerge (oliver)-[:DIRECTED]->(movie:Movie)<-[:ACTED_IN]-(reiner)\nreturn movie", "In our example graph, Oliver Stone and Rob Reiner have never worked together. When we try to +MERGE+ a movie between them, Cypher will not use any of the existing movies already connected to either person. Instead, a new movie node is created.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$139 = p;
                int x$140 = 2;
                int x$141 = 1;
                int x$142 = 0;
                int x$143 = 1;
                int x$144 = this.$outer.assertStats$default$5();
                int x$145 = this.$outer.assertStats$default$6();
                int x$146 = this.$outer.assertStats$default$8();
                int x$147 = this.$outer.assertStats$default$9();
                int x$148 = this.$outer.assertStats$default$10();
                int x$149 = this.$outer.assertStats$default$11();
                int x$150 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$139, x$141, x$140, x$142, x$144, x$145, x$143, x$146, x$147, x$148, x$149, x$150);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void merging_on_undirected_relationship() {
        this.testQuery("Merge on an undirected relationship", "+MERGE+ can also be used with an undirected relationship. When it needs to create a new one, it will pick a direction.", "match (charlie:Person {name:'Charlie Sheen'}), (oliver:Person {name:'Oliver Stone'})\nmerge (charlie)-[r:KNOWS]-(oliver)\nreturn r", "Assume that Charlie Sheen and Oliver Stone do not know each other then this +MERGE+ query will create a +:KNOWS+ relationship between them. The direction of the created relationship is arbitrary.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$151 = p;
                int x$152 = 1;
                int x$153 = this.$outer.assertStats$default$2();
                int x$154 = this.$outer.assertStats$default$4();
                int x$155 = this.$outer.assertStats$default$5();
                int x$156 = this.$outer.assertStats$default$6();
                int x$157 = this.$outer.assertStats$default$7();
                int x$158 = this.$outer.assertStats$default$8();
                int x$159 = this.$outer.assertStats$default$9();
                int x$160 = this.$outer.assertStats$default$10();
                int x$161 = this.$outer.assertStats$default$11();
                int x$162 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$151, x$153, x$152, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    public MergeTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
        this.properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Charlie"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Charlie Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Oliver"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Oliver Stone")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Michael"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Michael Douglas")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Rob"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Rob Reiner")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Martin"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Martin Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"WallStreet"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"Wall Street")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"TheAmericanPresident"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"The American President")})))}));
        this.setupConstraintQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE CONSTRAINT ON (n:Person) ASSERT n.name IS UNIQUE", "CREATE CONSTRAINT ON (n:Person) ASSERT n.role IS UNIQUE"}));
    }
}

