/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u0017\t\tr\n\u001d;j_:\fG.T1uG\"$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0003\u0016\u0001\u0011\u0005c#\u0001\the\u0006\u0004\b\u000eR3tGJL\u0007\u000f^5p]V\tq\u0003E\u0002\u0019?\u0005j\u0011!\u0007\u0006\u00035m\t\u0011\"[7nkR\f'\r\\3\u000b\u0005qi\u0012AC2pY2,7\r^5p]*\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!3\t!A*[:u!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0007b\u0002\u0016\u0001\u0005\u0004%\teK\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u0001\u0017\u0011\tai\u0013eL\u0005\u0003]e\u00111!T1q!\u0011AR&I\u0011\t\rE\u0002\u0001\u0015!\u0003-\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\t\u000bM\u0002A\u0011\u000b\u001b\u0002!\u001d,Go\u0012:ba\"4\u0018N_*us2,W#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001C4sCBDg/\u001b>\u000b\u0005i2\u0011!\u0004<jgV\fG.\u001b>bi&|g.\u0003\u0002=o\tQqI]1qQN#\u0018\u0010\\3\t\u000by\u0002A\u0011A \u0002\u000fM,7\r^5p]V\t\u0001\t\u0005\u0002B\u000b:\u0011!iQ\u0007\u0002;%\u0011A)H\u0001\u0007!J,G-\u001a4\n\u0005!2%B\u0001#\u001e\u0011\u0015A\u0005\u0001\"\u0001J\u0003Qy\u0007\u000f^5p]\u0006d'+\u001a7bi&|gn\u001d5jaR\t!\n\u0005\u0002C\u0017&\u0011A*\b\u0002\u0005+:LG\u000f\u000b\u0002H\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bC\u0001\u0006UVt\u0017\u000e^\u0005\u0003'B\u0013A\u0001V3ti\")Q\u000b\u0001C\u0001\u0013\u0006abn\u001c3f!J|\u0007/\u001a:us\u001a\u0013x.\\(qi&|g.\u00197O_\u0012,\u0007F\u0001+O\u0011\u0015A\u0006\u0001\"\u0001J\u0003ey\u0007\u000f^5p]\u0006dG+\u001f9fIJ+G.\u0019;j_:\u001c\b.\u001b9)\u0005]s\u0005")
public class OptionalMatchTest
extends DocumentingTestBase {
    private final Map<String, Map<String, String>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Charlie"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Charlie Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Oliver"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Oliver Stone")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Michael"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Michael Douglas")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Rob"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Rob Reiner")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Martin"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Martin Sheen")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"WallStreet"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"Wall Street")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"TheAmericanPresident"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)"The American President")})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Charlie:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN WallStreet:Movie", "Michael:Person ACTED_IN WallStreet:Movie", "Martin:Person ACTED_IN TheAmericanPresident:Movie", "Michael:Person ACTED_IN TheAmericanPresident:Movie", "Oliver:Person DIRECTED WallStreet:Movie", "Rob:Person DIRECTED TheAmericanPresident:Movie", "Charlie:Person FATHER Martin:Person"}));
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "OPTIONAL MATCH";
    }

    @Test
    public void optionalRelationship() {
        this.testQuery("Relationship", "If a relationship is optional, use the +OPTIONAL+ +MATCH+ clause. This is similar to how a SQL outer join works. If the relationship is there, it is returned. If it's not, +NULL+ is returned in it's place. ", "match (a:Movie {title: 'Wall Street'}) optional match (a)-->(x) return x", "Returns +NULL+, since the node has no outgoing relationships.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Map[] mapArray = new Map[1];
                Tuple2[] tuple2Array = new Tuple2[1];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), null);
                mapArray[0] = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])mapArray)), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void nodePropertyFromOptionalNode() {
        this.testQuery("Properties on optional elements", "Returning a property from an optional element that is +NULL+ will also return +NULL+.", "match (a:Movie {title: 'Wall Street'}) optional match (a)-->(x) return x, x.name", "Returns the element x (`NULL` in this query), and `NULL` as its name.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Map[] mapArray = new Map[1];
                Tuple2[] tuple2Array = new Tuple2[2];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), null);
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x.name"), null);
                mapArray[0] = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])mapArray)), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void optionalTypedRelationship() {
        this.testQuery("Optional typed and named relationship", "Just as with a normal relationship, you can decide which identifier it goes into, and what relationship type you need.", "match (a:Movie {title: 'Wall Street'}) optional match (a)-[r:ACTS_IN]->() return r", "This returns a node, and +NULL+, since the node has no outgoing `ACTS_IN` relationships.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Map[] mapArray = new Map[1];
                Tuple2[] tuple2Array = new Tuple2[1];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"r"), null);
                mapArray[0] = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])mapArray)), (Object)p.toList());
            }
        }}));
    }
}

