/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u0017\tYqJ\u001d3fe\nKH+Z:u\u0015\t\u0019A!\u0001\u0004e_\u000e<WM\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0003\u0013\ty!AA\nE_\u000e,X.\u001a8uS:<G+Z:u\u0005\u0006\u001cX\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011Q\u0002\u0001\u0005\u0006+\u0001!\tEF\u0001\u0011OJ\f\u0007\u000f\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:,\u0012a\u0006\t\u00041}\tS\"A\r\u000b\u0005iY\u0012!C5n[V$\u0018M\u00197f\u0015\taR$\u0001\u0006d_2dWm\u0019;j_:T\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Ae\u0011A\u0001T5tiB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB*ue&tw\rC\u0003+\u0001\u0011E3&\u0001\thKR<%/\u00199im&T8\u000b^=mKV\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005AqM]1qQZL'P\u0003\u00022\r\u0005ia/[:vC2L'0\u0019;j_:L!a\r\u0018\u0003\u0015\u001d\u0013\u0018\r\u001d5TifdW\rC\u00046\u0001\t\u0007I\u0011\t\u001c\u0002\u0015A\u0014x\u000e]3si&,7/F\u00018!\u0011A\u0002(\t\u001e\n\u0005eJ\"aA'baB!\u0001\u0004O\u0011<!\taT(D\u0001\u001e\u0013\tqTDA\u0002J]RDa\u0001\u0011\u0001!\u0002\u00139\u0014a\u00039s_B,'\u000f^5fg\u0002BQA\u0011\u0001\u0005\u0002\r\u000bqa]3di&|g.F\u0001\"\u0011\u0015)\u0005\u0001\"\u0001G\u0003)\u0019xN\u001d;Cs:\u000bW.\u001a\u000b\u0002\u000fB\u0011A\bS\u0005\u0003\u0013v\u0011A!\u00168ji\"\u0012Ai\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\"\tQA[;oSRL!\u0001U'\u0003\tQ+7\u000f\u001e\u0005\u0006%\u0002!\tAR\u0001\u0012g>\u0014HOQ=OC6,'+\u001a<feN,\u0007FA)L\u0011\u0015)\u0006\u0001\"\u0001G\u0003U\u0019xN\u001d;Cs6+H\u000e^5qY\u0016\u001cu\u000e\\;n]ND#\u0001V&\t\u000ba\u0003A\u0011\u0001$\u00025=\u0014H-\u001a:`Ef|f.\u001e7mC\ndWm\u00189s_B,'\u000f^=)\u0005][\u0005")
public class OrderByTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)34)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length"), (Object)BoxesRunTime.boxToInteger((int)170))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"B"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)34))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"C"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)32)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length"), (Object)BoxesRunTime.boxToInteger((int)185))})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A KNOWS B", "B KNOWS C"}));
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public String section() {
        return "Order by";
    }

    @Test
    public void sortByName() {
        this.testQuery("Order nodes by property", "+ORDER BY+ is used to sort the output.", "match (n) return n order by n.name", "The nodes are returned, sorted by their name.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrderByTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A"), this.$outer.node("B"), this.$outer.node("C")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void sortByNameReverse() {
        this.testQuery("Order nodes in descending order", "By adding +DESC[ENDING]+ after the identifier to sort on, the sort will be done in reverse order.", "match (n) return n order by n.name DESC", "The example returns the nodes, sorted by their name reversely.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrderByTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("C"), this.$outer.node("B"), this.$outer.node("A")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void sortByMultipleColumns() {
        this.testQuery("Order nodes by multiple properties", "You can order by multiple properties by stating each identifier in the +ORDER BY+ clause. Cypher will sort the result by the first identifier listed, and for equals values, go to the next property in the `ORDER BY` clause, and so on.", "match (n) return n order by n.age, n.name", "This returns the nodes, sorted first by their age, and then by their name.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrderByTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("C"), this.$outer.node("A"), this.$outer.node("B")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void order_by_nullable_property() {
        this.testQuery("Ordering NULL", "When sorting the result set, +NULL+ will always come at the end of the result set for ascending sorting, and first when doing descending sort.", "match (n) return n.length, n order by n.length", "The nodes are returned sorted by the length property, with a node without that property last.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OrderByTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A"), this.$outer.node("C"), this.$outer.node("B")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }
}

