/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.ArticleTest;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u0017\tY\u0001+\u0019;uKJtG+Z:u\u0015\t\u0019A!\u0001\u0004e_\u000e<WM\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0003\u0013\ty!AA\u0006BeRL7\r\\3UKN$\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0004\u0016\u0001\t\u0007I\u0011\t\f\u0002\u0015%tG-\u001a=Qe>\u00048/F\u0001\u0018!\rA\"%\n\b\u00033}q!AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\"\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AH\u0005\u0003G\u0011\u0012A\u0001T5ti*\u0011\u0001%\t\t\u0003M)r!a\n\u0015\u000e\u0003\u0005J!!K\u0011\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S\u0005BaA\f\u0001!\u0002\u00139\u0012aC5oI\u0016D\bK]8qg\u0002BQ\u0001\r\u0001\u0005\u0002E\na!Y:tKJ$Hc\u0001\u001a6oA\u0011qeM\u0005\u0003i\u0005\u0012A!\u00168ji\")ag\fa\u0001K\u0005!a.Y7f\u0011\u0015At\u00061\u0001:\u0003\u0019\u0011Xm];miB\u0011!hO\u0007\u0002\t%\u0011A\b\u0002\u0002\u0010\u000bb,7-\u001e;j_:\u0014Vm];mi\"9a\b\u0001b\u0001\n\u0003y\u0014\u0001E4sCBDG)Z:de&\u0004H/[8o+\u0005\u0001\u0005cA!G\u000f6\t!I\u0003\u0002D\t\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u000b\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0019#\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!aK%\t\r=\u0003\u0001\u0015!\u0003A\u0003E9'/\u00199i\t\u0016\u001c8M]5qi&|g\u000e\t\u0005\b#\u0002\u0011\r\u0011\"\u0011S\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002'B!\u0011\tV$W\u0013\t)&IA\u0002NCB\u0004B!\u0011+H\u000f\"1\u0001\f\u0001Q\u0001\nM\u000b1\u0002\u001d:pa\u0016\u0014H/[3tA!9!\f\u0001b\u0001\n\u0003Y\u0016!\u0002;ji2,W#A$\t\ru\u0003\u0001\u0015!\u0003H\u0003\u0019!\u0018\u000e\u001e7fA!9q\f\u0001b\u0001\n\u0003Y\u0016aB:fGRLwN\u001c\u0005\u0007C\u0002\u0001\u000b\u0011B$\u0002\u0011M,7\r^5p]\u0002Bqa\u0019\u0001C\u0002\u0013\u00051,\u0001\u0003uKb$\bBB3\u0001A\u0003%q)A\u0003uKb$\b\u0005")
public class PatternTest
extends ArticleTest {
    private final List<String> indexProps = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
    private final List<String> graphDescription = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A KNOWS B", "A KNOWS C", "A KNOWS D", "B KNOWS E", "C KNOWS E", "D KNOWS F"}));
    private final Map<String, Map<String, String>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Anders")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"B"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Becky")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"C"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Cesar")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"D"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Dilshad")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"E"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Emil")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"F"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Filipa")})))}));
    private final String title;
    private final String section;
    private final String text;

    @Override
    public List<String> indexProps() {
        return this.indexProps;
    }

    @Override
    public void assert(String name, ExecutionResult result) {
    }

    @Override
    public List<String> graphDescription() {
        return this.graphDescription;
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String section() {
        return this.section;
    }

    @Override
    public String text() {
        return this.text;
    }

    public PatternTest() {
        this.title = "Pattern";
        this.section = "Introduction";
        this.text = "\nPatterns\n========\n\nPatterns and pattern-matching are at the very heart of Cypher, so being effective with Cypher requires a good understanding of patterns.\n\nUsing patterns, you describe the shape of the data you're looking for. For example, in the `MATCH` clause you describe the shape with a pattern, and Cypher will figure out how to get that data for you.\n\nThe pattern describes the data using a form that is very similar to how one typically draws the shape of property graph data on a whiteboard: usually as circles (representing nodes) and arrows between them to represent relationships.\n\nPatterns appear in multiple places in Cypher: in `MATCH`, `CREATE` and `MERGE` clauses, and in pattern expressions. Each of these\nis described in more details in:\n\n* <<query-match>>\n* <<query-optional-match>>\n* <<query-create>>\n* <<query-merge>>\n* <<query-where-patterns>>\n\n== Patterns for nodes ==\n\nThe very simplest ``shape'' that can be described in a pattern is a node. A node is described using a pair of parentheses, and is typically given a name.\nFor example:\n\n+`(a)`+\n\nThis simple pattern describes a single node, and names that node using the identifier `a`.\n\nNote that the parentheses may be omitted, but only when there are no labels or properties specified for the node pattern.\n\n== Patterns for related nodes ==\n\nMore interesting is patterns that describe multiple nodes and relationships between them.\nCypher patterns describe relationships by employing an arrow between two nodes.\nFor example:\n\n+`(a)-->(b)`+\n\nThis pattern describes a very simple data shape: two nodes, and a single relationship from one to the other.\nIn this example, the two nodes are both named as `a` and `b` respectively, and the relationship is ``directed'': it goes from `a` to `b`.\n\nThis way of describing nodes and relationships can be extended to cover an arbitrary number of nodes and the relationships between them, for example:\n\n+`(a)-->(b)<--(c)`+\n\nSuch a series of connected nodes and relationships is called a \"path\".\n\nNote that the naming of the nodes in these patterns is only necessary should one need to refer to the same node again, either later in the pattern or elsewhere in the Cypher query.\nIf this is not necessary then the name may be omitted, like so:\n\n+`(a)-->()<--(c)`+\n\n== Labels ==\n\nIn addition to simply describing the shape of a node in the pattern, one can also describe attributes.\nThe most simple attribute that can be described in the pattern is a label that the node must have.\nFor example:\n\n+`(a:User)-->(b)`+\n\nOne can also describe a node that has multiple labels:\n\n+`(a:User:Admin)-->(b)`+\n\n== Specifying properties ==\n\nNodes and relationships are the fundamental structures in a graph. Neo4j uses properties on both of these to allow for far richer models.\n\nProperties can be expressed in patterns using a map-construct: curly brackets surrounding a number of key-expression pairs, separated by commas.\nE.g. a node with two properties on it would look like:\n+`(a { name: \"Andres\", sport: \"Brazilian Ju-Jitsu\" })`.+\n\nA relationship with expectations on it would could look like:\n+`(a)-[{blocked: false}]->(b)`.+\n\nWhen properties appear in patterns, they add an additional constraint to the shape of the data.\nIn the case of a `CREATE` clause, the properties will be set in the newly created nodes and relationships.\nIn the case of a `MERGE` clause, the properties will be used as additional constraints on the shape any existing data must have (the specified properties must exactly match any existing data in the graph).\nIf no matching data is found, then `MERGE` behaves like `CREATE` and the properties will be set in the newly created nodes and relationships.\n\nNote that patterns supplied to `CREATE` may use a single parameter to specify properties, e.g: `CREATE (node {paramName})`.\nThis is not possible with patterns used in other clauses, as Cypher needs to know the property names at the time the query is compiled, so that matching can be done effectively.\n\n== Describing relationships ==\n\nThe simplest way to describe a relationship is by using the arrow between two nodes, as in the previous examples.\nUsing this technique, you can describe that the relationship should exist and the directionality of it.\nIf you don't care about the direction of the relationship, the arrow head can be omitted, like so:\n\n+`(a)--(b)`+\n\nAs with nodes, relationships may also be given names.\nIn this case, a pair of square brackets is used to break up the arrow and the identifier is placed between.\nFor example:\n\n+`(a)-[r]->(b)`+\n\nMuch like labels on nodes, relationships can have types.\nTo describe a relationship with a specific type, you can specify this like so:\n\n+`(a)-[r:REL_TYPE]->(b)`+\n\nUnlike labels, relationships can only have one type.\nBut if we'd like to describe some data such that the relationship could have any one of a set of types, then they can all be listed in the pattern, separating them with the pipe symbol `|` like this:\n\n+`(a)-[r:TYPE1|TYPE2]->(b)`+\n\nNote that this form of pattern can only be used to describe existing data (ie. when using a pattern with `MATCH` or as an expression).\nIt will not work with `CREATE` or `MERGE`, since it's not possible to create a relationship with multiple types.\n\nAs with nodes, the name of the relationship can always be omitted, in this case like so:\n\n+`(a)-[:REL_TYPE]->(b)`+\n\n=== Variable length ===\n\nRather than describing a long path using a sequence of many node and relationship descriptions in a pattern, many relationships (and the intermediate nodes) can be described by specifying a length in the relationship description of a pattern.\nFor example:\n\n+`(a)-[*2]->(b)`+\n\nThis describes a graph of three nodes and two relationship, all in one path (a path of length 2).\nThis is equivalent to:\n\n+`(a)-->()-->(b)`+\n\nA range of lengths can also be specified: such relationship patterns are called ``variable length relationships''.\nFor example:\n\n+`(a)-[*3..5]->(b)`+\n\nThis is a minimum length of 3, and a maximum of 5.\nIt describes a graph of either 4 nodes and 3 relationships, 5 nodes and 4 relationships or 6 nodes and 5 relationships, all connected together in a single path.\n\nEither bound can be omitted. For example, to describe paths of length 3 or more, use:\n\n+`(a)-[*3..]->(b)`+\n\nAnd to describe paths of length 5 or less, use:\n\n+`(a)-[*..5]->(b)`+\n\nBoth bounds can be omitted, allowing paths of any length to be described:\n\n+`(a)-[*]->(b)`+\n\nAs a simple example, let's take the query below:\n\n###\nMATCH (me)-[:KNOWS*1..2]-(remote_friend)\nWHERE me.name = \"Filipa\"\nRETURN remote_friend.name###\n\nThis query finds data in the graph which a shape that fits the pattern: specifically a node (with the name property +Filipa+) and then the +KNOWS+ related nodes, one or two steps out.\nThis is a typical example of finding first and second degree friends.\n\nNote that variable length relationships can not be used with `CREATE` and `MERGE`.\n\n== Assigning to path identifiers ==\n\nAs described above, a series of connected nodes and relationships is called a \"path\". Cypher allows paths to be named\nusing an identifer, like so:\n\n+`p = (a)-[*3..5]->(b)`+\n\nYou can do this in `MATCH`, `CREATE` and `MERGE`, but not when using patterns as expressions.";
    }
}

