/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001-\u0011Q\"U;fef\u0004F.\u00198UKN$(BA\u0002\u0005\u0003\u0019!wnY4f]*\u0011QAB\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005\u001dA\u0011!\u00028f_RR'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005M!unY;nK:$\u0018N\\4UKN$()Y:f\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000e\u0001!9Q\u0003\u0001b\u0001\n\u00032\u0012\u0001D:fiV\u0004\u0018+^3sS\u0016\u001cX#A\f\u0011\u0007ay\u0012%D\u0001\u001a\u0015\tQ2$A\u0005j[6,H/\u00192mK*\u0011A$H\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001J\"\u0001\u0002'jgR\u0004\"A\t\u0014\u000f\u0005\r\"S\"A\u000f\n\u0005\u0015j\u0012A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!J\u000f\t\r)\u0002\u0001\u0015!\u0003\u0018\u00035\u0019X\r^;q#V,'/[3tA!9A\u0006\u0001b\u0001\n\u00032\u0012AF:fiV\u00048i\u001c8tiJ\f\u0017N\u001c;Rk\u0016\u0014\u0018.Z:\t\r9\u0002\u0001\u0015!\u0003\u0018\u0003]\u0019X\r^;q\u0007>t7\u000f\u001e:bS:$\u0018+^3sS\u0016\u001c\b\u0005C\u00031\u0001\u0011\u0005\u0011'A\u0004tK\u000e$\u0018n\u001c8\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\t9C\u0007C\u0003;\u0001\u0011\u00051(\u0001\u0007bY2tu\u000eZ3t'\u000e\fg\u000eF\u0001=!\t\u0019S(\u0003\u0002?;\t!QK\\5uQ\tI\u0004\t\u0005\u0002B\t6\t!I\u0003\u0002D\u0011\u0005)!.\u001e8ji&\u0011QI\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0003H\u0001\u0011\u00051(A\bo_\u0012,')\u001f'bE\u0016d7kY1oQ\t1\u0005\tC\u0003K\u0001\u0011\u00051(A\bo_\u0012,')_%oI\u0016D8+Z3lQ\tI\u0005\tC\u0003N\u0001\u0011\u00051(A\u000bo_\u0012,')_+oSF,X-\u00138eKb\u001cV-Z6)\u00051\u0003\u0005\"\u0002)\u0001\t\u0003Y\u0014\u0001\u00048pI\u0016\u0014\u00150\u00133TK\u0016\\\u0007FA(A\u0011\u0015\u0019\u0006\u0001\"\u0001<\u0003)\u0001(o\u001c6fGRLwN\u001c\u0015\u0003%\u0002CQA\u0016\u0001\u0005\u0002m\n\u0011b]3mK\u000e$\u0018n\u001c8)\u0005U\u0003\u0005\"B-\u0001\t\u0003Y\u0014\u0001E2beR,7/[1o!J|G-^2uQ\tA\u0006\tC\u0003]\u0001\u0011\u00051(A\u0007paRLwN\\1m\u001b\u0006$8\r\u001b\u0015\u00037\u0002CQa\u0018\u0001\u0005\u0002m\nab\u001c9uS>t\u0017\r\\#ya\u0006tG\r\u000b\u0002_\u0001\")!\r\u0001C\u0001w\u0005\tbn\u001c3f\u001fV$XM\u001d%bg\"Tu.\u001b8)\u0005\u0005\u0004\u0005\"B3\u0001\t\u0003Y\u0014\u0001B:peRD#\u0001\u001a!\t\u000b!\u0004A\u0011A\u001e\u0002\u0017M|'\u000f^3e\u0019&l\u0017\u000e\u001e\u0015\u0003O\u0002CQa\u001b\u0001\u0005\u0002m\nQ\u0001\\5nSRD#A\u001b!\t\u000b9\u0004A\u0011A\u001e\u0002\r\u0015D\b/\u00198eQ\ti\u0007\tC\u0003r\u0001\u0011\u00051(A\u0005tK6L\u0017\t\u001d9ms\"\u0012\u0001\u000f\u0011\u0005\u0006i\u0002!\taO\u0001\u0012g\u0016dWm\u0019;PeN+W.[!qa2L\bFA:A\u0011\u00159\b\u0001\"\u0001<\u00035\tg\u000e^5TK6L\u0017\t\u001d9ms\"\u0012a\u000f\u0011\u0005\u0006u\u0002!\taO\u0001\u0016g\u0016dWm\u0019;Pe\u0006sG/[*f[&\f\u0005\u000f\u001d7zQ\tI\b\tC\u0003~\u0001\u0011\u00051(\u0001\reSJ,7\r^3e%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\"z\u0013\u0012D#\u0001 !\t\r\u0005\u0005\u0001\u0001\"\u0001<\u0003i)h\u000eZ5sK\u000e$X\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004()_%eQ\ty\b\t\u0003\u0004\u0002\b\u0001!\taO\u0001\r]>$W\rS1tQ*{\u0017N\u001c\u0015\u0004\u0003\u000b\u0001\u0005BBA\u0007\u0001\u0011\u00051(\u0001\u0003tW&\u0004\bfAA\u0006\u0001\"1\u00111\u0003\u0001\u0005\u0002m\nQ!\u00199qYfD3!!\u0005A\u0011\u0019\tI\u0002\u0001C\u0001w\u0005)QO\\5p]\"\u001a\u0011q\u0003!")
public class QueryPlanTest
extends DocumentingTestBase {
    private final List<String> setupQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("CREATE (me:Person {name:'me'})\n       CREATE (andres:Person {name:'Andres'})\n       CREATE (andreas:Person {name:'Andreas'})\n       CREATE (malmo:Location {name:'Malmo'})\n       CREATE (london:Location {name:'London'})\n       CREATE (england:Country {name:'England'})\n       CREATE (field:Team {name:'Field'})\n       CREATE (engineering:Team {name:'Engineering'})\n       CREATE (me)-[:WORKS_IN {duration: 190}]->(london)\n       CREATE (london)-[:IN]->(england)\n       CREATE (me)-[:FRIENDS_WITH]->(andres)\n       CREATE (andres)-[:FRIENDS_WITH]->(andreas)\n    ")).stripMargin()}));
    private final List<String> setupConstraintQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("CREATE INDEX ON :Location(name)")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("CREATE CONSTRAINT ON (team:Team) ASSERT team.name is UNIQUE")).stripMargin()}));

    @Override
    public List<String> setupQueries() {
        return this.setupQueries;
    }

    @Override
    public List<String> setupConstraintQueries() {
        return this.setupConstraintQueries;
    }

    @Override
    public String section() {
        return "Query Plan";
    }

    @Test
    public void allNodesScan() {
        this.profileQuery("All Nodes Scan", new StringOps(Predef$.MODULE$.augmentString("Reads all nodes from the node store. The identifier that will contain the nodes is seen in the arguments.\n          |The following query will return all nodes. It's not a good idea to run a query like this on a production database.")).stripMargin(), "MATCH (n) RETURN n", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"AllNodesScan"));
            }
        }}));
    }

    @Test
    public void nodeByLabelScan() {
        this.profileQuery("Node by label scan", new StringOps(Predef$.MODULE$.augmentString("Using the label index, fetches all nodes with a specific label on them.\n                |The following query will return all nodes which have label 'Person' where the property 'name' has the value 'me' via a scan of the Person label index")).stripMargin(), "MATCH (person:Person {name: \"me\"}) RETURN person", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"LabelScan"));
            }
        }}));
    }

    @Test
    public void nodeByIndexSeek() {
        this.profileQuery("Node index seek", new StringOps(Predef$.MODULE$.augmentString("Finds nodes using an index seek. The node identifier and the index used is shown in the arguments of the operator.\n                |The following query will return all nodes which have label 'Company' where the property 'name' has the value 'Malmo' using the Location index.")).stripMargin(), "MATCH (location:Location {name: \"Malmo\"}) RETURN location", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"NodeIndexSeek"));
            }
        }}));
    }

    @Test
    public void nodeByUniqueIndexSeek() {
        this.profileQuery("Node unique index seek", "Finds nodes using an index seek on a unique index. The node identifier and the index used is shown in the arguments of the operator.\n          |The following query will return all nodes which have label 'Team' where the property 'name' has the value 'Field' using the Team unique index.", new StringOps(Predef$.MODULE$.augmentString("MATCH (team:Team {name: \"Field\"}) RETURN team")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"NodeUniqueIndexSeek"));
            }
        }}));
    }

    @Test
    public void nodeByIdSeek() {
        this.profileQuery("Node by Id seek", new StringOps(Predef$.MODULE$.augmentString("Reads one or more nodes by id from the node store.\n          |The following query will return the node which has nodeId 0")).stripMargin(), "MATCH n WHERE id(n) = 0 RETURN n", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"NodeByIdSeek"));
            }
        }}));
    }

    @Test
    public void projection() {
        this.profileQuery("Projection", new StringOps(Predef$.MODULE$.augmentString("For each row from it's input, projection executes a set of expressions and produces a row with the results of the expressions.\n\n          |The following query will produce one row with the value 'hello'.")).stripMargin(), "RETURN \"hello\" AS greeting", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.startsWith((String)"Projection"));
            }
        }}));
    }

    @Test
    public void selection() {
        this.profileQuery("Selection", new StringOps(Predef$.MODULE$.augmentString("Filters each row coming from the child operator, only passing through rows that evaluate the predicates to true.\n          |\n          |The following query will look for nodes with the label 'Person' and filter those whose name begins with the letter 'a'.")).stripMargin(), "MATCH (p:Person) WHERE p.name =~ \"^a.*\" RETURN p", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Filter"));
            }
        }}));
    }

    @Test
    public void cartesianProduct() {
        this.profileQuery("Cartesian Product", new StringOps(Predef$.MODULE$.augmentString("Produces a cross product of the two inputs - each row coming from the left child, will be matched with all the rows from the right child operator.\n          |\n          |The following query will join all the people with all the locations and return the cartesian product of the nodes with those labels.\n        ")).stripMargin(), "MATCH (p:Person), (l:Location) RETURN p, l", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"CartesianProduct"));
            }
        }}));
    }

    @Test
    public void optionalMatch() {
        this.profileQuery("Optional", new StringOps(Predef$.MODULE$.augmentString("Takes the input from it's leaf and passes it on. If the input is empty, a single empty row is generated instead.\n          |\n          |The following query will find all the people and the location they work in if there is one.\n        ")).stripMargin(), "MATCH (p:Person) OPTIONAL MATCH (p)-[:WORKS_IN]->(l) RETURN p, l", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Expand"));
            }
        }}));
    }

    @Test
    public void optionalExpand() {
        this.profileQuery("Optional Expand", new StringOps(Predef$.MODULE$.augmentString("Optional expand traverses relationships from a given node, and makes sure that predicates are evaluated before producing rows.\n          |\n          |If no matching relationships are found, a single row with null for the relationship and end node identifier is produced.\n          |\n          |The following query will find all the people and the location they work in as long as they've worked there for more than 180 days.\n        ")).stripMargin(), "MATCH (p:Person)\n           OPTIONAL MATCH (p)-[works_in:WORKS_IN]->(l) WHERE works_in.duration > 180\n           RETURN p, l", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"OptionalExpand"));
            }
        }}));
    }

    @Test
    public void nodeOuterHashJoin() {
        this.profileQuery("Node Outer Hash Join", new StringOps(Predef$.MODULE$.augmentString("Node Outer Hash Join performs an outer join between two sets of nodes.\n          |\n          |If no matching nodes are found, a single row with null for the unmatched part will be produced.\n          |\n          |The following query will find all the people and the locations inside a specific country\n          |where at least a friend of theirs works.\n        ")).stripMargin(), "MATCH (person:Person)\n           OPTIONAL MATCH (person)-[:FRIEND_WITH]->(friend)-[:WORKS_IN]->(location)<-[:IN]-(country: Country)\n           WHERE id(country) = 42\n           RETURN person, location", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"NodeOuterHashJoin"));
            }
        }}));
    }

    @Test
    public void sort() {
        this.profileQuery("Sort", new StringOps(Predef$.MODULE$.augmentString("Sorts rows by a provided key.\n          |\n          |The following query will find all the people and return them sorted alphabetically by name.\n        ")).stripMargin(), "MATCH (p:Person) RETURN p ORDER BY p.name", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Sort"));
            }
        }}));
    }

    @Test
    public void sortedLimit() {
        this.profileQuery("Sorted Limit", new StringOps(Predef$.MODULE$.augmentString("Returns the first 'n' rows sorted by a provided key. The physical operator is called 'Top'.\n          |\n          |The following query will find the first 2 people sorted alphabetically by name.\n        ")).stripMargin(), "MATCH (p:Person) RETURN p ORDER BY p.name LIMIT 2", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Top"));
            }
        }}));
    }

    @Test
    public void limit() {
        this.profileQuery("Limit", new StringOps(Predef$.MODULE$.augmentString("Returns the first 'n' rows.\n          |\n          |The following query will return the first 3 people in an arbitrary order.\n        ")).stripMargin(), "MATCH (p:Person) RETURN p LIMIT 3", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Limit"));
            }
        }}));
    }

    @Test
    public void expand() {
        this.profileQuery("Expand", new StringOps(Predef$.MODULE$.augmentString("Given a start node, expand will follow relationships coming in or out, depending on the pattern relationship. Can also handle variable length pattern relationships.\n          |\n          |The following query will return my friends of friends.\n        ")).stripMargin(), "MATCH (p:Person {name: \"me\"})-[:FRIENDS_WITH*2]->(fof) RETURN fof", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"expand"));
            }
        }}));
    }

    @Test
    public void semiApply() {
        this.profileQuery("Semi Apply", new StringOps(Predef$.MODULE$.augmentString("Tests for the existence of a pattern predicate.\n          |\n          |The following query will find all the people who have a friend.\n        ")).stripMargin(), "MATCH (other:Person)\n           WHERE (other)-[:FRIENDS_WITH]->()\n           RETURN other", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SemiApply"));
            }
        }}));
    }

    @Test
    public void selectOrSemiApply() {
        this.profileQuery("Select Or Semi Apply", new StringOps(Predef$.MODULE$.augmentString("Tests for the existence of a pattern predicate and evaluates a property.\n          |\n          |The following query will find all the people who have a friend or are older than 25.\n        ")).stripMargin(), "MATCH (other:Person)\n           WHERE other.age > 25 OR (other)-[:FRIENDS_WITH]->()\n           RETURN other", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SelectOrSemiApply"));
            }
        }}));
    }

    @Test
    public void antiSemiApply() {
        this.profileQuery("Anti Semi Apply", new StringOps(Predef$.MODULE$.augmentString("Tests for the absence of a pattern predicate.\n\n           The following query will find all the people who aren't my friend.\n        ")).stripMargin(), "MATCH (me:Person {name: \"me\"}), (other:Person)\n           WHERE NOT((me)-[:FRIENDS_WITH]->(other))\n           RETURN other", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"AntiSemiApply"));
            }
        }}));
    }

    @Test
    public void selectOrAntiSemiApply() {
        this.profileQuery("Select Or Anti Semi Apply", new StringOps(Predef$.MODULE$.augmentString("Tests for the absence of a pattern predicate and evaluates a property.\n          |\n          |The following query will find all the people who don't have a friend or are older than 25.\n        ")).stripMargin(), "MATCH (other:Person)\n           WHERE other.age > 25 OR NOT((other)-[:FRIENDS_WITH]->())\n           RETURN other", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SelectOrAntiSemiApply"));
            }
        }}));
    }

    @Test
    public void directedRelationshipById() {
        this.profileQuery("Directed Relationship By Id Seek", new StringOps(Predef$.MODULE$.augmentString("Reads one or more relationships by id from the relationship store. Produces both the relationship and the nodes on either side.\n          |\n          |The following query will find the relationship with id '0' and will return a row for the source node of that relationship.\n        ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n1)-[r]->()\n           WHERE id(r) = 0\n           RETURN r, n1\n        ")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"DirectedRelationshipByIdSeek"));
            }
        }}));
    }

    @Test
    public void undirectedRelationshipById() {
        this.profileQuery("Undirected Relationship By Id Seek", new StringOps(Predef$.MODULE$.augmentString("Reads one or more relationships by id from the relationship store.\n          |For each relationship, two rows are produced, with the end nodes in two different locations.\n          |\n          |The following query will find the relationship with id '1' and will return a row for both the source and destination nodes of that relationship.\n        ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (n1)-[r]-()\n           WHERE id(r) = 1\n           RETURN r, n1\n        ")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"UndirectedRelationshipByIdSeek"));
            }
        }}));
    }

    @Test
    public void nodeHashJoin() {
        this.profileQuery("Node Hash Join", new StringOps(Predef$.MODULE$.augmentString("Using a hash table, a node hash join joins the inputs coming from the left with the inputs coming from the right. The join key is specific in the arguments of the operator.\n          |\n          |The following query will find the people who work in London and the country which London belongs to.\n        ")).stripMargin(), "MATCH (person:Person)-[:WORKS_IN]->(location)<-[:IN]-(country: Country)\n           RETURN country, location, person", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertTrue((boolean)p.executionPlanDescription().toString().contains("NodeHashJoin"));
            }
        }}));
    }

    @Test
    public void skip() {
        this.profileQuery("Skip", new StringOps(Predef$.MODULE$.augmentString("Skips 'n' rows\n          |\n          |The following query will skip the person with the lowest 'id' property and return the rest.\n        ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (p:Person)\n           RETURN p\n           ORDER BY p.id\n           SKIP 1\n        ")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Skip"));
            }
        }}));
    }

    @Test
    public void apply() {
        this.profileQuery("Apply", new StringOps(Predef$.MODULE$.augmentString("Apply will execute a subquery for each entry in the current result.\n          |\n          |The following query will return all the people that have at least one friend and the city they work in.\n        ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (p:Person)-[:FRIENDS_WITH]->(f)\n           WITH p, count(f) as fs\n           WHERE fs > 0\n           MATCH (p)-[:WORKS_IN]->(city)\n           RETURN p, city\n        ")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Apply"));
            }
        }}));
    }

    @Test
    public void union() {
        this.profileQuery("Union", "Union concatenates the results from the right plan after the results of the left plan.", new StringOps(Predef$.MODULE$.augmentString("MATCH (p:Location)\n           RETURN p.name\n           UNION ALL\n           MATCH (p:Country)\n           RETURN p.name\n        ")).stripMargin(), (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"Union"));
            }
        }}));
    }
}

