/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u0017\tQ!+Z7pm\u0016$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0003\u0016\u0001\u0011Ec#\u0001\thKR<%/\u00199im&T8\u000b^=mKV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005AqM]1qQZL'P\u0003\u0002\u001d\r\u0005ia/[:vC2L'0\u0019;j_:L!AH\r\u0003\u0015\u001d\u0013\u0018\r\u001d5TifdW\rC\u0003!\u0001\u0011\u0005\u0013%\u0001\the\u0006\u0004\b\u000eR3tGJL\u0007\u000f^5p]V\t!\u0005E\u0002$U1j\u0011\u0001\n\u0006\u0003K\u0019\n\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001dB\u0013AC2pY2,7\r^5p]*\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,I\t!A*[:u!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007bB\u001b\u0001\u0005\u0004%\tEN\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#A\u001c\u0011\t\rBDFO\u0005\u0003s\u0011\u00121!T1q!\u0011\u0019\u0003\bL\u001e\u0011\u0005qjT\"\u0001\u0015\n\u0005yB#\u0001\u0002'p]\u001eDa\u0001\u0011\u0001!\u0002\u00139\u0014a\u00039s_B,'\u000f^5fg\u0002BQA\u0011\u0001\u0005\u0002\r\u000bqa]3di&|g.F\u0001-\u0011\u0015)\u0005\u0001\"\u0001G\u0003=\u0011X-\\8wK~\u0003(o\u001c9feRLH#A$\u0011\u0005qB\u0015BA%)\u0005\u0011)f.\u001b;)\u0005\u0011[\u0005C\u0001'P\u001b\u0005i%B\u0001(\t\u0003\u0015QWO\\5u\u0013\t\u0001VJ\u0001\u0003UKN$\b\"\u0002*\u0001\t\u00031\u0015A\u0007:f[>4XmX1`Y\u0006\u0014W\r\\0ge>lw,Y0o_\u0012,\u0007FA)L\u0011\u0015)\u0006\u0001\"\u0001G\u0003\t\u0012X-\\8wK~kW\u000f\u001c;ja2,w\f\\1cK2\u001cxL\u001a:p[~\u000bwL\\8eK\"\u0012Ak\u0013")
public class RemoveTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Andres"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)36L))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Tobias"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)25L))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Peter"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)34L))})))}));

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Andres:Swedish KNOWS Tobias:Swedish", "Andres KNOWS Peter:German:Swedish"}));
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public String section() {
        return "Remove";
    }

    @Test
    public void remove_property() {
        this.testQuery("Remove a property", "Neo4j doesn't allow storing +null+ in properties. Instead, if no value exists, the property is just not there. So, to remove a property value on a node or a relationship, is also done with +REMOVE+.", "match (andres {name: 'Andres'}) remove andres.age return andres", "The node is returned, and no property `age` exists on it.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertFalse((String)"Property was not removed as expected.", (boolean)this.$outer.node("Andres").hasProperty("age"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void remove_a_label_from_a_node() {
        this.testQuery("Remove a label from a node", "To remove labels, you use +REMOVE+.", "match (n {name: 'Peter'}) remove n:German return n", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.getLabelsFromNode(p));
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Swedish"}));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void remove_multiple_labels_from_a_node() {
        this.testQuery("Removing multiple labels", "To remove multiple labels, you use +REMOVE+.", "match (n {name: 'Peter'}) remove n:German:Swedish return n", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.assertionsHelper().macroAssert(this.$outer.getLabelsFromNode(p).isEmpty(), (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }
}

