/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0017\tQ!+\u001a;ve:$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0003\u0016\u0001\u0011\u0005c#\u0001\the\u0006\u0004\b\u000eR3tGJL\u0007\u000f^5p]V\tq\u0003E\u0002\u0019?\u0005j\u0011!\u0007\u0006\u00035m\t\u0011\"[7nkR\f'\r\\3\u000b\u0005qi\u0012AC2pY2,7\r^5p]*\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!3\t!A*[:u!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012aa\u0015;sS:<\u0007\"\u0002\u0016\u0001\t#Z\u0013\u0001E4fi\u001e\u0013\u0018\r\u001d5wSj\u001cF/\u001f7f+\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003!9'/\u00199im&T(BA\u0019\u0007\u000351\u0018n];bY&T\u0018\r^5p]&\u00111G\f\u0002\u000b\u000fJ\f\u0007\u000f[*us2,\u0007\"B\u001b\u0001\t\u00031\u0014aB:fGRLwN\\\u000b\u0002C!9\u0001\b\u0001b\u0001\n\u0003J\u0014A\u00039s_B,'\u000f^5fgV\t!\b\u0005\u0003\u0019w\u0005j\u0014B\u0001\u001f\u001a\u0005\ri\u0015\r\u001d\t\u00051m\nc\b\u0005\u0002@\u00016\tQ$\u0003\u0002B;\t\u0019\u0011I\\=\t\r\r\u0003\u0001\u0015!\u0003;\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0015I,G/\u001e:o\u001d>$W\rF\u0001H!\ty\u0004*\u0003\u0002J;\t!QK\\5uQ\t!5\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0011\u0005)!.\u001e8ji&\u0011\u0001+\u0014\u0002\u0005)\u0016\u001cH\u000fC\u0003S\u0001\u0011\u0005a)\u0001\nsKR,(O\u001c*fY\u0006$\u0018n\u001c8tQ&\u0004\bFA)L\u0011\u0015)\u0006\u0001\"\u0001G\u00039\u0011X\r^;s]B\u0013x\u000e]3sifD#\u0001V&\t\u000ba\u0003A\u0011\u0001$\u0002)],\u0017N\u001d3`m\u0006\u0014\u0018.\u00192mK~s\u0017-\\3tQ\t96\nC\u0003\\\u0001\u0011\u0005a)A\nok2d\u0017M\u00197f?B\u0014x\u000e]3si&,7\u000f\u000b\u0002[\u0017\")a\f\u0001C\u0001\r\u0006yA-[:uS:\u001cGoX8viB,H\u000f\u000b\u0002^\u0017\")\u0011\r\u0001C\u0001\r\u0006y1m\u001c7v[:|\u0016\r\\5bg&tw\r\u000b\u0002a\u0017\")A\r\u0001C\u0001\r\u0006\tr\u000e\u001e5fe~+\u0007\u0010\u001d:fgNLwN\\:)\u0005\r\\\u0005\"B4\u0001\t\u00031\u0015A\u0006:fiV\u0014hnX1mY~KG-\u001a8uS\u001aLWM]:)\u0005\u0019\\\u0005")
public class ReturnTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"happy"), (Object)"Yes!"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToInteger((int)55))})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A KNOWS B", "A BLOCKS B"}));
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "Return";
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Test
    public void returnNode() {
        this.testQuery("Return nodes", "To return a node, list it in the `RETURN` statement.", "match (n {name: \"B\"}) return n", "The example will return the node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("B"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void returnRelationship() {
        this.testQuery("Return relationships", "To return a relationship, just include it in the `RETURN` list.", "match (n {name: \"A\"})-[r:KNOWS]->(c) return r", "The relationship is returned by the example.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.size());
            }
        }}));
    }

    @Test
    public void returnProperty() {
        this.testQuery("Return property", "To return a property, use the dot separator, like this:", "match (n {name: \"A\"}) return n.name", "The value of the property `name` gets returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n.name"), (Object)"A")}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void weird_variable_names() {
        this.testQuery("Identifier with uncommon characters", "To introduce a placeholder that is made up of characters that are\n      outside of the english alphabet, you can use the +`+ to enclose the identifier, like this:", "match (`This isn't a common identifier`) where `This isn't a common identifier`.name='A'\nreturn `This isn't a common identifier`.happy", "The node with name \"A\" is returned", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"`This isn't a common identifier`.happy"), (Object)"Yes!")}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void nullable_properties() {
        this.testQuery("Optional properties", "If a property might or might not be there, you can still select it as usual. It will be treated as +NULL+ if it is missing", "match (n) return n.age", "This example returns the age when the node has that property, or +null+ if the property is not there.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Object[] objectArray = new Object[2];
                objectArray[0] = BoxesRunTime.boxToInteger((int)55);
                objectArray[1] = null;
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)), (Object)p.columnAs("n.age").toList());
            }
        }}));
    }

    @Test
    public void distinct_output() {
        this.testQuery("Unique results", "`DISTINCT` retrieves only unique rows depending on the columns that have been selected to output.", "match (a {name: \"A\"})-->(b) return distinct b", "The node named B is returned by the query, but only once.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("B")})), (Object)p.columnAs("b").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void column_aliasing() {
        this.testQuery("Column alias", "If the name of the column should be different from the expression used, you can rename it by using `AS` <new name>.", "match (a {name: \"A\"}) return a.age AS SomethingTotallyDifferent", "Returns the age property of a node, but renames the column.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{55})), (Object)p.columnAs("SomethingTotallyDifferent").toList());
            }
        }}));
    }

    @Test
    public void other_expressions() {
        this.testQuery("Other expressions", "Any expression can be used as a return item -- literals, predicates, properties, functions, and everything else.", "match (a {name: \"A\"}) return a.age > 30, \"I'm a literal\", (a)-->()", "Returns a predicate, a literal and function call with a pattern expression parameter.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnTest $outer;

            public final void apply(ExecutionResult p) {
                Map row = (Map)p.toList().head();
                Assert.assertEquals((Object)"I'm a literal", (Object)row.apply((Object)"\"I'm a literal\""));
                Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)row.apply((Object)"a.age > 30"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Seq)row.apply((Object)"(a)-->()")).size()));
                int $org_scalatest_assert_macro_right = 2;
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void return_all_identifiers() {
        this.testQuery("Return all elements", "When you want to return all nodes, relationships and paths found in a query, you can use the `*` symbol.", "match p=(a {name: \"A\"})-[r]->(b) return *", "This returns the two nodes, the relationship and the path used in the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)((MapLike)p.toList().head()).keys(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "r", "p"})));
            }
        }}));
    }
}

