/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0017\ty1k\u00195f[\u0006Le\u000eZ3y)\u0016\u001cHO\u0003\u0002\u0004\t\u00051Am\\2hK:T!!\u0002\u0004\u0002\r\rL\b\u000f[3s\u0015\t9\u0001\"A\u0003oK>$$NC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002\u0005\u000b\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007CA\t\u0013\u001b\u0005!\u0011BA\n\u0005\u0005i\tV/\u001a:z'R\fG/[:uS\u000e\u001cH+Z:u'V\u0004\bo\u001c:u!\t)\"$D\u0001\u0017\u0015\t9\u0002$A\u0004iK2\u0004XM]:\u000b\u0005e!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005m1\"AC$sCBD\u0017jY5oO\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003\u001b\u0001AQ!\t\u0001\u0005B\t\n\u0001c\u001a:ba\"$Um]2sSB$\u0018n\u001c8\u0016\u0003\r\u00022\u0001J\u0016.\u001b\u0005)#B\u0001\u0014(\u0003%IW.\\;uC\ndWM\u0003\u0002)S\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0013\u0003\t1K7\u000f\u001e\t\u0003]Mj\u0011a\f\u0006\u0003aE\nA\u0001\\1oO*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b0\u0005\u0019\u0019FO]5oO\"9a\u0007\u0001b\u0001\n\u0003:\u0014A\u00039s_B,'\u000f^5fgV\t\u0001\b\u0005\u0003%s5Z\u0014B\u0001\u001e&\u0005\ri\u0015\r\u001d\t\u0005IejS\u0006\u0003\u0004>\u0001\u0001\u0006I\u0001O\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b\u0005C\u0004@\u0001\t\u0007I\u0011\t\u0012\u0002-M,G/\u001e9D_:\u001cHO]1j]R\fV/\u001a:jKNDa!\u0011\u0001!\u0002\u0013\u0019\u0013aF:fiV\u00048i\u001c8tiJ\f\u0017N\u001c;Rk\u0016\u0014\u0018.Z:!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003\u001d\u0019Xm\u0019;j_:,\u0012!\f\u0005\u0006\r\u0002!\taR\u0001\u0018GJ,\u0017\r^3`S:$W\r_0p]~\u000bw\f\\1cK2$\u0012\u0001\u0013\t\u0003\u0013*k\u0011!K\u0005\u0003\u0017&\u0012A!\u00168ji\"\u0012Q)\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\"\tQA[;oSRL!AU(\u0003\tQ+7\u000f\u001e\u0005\u0006)\u0002!\taR\u0001\u0016IJ|\u0007oX5oI\u0016Dxl\u001c8`C~c\u0017MY3mQ\t\u0019V\nC\u0003X\u0001\u0011\u0005q)A\u0005vg\u0016|\u0016N\u001c3fq\"\u0012a+\u0014\u0005\u00065\u0002!\taR\u0001\u0015kN,w,\u001b8eKb|v/\u001b;i?^DWM]3)\u0005ek\u0005\"B/\u0001\t\u00039\u0015!E;tK~Kg\u000eZ3y?^LG\u000f[0j]\"\u0012A,\u0014\u0005\u0006A\u0002!\t!Y\u0001\u0016CN\u001cXM\u001d;J]\u0012,\u00070Z:P]2\u000b'-\u001a7t)\rA%M\u001b\u0005\u0006G~\u0003\r\u0001Z\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0003K\"t!!\u00134\n\u0005\u001dL\u0013A\u0002)sK\u0012,g-\u0003\u00025S*\u0011q-\u000b\u0005\u0006W~\u0003\r\u0001\\\u0001\u0010Kb\u0004Xm\u0019;fI&sG-\u001a=fgB\u0019Q.^<\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u000b\u0003\u0019a$o\\8u}%\t!&\u0003\u0002uS\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0017w\u0015\t!\u0018\u0006E\u0002nk\u0012\u0004")
public class SchemaIndexTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    private final Map<String, Map<String, String>> properties;
    private final List<String> setupConstraintQueries;

    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"andres:Person KNOWS mark:Person"}));
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public List<String> setupConstraintQueries() {
        return this.setupConstraintQueries;
    }

    @Override
    public String section() {
        return "Schema Index";
    }

    @Test
    public void create_index_on_a_label() {
        this.testQuery("Create index on a label", "To create an index on a property for all nodes that have a label, use +CREATE+ +INDEX+ +ON+. Note that the index is not immediately available, but will be created in the background. See <<graphdb-neo4j-schema-indexes>> for details.", "create index on :Person(name)", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaIndexTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.assertIndexesOnLabels("Person", (List<List<String>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void drop_index_on_a_label() {
        String x$1 = "Drop index on a label";
        String x$2 = "To drop an index on all nodes that have a label, use the +DROP+ +INDEX+ clause.";
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executePreparationQueries((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create index on :Person(name)"})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$4 = "drop index on :Person(name)";
        String x$5 = "";
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaIndexTest $outer;

            public final void apply(ExecutionResult p) {
                this.$outer.assertIndexesOnLabels("Person", (List<List<String>>)Nil$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$1, x$2, x$4, x$5, (Function0<Object>)x$3, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$6);
    }

    @Test
    public void use_index() {
        this.testQuery("Use index", "There is usually no need to specify which indexes to use in a query, Cypher will figure that out by itself. For example the query below will use the `Person(name)` index, if it exists. If you for some reason want to hint to specific indexes, see <<query-using>>.", "match (person:Person {name: 'Andres'}) return person", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.size());
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SchemaIndex"));
            }
        }}));
    }

    @Test
    public void use_index_with_where() {
        this.testQuery("Use index with WHERE", "Indexes are also automatically used for equality comparisons of a indexed property in the WHERE clause.If you for some reason want to hint to specific indexes, see <<query-using>>.", "match (person:Person) WHERE person.name = 'Andres' return person", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)1L, (long)p.size());
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SchemaIndex"));
            }
        }}));
    }

    @Test
    public void use_index_with_in() {
        this.testQuery("Use index with IN", "The IN predicate on `person.name` in the following query will use the `Person(name)` index, if it exists. If you for some reason want Cypher to use specific indexes, you can enforce it using hints. See <<query-using>>.", "match (person:Person) WHERE person.name IN ['Andres','Mark'] return person", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((long)2L, (long)p.size());
                Assert.assertThat((Object)p.executionPlanDescription().toString(), (Matcher)CoreMatchers.containsString((String)"SchemaIndex"));
            }
        }}));
    }

    public void assertIndexesOnLabels(String label, List<List<String>> expectedIndexes) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expectedIndexes);
        List $org_scalatest_assert_macro_right = this.RichGraph(this.db()).indexPropsForLabel(label);
        boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
        this.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
    }

    public SchemaIndexTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
        this.properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"andres"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Andres")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"mark"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Mark")})))}));
        this.setupConstraintQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE INDEX ON :Person(name)"}));
    }
}

