/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.QueryStatistics;
import org.neo4j.cypher.QueryStatisticsTestSupport;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.scalautils.Equality$;
import org.scalautils.TripleEqualsSupport;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0017\t91+\u001a;UKN$(BA\u0002\u0005\u0003\u0019!wnY4f]*\u0011QAB\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005\u001dA\u0011!\u00028f_RR'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\u0001\u0003\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t\u0019Bi\\2v[\u0016tG/\u001b8h)\u0016\u001cHOQ1tKB\u0011\u0011CE\u0007\u0002\t%\u00111\u0003\u0002\u0002\u001b#V,'/_*uCRL7\u000f^5dgR+7\u000f^*vaB|'\u000f\u001e\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"!\u0004\u0001\t\u000be\u0001A\u0011\u000b\u000e\u0002!\u001d,Go\u0012:ba\"4\u0018N_*us2,W#A\u000e\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012\u0001C4sCBDg/\u001b>\u000b\u0005\u00012\u0011!\u0004<jgV\fG.\u001b>bi&|g.\u0003\u0002#;\tQqI]1qQN#\u0018\u0010\\3\t\u000b\u0011\u0002A\u0011I\u0013\u0002!\u001d\u0014\u0018\r\u001d5EKN\u001c'/\u001b9uS>tW#\u0001\u0014\u0011\u0007\u001dr\u0003'D\u0001)\u0015\tI#&A\u0005j[6,H/\u00192mK*\u00111\u0006L\u0001\u000bG>dG.Z2uS>t'\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=B#\u0001\u0002'jgR\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\t1\fgn\u001a\u0006\u0002k\u0005!!.\u0019<b\u0013\t9$G\u0001\u0004TiJLgn\u001a\u0005\bs\u0001\u0011\r\u0011\"\u0011;\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002wA!q\u0005\u0010\u0019?\u0013\ti\u0004FA\u0002NCB\u0004Ba\n\u001f1\u007fA\u0011\u0001)Q\u0007\u0002Y%\u0011!\t\f\u0002\u0007\u0003:Lh+\u00197\t\r\u0011\u0003\u0001\u0015!\u0003<\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\t\u000b\u0019\u0003A\u0011A$\u0002\u000fM,7\r^5p]V\t\u0001\u0007C\u0003J\u0001\u0011\u0005!*\u0001\u000btKR|\u0006O]8qKJ$\u0018pX8o?:|G-\u001a\u000b\u0002\u0017B\u0011\u0001\tT\u0005\u0003\u001b2\u0012A!\u00168ji\"\u0012\u0001j\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\"\tQA[;oSRL!\u0001V)\u0003\tQ+7\u000f\u001e\u0005\u0006-\u0002!\tAS\u0001\u0015g\u0016$x\f\u001d:pa\u0016\u0014H/_0u_~sW\u000f\u001c7)\u0005U{\u0005\"B-\u0001\t\u0003Q\u0015aJ:fi~\u0003(o\u001c9feRLWm]0ge>lwl\u001c;iKJ|vM]1qQ~+G.Z7f]RD#\u0001W(\t\u000bq\u0003A\u0011\u0001&\u0002C%t7\r\\;tSZ,wl]3u?B\u0014x\u000e]3si&,7o\u00184s_6|V.\u00199)\u0005m{\u0005\"B0\u0001\t\u0003Q\u0015\u0001I:fi~\u000bw\f\u001d:pa\u0016\u0014H/_0vg&twmX1`a\u0006\u0014\u0018-\\3uKJD#AX(\t\u000b\t\u0004A\u0011\u0001&\u0002IM,GoX1mY~\u0003(o\u001c9feRLWm]0vg&twmX1`a\u0006\u0014\u0018-\\3uKJD#!Y(\t\u000b\u0015\u0004A\u0011\u0001&\u0002SM,GoX7vYRL\u0007\u000f\\3`aJ|\u0007/\u001a:uS\u0016\u001cx,\u001b8`_:,wl]3u?\u000ed\u0017-^:fQ\t!w\nC\u0003i\u0001\u0011\u0005!*\u0001\u000etKR|6/\u001b8hY\u0016|F.\u00192fY~{gnX1`]>$W\r\u000b\u0002h\u001f\")1\u000e\u0001C\u0001\u0015\u0006i2/\u001a;`[VdG/\u001b9mK~c\u0017MY3mg~{gnX1`]>$W\r\u000b\u0002k\u001f\u0002")
public class SetTest
extends DocumentingTestBase
implements QueryStatisticsTestSupport {
    private final Map<String, Map<String, Object>> properties;

    public QueryStatisticsTestSupport.QueryStatisticsAssertions QueryStatisticsAssertions(QueryStatistics expected) {
        return QueryStatisticsTestSupport.class.QueryStatisticsAssertions((QueryStatisticsTestSupport)this, (QueryStatistics)expected);
    }

    public void assertStats(ExecutionResult result, int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        QueryStatisticsTestSupport.class.assertStats((QueryStatisticsTestSupport)this, (ExecutionResult)result, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public QueryStatisticsTestSupport.QueryStatisticsAssertions assertStatsResult(int nodesCreated, int relationshipsCreated, int propertiesSet, int nodesDeleted, int relationshipsDeleted, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved) {
        return QueryStatisticsTestSupport.class.assertStatsResult((QueryStatisticsTestSupport)this, (int)nodesCreated, (int)relationshipsCreated, (int)propertiesSet, (int)nodesDeleted, (int)relationshipsDeleted, (int)labelsAdded, (int)labelsRemoved, (int)indexesAdded, (int)indexesRemoved, (int)constraintsAdded, (int)constraintsRemoved);
    }

    public int assertStats$default$2() {
        return QueryStatisticsTestSupport.class.assertStats$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$3() {
        return QueryStatisticsTestSupport.class.assertStats$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$4() {
        return QueryStatisticsTestSupport.class.assertStats$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$5() {
        return QueryStatisticsTestSupport.class.assertStats$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$6() {
        return QueryStatisticsTestSupport.class.assertStats$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$7() {
        return QueryStatisticsTestSupport.class.assertStats$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$8() {
        return QueryStatisticsTestSupport.class.assertStats$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$9() {
        return QueryStatisticsTestSupport.class.assertStats$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$10() {
        return QueryStatisticsTestSupport.class.assertStats$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$11() {
        return QueryStatisticsTestSupport.class.assertStats$default$11((QueryStatisticsTestSupport)this);
    }

    public int assertStats$default$12() {
        return QueryStatisticsTestSupport.class.assertStats$default$12((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$1() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$1((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$2() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$2((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$3() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$3((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$4() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$4((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$5() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$5((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$6() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$6((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$7() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$7((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$8() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$8((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$9() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$9((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$10() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$10((QueryStatisticsTestSupport)this);
    }

    public int assertStatsResult$default$11() {
        return QueryStatisticsTestSupport.class.assertStatsResult$default$11((QueryStatisticsTestSupport)this);
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Andres:Swedish KNOWS Peter", "Stefan KNOWS Andres", "Emil KNOWS Peter"}));
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public String section() {
        return "Set";
    }

    @Test
    public void set_property_on_node() {
        this.testQuery("Set a property", "To set a property on a node or relationship, use +SET+.", "match (n {name: 'Andres'}) set n.surname = 'Taylor' return n", "The newly changed node is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.node("Andres").getProperty("surname"));
                String $org_scalatest_assert_macro_right = "Taylor";
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_property_to_null() {
        this.testQuery("Remove a property", "Normally you remove a property by using +<<query-remove,REMOVE>>+, but it's sometimes handy to do\nit using the +SET+ command. One example is if the property comes from a parameter.", "match (n {name: 'Andres'}) set n.name = null return n", "The node is returned by the query, and the name property is now missing.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertFalse((boolean)this.$outer.node("Andres").hasProperty("name"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_properties_from_other_graph_element() {
        this.testQuery("Copying properties between nodes and relationships", new StringOps(Predef$.MODULE$.augmentString("You can also use +SET+ to copy all properties from one graph element to another. Remember that doing this\nwill remove all other properties on the receiving graph element.")).stripMargin(), "match (at {name: 'Andres'}), (pn {name: 'Peter'}) set at = pn return at, pn", "The Andres node has had all it's properties replaced by the properties in the Peter node.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.node("Andres").getProperty("name"));
                String $org_scalatest_assert_macro_right = "Peter";
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
                Assert.assertFalse((String)"Didn't expect the Andres node to have an hungry property", (boolean)this.$outer.node("Andres").hasProperty("hungry"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void inclusive_set_properties_from_map() {
        this.testQuery("Adding properties from maps", new StringOps(Predef$.MODULE$.augmentString("When setting properties from a map (literal, paremeter, or graph element), you can use the `+=` form of `SET`\n          |to only add properties, and not remove any of the existing properties on the graph element.\n        ")).stripMargin(), "match (peter {name: 'Peter'}) SET peter += { hungry: true, position: 'Entrepreneur' }", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.node("Peter").getProperty("name"));
                String $org_scalatest_assert_macro_right = "Peter";
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.node("Peter").getProperty("hungry"));
                boolean $org_scalatest_assert_macro_right2 = true;
                boolean $org_scalatest_assert_macro_result2 = $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_result2, (Option)None$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.node("Peter").getProperty("position"));
                String $org_scalatest_assert_macro_right3 = "Entrepreneur";
                boolean $org_scalatest_assert_macro_result3 = $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_result3, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_a_property_using_a_parameter() {
        String x$13 = "Set a property using a parameter";
        String x$14 = "\nUse a parameter to give the value of a property.\n";
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"surname"), (Object)"Taylor")}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$16 = "match (n {name: 'Andres'}) set n.surname = {surname} return n";
        String x$17 = "The Andres node has got an surname added.";
        Seq x$18 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$1 = p;
                int x$2 = 0;
                int x$3 = 1;
                int x$4 = this.$outer.assertStats$default$3();
                int x$5 = this.$outer.assertStats$default$5();
                int x$6 = this.$outer.assertStats$default$6();
                int x$7 = this.$outer.assertStats$default$7();
                int x$8 = this.$outer.assertStats$default$8();
                int x$9 = this.$outer.assertStats$default$9();
                int x$10 = this.$outer.assertStats$default$10();
                int x$11 = this.$outer.assertStats$default$11();
                int x$12 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$13, x$14, x$16, x$17, (Function0<Object>)x$15, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$18);
    }

    @Test
    public void set_all_properties_using_a_parameter() {
        String x$31 = "Set all properties using a parameter";
        String x$32 = "\nThis will replace all existing properties on the node with the new set provided by the parameter.\n";
        Serializable x$33 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"props"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Andres"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"position"), (Object)"Developer")})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$34 = "match (n {name: 'Andres'}) set n = {props} return n";
        String x$35 = "The Andres node has had all it's properties replaced by the properties in the +props+ parameter.";
        Seq x$36 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$19 = p;
                int x$20 = 0;
                int x$21 = 4;
                int x$22 = this.$outer.assertStats$default$3();
                int x$23 = this.$outer.assertStats$default$5();
                int x$24 = this.$outer.assertStats$default$6();
                int x$25 = this.$outer.assertStats$default$7();
                int x$26 = this.$outer.assertStats$default$8();
                int x$27 = this.$outer.assertStats$default$9();
                int x$28 = this.$outer.assertStats$default$10();
                int x$29 = this.$outer.assertStats$default$11();
                int x$30 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$19, x$20, x$22, x$21, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
        this.prepareAndTestQuery(x$31, x$32, x$34, x$35, (Function0<Object>)x$33, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$36);
    }

    @Test
    public void set_multiple_properties_in_one_set_clause() {
        this.testQuery("Set multiple properties using one SET clause", "If you want to set multiple properties in one go, simply separate them with a comma.", "match (n {name: 'Andres'}) set n.position = 'Developer', n.surname = 'Taylor'", "", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                ExecutionResult x$37 = p;
                int x$38 = 0;
                int x$39 = 2;
                int x$40 = this.$outer.assertStats$default$3();
                int x$41 = this.$outer.assertStats$default$5();
                int x$42 = this.$outer.assertStats$default$6();
                int x$43 = this.$outer.assertStats$default$7();
                int x$44 = this.$outer.assertStats$default$8();
                int x$45 = this.$outer.assertStats$default$9();
                int x$46 = this.$outer.assertStats$default$10();
                int x$47 = this.$outer.assertStats$default$11();
                int x$48 = this.$outer.assertStats$default$12();
                this.$outer.assertStats(x$37, x$38, x$40, x$39, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_single_label_on_a_node() {
        this.testQuery("Set a label on a node", "To set a label on a node, use +SET+.", "match (n {name: 'Stefan'}) set n :German return n", "The newly labeled node is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.getLabelsFromNode(p));
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"German"}));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void set_multiple_labels_on_a_node() {
        this.testQuery("Set multiple labels on a node", "To set multiple labels on a node, use +SET+ and separate the different labels using +:+.", "match (n {name: 'Emil'}) set n :Swedish:Bossman return n", "The newly labeled node is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SetTest $outer;

            public final void apply(ExecutionResult p) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.getLabelsFromNode(p));
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Swedish", "Bossman"}));
                boolean $org_scalatest_assert_macro_result = $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_result, (Option)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    public SetTest() {
        QueryStatisticsTestSupport.class.$init$((QueryStatisticsTestSupport)this);
        this.properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Andres"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)36L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"hungry"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Peter"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)34L))})))}));
    }
}

