/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.RelationshipIndex;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u0017\tI1\u000b^1siR+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001Z8dO\u0016t'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111\u0003R8dk6,g\u000e^5oOR+7\u000f\u001e\"bg\u0016DQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001\"B\u000b\u0001\t\u00032\u0012\u0001E4sCBDG)Z:de&\u0004H/[8o+\u00059\u0002c\u0001\r C5\t\u0011D\u0003\u0002\u001b7\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039u\t!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001a\u0005\u0011a\u0015n\u001d;\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t11\u000b\u001e:j]\u001eDQA\u000b\u0001\u0005BY\t!\"\u001b8eKb\u0004&o\u001c9t\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u001d\u0019Xm\u0019;j_:,\u0012A\f\t\u0003_Mr!\u0001M\u0019\u000e\u0003uI!AM\u000f\u0002\rA\u0013X\rZ3g\u0013\tACG\u0003\u00023;!)a\u0007\u0001C\u0001o\u0005Yan\u001c3fg~\u0013\u0017pX5e)\u0005A\u0004C\u0001\u0019:\u0013\tQTD\u0001\u0003V]&$\bFA\u001b=!\ti\u0004)D\u0001?\u0015\ty\u0004\"A\u0003kk:LG/\u0003\u0002B}\t!A+Z:u\u0011\u0015\u0019\u0005\u0001\"\u00018\u0003M\u0011X\r\\1uS>t7\u000f[5qg~\u0013\u0017pX5eQ\t\u0011E\bC\u0003G\u0001\u0011\u0005q'\u0001\u000bnk2$\u0018\u000e\u001d7f?:|G-Z:`Ef|\u0016\u000e\u001a\u0015\u0003\u000brBQ!\u0013\u0001\u0005\u0002]\nQ\"\u00197m?RDWm\u00188pI\u0016\u001c\bF\u0001%=\u0011\u0015a\u0005\u0001\"\u00018\u00039qw\u000eZ3t?\nLx,\u001b8eKbD#a\u0013\u001f\t\u000b=\u0003A\u0011A\u001c\u0002-I,G.\u0019;j_:\u001c\b.\u001b9t?\nLx,\u001b8eKbD#A\u0014\u001f\t\u000bI\u0003A\u0011A\u001c\u0002)9|G-Z:`Ef|\u0016N\u001c3fq~\u000bX/\u001a:zQ\t\tF\bC\u0003V\u0001\u0011\u0005q'A\rti\u0006\u0014HoX<ji\"|V.\u001e7uSBdWm\u00188pI\u0016\u001c\bF\u0001+=\u0001")
public class StartTest
extends DocumentingTestBase {
    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A KNOWS B", "A KNOWS C"}));
    }

    @Override
    public List<String> indexProps() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
    }

    @Override
    public String section() {
        return "Start";
    }

    @Test
    public void nodes_by_id() {
        this.testQuery("Node by id", "\nBinding a node as a starting point is done with the `node(*)` function.\n\n[NOTE]\nNeo4j reuses its internal ids when nodes and relationships are deleted,\nwhich means it's bad practice to refer to them in this way.\nInstead, use application generated ids.\n\n[TIP]\nThe preferred way to do this is to use the `id` function (see <<functions-id>>) together with `MATCH`.\n", "start n=node(%A%) return n", "The corresponding node is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)p.columnAs("n").toList()).asJava(), (Matcher)JUnitMatchers.hasItem((Object)this.$outer.node("A")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void relationships_by_id() {
        this.testQuery("Relationship by id", "\nBinding a relationship as a starting point is done with the `relationship(*)` function, which can also be abbreviated `rel(*)`.\nSee <<start-node-by-id>> for more information on Neo4j ids.\n\n[TIP]\nThe preferred way to do this is to use the `id` function (see <<functions-id>>) together with `MATCH`.\n", "start r=relationship(0) return r", "The relationship with id +0+ is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertThat((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)p.columnAs("r").toList()).asJava(), (Matcher)JUnitMatchers.hasItem((Object)this.$outer.rel(0L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void multiple_nodes_by_id() {
        this.testQuery("Multiple nodes by id", "\nMultiple nodes are selected by listing them separated by commas.\n\n[TIP]\nThe preferred way to do this is to use the `id` function (see <<functions-id>>) together with `MATCH` and the `IN` operator (see <<query-operators-collection>>).\n", "start n=node(%A%, %B%, %C%) return n", "This returns the nodes listed in the `START` statement.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A"), this.$outer.node("B"), this.$outer.node("C")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void all_the_nodes() {
        this.testQuery("All nodes", "\nTo get all the nodes, use an asterisk.\nThis can be done with relationships as well.\n\nTIP: The preferred way to do this is to use a `MATCH` clause, see <<match-get-all-nodes>> in <<query-match>> for how to do that.\n", "start n=node(*) return n", "This query returns all the nodes in the graph.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A"), this.$outer.node("B"), this.$outer.node("C")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void nodes_by_index() {
        this.generateConsole_$eq(false);
        this.testQuery("Node by index lookup", "When the starting point can be found by using index lookups, it can be done like this: `node:index-name(key = \"value\")`. In this example, there exists a node index named `nodes`.", "start n=node:nodes(name = \"A\") return n", "The query returns the node indexed with the name \"+A+\".", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("A"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void relationships_by_index() {
        this.generateConsole_$eq(false);
        this.RichGraph(this.db()).inTx((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = this.$outer.db().getRelationshipById(0L);
                String property = "name";
                String value = "Andr\u00e9s";
                r.setProperty(property, (Object)value);
                RelationshipIndex relIndex = this.$outer.db().index().forRelationships("rels");
                relIndex.add((PropertyContainer)r, property, (Object)value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testQuery("Relationship by index lookup", "When the starting point can be found by using index lookups, it can be done like this: `relationship:index-name(key = \"value\")`.", "start r=relationship:rels(name = \"Andr\u00e9s\") return r", "The relationship indexed with the +name+ property set to \"+Andr\u00e9s+\" is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"r"), (Object)this.$outer.rel(0L))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void nodes_by_index_query() {
        this.generateConsole_$eq(false);
        this.testQuery("Node by index query", "When the starting point can be found by more complex Lucene queries, this is the syntax to use: `node:index-name(\"query\")`.This allows you to write more advanced index queries.", "start n=node:nodes(\"name:A\") return n", "The node indexed with name \"A\" is returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("A"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void start_with_multiple_nodes() {
        this.testQuery("Multiple starting points", "Sometimes you want to bind multiple starting points. Just list them separated by commas.", "start a=node(%A%), b=node(%B%) return a,b", "Both the nodes +A+ and the +B+  are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)this.$outer.node("A")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)this.$outer.node("B"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }
}

