/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u0017\tQQK\\<j]\u0012$Vm\u001d;\u000b\u0005\r!\u0011A\u00023pG\u001e,gN\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u000b9,w\u000e\u000e6\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0003\u0016\u0001\u0011\u0005a#A\u0004tK\u000e$\u0018n\u001c8\u0016\u0003]\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004TiJLgn\u001a\u0005\u0006A\u0001!\t!I\u0001\u000eg&l\u0007\u000f\\3`k:<\u0018N\u001c3\u0015\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012A!\u00168ji\"\u0012q$\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003Y!\tQA[;oSRL!AL\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006a\u0001!\t!I\u0001\u0014I&\u001cH/\u001b8di~\u001bw\u000e\u001c7fGRLwN\u001c\u0015\u0003_%BQa\r\u0001\u0005\u0002\u0005\nQe\u0019:fCR,w\fZ1uC~3'o\\7`G>dG.Z2uS>tw\f]1sC6,G/\u001a:)\u0005IJ\u0003")
public class UnwindTest
extends DocumentingTestBase {
    @Override
    public String section() {
        return "Unwind";
    }

    @Test
    public void simple_unwind() {
        this.testQuery("Unwind a collection", "We want to transform the literal collection into rows named `x` and return them.", "UNWIND [1,2,3] as x RETURN x", "Each value of the original collection is returned as an individual row.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)p.columnAs("x").toList());
            }
        }}));
    }

    @Test
    public void distinct_collection() {
        this.testQuery("Create a distinct collection", "We want to transform a collection of duplicates into a set using `DISTINCT`.", "WITH [1,1,2,2] as coll UNWIND coll as x WITH DISTINCT x RETURN collect(x) as set", "Each value of the original collection is unwound and passed through distinct to create a unique set.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))})), (Object)p.columnAs("set").toList());
            }
        }}));
    }

    @Test
    public void create_data_from_collection_parameter() {
        String x$1 = "Create nodes from a collection parameter";
        String x$2 = "Create a number of nodes and relationships from a parameter-list without using +FOREACH+.";
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnwindTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setParameters((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"events"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"year"), (Object)BoxesRunTime.boxToInteger((int)2014)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"year"), (Object)BoxesRunTime.boxToInteger((int)2014)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))}))})))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        String x$4 = "UNWIND {events} as event\n           MERGE (y:Year {year:event.year})\n           MERGE (y)<-[:IN]-(e:Event {id:event.id})\n           RETURN e.id as x order by x";
        String x$5 = "Each value of the original collection is unwound and passed through distinct to create a unique set.";
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)p.columnAs("x").toList());
            }
        }}));
        this.prepareAndTestQuery(x$1, x$2, x$4, x$5, (Function0<Object>)x$3, (Seq<Function1<ExecutionResult, BoxedUnit>>)x$6);
    }
}

