/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u0017\tIq\u000b[3sKR+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001Z8dO\u0016t'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u00111\u0003R8dk6,g\u000e^5oOR+7\u000f\u001e\"bg\u0016DQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001\"B\u000b\u0001\t\u00032\u0012\u0001E4sCBDG)Z:de&\u0004H/[8o+\u00059\u0002c\u0001\r C5\t\u0011D\u0003\u0002\u001b7\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039u\t!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001a\u0005\u0011a\u0015n\u001d;\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t11\u000b\u001e:j]\u001eDqA\u000b\u0001C\u0002\u0013\u00053&\u0001\u0006qe>\u0004XM\u001d;jKN,\u0012\u0001\f\t\u000515\ns&\u0003\u0002/3\t\u0019Q*\u00199\u0011\tai\u0013\u0005\r\t\u0003cIj\u0011!H\u0005\u0003gu\u00111!\u00118z\u0011\u0019)\u0004\u0001)A\u0005Y\u0005Y\u0001O]8qKJ$\u0018.Z:!\u0011\u00159\u0004\u0001\"\u00159\u0003A9W\r^$sCBDg/\u001b>TifdW-F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0005he\u0006\u0004\bN^5{\u0015\tqd!A\u0007wSN,\u0018\r\\5{CRLwN\\\u0005\u0003\u0001n\u0012!b\u0012:ba\"\u001cF/\u001f7f\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u001d\u0019Xm\u0019;j_:,\u0012!\t\u0005\u0006\u000b\u0002!\tAR\u0001\u0015M&dG/\u001a:`_:|fn\u001c3f?2\f'-\u001a7\u0015\u0003\u001d\u0003\"!\r%\n\u0005%k\"\u0001B+oSRD#\u0001R&\u0011\u00051{U\"A'\u000b\u00059C\u0011!\u00026v]&$\u0018B\u0001)N\u0005\u0011!Vm\u001d;\t\u000bI\u0003A\u0011\u0001$\u0002%\u0019LG\u000e^3s?>tw\f\u001d:pa\u0016\u0014H/\u001f\u0015\u0003#.CQ!\u0016\u0001\u0005\u0002\u0019\u000b!CY8pY\u0016\fgnX8qKJ\fG/[8og\"\u0012Ak\u0013\u0005\u00061\u0002!\tAR\u0001\u0014e\u0016<W\u000f\\1s?\u0016D\bO]3tg&|gn\u001d\u0015\u0003/.CQa\u0017\u0001\u0005\u0002\u0019\u000b1D]3hk2\f'oX3yaJ,7o]5p]N|Vm]2ba\u0016$\u0007F\u0001.L\u0011\u0015q\u0006\u0001\"\u0001G\u0003\u0011\u0012XmZ;mCJ|V\r\u001f9sKN\u001c\u0018n\u001c8t?\u000e\f7/Z0j]N,gn]5uSZ,\u0007FA/L\u0011\u0015\t\u0007\u0001\"\u0001G\u00031A\u0017m]0qe>\u0004XM\u001d;zQ\t\u00017\nC\u0003e\u0001\u0011\u0005a)\u0001\u000ed_6\u0004\u0018M]3`S\u001a|\u0006O]8qKJ$\u0018pX3ySN$8\u000f\u000b\u0002d\u0017\")q\r\u0001C\u0001\r\u0006A3m\\7qCJ,w,\u001b4`aJ|\u0007/\u001a:us~+\u00070[:ug~#WMZ1vYR|f-\u00197tK\"\u0012am\u0013\u0005\u0006U\u0002!\tAR\u0001\u001cM&dG/\u001a:`_:|&/\u001a7bi&|gn\u001d5ja~#\u0018\u0010]3)\u0005%\\\u0005\"B7\u0001\t\u00031\u0015A\u00044jYR,'oX8o?:,H\u000e\u001c\u0015\u0003Y.CQ\u0001\u001d\u0001\u0005\u0002\u0019\u000b!CZ5mi\u0016\u0014xl\u001c8`a\u0006$H/\u001a:og\"\u0012qn\u0013\u0005\u0006g\u0002!\tAR\u0001\u001aaJ,G-[2bi\u0016|v/\u001b;i?B\u0014x\u000e]3si&,7\u000f\u000b\u0002s\u0017\")a\u000f\u0001C\u0001\r\u00069\u0002.Y:`]>$xL]3mCRLwN\\:iSB|Fo\u001c\u0015\u0003k.CQ!\u001f\u0001\u0005\u0002\u0019\u000b1\"\u001b8`_B,'/\u0019;pe\"\u0012\u0001p\u0013")
public class WhereTest
extends DocumentingTestBase {
    private final Map<String, Map<String, Object>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Andres"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)36L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"belt"), (Object)"white")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Tobias"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)25L))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Peter"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)BoxesRunTime.boxToLong((long)34L))})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Andres KNOWS Tobias", "Andres:Swedish KNOWS Peter"}));
    }

    @Override
    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "Where";
    }

    @Test
    public void filter_on_node_label() {
        this.testQuery("Filter on node label", "To filter nodes by label, write a label predicate after the `WHERE` keyword using `WHERE n:foo`.", "match (n) where n:Swedish return n", "The \"+Andres+\" node will be returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Andres")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void filter_on_property() {
        this.testQuery("Filter on node property", "To filter on a property, write your clause after the `WHERE` keyword. Filtering on relationship properties works just the same way.", "match (n) where n.age < 30 return n", "The \"+Tobias+\" node will be returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Tobias")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void boolean_operations() {
        this.testQuery("Boolean operations", "You can use the expected boolean operators `AND` and `OR`, and also the boolean function `NOT`. See <<cypher-working-with-null>> for more information on how this works with +NULL+.", "match (n) where n.name = 'Peter' xor (n.age < 30 and n.name = \"Tobias\") or not (n.name = \"Tobias\" or n.name=\"Peter\") return n", "This query shows how boolean operators can be used.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)this.$outer.nodes((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Andres", "Tobias", "Peter"})).toSet(), (Object)p.columnAs("n").toSet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void regular_expressions() {
        this.testQuery("Regular expressions", "You can match on regular expressions by using `=~ \"regexp\"`, like this:", "match (n) where n.name =~ 'Tob.*' return n", "The \"+Tobias+\" node will be returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Tobias")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void regular_expressions_escaped() {
        this.testQuery("Escaping in regular expressions", "If you need a forward slash inside of your regular expression, escape it. Remember that back slash needs to be escaped in string literals", "match (n) where n.name =~ 'Some\\\\/thing' return n", "No nodes match this regular expression.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Nil$.MODULE$, (Object)p.toList());
            }
        }}));
    }

    @Test
    public void regular_expressions_case_insensitive() {
        this.testQuery("Case insensitive regular expressions", "By pre-pending a regular expression with `(?i)`, the whole expression becomes case insensitive.", "match (n) where n.name =~ '(?i)ANDR.*' return n", "The node with name \"+Andres+\" is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("Andres"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void has_property() {
        this.testQuery("Property exists", "To only include nodes/relationships that have a property, use the `HAS()` function and just write out the identifier and the property you expect it to have.", "match (n) where has(n.belt) return n", "The node named \"+Andres+\" is returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Andres")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void compare_if_property_exists() {
        this.testQuery("Default to true if property is missing", "If you want to compare a property on a graph element, but only if it exists, you can compare the property against both the value you are looking for and +NULL+, like:", "match (n) where n.belt = 'white' or n.belt IS NULL return n order by n.name", "This returns all nodes, even those without the belt property.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Andres"), this.$outer.node("Peter"), this.$outer.node("Tobias")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void compare_if_property_exists_default_false() {
        this.testQuery("Default to false if property is missing", "As missing properties evaluate to +NULL+, the comparision in the example will evaluate to +FALSE+ for nodes without the +belt+ property.", "match (n) where n.belt = 'white' return n", "Only nodes with the belt property are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Andres")})), (Object)p.columnAs("n").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void filter_on_relationship_type() {
        this.testQuery("Filtering on relationship type", "You can put the exact relationship type in the `MATCH` pattern, but sometimes you want to be able to do more advanced filtering on the type. You can use the special property `TYPE` to compare the type with something else. In this example, the query does a regular expression comparison with the name of the relationship type.", "match (n)-[r]->() where n.name='Andres' and type(r) =~ 'K.*' return r", "This returns relationships that has a type whose name starts with K.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)"KNOWS", (Object)((Relationship)p.columnAs("r").toList().head()).getType().name());
            }
        }}));
    }

    @Test
    public void filter_on_null() {
        this.testQuery("Filter on NULL", "Sometimes you might want to test if a value or an identifier is +NULL+. This is done just like SQL does it, with `IS NULL`. Also like SQL, the negative is `IS NOT NULL`, although `NOT(IS NULL x)` also works.", "match (person) where person.name = 'Peter' AND person.belt is null return person", "Nodes that have name 'Peter' but no belt property are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"person"), (Object)this.$outer.node("Peter"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void filter_on_patterns() {
        this.testQuery("Filter on patterns", "Patterns are expressions in Cypher, expressions that return a collection of paths. Collection\nexpressions are also predicates -- an empty collection represents `false`, and a non-empty represents `true`.\n\nSo, patterns are not only expressions, they are also predicates. The only limitation to your pattern is that you must be\nable to express it in a single path. You can not use commas between multiple paths like you do in `MATCH`. You can achieve\nthe same effect by combining multiple patterns with `AND`.\n\nNote that you can not introduce new identifiers here. Although it might look very similar to the `MATCH` patterns, the\n`WHERE` clause is all about eliminating matched subgraphs. `MATCH (a)-[*]->(b)` is very different from `WHERE (a)-[*]->(b)`; the\nfirst will produce a subgraph for every path it can find between `a` and `b`, and the latter will eliminate any matched\nsubgraphs where `a` and `b` do not have a directed relationship chain between them.\n             ", "match (tobias {name: 'Tobias'}), (others) where others.name IN ['Andres', 'Peter'] and (tobias)<--(others) return others", "Nodes that have an outgoing relationship to the \"+Tobias+\" node are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"others"), (Object)this.$outer.node("Andres"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void predicate_with_properties() {
        this.testQuery("Filter on patterns with properties", "You can also add properties to your patterns:", "match (n) where (n)-[:KNOWS]-({name:'Tobias'}) return n", "Finds all nodes that have a +KNOWS+ relationship to a node with the name +Tobias+.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"n"), (Object)this.$outer.node("Andres"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void has_not_relationship_to() {
        this.testQuery("Filter on patterns using NOT", "The `NOT` function can be used to exclude a pattern. ", "MATCH (persons), (peter {name: 'Peter'}) where not (persons)-->(peter) return persons", "Nodes that do not have an outgoing relationship to the \"+Peter+\" node are returned.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"persons"), (Object)this.$outer.node("Tobias"))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"persons"), (Object)this.$outer.node("Peter"))}))})), (Object)p.toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void in_operator() {
        this.testQuery("IN operator", "To check if an element exists in a collection, you can use the `IN` operator.", "match (a) where a.name IN [\"Peter\", \"Tobias\"] return a", "This query shows how to check if a property exists in a literal collection.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WhereTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("Tobias"), this.$outer.node("Peter")})), (Object)p.columnAs("a").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }
}

