/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\tAq+\u001b;i)\u0016\u001cHO\u0003\u0002\u0004\t\u00051Am\\2hK:T!!\u0002\u0004\u0002\r\rL\b\u000f[3s\u0015\t9\u0001\"A\u0003oK>$$NC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t\u0019Bi\\2v[\u0016tG/\u001b8h)\u0016\u001cHOQ1tK\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005BY\t\u0001c\u001a:ba\"$Um]2sSB$\u0018n\u001c8\u0016\u0003]\u00012\u0001G\u0010\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003%IW.\\;uC\ndWM\u0003\u0002\u001d;\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003y\tQa]2bY\u0006L!\u0001I\r\u0003\t1K7\u000f\u001e\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA\u0001\\1oO*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005\u0019\u0019FO]5oO\")!\u0006\u0001C)W\u0005\u0001r-\u001a;He\u0006\u0004\bN^5{'RLH.Z\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\tOJ\f\u0007\u000f\u001b<ju*\u0011\u0011GB\u0001\u000em&\u001cX/\u00197ju\u0006$\u0018n\u001c8\n\u0005Mr#AC$sCBD7\u000b^=mK\"9Q\u0007\u0001b\u0001\n\u00032\u0014A\u00039s_B,'\u000f^5fgV\tq\u0007\u0005\u0003\u0019q\u0005R\u0014BA\u001d\u001a\u0005\ri\u0015\r\u001d\t\u00051a\n\u0013\u0005\u0003\u0004=\u0001\u0001\u0006IaN\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b\u0005C\u0003?\u0001\u0011\u0005q(A\u0004tK\u000e$\u0018n\u001c8\u0016\u0003\u0005BQ!\u0011\u0001\u0005\u0002\t\u000bQEZ5mi\u0016\u0014xl\u001c8`C\u001e<'/Z4bi\u0016|f-\u001e8di&|gn]0sKN,H\u000e^:\u0015\u0003\r\u0003\"\u0001R#\u000e\u0003uI!AR\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0001\"\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u0005\u0002\u000b),h.\u001b;\n\u00055S%\u0001\u0002+fgRDQa\u0014\u0001\u0005\u0002\t\u000bAc]8si~\u001bw\u000e\u001c7fGR|&/Z:vYR\u001c\bF\u0001(I\u0011\u0015\u0011\u0006\u0001\"\u0001C\u0003=a\u0017.\\5u?\n\u0014\u0018M\\2iS:<\u0007FA)I\u0001")
public class WithTest
extends DocumentingTestBase {
    private final Map<String, Map<String, String>> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"A"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Anders")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"B"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Bossman")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"C"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Ceasar")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"D"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"David")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"E"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Emil")})))}));

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A KNOWS B", "A BLOCKS C", "D KNOWS A", "B KNOWS E", "C KNOWS E", "B BLOCKS D"}));
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    public Map<String, Map<String, String>> properties() {
        return this.properties;
    }

    @Override
    public String section() {
        return "With";
    }

    @Test
    public void filter_on_aggregate_functions_results() {
        this.testQuery("Filter on aggregate function results", "Aggregated results have to pass through a `WITH` clause to be able to filter on.", "match (david {name: \"David\"})--(otherPerson)-->() with otherPerson, count(*) as foaf where foaf > 1 return otherPerson", "The person connected to David with the at least more than one outgoing relationship will be returned by the query.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithTest $outer;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node("A")})), (Object)p.columnAs("otherPerson").toList());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }}));
    }

    @Test
    public void sort_collect_results() {
        this.testQuery("Sort results before using collect on them", "You can sort your results before passing them to collect, thus sorting the resulting collection.", "match (n) with n order by n.name desc limit 3 return collect(n.name)", "A list of the names of people in reverse order, limited to 3, in a collection.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Emil", "David", "Ceasar"}))})), (Object)p.columnAs("collect(n.name)").toList());
            }
        }}));
    }

    @Test
    public void limit_branching() {
        this.testQuery("Limit branching of your path search", "You can match paths, limit to a certain number, and then match again using those paths as a base As well as any number of similar limited searches.", "match (n {name: \"Anders\"})--(m) with m order by m.name desc limit 1 match (m)--(o) return o.name", "Starting at Anders, find all matching nodes, order by name descending and get the top result, then find all the nodes connected to that top result, and return their names.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anders", "Bossman"})), (Object)p.columnAs("o.name").toList());
            }
        }}));
    }
}

