/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\t\t#i\\8ti&twMU3d_6lWM\u001c3bi&|gNU3tk2$8\u000fV3ti*\u00111\u0001B\u0001\tG>|7NY8pW*\u0011QAB\u0001\u0007I>\u001cw-\u001a8\u000b\u0005\u001dA\u0011AB2za\",'O\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0014\t>\u001cW/\\3oi&tw\rV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005\u0002e\tqa]3di&|g.F\u0001\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u0015;sS:<\u0007bB\u0012\u0001\u0005\u0004%\t\u0005J\u0001\b]>$\u0016\u000e\u001e7f+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#a\u0002\"p_2,\u0017M\u001c\u0005\u0007Y\u0001\u0001\u000b\u0011B\u0013\u0002\u00119|G+\u001b;mK\u0002BQA\f\u0001\u0005R=\n\u0001cZ3u\u000fJ\f\u0007\u000f\u001b<juN#\u0018\u0010\\3\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u0011\u001d\u0014\u0018\r\u001d5wSjT!!\u000e\u0005\u0002\u001bYL7/^1mSj\fG/[8o\u0013\t9$G\u0001\u0006He\u0006\u0004\bn\u0015;zY\u0016Dq!\u000f\u0001C\u0002\u0013\u0005#(\u0001\u0007tKR,\b/U;fe&,7/F\u0001<!\ra\u0014IG\u0007\u0002{)\u0011ahP\u0001\nS6lW\u000f^1cY\u0016T!\u0001Q\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C{\t!A*[:u\u0011\u0019!\u0005\u0001)A\u0005w\u0005i1/\u001a;vaF+XM]5fg\u0002BQA\u0012\u0001\u0005\u0002\u001d\u000bqCY8pgRLgn\u001a*fG>lW.\u001a8eCRLwN\\:\u0015\u0003!\u0003\"AJ%\n\u0005);#\u0001B+oSRD#!\u0012'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=S\u0011!\u00026v]&$\u0018BA)O\u0005\u0011!Vm\u001d;")
public class BoostingRecommendationResultsTest
extends DocumentingTestBase {
    private final boolean noTitle;
    private final List<String> setupQueries;

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public boolean noTitle() {
        return this.noTitle;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> setupQueries() {
        return this.setupQueries;
    }

    @Test
    public void boostingRecommendations() {
        this.testQuery("Boosting with properties on relationships", "This query finds the recommended friends for the origin that are working at the same place as the origin, \nor know a person that the origin knows, also, the origin should not already know the target. This recommendation is \nweighted for the weight of the relationship `r2`, and boosted with a factor of 2, if there is an `activity`-property on that relationship", "MATCH (origin)-[r1:KNOWS|WORKS_AT]-(c)-[r2:KNOWS|WORKS_AT]-(candidate)\nWHERE origin.name = \"Clark Kent\"\nAND type(r1)=type(r2) AND NOT (origin)-[:KNOWS]-(candidate)\nRETURN origin.name as origin, candidate.name as candidate, \n    SUM(ROUND(r2.weight + (COALESCE(r2.activity, 0) * 2))) as boost\nORDER BY boost desc limit 10", "This returns the recommended friends for the origin nodes and their recommendation score.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"origin"), (Object)"Clark Kent"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"candidate"), (Object)"Perry White"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"boost"), (Object)BoxesRunTime.boxToInteger((int)22))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"origin"), (Object)"Clark Kent"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"candidate"), (Object)"Anderson Cooper"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"boost"), (Object)BoxesRunTime.boxToInteger((int)4))}))})), (Object)p.toList());
            }
        }}));
    }

    public BoostingRecommendationResultsTest() {
        this.generateInitialGraphForConsole_$eq(false);
        this.noTitle = true;
        this.setupQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create \n(clark {name: \"Clark Kent\"}),\n(lois {name:\"Lois Lane\"}),\n(jimmy {name:\"Jimmy Olsen\"}),\n(perry {name:\"Perry White\"}),\n(cooper {name:\"Anderson Cooper\"}),\n(dailyplanet {name:\"Daily Planet\"}),\n(cnn {name:\"CNN\"}),\nclark-[:KNOWS {weight: 4}]->lois,\nclark-[:KNOWS {weight: 4}]->jimmy,\nlois-[:KNOWS {weight: 4}]->perry,\njimmy-[:KNOWS {weight: 4}]->perry,\nlois-[:KNOWS {weight: 4}]->cooper,\nclark-[:WORKS_AT {weight: 2, activity: 45}]->dailyplanet,\njimmy-[:WORKS_AT {weight: 2, activity: 10}]->dailyplanet,\nperry-[:WORKS_AT {weight: 2, activity: 6}]->dailyplanet,\nlois-[:WORKS_AT {weight: 2, activity: 56}]->dailyplanet,\ncooper-[:WORKS_AT {weight: 2, activity: 2}]->cnn,\nperry-[:WORKS_AT {weight: 2, activity: 3}]->cnn"}));
    }
}

