/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001b\t)2i\u001c$bm>\u0014\u0018\u000e^3e!2\f7-Z:UKN$(BA\u0002\u0005\u0003!\u0019wn\\6c_>\\'BA\u0003\u0007\u0003\u0019!wnY4f]*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005!\u0011BA\t\u0005\u0005M!unY;nK:$\u0018N\\4UKN$()Y:f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0013$\u0001\the\u0006\u0004\b\u000eR3tGJL\u0007\u000f^5p]V\t!\u0004E\u0002\u001cE\u0011j\u0011\u0001\b\u0006\u0003;y\t\u0011\"[7nkR\f'\r\\3\u000b\u0005}\u0001\u0013AC2pY2,7\r^5p]*\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$9\t!A*[:u!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u0015;sS:<\u0007\"B\u0017\u0001\t\u0003q\u0013aB:fGRLwN\\\u000b\u0002I!)\u0001\u0007\u0001C)c\u0005\u0001r-\u001a;He\u0006\u0004\bN^5{'RLH.Z\u000b\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\tOJ\f\u0007\u000f\u001b<ju*\u0011q\u0007C\u0001\u000em&\u001cX/\u00197ju\u0006$\u0018n\u001c8\n\u0005e\"$AC$sCBD7\u000b^=mK\")1\b\u0001C\u0001y\u0005\t2m\u001c$bm>\u0014\u0018\u000e^3e!2\f7-Z:\u0015\u0003u\u0002\"AP \u000e\u0003\u0001J!\u0001\u0011\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003u\t\u0003\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0006\u0002\u000b),h.\u001b;\n\u0005\u001d#%\u0001\u0002+fgRDQ!\u0013\u0001\u0005\u0002q\nabY8UC\u001e<W\r\u001a)mC\u000e,7\u000f\u000b\u0002I\u0005\u0002")
public class CoFavoritedPlacesTest
extends DocumentingTestBase {
    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joe favorite CoffeeShop1", "Joe favorite SaunaX", "Joe favorite MelsPlace", "Jill favorite CoffeeShop1", "Jill favorite MelsPlace", "CoffeeShop2 tagged Cool", "CoffeeShop1 tagged Cool", "CoffeeShop1 tagged Cosy", "CoffeeShop3 tagged Cosy", "MelsPlace tagged Cosy", "MelsPlace tagged Cool", "Jill favorite CoffeShop2"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Test
    public void coFavoritedPlaces() {
        this.testQuery("Co-favorited places -- users who like x also like y", "Find places that people also like who favorite this place:\n\n* Determine who has favorited place x.\n* What else have they favorited that is not place x.", "MATCH (place)<-[:favorite]-(person)-[:favorite]->(stuff)\n          WHERE place.name = 'CoffeeShop1'\n      \t\tRETURN stuff.name, count(*)\n      \t\tORDER BY count(*) DESC, stuff.name", "The list of places that are favorited by people that favorited the start place.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"stuff.name"), (Object)"MelsPlace"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(*)"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"stuff.name"), (Object)"CoffeShop2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(*)"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"stuff.name"), (Object)"SaunaX"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(*)"), (Object)BoxesRunTime.boxToInteger((int)1))}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void coTaggedPlaces() {
        this.testQuery("Co-Tagged places -- places related through tags", "Find places that are tagged with the same tags:\n\n* Determine the tags for place x.\n* What else is tagged the same as x that is not x.", "MATCH (place)-[:tagged]->(tag)<-[:tagged]-(otherPlace)\nWHERE place.name = 'CoffeeShop1'\nRETURN otherPlace.name, collect(tag.name)\nORDER BY length(collect(tag.name)) DESC, otherPlace.name", "This query returns other places than CoffeeShop1 which share the same tags; they are ranked by the number of tags.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"otherPlace.name"), (Object)"MelsPlace"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collect(tag.name)"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cool", "Cosy"})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"otherPlace.name"), (Object)"CoffeeShop2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collect(tag.name)"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cool"})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"otherPlace.name"), (Object)"CoffeeShop3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collect(tag.name)"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cosy"})))}))})), (Object)p.toList());
            }
        }}));
    }
}

