/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u001b\t)2i\\7qY\u0016D8+[7jY\u0006\u0014\u0018\u000e^=UKN$(BA\u0002\u0005\u0003!\u0019wn\\6c_>\\'BA\u0003\u0007\u0003\u0019!wnY4f]*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005!\u0011BA\t\u0005\u0005M!unY;nK:$\u0018N\\4UKN$()Y:f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0004tK\u000e$\u0018n\u001c8\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\t1\fgn\u001a\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0004TiJLgn\u001a\u0005\u0006G\u0001!\t\u0006J\u0001\u0011O\u0016$xI]1qQZL'p\u0015;zY\u0016,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\n\u0001b\u001a:ba\"4\u0018N\u001f\u0006\u0003U!\tQB^5tk\u0006d\u0017N_1uS>t\u0017B\u0001\u0017(\u0005)9%/\u00199i'RLH.\u001a\u0005\b]\u0001\u0011\r\u0011\"\u00110\u00031\u0019X\r^;q#V,'/[3t+\u0005\u0001\u0004cA\u0019955\t!G\u0003\u00024i\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003kY\n!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d3\u0005\u0011a\u0015n\u001d;\t\rm\u0002\u0001\u0015!\u00031\u00035\u0019X\r^;q#V,'/[3tA!)Q\b\u0001C\u0001}\u0005qA/Z:u'&lG.[1sSRLH#A \u0011\u0005\u0001\u000bU\"\u0001\u001c\n\u0005\t3$\u0001B+oSRD#\u0001\u0010#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011!\u00026v]&$\u0018BA%G\u0005\u0011!Vm\u001d;")
public class ComplexSimilarityTest
extends DocumentingTestBase {
    private final List<String> setupQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE (me {name:'me'})-[:ATE {times:10}]->(food {name:'meat'})<-[:ATE {times:5}]-(you {name:'you'})"}));

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> setupQueries() {
        return this.setupQueries;
    }

    @Test
    public void testSimliarity() {
        this.testQuery("Calculate similarities by complex calculations", "Here, a similarity between two players in a game is calculated by the number of times they have eaten the same food.", "MATCH (me {name: 'me'})-[r1:ATE]->(food)<-[r2:ATE]-(you)\nWITH me,count(distinct r1) as H1,count(distinct r2) as H2,you\nMATCH (me)-[r1:ATE]->(food)<-[r2:ATE]-(you)\nRETURN sum((1-ABS(r1.times/H1-r2.times/H2))*(r1.times+r2.times)/(H1+H2)) as similarity", "The two players and their similarity measure.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"similarity"), (Object)BoxesRunTime.boxToDouble((double)-30.0))}))})), (Object)p.toList());
            }
        }}));
    }
}

